/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.net.URL;
import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.common.utils.DBObjectHandler;
import oracle.dbtools.common.utils.DBURLUtil;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.ConnectionResolver;

public class BasicDBObject {
    protected static String FOLDER = "_FOLDER";
    protected URL m_url;
    protected String m_name;
    protected String m_schema;
    protected String m_type;
    protected String m_folderType;
    protected String m_childName;
    protected String m_connName;
    protected String m_connType;
    protected String m_catalog;
    protected Connection m_conn;

    protected BasicDBObject() {
    }

    public BasicDBObject(URL url) {
        this.m_url = url;
        DBURLUtil.ParsedURL parsedURL = DBURLUtil.getParsedURL(url);
        this.m_connName = parsedURL.getConnectionName();
        this.m_name = parsedURL.getObjectName();
        String type = parsedURL.getObjectType();
        this.m_type = ModelUtil.hasLength(this.m_name) ? type : BasicDBObject.createFolderType(type);
        this.m_folderType = type;
        this.m_schema = parsedURL.getSchema();
        this.m_catalog = parsedURL.getCatalog();
        this.m_childName = parsedURL.getChildName();
    }

    public String getCatalog() {
        this.loadDBData();
        assert (null == this.m_catalog || this.m_catalog != null);
        return null;
    }

    public String getKey() {
        this.loadDBData();
        return BasicDBObject.getKey(this.getConnectionType(), this.getObjectType());
    }

    public static String getKey(String connType, String objType) {
        return connType + "#" + objType;
    }

    protected static String createFolderType(String baseType) {
        return baseType + FOLDER;
    }

    public String getObjectType() {
        this.loadDBData();
        return this.m_type;
    }

    public String getObjectFolderType() {
        this.loadDBData();
        return this.m_folderType;
    }

    public boolean isObjectFolderType() {
        return this.m_type.endsWith(FOLDER);
    }

    public String getChildName() {
        this.loadDBData();
        return this.m_childName;
    }

    public Connection getConnection() {
        if (this.m_conn == null) {
            try {
                this.m_conn = ConnectionResolver.getConnection(this.m_connName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.m_conn;
    }

    public void setConnection(Connection conn) {
        this.m_conn = conn;
    }

    public String getConnectionName() {
        this.loadDBData();
        return this.m_connName;
    }

    public String getConnectionType() {
        this.loadDBData();
        return "Oracle";
    }

    public String getObjectName() {
        this.loadDBData();
        return this.m_name;
    }

    public String getSchemaName() {
        this.loadDBData();
        return this.m_schema;
    }

    public URL getURL() {
        this.loadDBData();
        return this.m_url;
    }

    public Map<String, Object> getDictionary() {
        return DBObjectHandler.getDictionary(this);
    }

    public synchronized void loadDBData() {
    }

    public synchronized void reloadDBData() {
    }

    public static void main(String[] args) {
    }
}

