/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection0;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import oracle.dbtools.app.injection0.PlsqlException;
import oracle.dbtools.app.injection0.PlsqlType;
import oracle.dbtools.app.injection0.SqlInjectionGraph;
import oracle.dbtools.app.injection0.Usage;
import oracle.dbtools.app.injection0.ValueNode;
import oracle.dbtools.parser.ParseNode;

class SymbolTable {
    private static final boolean DEBUG = false;
    private final HashMap<String, Usage> declares = new HashMap();
    private final HashMap<String, Usage> assigns = new HashMap();
    private final SymbolTable enclosingScope;
    private Metadata meta;
    private final Deque<Metadata> metadataStack;

    SymbolTable() {
        this((SymbolTable)null);
    }

    SymbolTable(SymbolTable enclosingScope) {
        this.enclosingScope = enclosingScope;
        this.metadataStack = new ArrayDeque<Metadata>();
        this.meta = enclosingScope != null ? new Metadata(enclosingScope.meta) : new Metadata();
    }

    public SymbolTable(PlsqlType.Function[] functions) {
        this();
        for (PlsqlType.Function func : functions) {
            this.define(func, SqlInjectionGraph.fakeParseNode(-1));
        }
    }

    Usage define(String name, PlsqlType type, ParseNode pos) {
        Usage decl;
        Usage oldDecl = this.declares.put(name = this.canonicalize(name), decl = new Usage(this, name, type, pos));
        if (oldDecl != null) {
            // empty if block
        }
        Usage usageWrite = new Usage(this, name, type, pos);
        this.assigns.put(name, usageWrite);
        return usageWrite;
    }

    private void define(PlsqlType.Function func, ParseNode pos) {
        Usage decl;
        String funcname = this.canonicalize(func.name);
        Usage oldDecl = this.declares.put(funcname, decl = new Usage(this, funcname, func, pos));
        if (oldDecl != null) {
            throw new IllegalArgumentException("Attempt to define system function " + func + " failed due to preexsiting definition " + oldDecl);
        }
        if (func.parms.size() == 0) {
            Usage usageWrite = new Usage(this, funcname, func.returnType, pos);
            this.assigns.put(func.name, usageWrite);
        }
    }

    Usage write(Usage oldUsage, ParseNode pos) {
        Usage usage = new Usage(oldUsage, pos);
        this.meta.write.accept(usage, pos, this);
        this.assigns.put(oldUsage.getName(), usage);
        return usage;
    }

    Set<String> getLocalNameSet() {
        return this.assigns.keySet();
    }

    Usage read(String name) {
        Usage ret = this.readNoHook(name);
        ret = this.meta.read.apply(name, ret);
        return ret;
    }

    private Usage readNoHook(String name) {
        name = this.canonicalize(name);
        SymbolTable table = this;
        Usage ret = null;
        do {
            ret = table.assigns.get(name);
            table = table.enclosingScope;
        } while (ret == null && table != null);
        return ret;
    }

    Usage readLocal(String name) {
        name = this.canonicalize(name);
        return this.assigns.get(name);
    }

    Usage getDeclaration(String name) {
        name = this.canonicalize(name);
        SymbolTable table = this;
        Usage ret = null;
        do {
            ret = table.declares.get(name);
            table = table.enclosingScope;
        } while (ret == null && table != null);
        return ret;
    }

    Usage getLocalDeclaration(String name) {
        name = this.canonicalize(name);
        return this.declares.get(name);
    }

    void cont() {
        this.meta.cont.accept(this);
    }

    void exit() {
        this.meta.exit.accept(this);
    }

    void retrn(ValueNode.ExprNode expr) {
        this.meta.retrn.accept(expr, this);
    }

    public SymbolTable getEnclosingScope() {
        return this.enclosingScope;
    }

    public AssignmentHook hookWrite(AssignmentHook assignmentHook) {
        AssignmentHook old = this.meta.write;
        this.meta.write = assignmentHook;
        return old;
    }

    public BiConsumer<ValueNode.ExprNode, SymbolTable> hookRetrn(BiConsumer<ValueNode.ExprNode, SymbolTable> retrnHook) {
        BiConsumer<ValueNode.ExprNode, SymbolTable> old = this.meta.retrn;
        this.meta.retrn = retrnHook;
        return old;
    }

    public String canonicalize(String name) {
        return name.toUpperCase();
    }

    public BiFunction<String, Usage, Usage> hookRead(BiFunction<String, Usage, Usage> getHook) {
        BiFunction<String, Usage, Usage> old = this.meta.read;
        this.meta.read = getHook;
        return old;
    }

    public Consumer<SymbolTable> hookContinue(Consumer<SymbolTable> contHook) {
        Consumer<SymbolTable> old = this.meta.cont;
        this.meta.cont = contHook;
        return old;
    }

    public Consumer<SymbolTable> hookExit(Consumer<SymbolTable> exitHook) {
        Consumer<SymbolTable> old = this.meta.exit;
        this.meta.exit = exitHook;
        return old;
    }

    public BiConsumer<EnumSet<PlsqlException>, ParseNode> hookExceptions(BiConsumer<EnumSet<PlsqlException>, ParseNode> exceptionsHook) {
        BiConsumer<EnumSet<PlsqlException>, ParseNode> old = this.meta.exceptions;
        this.meta.exceptions = exceptionsHook;
        return old;
    }

    public void exceptions(EnumSet<PlsqlException> exceptions, ParseNode pos) {
        this.meta.exceptions.accept(exceptions, pos);
    }

    public void pushMetadata() {
    }

    public void popMetadata() {
        this.meta = this.metadataStack.pop();
    }

    void dump(boolean global) {
        for (String name : this.assigns.keySet()) {
            Usage u = global ? this.read(name) : this.assigns.get(name);
            System.out.print(u + " <-");
            for (Usage u2 : u.getSources()) {
                System.out.print(" " + u2);
            }
            System.out.print(" ->");
            for (Usage u2 : u.getFlows()) {
                System.out.print(" " + u2);
            }
            System.out.println();
        }
    }

    class Metadata {
        Usage loopContinue;
        Usage loopExit;
        AssignmentHook write;
        BiFunction<String, Usage, Usage> read;
        Consumer<SymbolTable> cont;
        Consumer<SymbolTable> exit;
        BiConsumer<ValueNode.ExprNode, SymbolTable> retrn;
        BiConsumer<EnumSet<PlsqlException>, ParseNode> exceptions;

        private Metadata() {
            this.loopContinue = null;
            this.loopExit = null;
            this.write = (a, b, c) -> {};
            this.read = (a, b) -> b;
            this.cont = a -> {};
            this.exit = a -> {};
            this.retrn = (a, b) -> {};
            this.exceptions = (a, b) -> {};
        }

        private Metadata(Metadata meta) {
            this.loopContinue = meta.loopContinue;
            this.loopExit = meta.loopExit;
            this.write = meta.write;
            this.read = meta.read;
            this.cont = meta.cont;
            this.exit = meta.exit;
            this.retrn = meta.retrn;
            this.exceptions = meta.exceptions;
        }
    }

    @FunctionalInterface
    static interface AssignmentHook {
        public void accept(Usage var1, ParseNode var2, SymbolTable var3);
    }
}

