/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SqlInjectionGraph;

public class ParmSpec {
    private int pos;
    private String name;
    private PlsqlType type;
    private SqlInjectionGraph.ParameterMode mode;
    boolean noCopy;
    boolean defaulted;

    ParmSpec(int pos, String name, PlsqlType type, SqlInjectionGraph.ParameterMode mode) {
        this(pos, name, type, mode, false, false);
    }

    ParmSpec(int pos, String name, PlsqlType type, SqlInjectionGraph.ParameterMode mode, boolean noCopy, boolean defaulted) {
        this.pos = pos;
        this.name = name;
        this.type = type;
        this.mode = mode;
        this.noCopy = noCopy;
    }

    ParmSpec(int pos, String name, String dataType, SqlInjectionGraph.ParameterMode mode) {
        this.pos = pos;
        this.name = name;
        this.mode = mode;
        this.noCopy = false;
        switch (dataType) {
            case "OPAQUE/XMLTYPE": {
                break;
            }
            case "REF CURSOR": {
                break;
            }
            case "TABLE": {
                break;
            }
            case "OBJECT": {
                break;
            }
            case "PL/SQL TABLE": {
                this.type = new PlsqlType.Record();
                break;
            }
            case "REF": {
                break;
            }
            case "VARRAY": {
                this.type = new PlsqlType.Collection(null);
                throw new InternalError("Type of collection unread");
            }
            case "PL/SQL RECORD": {
                this.type = new PlsqlType.Record();
                break;
            }
            case "UNDEFINED": {
                break;
            }
            default: {
                throw new SqlInjectionAnalysisFailure("Unrecognized datatype " + dataType);
            }
        }
    }

    public SqlInjectionGraph.ParameterMode getMode() {
        if (this.mode == null) {
            return SqlInjectionGraph.ParameterMode.OUT;
        }
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public int getPos() {
        return this.pos;
    }

    public PlsqlType getType() {
        return this.type;
    }

    public boolean isNoCopy() {
        return this.noCopy;
    }

    public boolean isDefaulted() {
        return this.defaulted;
    }

    public String toString() {
        return this.pos + ":" + this.name + " " + this.type + " " + this.mode + (this.noCopy ? " NOCOPY" : "");
    }
}

