/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.script.ScriptException;
import oracle.arbori.scripting.GlobalMap;
import oracle.arbori.util.DictionaryViews;
import oracle.dbtools.app.Completer;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.app.JSCompleter;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.insight.BasicTabCol;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RecognizedRule;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.mysql.MysqlEarley;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.util.Service;

public class SqlCompleter
extends Completer {
    public String lastFunctionCallName;
    protected static final String color32 = "\u001b[32m";
    protected static final String color1 = "\u001b[1m";
    protected static final String color0 = "\u001b[0m";
    Earley earley = null;
    public int editorOffset = -1;
    IProgram programInstance = null;
    Dialect dialect = null;
    private Connection _conn = null;
    private static Map<Connection, DictionaryViews> conn2DictView = new HashMap<Connection, DictionaryViews>();
    public static int timeout = 5000;
    public static long thresholdWeightFactor = 133640L;
    public static int maxKeywordSuggestions = 10;
    public static int maxRuleSuggestions = 3;
    static final String missingId = "MISSING_ID";
    public static boolean reportedNoJSEngineAvailable = false;
    public static int maxUsers = 20;
    public static int maxObjects = 50;
    static final String MySQL = "MySQL";
    static final String H2 = "H2";
    private final int minPrefLen = 3;
    private final String NOTASYNONYM = "NOTASYNONYM";
    private Map<String, String> synonymCache = new HashMap<String, String>();

    public static void main(String[] args) throws Exception {
        Connection conn = null;
        if (1 == args.length) {
            conn = DriverManager.getConnection(args[0]);
        }
        SqlCompleter c = new SqlCompleter(conn);
        String input = "select * from hr.employees e \r\n          join hr.departments d on e.department_id = d.department_id;\r\n\r\nselect * from hr.employees where !";
        int pos = input.indexOf("!");
        input = input.replace("!", "");
        System.out.println("pos=" + pos);
        long t1 = System.currentTimeMillis();
        CompletionList candidates = c.complete(input, pos);
        System.out.println("offset=" + c.editorOffset);
        System.out.println(candidates.toString());
        long t2 = System.currentTimeMillis();
        System.out.println("Time = " + (t2 - t1));
        c.complete(input, pos);
        long t3 = System.currentTimeMillis();
        System.out.println("Time again = " + (t3 - t2));
    }

    public SqlCompleter(Connection conn) {
        this._conn = conn;
    }

    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    private String convert2Dba(String query) throws SQLException {
        if (this.dialect != Dialect.ORACLE) {
            return query;
        }
        DictionaryViews dv = conn2DictView.get(this.getConnection());
        if (dv == null) {
            dv = new DictionaryViews(this.getConnection());
            conn2DictView.put(this.getConnection(), dv);
        }
        return dv.translate(query);
    }

    private ResultSet executeQuery(final PreparedStatement stmt) throws SQLException {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(timeout);
                    if (stmt != null) {
                        stmt.cancel();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
        try {
            ResultSet ret = stmt.executeQuery();
            return ret;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public Set<Long> predict(int pos, Matrix matrix) {
        Parser.EarleyCell cell;
        if (1 < pos && (cell = matrix.get(pos - 1, pos)) != null) {
            for (int i = 0; i < cell.size(); ++i) {
                if (cell.getPosition(i) != 1) continue;
                int rule = cell.getRule(i);
                if (this.earley.rules[rule].head != this.earley.getSymbol("select_list") || this.earley.rules[rule].rhs[0] != this.earley.getSymbol("'*'")) continue;
                HashSet<Long> predictions = new HashSet<Long>();
                predictions.add(Service.lPair((int)this.earley.getSymbol("'FROM'"), (int)this.earley.getSymbol("from_clause")));
                predictions.add(Service.lPair((int)this.earley.getSymbol("'INTO'"), (int)this.earley.getSymbol("into_list")));
                return predictions;
            }
        }
        return this.earley.predict(pos, matrix);
    }

    String condition() {
        if (this.dialect == Dialect.MySQL) {
            return "predicate";
        }
        return "condition";
    }

    String simple_comparison_condition___1() {
        if (this.dialect == Dialect.MySQL) {
            return "predicate";
        }
        return "simple_comparison_condition___1";
    }

    String cmp_op() {
        if (this.dialect == Dialect.MySQL) {
            return "comparisonOperator";
        }
        return "cmp_op";
    }

    String paren_expr_list() {
        if (this.dialect == Dialect.MySQL) {
            return "functionCall";
        }
        return "paren_expr_list";
    }

    String expr() {
        if (this.dialect == Dialect.MySQL) {
            return "expression";
        }
        return "expr";
    }

    String stmt() {
        if (this.dialect == Dialect.MySQL) {
            return "procedureSqlStatement";
        }
        return "stmt";
    }

    String table_reference() {
        if (this.dialect == Dialect.MySQL) {
            return "tableSource";
        }
        return "table_reference";
    }

    String dml_table_expression_clause() {
        if (this.dialect == Dialect.MySQL) {
            return "tableSource";
        }
        return "dml_table_expression_clause";
    }

    String column() {
        if (this.dialect == Dialect.MySQL) {
            return "fullColumnName";
        }
        return "column";
    }

    String bind_var() {
        if (this.dialect == Dialect.MySQL) {
            return "mysqlVariable";
        }
        return "bind_var";
    }

    String constrained_type() {
        if (this.dialect == Dialect.MySQL) {
            return "dataType";
        }
        return "constrained_type";
    }

    public List<RecognizedRule> topRuleSuggestions(SyntaxError err, LexerToken prefix, List<LexerToken> src) {
        int N = 100;
        List tmp = err.topNrules(100, false, prefix == null ? null : prefix.content);
        long cutWeight = -1L;
        LinkedList<RecognizedRule> ret = new LinkedList<RecognizedRule>();
        int i = 0;
        for (RecognizedRule rr : tmp) {
            if (cutWeight == -1L) {
                cutWeight = rr.weight / thresholdWeightFactor;
            }
            if (rr.weight < cutWeight || maxKeywordSuggestions <= i) break;
            if (!rr.isKeyword()) continue;
            ret.add(rr);
            ++i;
        }
        cutWeight = -1L;
        i = 0;
        for (RecognizedRule rr : tmp) {
            if (cutWeight == -1L) {
                cutWeight = rr.weight / thresholdWeightFactor;
            }
            if (rr.weight < cutWeight || maxRuleSuggestions <= i) break;
            if (ret.contains(rr)) continue;
            rr.head = this.sugarcoatSymbol(rr.head);
            rr.rhs[0] = this.sugarcoatSymbol(rr.rhs[0]);
            ret.add(rr);
            ++i;
        }
        return ret;
    }

    private Map<Long, Integer> getFrequencies() {
        if (this.dialect == Dialect.ORACLE) {
            return HarvestDoc.getFrequencies();
        }
        if (this.dialect == Dialect.MySQL) {
            return MysqlEarley.getFrequencies();
        }
        return null;
    }

    public Set<String> topKWsuggestions(Set<Long> suggestions, LexerToken prefix) {
        if (this.getFrequencies() == null) {
            TreeSet<String> ret = new TreeSet<String>();
            int cnt = 0;
            for (long entry : suggestions) {
                String sym;
                Object prefixKW = "'";
                if (prefix != null) {
                    prefixKW = "'" + prefix.content;
                }
                if (!(sym = this.earley.allSymbols[Service.lX((long)entry)]).startsWith(((String)prefixKW).toUpperCase()) || sym.length() < 5 && !"'*'".equals(sym) && !"'-'".equals(sym) || ret.contains(sym = sym.substring(1, sym.length() - 1))) continue;
                ret.add(sym);
                if (50 >= ++cnt) continue;
                break;
            }
            return ret;
        }
        TreeMap<Long, Integer> topN = new TreeMap<Long, Integer>();
        int N = 10;
        for (long entry : suggestions) {
            String string;
            String sym;
            Object prefixKW = "'";
            if (prefix != null) {
                prefixKW = "'" + prefix.content;
            }
            if (!(sym = this.earley.allSymbols[Service.lX((long)entry)]).startsWith(((String)prefixKW).toUpperCase()) || sym.length() < 4 && !"'*'".equals(sym) && !"'-'".equals(sym) || (string = this.earley.allSymbols[Service.lY((long)entry)]).endsWith("]\"") && 0 < string.indexOf("[") && 2 + sym.length() < string.length()) continue;
            long minVar = -1L;
            int minVal = Integer.MAX_VALUE;
            Iterator iterator = topN.keySet().iterator();
            while (iterator.hasNext()) {
                long s = (Long)iterator.next();
                int tmp = (Integer)topN.get(s);
                if (tmp >= minVal) continue;
                minVar = s;
                minVal = tmp;
            }
            long suggestedVar = entry;
            Integer suggestedVal = this.getFrequencies().get(entry);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            if (topN.size() == 10) {
                if (suggestedVal == null || minVal >= suggestedVal) continue;
                topN.remove(minVar);
                topN.put(suggestedVar, suggestedVal);
                continue;
            }
            topN.put(suggestedVar, suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry e : topN.entrySet()) {
            myList.add(e);
        }
        Collections.sort(myList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        int div = 0;
        if (prefix != null) {
            div = prefix.content.length();
        }
        TreeSet<String> ret = new TreeSet<String>();
        int i = 0;
        for (Map.Entry entry : myList) {
            if (10 < i) break;
            String sugg = this.earley.allSymbols[Service.lX((long)((Long)entry.getKey()))];
            sugg = sugg.substring(1, sugg.length() - 1);
            if ("true".equals(HiddenParameters.parameters.get("coloredComplete"))) {
                String pre = sugg.substring(0, div);
                String post = sugg.substring(div);
                ret.add(color0 + pre + color32 + post + color0);
            } else {
                ret.add(sugg);
            }
            ++i;
        }
        return ret;
    }

    public String sugarcoatSymbol(String s) {
        if (s.startsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        int pos = s.indexOf(91);
        if (0 < pos) {
            return s.substring(0, pos);
        }
        return s;
    }

    private void printRules(Collection<RecognizedRule> rules, String symbol) {
        int i = -1;
        for (RecognizedRule r : rules) {
            ++i;
            if (!r.head.contains(symbol)) continue;
            System.out.println("i=" + i + "    " + r.toString() + " , weight=" + r.weight);
        }
    }

    private Set<RecognizedRule> inline(Collection<RecognizedRule> input, Matrix matrix, List<LexerToken> src) {
        TreeSet<RecognizedRule> ret = new TreeSet<RecognizedRule>();
        for (RecognizedRule rr : input) {
            ret.addAll(this.inlineRecognized(rr, matrix, src));
            ret.addAll(this.inlineAtPos(rr, matrix, src));
        }
        return ret;
    }

    private List<RecognizedRule> inlineRecognized(RecognizedRule input, Matrix matrix, List<LexerToken> src) {
        LinkedList<RecognizedRule> ret = new LinkedList<RecognizedRule>();
        if (input.X == input.Y) {
            return ret;
        }
        Parser.EarleyCell cell = matrix.get(input.X, input.Y);
        ParseNode node = this.earley.treeForACell(src, matrix, cell, input.X, input.Y);
        LinkedList rhs = node.flatten();
        ret.add(new RecognizedRule(input, rhs.toArray(new String[0]), null));
        return ret;
    }

    private List<RecognizedRule> inlineAtPos(RecognizedRule input, Matrix matrix, List<LexerToken> src) {
        LinkedList<RecognizedRule> ret = new LinkedList<RecognizedRule>();
        String symbol = input.rhs[input.pos];
        if ("...".equals(symbol)) {
            return ret;
        }
        int code = (Integer)SqlEarley.getInstance().symbolIndexes.get(symbol);
        Map railroads = HarvestDoc.getRailroads();
        DocURL tdoc = (DocURL)railroads.get(code);
        if (!(tdoc != null || symbol.charAt(0) == '\'' || "identifier".equals(symbol) || "digits".equals(symbol) || "boolean".equals(symbol) || "path".equals(symbol) || "url".equals(symbol))) {
            Parser.Tuple[] tuples = SqlEarley.getInstance().rules;
            for (int i = 0; i < tuples.length; ++i) {
                Parser.Tuple candidate = tuples[i];
                if (candidate.head != code) continue;
                ret.add(new RecognizedRule(input, input.pos, candidate.rhs, candidate.head));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompletionList complete(String input, int pos) {
        CompletionList completionList;
        if (((String)input).length() < pos) {
            pos = ((String)input).length();
        }
        if (this.dialect == null) {
            try {
                Object vendor;
                Connection conn = this.getConnection();
                Object object = vendor = null == conn ? null : conn.getMetaData().getDatabaseProductName();
                this.dialect = MySQL.equals(vendor) ? Dialect.MySQL : (H2.equals(vendor) ? Dialect.H2 : Dialect.ORACLE);
            }
            catch (Throwable conn) {
                // empty catch block
            }
        }
        CompletionList ret = new CompletionList();
        this.earley = SqlEarley.partialRecognizer();
        if (this.dialect == Dialect.MySQL) {
            try {
                this.earley = new MysqlEarley();
            }
            catch (Throwable vendor) {
                // empty catch block
            }
        }
        if (this.dialect != Dialect.MySQL) {
            try {
                for (CompletionItem c : new JSCompleter(this.earley).complete((String)input, pos)) {
                    ret.add(c);
                }
            }
            catch (Throwable vendor) {
                // empty catch block
            }
        }
        try {
            Set<String> topKWsuggestions2;
            String dot;
            Object typePredicate;
            TreeSet<String> predictions2;
            Object extra;
            SyntaxError error;
            List src;
            int lexOptions = 63;
            if (this.dialect == Dialect.MySQL) {
                lexOptions = 319;
            }
            if (0 == (src = Lexer.parse((String)input, (boolean)false, (int)lexOptions)).size()) {
                CompletionList completionList2 = ret;
                return completionList2;
            }
            try {
                LexerToken tmp = LexerToken.getTokenAtCharOffset((List)src, (int)pos);
                if (tmp.posInsideLiteral(pos)) {
                    CompletionList completionList3 = ret;
                    return completionList3;
                }
            }
            catch (Exception tmp) {
                // empty catch block
            }
            Matrix matrix = new Matrix((Parser)this.earley);
            this.earley.parse(src, matrix);
            String[] toRecognize = new String[]{"sql_statements", "select", "insert", "update", "delete", "merge"};
            if (this.dialect == Dialect.MySQL) {
                toRecognize = new String[]{"sqlStatements"};
            }
            if ((error = SyntaxError.checkSyntax((String)input, (String[])toRecognize, (List)src, (Earley)this.earley, (Matrix)matrix, (String)"^^^", (String)"SyntaxError_DetailedMessage")) != null) {
                int select = -1;
                int from = -1;
                for (LexerToken t : src) {
                    if ("select".equalsIgnoreCase(t.content) && t.end < pos) {
                        select = t.end;
                    }
                    if (0 > select || !"from".equalsIgnoreCase(t.content)) continue;
                    if (pos < t.begin) {
                        from = t.begin;
                        break;
                    }
                    select = -1;
                }
                if (0 <= select && 0 <= from) {
                    String selClause = ((String)input).substring(select, from);
                    List selTokens = Lexer.parse((String)selClause, (boolean)false, (int)lexOptions);
                    if (1 < selTokens.size() && ".".equals(((LexerToken)selTokens.get((int)(selTokens.size() - 1))).content)) {
                        ret.alias = ((LexerToken)selTokens.get((int)(selTokens.size() - 2))).content;
                    } else if (2 < selTokens.size() && ".".equals(((LexerToken)selTokens.get((int)(selTokens.size() - 2))).content)) {
                        ret.prefix = (LexerToken)selTokens.get(selTokens.size() - 1);
                        ret.alias = ((LexerToken)selTokens.get((int)(selTokens.size() - 3))).content;
                    }
                    String prefix = ((String)input).substring(0, select);
                    if (error.end <= select) {
                        prefix = "select";
                        pos = prefix.length() + 1;
                    } else {
                        pos = select + 1;
                    }
                    input = prefix + " * " + ((String)input).substring(from);
                    src = Lexer.parse((String)input, (boolean)false, (int)lexOptions);
                    matrix = new Matrix((Parser)this.earley);
                    this.earley.parse(src, matrix);
                } else {
                    this.editorOffset = LexerToken.char2lex((List)src, (int)pos, (boolean)true);
                    LexerToken cur = null;
                    if (this.editorOffset < src.size()) {
                        cur = (LexerToken)src.get(this.editorOffset);
                    }
                    Set<Long> predicted = this.predict(this.editorOffset, matrix);
                    TreeSet<String> predictions = new TreeSet<String>();
                    for (long key : predicted) {
                        predictions.add(this.earley.allSymbols[Service.lX((long)key)]);
                    }
                    if (predictions.contains("';'")) {
                        extra = ";";
                        input = ((String)input).substring(0, pos) + (String)extra + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, (boolean)false, (int)lexOptions);
                    } else if (predictions.contains("')'")) {
                        extra = ");";
                        input = ((String)input).substring(0, pos) + (String)extra + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, (boolean)false, (int)lexOptions);
                    } else if (predictions.contains(this.simple_comparison_condition___1())) {
                        extra = "=1 ";
                        if (predictions.contains(this.condition())) {
                            extra = " MISSING_ID" + (String)extra;
                        }
                        input = ((String)input).substring(0, pos) + (String)extra + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, (boolean)false, (int)lexOptions);
                    } else if (predictions.contains("identifier") && (cur == null || !cur.incomplete())) {
                        extra = " MISSING_ID";
                        if (2 < this.editorOffset && !predictions.contains(this.table_reference())) {
                            Set<Long> predicted2 = this.predict(this.editorOffset - 2, matrix);
                            predictions2 = new TreeSet<String>();
                            for (long key : predicted2) {
                                predictions2.add(this.earley.allSymbols[Service.lX((long)key)]);
                            }
                            if (predictions2.contains(this.condition())) {
                                extra = " MISSING_ID and 1 ";
                            }
                        }
                        input = ((String)input).substring(0, pos) + (String)extra + " " + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, (boolean)false, (int)lexOptions);
                    }
                }
            }
            Parsed target = new Parsed((String)input, src, this.earley, (String)null);
            this.editorOffset = LexerToken.char2lex((List)src, (int)pos);
            if (this.editorOffset < src.size() && ((LexerToken)src.get((int)this.editorOffset)).begin < pos && pos <= ((LexerToken)src.get((int)this.editorOffset)).end) {
                ret.prefix = (LexerToken)src.get(this.editorOffset);
            }
            if (!(ret.prefix == null || ret.prefix.type != Token.OPERATION || ret.prefix.content.equals(":") || ret.prefix.content.equals("!") || ret.prefix.content.equals("^"))) {
                ret.prefix = null;
                ++this.editorOffset;
            }
            if ("*".equals(ret.prefix)) {
                ret.prefix = null;
                --this.editorOffset;
            }
            if (ret.alias == null) {
                if (0 <= this.editorOffset - 2 && this.editorOffset < src.size() && ".".equals(((LexerToken)src.get((int)(this.editorOffset - 1))).content)) {
                    ret.alias = ((LexerToken)src.get((int)(this.editorOffset - 2))).content;
                } else if (0 <= this.editorOffset - 3 && this.editorOffset < src.size() && ".".equals(((LexerToken)src.get((int)(this.editorOffset - 2))).content)) {
                    ret.alias = ((LexerToken)src.get((int)(this.editorOffset - 3))).content;
                }
            }
            if (4 <= ((LexerToken)src.get((int)0)).content.length() && ((LexerToken)src.get((int)0)).content.substring(0, 4).equalsIgnoreCase("desc") || 3 <= ((LexerToken)src.get((int)0)).content.length() && ((LexerToken)src.get((int)0)).content.substring(0, 3).equalsIgnoreCase("ddl") || 4 <= ((LexerToken)src.get((int)0)).content.length() && ((LexerToken)src.get((int)0)).content.substring(0, 4).equalsIgnoreCase("info") || 4 <= ((LexerToken)src.get((int)0)).content.length() && ((LexerToken)src.get((int)0)).content.substring(0, 4).equalsIgnoreCase("ctas")) {
                String pref = "";
                if (ret.prefix != null) {
                    pref = ret.prefix.content;
                    if (pos < ret.prefix.end) {
                        pref = pref.substring(0, pos - ret.prefix.begin);
                    }
                }
                String owner = null;
                String obj = pref;
                if (2 < src.size() && ".".equals(((LexerToken)src.get((int)2)).content)) {
                    owner = ((LexerToken)src.get((int)1)).content.toUpperCase();
                }
                typePredicate = "object_type in ('TABLE','VIEW','SYNONYM','PACKAGE','PROCEDURE','FUNCTION','TYPE') and";
                if (0 < obj.length()) {
                    typePredicate = "";
                }
                for (CompletionItem sugg : this.queryObjects(owner, obj.toUpperCase(), (String)typePredicate)) {
                    ret.add(sugg);
                }
                ret.pos = pos - pref.length();
                extra = ret;
                return extra;
            }
            int div = 0;
            if (ret.prefix != null) {
                div = ret.prefix.content.length();
            }
            Set<Long> predicted = this.predict(this.editorOffset, matrix);
            TreeSet<String> predictions = new TreeSet<String>();
            typePredicate = predicted.iterator();
            while (typePredicate.hasNext()) {
                long key = (Long)typePredicate.next();
                predictions.add(this.earley.allSymbols[Service.lX((long)key)]);
            }
            HashMap<String, String> alias2table = new HashMap<String, String>();
            Map output = null;
            if (predictions.contains(this.expr()) || predictions.contains("identifier") && predictions.contains(this.stmt()) || predictions.contains(this.bind_var())) {
                if (output == null) {
                    output = this.getProgram(this.earley).eval(target, this);
                }
                MaterializedPredicate vars = (MaterializedPredicate)output.get("localVars");
                for (Object t : vars.getTuples()) {
                    ParseNode id = vars.getAttribute((Tuple)t, "id");
                    String string = ((LexerToken)src.get((int)id.from)).content;
                    ret.add(new CompletionItem(string, CompletionItem.Type.COLUMN));
                }
            }
            String filter = "object_type in ('TABLE','VIEW','SYNONYM') and";
            if (!predictions.contains(this.table_reference()) && !predictions.contains(this.dml_table_expression_clause())) {
                MaterializedPredicate connect;
                Object t;
                if (output == null) {
                    output = this.getProgram(this.earley).eval(target, this);
                }
                if (this.dialect != Dialect.MySQL && (t = (connect = (MaterializedPredicate)output.get("connect")).getTuples().iterator()).hasNext()) {
                    Tuple t2 = (Tuple)t.next();
                    ParseNode parseNode = connect.getAttribute(t2, "command");
                    String pref = ((LexerToken)src.get((int)(parseNode.from + 1))).content;
                    if (missingId.equals(pref)) {
                        pref = "";
                    }
                    if (";".equals(pref)) {
                        pref = "";
                    }
                    for (String sugg : NetEntries.getMatching(pref)) {
                        ret.add(new CompletionItem(sugg, CompletionItem.Type.TURLNET));
                    }
                    CompletionList completionList4 = ret;
                    return completionList4;
                }
                predictions2 = new TreeSet<String>();
                if (predictions.contains("identifier") && 1 < this.editorOffset) {
                    Set<Long> predicted2 = this.predict(this.editorOffset - 2, target.getMatrix());
                    for (long l : predicted2) {
                        predictions2.add(this.earley.allSymbols[Service.lX((long)l)]);
                    }
                }
                if (predictions.contains("identifier") && predictions2.contains(this.constrained_type())) {
                    String tbl = null;
                    if (1 < this.editorOffset && ".".equals(((LexerToken)src.get((int)(this.editorOffset - 1))).content)) {
                        tbl = ((LexerToken)src.get((int)(this.editorOffset - 2))).content.toUpperCase();
                        for (String string : this.queryColumns(null, tbl, null)) {
                            ret.add(new CompletionItem(string + "%TYPE", CompletionItem.Type.JAVA_CLASS));
                        }
                    }
                }
                boolean isJoin = false;
                MaterializedPredicate widestQb = (MaterializedPredicate)output.get("\"widest qb\"");
                Iterator iterator = widestQb.getTuples().iterator();
                if (iterator.hasNext()) {
                    Tuple t3 = (Tuple)iterator.next();
                    ParseNode parseNode = widestQb.getAttribute(t3, "query_block");
                    int j = 0;
                    for (LexerToken lt : target.getSrc()) {
                        if (j < parseNode.from) continue;
                        if (parseNode.to <= j) break;
                        if ("JOIN".equalsIgnoreCase(lt.content)) {
                            isJoin = true;
                            break;
                        }
                        ++j;
                    }
                }
                MaterializedPredicate materializedPredicate = (MaterializedPredicate)output.get("\"table_alias in widest qb\"");
                for (Tuple tuple : materializedPredicate.getTuples()) {
                    ParseNode tst;
                    String tableExpr;
                    ParseNode table = materializedPredicate.getAttribute(tuple, "table");
                    ParseNode alias = materializedPredicate.getAttribute(tuple, "alias");
                    if (ret.alias != null && !ret.alias.toUpperCase().equals(((LexerToken)src.get((int)alias.from)).content.toUpperCase())) continue;
                    if (table.from + 1 == table.to && alias.from + 1 == alias.to) {
                        alias2table.put(((LexerToken)src.get((int)alias.from)).content.toUpperCase(), ((LexerToken)src.get((int)table.from)).content.toUpperCase());
                    }
                    String _alias = "'" + ((LexerToken)src.get((int)alias.from)).content.toUpperCase() + "'";
                    List _src = src.subList(0, alias.from);
                    Matrix _matrix = new Matrix((Parser)this.earley);
                    this.earley.parse(_src, _matrix);
                    Set<Long> _predicted = this.predict(alias.from, _matrix);
                    TreeSet<String> _predictions = new TreeSet<String>();
                    for (long key : _predicted) {
                        _predictions.add(this.earley.allSymbols[Service.lX((long)key)]);
                    }
                    if (_predictions.contains(_alias)) {
                        alias = table;
                    }
                    int begin = ((LexerToken)src.get((int)table.from)).begin;
                    int end = ((LexerToken)src.get((int)(table.to - 1))).end;
                    String owner = null;
                    String tab = null;
                    if (ret.prefix != null) {
                        tab = ret.prefix.content;
                        if (pos < ret.prefix.end) {
                            tab = tab.substring(0, pos - ret.prefix.begin);
                        }
                    }
                    if (0 < (tableExpr = target.getInput().substring(begin, end)).indexOf(46)) {
                        owner = tableExpr.substring(0, tableExpr.indexOf(46));
                        tab = tableExpr.substring(tableExpr.indexOf(46) + 1);
                    } else {
                        owner = null;
                        tab = tableExpr;
                    }
                    if (table == alias && table.to < src.size() && ".".equals(((LexerToken)src.get((int)table.to)).content)) {
                        owner = tableExpr;
                        tab = "";
                        ret.prefix = null;
                    }
                    tab = tab.trim();
                    String aliased = ((LexerToken)src.get((int)alias.from)).content + ".";
                    if (predictions.contains(this.column()) || predictions2.contains(this.column())) {
                        String prefix = null;
                        if (ret.prefix != null) {
                            if (alias == table) {
                                prefix = ret.prefix.content;
                            }
                            if (0 < this.editorOffset && ".".equals(((LexerToken)src.get((int)(this.editorOffset - 1))).content)) {
                                prefix = ret.prefix.content;
                            }
                        }
                        int cnt = 0;
                        for (String string : this.queryColumns(owner, tab, prefix)) {
                            void var33_113;
                            if (1 < materializedPredicate.cardinality() || isJoin) {
                                String string2 = aliased + string;
                                div += aliased.length();
                            } else if (0 == cnt++) {
                                ret.add(new CompletionItem(aliased, CompletionItem.Type.COLUMN));
                            }
                            ret.add(new CompletionItem((String)var33_113, CompletionItem.Type.COLUMN));
                        }
                        if (prefix != null && ret.alias == null) {
                            for (CompletionItem completionItem : this.queryObjects(null, prefix.toUpperCase(), "object_type in ('SEQUENCE') and")) {
                                ret.add(completionItem);
                            }
                        }
                        Map<String, ParseNode> inlineViews = BasicTabCol.getInlineViewNodes(target.getRoot(), target.getSrc());
                        block28: for (String key : inlineViews.keySet()) {
                            ParseNode candidate = inlineViews.get(key);
                            if (candidate == null) {
                                candidate = inlineViews.get("inline subquery");
                            }
                            ParseNode inlineViewSelectList = BasicTabCol.getSelectList(candidate);
                            ArrayList<BasicTabCol.Column> inlineViewColumns = BasicTabCol.extractColumns(inlineViewSelectList, target.getSrc(), false, false);
                            for (int i = 0; i < inlineViewColumns.size(); ++i) {
                                BasicTabCol.Column c = inlineViewColumns.get(i);
                                String colName = c.alias;
                                if (colName == null) {
                                    ParseNode cExpr = c.colExpr;
                                    if (cExpr == null || cExpr.to - cExpr.from != 3 && cExpr.to - cExpr.from != 1) continue block28;
                                    colName = ((LexerToken)target.getSrc().get((int)(cExpr.to - 1))).content;
                                }
                                ret.add(new CompletionItem(colName, CompletionItem.Type.COLUMN));
                            }
                        }
                    }
                    boolean ok = true;
                    for (String symbol : predictions) {
                        if (!symbol.startsWith("where_clause") && !symbol.startsWith("\"fromClause[7,14)\"")) continue;
                        ok = false;
                        break;
                    }
                    if (!ok || (tst = target.getRoot().descendant(this.editorOffset, this.editorOffset, this.earley.getSymbol(this.table_reference()))) == null || tst.to > tst.from + 4) continue;
                    for (CompletionItem completionItem : this.queryObjects(owner, tab.toUpperCase(), "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                        ret.add(completionItem);
                    }
                }
            } else {
                String prefix = "";
                if (ret.prefix != null) {
                    prefix = ret.prefix.content;
                    if (pos < ret.prefix.end) {
                        prefix = prefix.substring(0, pos - ret.prefix.begin);
                    }
                }
                for (CompletionItem sugg : this.queryObjects(null, prefix, "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                    ret.add(sugg);
                }
            }
            boolean isPackaged = false;
            if (!(!predictions.contains("function_call") && !predictions.contains("decl_id") || 2 > this.editorOffset && ret.alias == null || !".".equals(dot = ((LexerToken)src.get((int)(this.editorOffset - 1))).content) && ret.alias == null)) {
                void var19_66;
                isPackaged = true;
                String pkg = ret.alias != null ? ret.alias : ((LexerToken)src.get((int)(this.editorOffset - 2))).content;
                String string = "";
                if (ret.prefix != null) {
                    String string3 = ret.prefix.content;
                    if (pos < ret.prefix.end) {
                        String string4 = string3.substring(0, pos - ret.prefix.begin);
                    }
                }
                for (CompletionItem completionItem : this.queryPackageProcedures(null, pkg, (String)var19_66, predictions.contains("condition"))) {
                    ret.add(completionItem);
                }
                for (CompletionItem completionItem : this.queryPackageProcedures(pkg, null, (String)var19_66, predictions.contains("condition"))) {
                    ret.add(completionItem);
                }
            }
            if (!isPackaged && predictions.contains("function_call")) {
                String prefix = "";
                if (ret.prefix != null) {
                    prefix = ret.prefix.content;
                }
                for (CompletionItem completionItem : this.queryPackageProcedures(null, null, prefix, predictions.contains("condition"))) {
                    ret.add(completionItem);
                }
                if (0 < prefix.length()) {
                    for (CompletionItem completionItem : this.queryObjects(null, prefix.toUpperCase(), "object_type in ('PACKAGE','TYPE') and")) {
                        ret.add(completionItem);
                    }
                }
            }
            if (predictions.contains(this.condition())) {
                for (CompletionItem item : this.joinConditions(ret.entries, alias2table)) {
                    ret.add(item);
                }
            }
            if (this.lastFunctionCallName != null && predictions.contains("arg")) {
                void var19_74;
                String pkg = null;
                String fun = null;
                if (0 < this.lastFunctionCallName.indexOf(46)) {
                    pkg = this.lastFunctionCallName.substring(0, this.lastFunctionCallName.indexOf(46));
                    fun = this.lastFunctionCallName.substring(this.lastFunctionCallName.indexOf(46) + 1);
                } else {
                    pkg = null;
                    fun = this.lastFunctionCallName;
                }
                String string = "";
                if (ret.prefix != null) {
                    String string5 = ret.prefix.content;
                }
                for (String string6 : this.inlineArguments(this.queryArguments(pkg, fun, (String)var19_74))) {
                    ret.add(new CompletionItem(string6, CompletionItem.Type.ARGUMENT));
                }
            }
            if (ret.alias == null && ((topKWsuggestions2 = this.topKWsuggestions(predicted, ret.prefix)).size() <= 10 && ret.size() == 0 || ret.prefix != null)) {
                for (String string : topKWsuggestions2) {
                    ret.add(new CompletionItem(string, CompletionItem.Type.KEYWORD));
                }
            }
            if (ret.size() == 1 && 0 < ret.first().toString().indexOf(32)) {
                CompletionList topKWsuggestions2 = ret;
                return topKWsuggestions2;
            }
            int p = pos;
            if (ret.prefix != null) {
                p = pos - ret.prefix.content.length();
            }
            ret.pos = p;
            CompletionList completionList5 = ret;
            return completionList5;
        }
        catch (SQLRecoverableException e) {
            completionList = ret;
            return completionList;
        }
        catch (Throwable t) {
            t.printStackTrace();
            completionList = ret;
            return completionList;
        }
    }

    public void addSuggestionItem(CompletionList ret, RecognizedRule sugg) {
        String symbol = sugg.rhs[sugg.pos];
        if (symbol.charAt(0) == '\'') {
            ret.add(new CompletionItem(symbol.substring(1, symbol.length() - 1), CompletionItem.Type.KEYWORD));
        }
    }

    private IProgram getProgram(Earley earley) throws IOException {
        if (this.programInstance == null) {
            String file = "completion.prg";
            if (this.dialect == Dialect.MySQL) {
                file = "completion_mysql.prg";
            }
            this.programInstance = new IProgram(earley, Service.readFile(SqlCompleter.class, (String)file));
        }
        this.programInstance.offset = this.editorOffset;
        GlobalMap globals = this.programInstance.getGlobals();
        if (globals != null) {
            globals.put("editorOffset", (Object)this.editorOffset);
        }
        return this.programInstance;
    }

    public static String discolor(String cleaned) {
        cleaned = cleaned.replace(color0, "");
        cleaned = cleaned.replace(color1, "");
        cleaned = cleaned.replace(color32, "");
        return cleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompletionItem> queryObjects(String Owner, String prefix, String typesClause) throws SQLException {
        String owner;
        if (this.dialect == Dialect.H2) {
            return new LinkedList<CompletionItem>();
        }
        Connection conn = this.getConnection();
        if (conn == null) {
            return new LinkedList<CompletionItem>();
        }
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        String query = this.objectsDictSql(typesClause);
        if (Owner != null) {
            query = this.objectsByOwnerDictSql(typesClause);
        }
        if ((owner = Owner) != null) {
            owner = Owner.toUpperCase();
            if (this.dialect == Dialect.MySQL) {
                owner = Owner.toLowerCase();
            }
        }
        if (3 <= prefix.length() && this.dialect != Dialect.MySQL) {
            query = query.replace("owner=user", "owner in ('PUBLIC','SYS',user)");
        }
        PreparedStatement stmt = conn.prepareStatement(this.convert2Dba(query));
        int pos = 1;
        String leadingWildCard = this.prefixWildcard;
        if (prefix.length() < 3) {
            leadingWildCard = "";
        }
        if (owner != null) {
            stmt.setObject(pos++, owner);
        } else if (this.dialect != Dialect.MySQL) {
            stmt.setObject(pos++, leadingWildCard + prefix.toUpperCase().replace("_", "\\_") + "%");
        }
        stmt.setObject(pos++, leadingWildCard + prefix.toUpperCase().replace("_", "\\_") + "%");
        ResultSet rs = this.executeQuery(stmt);
        try {
            LinkedList<CompletionItem> users = new LinkedList<CompletionItem>();
            LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
            while (rs != null && rs.next()) {
                String candidate = rs.getString(1);
                String type = rs.getString(2);
                if (candidate.endsWith(".")) {
                    users.add(new CompletionItem(candidate, CompletionItem.Type.USER));
                    continue;
                }
                if ("TABLE".equalsIgnoreCase(type) || "BASE TABLE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.TABLE);
                    continue;
                }
                if ("VIEW".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.VIEW);
                    continue;
                }
                if ("SYNONYM".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.SYNONYM);
                    continue;
                }
                if ("PROCEDURE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PROCEDURE);
                    continue;
                }
                if ("FUNCTION".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.FUNCTION);
                    continue;
                }
                if ("PACKAGE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PACKAGE);
                    continue;
                }
                if ("PACKAGE BODY".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PACKAGE_BODY);
                    continue;
                }
                if ("SEQUENCE".equalsIgnoreCase(type)) {
                    this.addUnique(candidate + ".nextval", ret, CompletionItem.Type.SEQUENCE);
                    continue;
                }
                if ("INDEX".equalsIgnoreCase(type)) {
                    this.addUnique(candidate, ret, CompletionItem.Type.INDEX);
                    continue;
                }
                ret.add(new CompletionItem(candidate, CompletionItem.Type.OTHER_DB_OBJECT));
            }
            if (users.size() < maxUsers) {
                ret.addAll(users);
            }
            LinkedList<CompletionItem> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String objectsByOwnerDictSql(String typesClause) throws SQLException {
        if (this.dialect == Dialect.MySQL) {
            return "SELECT upper(table_name) object_name,\n    table_type\nFROM information_schema.tables\nWHERE table_schema = ?\nAND table_name like ? \nORDER BY table_name";
        }
        return "select object_name, object_type from all_objects \nwhere " + typesClause + " owner = :1 and object_name like :2 ESCAPE '\\' \nand rownum < " + maxObjects + " order by object_name";
    }

    public String objectsDictSql(String typesClause) throws SQLException {
        if (this.dialect == Dialect.MySQL) {
            Connection conn = this.getConnection();
            String database = null == conn ? null : conn.getCatalog();
            return "SELECT upper(table_name) object_name,\n    table_type\nFROM information_schema.tables\nWHERE table_schema = '" + database + "'\nAND table_name like ? \nORDER BY table_name";
        }
        return "select /*distinct*/ object_name, object_type from all_objects \nwhere " + typesClause + " owner=user \nand object_name like :1 ESCAPE '\\' and rownum < 50\nunion all \nselect username||'.', 'USER' from all_users where username like :2 and rownum <= " + maxUsers + " \norder by object_name";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> queryColumns(String Owner, String Table2, String prefix) throws SQLException {
        String table;
        Connection conn = this.getConnection();
        if (conn == null) {
            return new LinkedList<String>();
        }
        String owner = Owner;
        if (owner != null) {
            owner = Owner.toUpperCase();
            if (this.dialect == Dialect.MySQL) {
                owner = Owner.toLowerCase();
            }
        }
        if ((table = Table2) != null) {
            table = Table2.toUpperCase();
            if (this.dialect == Dialect.MySQL) {
                table = Table2.toLowerCase();
            } else {
                String synTab = this.getTable(owner, table);
                if (synTab != null) {
                    table = synTab;
                    int pos = synTab.indexOf(46);
                    if (0 < pos) {
                        owner = synTab.substring(0, pos);
                        table = synTab.substring(pos + 1);
                    }
                }
            }
        }
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        String query = this.columnsDictSql();
        if (owner != null) {
            query = this.columnsByOwnerDictSql();
        }
        PreparedStatement stmt = conn.prepareStatement(this.convert2Dba(query));
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner);
        }
        stmt.setObject(pos++, table);
        if (3 <= prefix.length()) {
            stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase() + "%");
        } else {
            stmt.setObject(pos++, prefix.toUpperCase() + "%");
        }
        ResultSet rs = this.executeQuery(stmt);
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs != null && rs.next()) {
                ret.add(rs.getString(1));
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String columnsByOwnerDictSql() throws SQLException {
        String product;
        Connection conn = this.getConnection();
        String string = product = null == conn ? null : conn.getMetaData().getDatabaseProductName();
        if (MySQL.equals(product)) {
            return "SELECT upper(column_name) column_name\nFROM information_schema.columns\nWHERE table_schema = ? AND table_name = ? AND column_name like ? \nORDER BY column_name";
        }
        return "select column_name from all_tab_columns where owner = :1 and table_name = :2 \nand column_name like :2 and rownum < 50 order by column_name\n";
    }

    public String columnsDictSql() throws SQLException {
        String product;
        Connection conn = this.getConnection();
        String string = product = null == conn ? null : conn.getMetaData().getDatabaseProductName();
        if (MySQL.equals(product)) {
            String database = null == conn ? null : conn.getCatalog();
            return "SELECT upper(column_name) column_name\nFROM information_schema.columns\nWHERE table_schema = '" + database + "'\nAND table_name = ? AND column_name like ? \nORDER BY column_name";
        }
        return "select column_name from all_tab_columns where table_name = :1 and owner in ('PUBLIC','SYS',user) \nand column_name like :2 and rownum < 50 order by column_name\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompletionItem> queryPackageProcedures(String owner, String pkg, String prefix, boolean functionsOnly) throws SQLException {
        Connection conn;
        String synTab;
        if (this.dialect == Dialect.H2) {
            return new LinkedList<CompletionItem>();
        }
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (pkg != null && (synTab = this.getTable(owner, pkg.toUpperCase())) != null) {
            pkg = synTab;
            int pos1 = synTab.indexOf(46);
            if (0 < pos1) {
                owner = synTab.substring(0, pos1);
                pkg = synTab.substring(pos1 + 1);
            }
        }
        String query = "select procedure_name from sys.all_procedures \nwhere owner in ('PUBLIC','SYS', USER) and object_name = :1 \nand procedure_name like :2 and object_type = 'PACKAGE' \nand rownum < 50 order by procedure_name\n";
        if (pkg == null) {
            query = query.replace("procedure_name from", "object_name from");
            query = query.replace("and procedure_name like :2", "");
            query = query.replace("object_name = :1", "object_name like :1");
            query = query.replace("object_type = 'PACKAGE'", "object_type in (" + (!functionsOnly ? "'PROCEDURE'," : "") + "'FUNCTION')");
        }
        if (owner != null) {
            query = query.replace("owner in ('PUBLIC','SYS', USER)", "owner = :1");
            query = query.replace(":2", ":3");
            query = query.replace(":1", ":2");
        }
        if (pkg == null && prefix.length() < 3) {
            query = query.replace("owner in ('PUBLIC','SYS', USER)", "owner = user");
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<CompletionItem>();
        }
        PreparedStatement stmt = conn.prepareStatement(this.convert2Dba(query));
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        }
        if (pkg != null) {
            stmt.setObject(pos++, pkg.toUpperCase());
        }
        if (3 <= prefix.length()) {
            stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase() + "%");
        } else {
            stmt.setObject(pos++, prefix.toUpperCase() + "%");
        }
        ResultSet rs = this.executeQuery(stmt);
        try {
            LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
            while (rs != null && rs.next()) {
                this.addUnique(rs, ret, CompletionItem.Type.PROCEDURE);
            }
            LinkedList<CompletionItem> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> queryArguments(String pkg, String function, String prefix) throws SQLException {
        if (this.dialect == Dialect.H2) {
            return new LinkedList<String>();
        }
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        Object query = "SELECT  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name, \n a.argument_name||'=>'||substr(a.argument_name,1,1)||'/*'||a.data_type||' '||a.defaulted||'*/' argument, a.position position \nFROM all_arguments a \nWHERE rownum <=50 and    argument_name is not null \n";
        query = pkg != null ? (String)query + "and package_name = :1 and object_name = :2  and argument_name like :3 \norder by position \n" : (String)query + "and  object_name = :1 and owner in ('PUBLIC','SYS',user) \n and argument_name like :2 order by position";
        Connection conn = this.getConnection();
        if (conn == null) {
            return new LinkedList<String>();
        }
        PreparedStatement stmt = conn.prepareStatement(this.convert2Dba((String)query));
        int pos = 1;
        if (pkg != null) {
            stmt.setObject(pos++, pkg.toUpperCase());
        }
        stmt.setObject(pos++, function.toUpperCase());
        if (3 <= prefix.length()) {
            stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase() + "%");
        } else {
            stmt.setObject(pos++, prefix.toUpperCase() + "%");
        }
        ResultSet rs = this.executeQuery(stmt);
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs != null && rs.next()) {
                String a = rs.getString(2);
                if (ret.contains(a)) continue;
                ret.add(a);
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<String> inlineArguments(List<String> arguments) {
        LinkedList<String> ret = new LinkedList<String>();
        StringBuilder fullArgs = new StringBuilder();
        StringBuilder shortArgs = new StringBuilder();
        for (String arg : arguments) {
            boolean isDefault = 0 < arg.indexOf(" Y*/");
            arg = arg.replace(" Y*/", "*/");
            arg = arg.replace(" N*/", "*/");
            if (fullArgs.length() > 0) {
                fullArgs.append(",");
            }
            fullArgs.append(arg);
            if (isDefault) continue;
            if (shortArgs.length() > 0) {
                shortArgs.append(",");
            }
            shortArgs.append(arg);
        }
        if (fullArgs.length() != shortArgs.length()) {
            ret.add("/*min sig:*/" + shortArgs.toString());
            ret.add("/*full sig:*/" + fullArgs.toString());
        } else {
            ret.add(fullArgs.toString());
        }
        return ret;
    }

    private void addUnique(ResultSet rs, List<CompletionItem> ret, CompletionItem.Type type) throws SQLException {
        String candidate = rs.getString(1);
        if (!candidate.endsWith(".")) {
            candidate = Service.addDoubleQuote((String)candidate);
        }
        this.addUnique(candidate, ret, type);
    }

    private void addUnique(String name, List<CompletionItem> ret, CompletionItem.Type type) {
        CompletionItem item = new CompletionItem(name, type);
        if (!ret.contains(item)) {
            // empty if block
        }
        ret.add(item);
    }

    private List<CompletionItem> joinConditions(List<CompletionItem> items, Map<String, String> alias2table) {
        LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
        int cnt = 0;
        block0: for (CompletionItem first : items) {
            String firstName = first.entry;
            int fi = firstName.indexOf(46);
            if (fi <= 0 || !CompletionItem.Type.COLUMN.equals((Object)first.type)) continue;
            for (CompletionItem second : items) {
                String secondName = second.entry;
                int si = secondName.indexOf(46);
                if (si <= 0 || firstName.compareTo(secondName) <= 0 || !CompletionItem.Type.COLUMN.equals((Object)first.type) || !this.colNamesMatch(firstName, secondName, alias2table)) continue;
                ret.add(new CompletionItem(firstName + " = " + secondName, CompletionItem.Type.CONDITION));
                if (++cnt <= 50) continue;
                break block0;
            }
        }
        return ret;
    }

    private boolean colNamesMatch(String firstCol, String secondCol, Map<String, String> alias2table) {
        int fi = firstCol.indexOf(46);
        if (fi < 0) {
            return false;
        }
        int si = secondCol.indexOf(46);
        if (si < 0) {
            return false;
        }
        String firstNAME = firstCol.substring(fi + 1).toUpperCase();
        String secondNAME = secondCol.substring(si + 1).toUpperCase();
        if (firstNAME == null) {
            return false;
        }
        if (firstNAME.equals(secondNAME)) {
            return true;
        }
        String tmp1 = alias2table.get(firstCol.substring(0, fi).toUpperCase());
        if (tmp1 == null) {
            return false;
        }
        String firstTABLE = tmp1.toUpperCase();
        String tmp2 = alias2table.get(secondCol.substring(0, si).toUpperCase());
        if (tmp2 == null) {
            return false;
        }
        String secondTABLE = tmp2.toUpperCase();
        return firstNAME.startsWith(firstTABLE) && secondNAME.equals(firstNAME + "_ID") || firstNAME.startsWith(firstTABLE) && secondNAME.equals(firstNAME + "_NAME") || secondNAME.startsWith(secondTABLE) && firstNAME.equals(secondNAME + "_ID") || secondNAME.startsWith(secondTABLE) && firstNAME.equals(secondNAME + "_NAME") || this.tabColNamesMatch(firstNAME, firstTABLE) && firstNAME.endsWith("_ID") && this.tabColNamesMatch(secondNAME, secondTABLE) && secondNAME.endsWith("_ID") || this.tabColNamesMatch(firstNAME, firstTABLE) && firstNAME.endsWith("_NAME") && this.tabColNamesMatch(secondNAME, secondTABLE) && secondNAME.endsWith("_NAME");
    }

    private boolean tabColNamesMatch(String column, String table) {
        if (table.length() < 5 || column.length() < 5) {
            return false;
        }
        for (int i = 0; i < table.length() - 5; ++i) {
            String tab = table.substring(i, i + 5);
            if (!column.contains(tab)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTable(String owner, String synonym) {
        if (this.synonymCache.containsKey(this.fullName(synonym, owner))) {
            String ret = this.synonymCache.get(this.fullName(synonym, owner));
            if (!"NOTASYNONYM".equals(ret)) return ret;
            return null;
        }
        Object ownerInClause = "owner in (user,'PUBLIC')";
        if (owner != null) {
            ownerInClause = "owner = '" + Service.handleMixedCase((String)owner) + "'";
        }
        Statement stmt = null;
        try {
            Connection conn = this.getConnection();
            if (null == conn) {
                String string = null;
                return string;
            }
            stmt = conn.prepareStatement("select table_owner, table_name from all_synonyms \nwhere " + (String)ownerInClause + " and synonym_name=? \n");
            stmt.setObject(1, synonym);
            ResultSet rs = this.executeQuery((PreparedStatement)stmt);
            if (rs != null && rs.next()) {
                String ret = rs.getString("table_owner") + "." + rs.getString("table_name");
                this.synonymCache.put(this.fullName(synonym, owner), ret);
                String string = ret;
                return string;
            }
            this.synonymCache.put(this.fullName(synonym, owner), "NOTASYNONYM");
            String string = null;
            return string;
        }
        catch (SQLException e) {
            String string = null;
            return string;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String fullName(String synonym, String owner) {
        if (owner == null) {
            return synonym;
        }
        return owner + "." + synonym;
    }

    public void lastFunction(Parsed target, Map<String, ParseNode> tuple) {
        String name;
        ParseNode node = tuple.get("name");
        this.lastFunctionCallName = name = target.getInput().substring(((LexerToken)target.getSrc().get((int)node.from)).begin, ((LexerToken)target.getSrc().get((int)(node.to - 1))).end);
    }

    static class IProgram
    extends Program {
        public int offset = -1;

        private IProgram(Earley earley, String programText) throws IOException {
            super(earley, null);
            try {
                this.compile(programText, this.struct);
            }
            catch (ScriptException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static enum Dialect {
        ORACLE,
        MySQL,
        H2;

    }
}

