/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.app.Format;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.util.Service;

public class FormattingPreferences {
    public static boolean debug = false;
    public Format format;
    private String[] alignedKeywords = new String[]{"SELECT", "INTO", "FROM", "JOIN", "RIGHT", "WHERE", "OR", "AND", "GROUP", "HAVING", "ORDER", "UPDATE", "SET", "FETCH"};
    public String breakOnSubqueries = "breakOnSubqueries";
    public String breakAnsiiJoin = "breakAnsiiJoin";
    public String breakParenCondition = "breakParenCondition";

    public void invokeAllGuessMethods(String sample) throws Exception {
        List src = Lexer.parse((String)sample);
        SqlEarley earley = SqlEarley.getInstance();
        ParseNode root = earley.parse(src);
        Parsed target = null;
        if (this.format.programInstance == null) {
            try {
                this.format.format("");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        target = new Parsed(sample, src, root);
        Map rels = this.format.programInstance.eval(target);
        for (Method m : FormattingPreferences.class.getDeclaredMethods()) {
            if (!m.getName().startsWith("guess") || !Modifier.isPublic(m.getModifiers())) continue;
            try {
                m.invoke((Object)this, sample, src, root, rels);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void guessSingleLineComments(String sample, List<LexerToken> srcDummy, ParseNode rootDummy, Map<String, MaterializedPredicate> rels) {
        int slComments = 0;
        int mlComments = 0;
        List src = Lexer.parse((String)sample, (boolean)true);
        for (LexerToken t : src) {
            if (t.type == Token.COMMENT) {
                ++mlComments;
                continue;
            }
            if (t.type != Token.LINE_COMMENT) continue;
            ++slComments;
        }
        if (debug) {
            System.out.println("==================SingleLineComments==================");
            System.out.println("slComments=" + slComments);
            System.out.println("mlComments=" + mlComments);
        }
        if (3 < slComments && mlComments * 20 < slComments) {
            this.format.options.put(this.format.singleLineComments, (Object)Format.InlineComments.SingleLine);
        } else if (3 < mlComments && slComments * 20 < mlComments) {
            this.format.options.put(this.format.singleLineComments, (Object)Format.InlineComments.MultiLine);
        } else {
            this.format.options.put(this.format.singleLineComments, (Object)Format.InlineComments.CommentsUnchanged);
        }
    }

    public void guessKwCase(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessCase(sample, src, root, true);
    }

    public void guessIdCase(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessCase(sample, src, root, false);
    }

    private void guessCase(String sample, List<LexerToken> src, ParseNode root, boolean isKw) {
        int cntUpper = 0;
        int cntLower = 0;
        int cntInitcap = 0;
        for (ParseNode desc : root.descendants()) {
            String word;
            if (desc.from + 1 != desc.to || desc.contains(SqlEarley.getInstance().identifier) == isKw || !Character.isLetter((word = src.get((int)desc.from).content).charAt(0)) || word.length() < 2) continue;
            if (Character.isUpperCase(word.charAt(0)) && Character.isUpperCase(word.charAt(1))) {
                ++cntUpper;
                continue;
            }
            if (Character.isUpperCase(word.charAt(0)) && Character.isLowerCase(word.charAt(1))) {
                ++cntInitcap;
                continue;
            }
            if (!Character.isLowerCase(word.charAt(0)) || !Character.isLowerCase(word.charAt(1))) continue;
            ++cntLower;
        }
        Format.Case ret = Format.Case.NoCaseChange;
        if (cntLower * 9 < cntUpper && cntInitcap * 10 < cntUpper) {
            ret = Format.Case.UPPER;
        }
        if (cntUpper * 9 < cntLower && cntInitcap * 10 < cntLower) {
            ret = Format.Case.lower;
        }
        if (cntLower * 9 < cntInitcap && cntUpper * 10 < cntInitcap) {
            ret = Format.Case.InitCap;
        }
        if (debug) {
            System.out.println("==================" + (isKw ? "keywords" : "identifiers") + "==================");
            System.out.println("Upper=" + cntUpper);
            System.out.println("Lower=" + cntLower);
            System.out.println("Initcap=" + cntInitcap);
        }
        this.format.options.put(isKw ? this.format.kwCase : this.format.idCase, (Object)ret);
    }

    public void guessSpaces(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int[] idents = new int[200];
        StringTokenizer st = new StringTokenizer(sample, "\n");
        int priorFullIndent = -1;
        LinkedList<Integer> priorRelativeIndents = new LinkedList<Integer>();
        while (st.hasMoreTokens()) {
            int ident;
            String token = st.nextToken();
            token = token.replace("\r", "");
            if ((token = token.replace("\t", "")).length() == 0) continue;
            for (ident = 0; ident < token.length() && token.charAt(ident) == ' '; ++ident) {
            }
            if (priorFullIndent == -1) {
                priorFullIndent = ident;
                priorRelativeIndents.add(ident);
                continue;
            }
            int index = ident - priorFullIndent;
            if (index == 0) {
                if (priorRelativeIndents.size() == 0) {
                    priorRelativeIndents.add(ident);
                    continue;
                }
                Integer tmp = (Integer)priorRelativeIndents.getLast();
                if (tmp != 0) {
                    index = tmp;
                }
            }
            if (index < 0) {
                index = -index;
                if (priorRelativeIndents.size() == 0) {
                    priorRelativeIndents.add(ident);
                    continue;
                }
                priorRelativeIndents.removeLast();
            } else if (priorFullIndent < ident) {
                priorRelativeIndents.add(index);
            }
            if (index != 0) {
                int n = index;
                idents[n] = idents[n] + 1;
            }
            priorFullIndent = ident;
        }
        if (debug) {
            System.out.println("==================spaces==================");
            for (int i = 0; i < idents.length; ++i) {
                if (idents[i] == 0) continue;
                System.out.println("idents[" + i + "]=" + idents[i]);
            }
        }
        int ret = 1;
        for (int i = 1; i < idents.length; ++i) {
            if (idents[ret] >= idents[i]) continue;
            ret = i;
        }
        this.format.options.put(this.format.identSpaces, ret);
    }

    private void guessAlign(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels, String idSymbol, String id1Symbol, String scopeSymbol, String formatOpt) {
        int aligned = 0;
        int misaligned = 0;
        TreeMap<ParseNode, LinkedList<Integer>> offsets = new TreeMap<ParseNode, LinkedList<Integer>>();
        MaterializedPredicate idsInTheScope = rels.get("paddedIdsInScope");
        for (Tuple t : idsInTheScope.getTuples()) {
            ParseNode id = idsInTheScope.getAttribute(t, "predecessor");
            ParseNode id1 = idsInTheScope.getAttribute(t, "follower");
            ParseNode scope = idsInTheScope.getAttribute(t, "scope");
            if (idSymbol != null && !id.contains(idSymbol) || id1Symbol != null && !id1.contains(id1Symbol) || scopeSymbol != null && !scope.contains(scopeSymbol)) continue;
            int nlPos = sample.substring(0, src.get((int)id.from).begin).lastIndexOf(10);
            LinkedList<Integer> localOffsets = (LinkedList<Integer>)offsets.get(scope);
            if (localOffsets == null) {
                localOffsets = new LinkedList<Integer>();
                offsets.put(scope, localOffsets);
            }
            localOffsets.add(src.get((int)id1.from).begin - nlPos);
        }
        for (ParseNode scope : offsets.keySet()) {
            List localOffsets = (List)offsets.get(scope);
            Integer prior = null;
            Iterator iterator = localOffsets.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (prior == null) {
                    prior = i;
                    continue;
                }
                if (prior == i) {
                    ++aligned;
                } else {
                    ++misaligned;
                }
                prior = i;
            }
        }
        if (debug) {
            System.out.println("==================" + formatOpt + "==================");
            System.out.println("aligned=" + aligned);
            System.out.println("misaligned=" + misaligned);
        }
        if (0 < aligned || 0 < misaligned) {
            this.format.options.put(formatOpt, 2 < aligned && misaligned * 5 < aligned);
        }
    }

    public void guessAlignTabColAliases(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessAlign(sample, src, root, rels, "column", "as_alias", "select_clause", this.format.alignTabColAliases);
    }

    public void guessAlignTypeDecl(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessAlign(sample, src, root, rels, null, "datatype", null, this.format.alignTypeDecl);
        this.guessAlign(sample, src, root, rels, "decl_id", null, null, this.format.alignTypeDecl);
    }

    public void guessAlignNamedArgs(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessAlign(sample, src, root, rels, "sim_expr", "'='", "paren_expr_list", this.format.alignNamedArgs);
    }

    public void guessAlignAssignments(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessAlign(sample, src, root, rels, "name", "':'", null, this.format.alignAssignments);
    }

    public void guessAlignEquality(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessAlign(sample, src, root, rels, "column", "'='", "where_clause", this.format.alignEquality);
    }

    public void guessRightAlign(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        boolean tmp = debug;
        debug = false;
        this.guessSpaces(sample, src, root, rels);
        debug = tmp;
        int indent = this.format.identSpaces.length();
        int selectLen = "SELECT".length();
        int rightAligned = 0;
        int indented = 0;
        LexerToken prior = null;
        for (LexerToken t : src) {
            for (String kw : this.alignedKeywords) {
                if (prior == null) break;
                if (!kw.equals(t.content.toUpperCase()) || t.content.length() == selectLen) continue;
                String prefix = sample.substring(prior.end, t.begin);
                prefix = prefix.replace("\n", "");
                if ((prefix = prefix.replace("\r", "")).length() % indent == selectLen - t.content.length()) {
                    ++rightAligned;
                }
                if (prefix.length() % indent != 0) continue;
                ++indented;
            }
            prior = t;
        }
        if (debug) {
            System.out.println("==================RightAlign==================");
            System.out.println("rightAligned=" + rightAligned);
            System.out.println("indented=" + indented);
        }
        this.format.options.put(this.format.alignRight, indented < rightAligned);
    }

    public void guessUseTab(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int tabNo = 0;
        int spaceNo = 0;
        StringTokenizer st = new StringTokenizer(sample, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.replace("\r", "")).startsWith("\t")) {
                ++tabNo;
            }
            if (!token.startsWith(" ")) continue;
            ++spaceNo;
        }
        if (debug) {
            System.out.println("==================UseTab==================");
            System.out.println("tabNo=" + tabNo);
            System.out.println("spaceNo=" + spaceNo);
        }
        this.format.options.put(this.format.useTab, spaceNo < tabNo);
    }

    private void guessBreaks(String sample, String symbol, String fmtOption) {
        int before = 0;
        int after = 0;
        int noBreak = 0;
        StringTokenizer st = new StringTokenizer(sample, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token = token.replace("\r", "");
            token = token.replace("\t", "");
            if ((token = token.replace(" ", "")).startsWith(symbol)) {
                ++before;
            }
            if (token.endsWith(symbol)) {
                ++after;
            }
            if (token.indexOf(symbol) == token.lastIndexOf(symbol)) continue;
            ++noBreak;
        }
        if (debug) {
            System.out.println("==================" + fmtOption + "==================");
            System.out.println("before=" + before);
            System.out.println("after=" + after);
            System.out.println("noBreak=" + noBreak);
        }
        if (before > after && before > noBreak) {
            this.format.options.put(this.format.breaksComma, (Object)Format.Breaks.Before);
        } else if (before < after && noBreak < after) {
            this.format.options.put(this.format.breaksComma, (Object)Format.Breaks.After);
        } else if (before < noBreak && after < noBreak) {
            this.format.options.put(this.format.breaksComma, (Object)Format.Breaks.None);
        }
    }

    public void guessBreaksComma(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessBreaks(sample, ",", this.format.breaksComma);
    }

    public void guessBreaksConcat(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.guessBreaks(sample, "||", this.format.breaksConcat);
    }

    private boolean matchesSyntax(ParseNode node, String syntax) {
        if (node == null) {
            return false;
        }
        if (node.contains(syntax)) {
            return true;
        }
        ParseNode child = node.parent();
        return this.matchesSyntax(child, syntax);
    }

    private long balanceOfBreaksBeforeToken(String sample, List<LexerToken> src, ParseNode root, String symbol, String syntax) {
        return this.balanceOfBreaksAroundToken(sample, src, root, symbol, syntax, false);
    }

    private long balanceOfBreaksAfterToken(String sample, List<LexerToken> src, ParseNode root, String symbol, String syntax) {
        return this.balanceOfBreaksAroundToken(sample, src, root, symbol, syntax, true);
    }

    private long balanceOfBreaksAroundToken(String sample, List<LexerToken> src, ParseNode root, String symbol, String syntax, boolean after) {
        int total = 0;
        int matches = 0;
        int pos = -1;
        LexerToken prior = null;
        for (LexerToken t : src) {
            ++pos;
            if (symbol.equalsIgnoreCase(t.content)) {
                if (sample.length() < t.end + 2) break;
                if (!this.matchesSyntax(root.leafAtPos(pos), syntax)) continue;
                ++total;
                String tmp = sample.substring(t.end, t.end + 2);
                if (!after) {
                    if (prior == null) continue;
                    tmp = sample.substring(prior.end, prior.end + 2);
                }
                if (tmp.startsWith("\n")) {
                    ++matches;
                } else if (tmp.startsWith("\r\n")) {
                    ++matches;
                }
            }
            prior = t;
        }
        if (debug) {
            System.out.println("==================balanceOfBreaks " + (after ? "After" : "Before") + " Token " + symbol + "==================");
            System.out.println("matches=" + matches);
            System.out.println("total=" + total);
        }
        return Service.lPair((int)matches, (int)total);
    }

    public void guessBreaksAroundLogicalConjunctions(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = this.balanceOfBreaksAfterToken(sample, src, root, "OR", "condition");
        int matches = Service.lX((long)pair);
        int total = Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "AND", "condition");
        matches += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "OR", "pls_expr");
        matches += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "AND", "pls_expr");
        int matchesAfter = matches += Service.lX((long)pair);
        int totalAfter = total += Service.lY((long)pair);
        pair = this.balanceOfBreaksBeforeToken(sample, src, root, "OR", "condition");
        matches = Service.lX((long)pair);
        total = Service.lY((long)pair);
        pair = this.balanceOfBreaksBeforeToken(sample, src, root, "AND", "condition");
        matches += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksBeforeToken(sample, src, root, "OR", "pls_expr");
        matches += Service.lX((long)pair);
        total += Service.lY((long)pair);
        if (0 < totalAfter & 0 < (total += Service.lY((long)(pair = this.balanceOfBreaksBeforeToken(sample, src, root, "AND", "pls_expr")))) && totalAfter < matchesAfter * 2 & total < (matches += Service.lX((long)pair)) * 2) {
            this.format.options.put(this.format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.BeforeAndAfter);
            return;
        }
        if (0 < totalAfter && totalAfter < matchesAfter * 2) {
            this.format.options.put(this.format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.After);
            return;
        }
        if (0 < total && total < matches * 2) {
            this.format.options.put(this.format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.Before);
            return;
        }
        if (0 < totalAfter & 0 < total) {
            this.format.options.put(this.format.breaksAroundLogicalConjunctions, (Object)Format.Breaks.None);
        }
    }

    public void guessBreaksAfterSelect(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = this.balanceOfBreaksAfterToken(sample, src, root, "SELECT", "query_block");
        int matches = Service.lX((long)pair);
        int total = Service.lY((long)pair);
        if (0 < total) {
            this.format.options.put(this.format.breaksAfterSelect, 0 < matches);
        }
    }

    public void guessFlowControl(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long pair = this.balanceOfBreaksAfterToken(sample, src, root, "IF", "if_stmt");
        int brksAfterKw = Service.lX((long)pair);
        int total = Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "ELSIF", "if_stmt");
        brksAfterKw += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "ELSE", "if_stmt");
        brksAfterKw += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "WHEN", "case_stmt");
        brksAfterKw += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "WHEN", "case_expression");
        brksAfterKw += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "WHILE", "iteration_scheme");
        if ((total += Service.lY((long)pair)) < (brksAfterKw += Service.lX((long)pair)) * 2) {
            this.format.options.put(this.format.flowControl, (Object)Format.FlowControl.IndentedConditionsActions);
            if (debug) {
                System.out.println("************ flowControl = FlowControl.IndentedConditionsActions *************");
            }
            return;
        }
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "THEN", "if_stmt");
        brksAfterKw = Service.lX((long)pair);
        total = Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "THEN", "case_stmt");
        brksAfterKw += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksAfterToken(sample, src, root, "THEN", "case_expression");
        if ((total += Service.lY((long)pair)) < (brksAfterKw += Service.lX((long)pair)) * 2) {
            this.format.options.put(this.format.flowControl, (Object)Format.FlowControl.IndentedActions);
            if (debug) {
                System.out.println("************ flowControl = FlowControl.IndentedActions *************");
            }
            return;
        }
        pair = this.balanceOfBreaksBeforeToken(sample, src, root, "THEN", "if_stmt");
        brksAfterKw = Service.lX((long)pair);
        total = Service.lY((long)pair);
        pair = this.balanceOfBreaksBeforeToken(sample, src, root, "THEN", "case_stmt");
        brksAfterKw += Service.lX((long)pair);
        total += Service.lY((long)pair);
        pair = this.balanceOfBreaksBeforeToken(sample, src, root, "THEN", "case_expression");
        if ((total += Service.lY((long)pair)) < (brksAfterKw += Service.lX((long)pair)) * 2) {
            this.format.options.put(this.format.flowControl, (Object)Format.FlowControl.SeparateConditionsActions);
            if (debug) {
                System.out.println("************ flowControl = FlowControl.SeparateConditionsActions *************");
            }
            return;
        }
        this.format.options.put(this.format.flowControl, (Object)Format.FlowControl.Terse);
        if (debug) {
            System.out.println("************ flowControl = FlowControl.Terse *************");
        }
    }

    public void guessCommasPerLine(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int lines = 0;
        int commas = 0;
        boolean foundComma = false;
        StringTokenizer st = new StringTokenizer(sample, "\n,", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("\n".equals(token)) {
                if (foundComma) {
                    ++lines;
                }
                foundComma = false;
                continue;
            }
            if (!",".equals(token)) continue;
            foundComma = true;
            ++commas;
        }
        if (debug) {
            System.out.println("==================commasPerLine==================");
            System.out.println("lines=" + lines);
            System.out.println("commas=" + commas);
        }
        this.format.options.put(this.format.commasPerLine, (commas + 1) / (lines + 1));
    }

    public void guessMaxCharLineSize(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int maxLen = 0;
        StringTokenizer st = new StringTokenizer(sample, "\n,", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (maxLen >= token.length()) continue;
            maxLen = token.length();
        }
        if (debug) {
            System.out.println("==================MaxCharLineSize==================");
            System.out.println("maxLen=" + maxLen);
        }
        if (maxLen > 128) {
            this.format.options.put(this.format.maxCharLineSize, maxLen);
        }
    }

    public void guessBreakOnSubqueries(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.decideBreakOn(sample, src, new String[]{"subquery"}, new String[0], rels, this.format.breakOnSubqueries);
    }

    public void guessBreakAnsiiJoin(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.decideBreakOn(sample, src, new String[]{"table_reference", "condition"}, new String[]{"on_using_condition", "\"inner_cross_join_clause\"", "cross_outer_apply_clause"}, rels, this.format.breakAnsiiJoin);
    }

    public void guessBreakParenCondition(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        this.decideBreakOn(sample, src, new String[]{"'('"}, new String[]{"compound_condition"}, rels, this.format.breakParenCondition);
    }

    private void decideBreakOn(String sample, List<LexerToken> src, String[] nodeConditions, String[] parentConditions, Map<String, MaterializedPredicate> rels, String param) {
        int yes = 0;
        int no = 0;
        MaterializedPredicate formattedNodes = rels.get("indentedNodes1");
        for (Tuple t : formattedNodes.getTuples()) {
            ParseNode node = formattedNodes.getAttribute(t, "node");
            boolean proceed = nodeConditions.length == 0;
            for (String nodeCondition : nodeConditions) {
                if (!node.contains(nodeCondition)) continue;
                proceed = true;
                break;
            }
            if (!proceed) continue;
            proceed = parentConditions.length == 0;
            for (String parentCondition : parentConditions) {
                if (node.parent() == null || !node.parent().contains(parentCondition)) continue;
                proceed = true;
                break;
            }
            if (!proceed || node.from == 0) continue;
            int from = src.get((int)(node.from - 1)).end;
            int to = src.get((int)node.from).begin;
            String padding = sample.substring(from, to);
            if (0 < padding.indexOf(10)) {
                ++yes;
                continue;
            }
            ++no;
        }
        if (debug) {
            System.out.println("==================BreakOn " + nodeConditions[0] + "==================");
            System.out.println("yes=" + yes);
            System.out.println("no=" + no);
        }
        if (0 < yes || no < 0) {
            this.format.options.put(param, no < yes);
        }
    }

    public void guessForceLinebreaksBeforeComment(String sample, List<LexerToken> srcDummy, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int yes = 0;
        int no = 0;
        List src = Lexer.parse((String)sample, (boolean)true);
        LexerToken prior = null;
        for (LexerToken t : src) {
            if (prior != null && (t.type == Token.COMMENT || t.type == Token.LINE_COMMENT)) {
                int from = prior.end;
                int to = t.begin;
                String padding = sample.substring(from, to);
                if (padding.indexOf(10) != padding.lastIndexOf(10)) {
                    ++yes;
                    continue;
                }
                ++no;
                continue;
            }
            if (t.type == Token.WS) continue;
            prior = t;
        }
        if (debug) {
            System.out.println("==================ForceLinebreaksBeforeComment==================");
            System.out.println("yes=" + yes);
            System.out.println("no=" + no);
        }
        if (0 < yes || no < 0) {
            this.format.options.put(this.format.forceLinebreaksBeforeComment, no < yes);
        }
    }

    public void guessExtraLinesAfterSignificantStatements(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        int yes = 0;
        int no = 0;
        MaterializedPredicate extraLines = rels.get("brkX2");
        for (Tuple t : extraLines.getTuples()) {
            ParseNode node = extraLines.getAttribute(t, "node");
            if (node.to < src.size()) {
                int from = src.get((int)(node.to - 1)).end;
                int to = src.get((int)node.to).begin;
                String padding = sample.substring(from, to);
                if (padding.indexOf(10) != padding.lastIndexOf(10)) {
                    ++yes;
                    continue;
                }
                ++no;
                continue;
            }
            ++no;
        }
        if (debug) {
            System.out.println("==================ExtraLinesAfterSignificantStatements==================");
            System.out.println("yes=" + yes);
            System.out.println("no=" + no);
        }
        if (0 < yes || no < 0) {
            this.format.options.put(this.format.extraLinesAfterSignificantStatements, (Object)(no < yes ? Format.BreaksX2.X2 : Format.BreaksX2.X1));
        }
    }

    private long spaceAroundToken(String sample, List<LexerToken> src, ParseNode root, String symbol) {
        int before = 0;
        int after = 0;
        int cnt = 0;
        for (ParseNode node : root.descendants()) {
            if (!node.contains(symbol) || src.get((int)(node.to - 1)).end < sample.length() && sample.charAt(src.get((int)(node.to - 1)).end) == '\n' || src.get((int)(node.to - 1)).end < sample.length() && sample.charAt(src.get((int)(node.to - 1)).end) == '\r') continue;
            if (0 < src.get((int)node.from).begin && sample.charAt(src.get((int)node.from).begin - 1) == ' ') {
                ++before;
            }
            if (src.get((int)(node.to - 1)).end < sample.length() && sample.charAt(src.get((int)(node.to - 1)).end) == ' ') {
                ++after;
            }
            ++cnt;
        }
        if (debug) {
            System.out.println("================== spaceAfterToken " + symbol + " ==================");
            System.out.println("before=" + before);
            System.out.println("after=" + after);
            System.out.println("cnt=" + cnt);
        }
        return Service.lPair((int)cnt, (int)Service.pair((int)before, (int)after));
    }

    public void guessSpaceAroundOperators(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long cba = this.spaceAroundToken(sample, src, root, "relal_op");
        int cnt = Service.lX((long)cba);
        int ba = Service.lY((long)cba);
        int before = Service.X((int)ba);
        int after = Service.Y((int)ba);
        cba = this.spaceAroundToken(sample, src, root, "cmp_op");
        ba = Service.lY((long)cba);
        before += Service.X((int)ba);
        after += Service.Y((int)ba);
        if (0 < (cnt += Service.lX((long)cba))) {
            this.format.options.put(this.format.spaceAroundOperators, before * 3 >= cnt * 2 && after * 3 >= cnt * 2);
        }
    }

    public void guessSpaceAfterCommas(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long cba = this.spaceAroundToken(sample, src, root, "','");
        int cnt = Service.lX((long)cba);
        int ba = Service.lY((long)cba);
        int after = Service.Y((int)ba);
        if (0 < cnt) {
            this.format.options.put(this.format.spaceAfterCommas, after * 3 >= cnt * 2);
        }
    }

    public void guessSpaceAroundBrackets(String sample, List<LexerToken> src, ParseNode root, Map<String, MaterializedPredicate> rels) {
        long cba1 = this.spaceAroundToken(sample, src, root, "'('");
        int cnt1 = Service.lX((long)cba1);
        int ba1 = Service.lY((long)cba1);
        int before1 = Service.X((int)ba1);
        int after1 = Service.Y((int)ba1);
        long cba2 = this.spaceAroundToken(sample, src, root, "')'");
        int cnt2 = Service.lX((long)cba2);
        int ba2 = Service.lY((long)cba2);
        int before2 = Service.X((int)ba2);
        int after2 = Service.Y((int)ba2);
        Format.Space o = Format.Space.NoSpace;
        if ((before1 + after2) * 3 >= (cnt1 + cnt2) * 2) {
            o = Format.Space.Outside;
        }
        if ((before2 + after1) * 3 >= (cnt1 + cnt2) * 2) {
            o = Format.Space.Inside;
        }
        if (0 < cnt1 + cnt2) {
            this.format.options.put(this.format.spaceAroundBrackets, (Object)o);
        }
    }

    private static List<String> diffs(Map<String, Object> m1, Map<String, Object> m2) {
        if (m1.size() != m2.size()) {
            throw new AssertionError((Object)("m1.size()!= m2.size() " + m1.size() + "!=" + m2.size()));
        }
        LinkedList<String> ret = new LinkedList<String>();
        for (String k1 : m1.keySet()) {
            Object v1 = m1.get(k1);
            Object v2 = m2.get(k1);
            if (v2 == null) {
                throw new AssertionError((Object)("no matching key for " + k1));
            }
            if (v1.equals(v2)) continue;
            ret.add(k1);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(FormattingPreferences.class, (String)"usergrantshelpertest1_b.testsql");
        boolean runInDebugMode = false;
        Format format = new Format();
        FormattingPreferences formattingPreferences = new FormattingPreferences();
        formattingPreferences.format = format;
        if (runInDebugMode) {
            input = Service.readFile(FormattingPreferences.class, (String)"guessPreferences.sql");
            debug = true;
            formattingPreferences.invokeAllGuessMethods(input);
        } else {
            HashMap<String, Object> oldOptions = new HashMap<String, Object>();
            for (String k : format.options.keySet()) {
                oldOptions.put(k, format.options.get(k));
            }
            for (String pref : oldOptions.keySet()) {
                if ("adjustCaseOnly".equals(pref) || "formatProgramURL".equals(pref) || !"alignEquality".equals(pref)) continue;
                debug = true;
                Object value = oldOptions.get(pref);
                Comparable<Boolean> modified = null;
                format.setDefaultOptions();
                if (value instanceof Boolean) {
                    modified = (Boolean)value == false;
                } else if (value instanceof Integer) {
                    modified = (Integer)value + 1;
                } else if (value instanceof Enum) {
                    ?[] enums;
                    Enum e = (Enum)value;
                    Class<?> ce = e.getClass();
                    for (Object o : enums = ce.getEnumConstants()) {
                        if (o.equals(e)) continue;
                        modified = o;
                        break;
                    }
                }
                format.options.put(pref, modified);
                String formatted = new Format().format(input);
                format.setDefaultOptions();
                formattingPreferences.invokeAllGuessMethods(formatted);
                if (((Object)modified).equals(format.options.get(pref))) {
                    System.out.println(" ***** " + pref + " ***** OK");
                } else {
                    System.out.println(" ***** " + pref + " ***** " + format.options.get(pref) + " != " + modified);
                }
                List<String> diffs = FormattingPreferences.diffs(oldOptions, format.options);
                for (String d : diffs) {
                    if (d.equals(pref)) continue;
                    System.out.println(d + ":  " + oldOptions.get(d) + "->" + format.options.get(d));
                }
            }
        }
    }
}

