/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptException;
import oracle.dbtools.app.Issue;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class CodeScan {
    String[] ruleFiles;
    public Set<String> ruleExclusions = new HashSet<String>();
    protected Parsed target;

    public CodeScan(String[] ruleFiles) {
        this.ruleFiles = ruleFiles;
    }

    public Set<Issue> report(String input) {
        return this.report(input, false);
    }

    public Set<Issue> report(String input, boolean timing) {
        TreeSet<Issue> issues = new TreeSet<Issue>();
        try {
            Program.debug = false;
            Program.timing = timing;
            StringBuilder prg = new StringBuilder();
            for (int i = 0; i < this.ruleFiles.length; ++i) {
                prg.append(Program.getContent((String)this.ruleFiles[i]));
            }
            int[] lineMap = Service.lineMap((String)input);
            this.target = new Parsed(input, (Earley)SqlEarley.getInstance(), "sql_statements");
            for (ParseNode node : this.target.getRoot().descendants()) {
                if (!node.contains("wrap")) continue;
                return issues;
            }
            Program program = new Program((Earley)SqlEarley.getInstance(), (Object)this);
            try {
                program.compile(prg.toString(), (Object)this);
            }
            catch (ScriptException e) {
                throw new AssertionError((Object)e);
            }
            Map predicateVectors = program.eval(this.target, (Object)this);
            for (String key : predicateVectors.keySet()) {
                if (!key.contains(":") || !key.startsWith("\"")) continue;
                String ruleNo = key.substring(1, key.length() - 1);
                String msg = null;
                int offset = ruleNo.indexOf(":");
                if (0 < offset) {
                    msg = ruleNo.substring(offset + 2);
                    ruleNo = ruleNo.substring(0, offset);
                }
                if (this.ruleExclusions.contains(ruleNo)) continue;
                MaterializedPredicate rulePred = (MaterializedPredicate)predicateVectors.get(key);
                LinkedList<String> cols = new LinkedList<String>();
                for (int i = 0; i < rulePred.arity(); ++i) {
                    String col = rulePred.getAttribute(i);
                    if (col.contains("^") || col.contains("+") || col.contains("-")) continue;
                    cols.add(col);
                }
                String attr = (String)cols.get(0);
                if (cols.contains("node")) {
                    attr = "node";
                }
                for (Tuple t : rulePred.getTuples()) {
                    for (int i = 0; i < rulePred.arity(); ++i) {
                        ParseNode cell = rulePred.getAttribute(t, attr);
                        int pos = ((LexerToken)this.target.getSrc().get((int)cell.from)).begin;
                        int ln = Service.charPos2LineNo0((int[])lineMap, (int)pos);
                        int col = pos - Service.lineNo2CharPos0((int[])lineMap, (int)ln);
                        Issue issue = new Issue(ln, col, ruleNo, msg);
                        issues.add(issue);
                    }
                }
            }
        }
        catch (SyntaxError e) {
            System.err.println(e.getDetailedMessage());
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return issues;
    }
}

