/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

public class ModelObject
extends AbstractSQLFragment {
    public static final String TYPE = "MODEL";
    private static final String IGNORE = "IGNORE";
    private static final String KEEP = "KEEP";
    private static final String NAV = "NAV";
    private static final String UNIQUE = "UNIQUE";
    private static final String DIMENSION = "DIMENSION";
    private static final String SINGLE = "SINGLE";
    private static final String REFERENCE = "REFERENCE";
    private static final String RETURN = "RETURN";
    private static final String UPDATED = "UPDATED";
    private static final String ALL = "ALL";
    private static final String ROWS = "ROWS";
    private static final String PARTITION_BY = "PARTITION BY";
    private static final String DIMENSION_BY = "DIMENSION BY";
    private static final String MEASURES = "MEASURES";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    private static final String EQUALS = "=";
    private static final String ON = "ON";
    private static final String MAIN = "MAIN";
    private static final String RULES = "RULES";
    private static final String UPDATE = "UPDATE";
    private static final String UPSERT = "UPSERT";
    private static final String AUTOMATIC = "AUTOMATIC";
    private static final String SEQUENTIAL = "SEQUENTIAL";
    private static final String ORDER = "ORDER";
    private static final String ITERATE = "ITERATE";
    private static final String UNTIL = "UNTIL";
    private static final String LEFT_SQUARE_BRACKET = "[";
    private static final String RIGHT_SQUARE_BRACKET = "]";
    private static final String COMMA = ",";
    private static final String FOR = "FOR";
    private static final String IN = "IN";
    private static final String LIKE = "LIKE";
    private static final String FROM = "FROM";
    private static final String TO = "TO";
    private static final String INCREMENT = "INCREMENT";
    private static final String DECREMENT = "DECREMENT";

    public ModelObject() {
        this.setReturnUpdatedRows(this.getReturnUpdatedRows());
        this.setReturnAllRows(this.getReturnAllRows());
    }

    public void setCellReferenceOptions(CellReferenceOptions cellReferenceOptions) {
        this.setProperty("cellReferenceOptions", cellReferenceOptions);
    }

    public CellReferenceOptions getCellReferenceOptions() {
        return (CellReferenceOptions)this.getProperty("cellReferenceOptions");
    }

    public void setReturnUpdatedRows(boolean bl) {
        this.setProperty("returnUpdatedRows", bl);
    }

    public boolean getReturnUpdatedRows() {
        return (Boolean)this.getProperty("returnUpdatedRows", false);
    }

    public void setReturnAllRows(boolean bl) {
        this.setProperty("returnAllRows", bl);
    }

    public boolean getReturnAllRows() {
        return (Boolean)this.getProperty("returnAllRows", false);
    }

    public void setReferenceModels(SQLFragment[] sQLFragmentArray) {
        this.getChildSupport("referenceModels").setChildArray(sQLFragmentArray);
    }

    public SQLFragment[] getReferenceModels() {
        return this.getChildSupport("referenceModels").getChildArray(SQLFragment.class);
    }

    public void setMainModelName(String string) {
        this.setProperty("mainModelName", string);
    }

    public String getMainModelName() {
        return (String)this.getProperty("mainModelName");
    }

    public void setModelColumnClauses(SQLFragment sQLFragment) {
        this.setProperty("modelColumnClauses", sQLFragment);
    }

    public SQLFragment getModelColumnClauses() {
        return (SQLFragment)this.getProperty("modelColumnClauses");
    }

    public void setMainModelCellReferenceOptions(SQLFragment sQLFragment) {
        this.setProperty("mainModelCellReferenceOptions", sQLFragment);
    }

    public SQLFragment getMainModelCellReferenceOptions() {
        return (SQLFragment)this.getProperty("mainModelCellReferenceOptions");
    }

    public void setModelRulesClause(SQLFragment sQLFragment) {
        this.setProperty("modelRulesClause", sQLFragment);
    }

    public SQLFragment getModelRulesClause() {
        return (SQLFragment)this.getProperty("modelRulesClause");
    }

    @Override
    public String getSQLText() {
        SQLFragment sQLFragment2;
        SQLFragment[] sQLFragmentArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TYPE);
        if (this.getCellReferenceOptions() != null) {
            sQLFragmentArray = this.getCellReferenceOptions();
            stringBuilder.append(" ").append(sQLFragmentArray.getSQLText());
        }
        if (this.getReturnUpdatedRows()) {
            stringBuilder.append(" ").append(RETURN).append(" ").append(" ").append(UPDATED).append(" ").append(ROWS).append("\n");
        } else if (this.getReturnAllRows()) {
            stringBuilder.append(" ").append(RETURN).append(" ").append(" ").append(ALL).append(" ").append(ROWS).append("\n");
        }
        sQLFragmentArray = this.getReferenceModels();
        if (sQLFragmentArray != null) {
            for (SQLFragment sQLFragment2 : sQLFragmentArray) {
                stringBuilder.append(" ").append(sQLFragment2.getSQLText());
            }
        }
        String string = this.getMainModelName();
        SQLFragment sQLFragment3 = this.getModelColumnClauses();
        SQLFragment sQLFragment4 = this.getMainModelCellReferenceOptions();
        sQLFragment2 = this.getModelRulesClause();
        stringBuilder.append(" ");
        if (ModelUtil.hasLength((String)string)) {
            stringBuilder.append(MAIN).append(" ").append(string);
        }
        stringBuilder.append(" ").append(sQLFragment3.getSQLText());
        if (sQLFragment4 != null) {
            stringBuilder.append(" ").append(sQLFragment4.getSQLText());
        }
        stringBuilder.append(" ").append(sQLFragment2.getSQLText());
        return stringBuilder.toString();
    }

    public static class CellReferenceOptions
    extends AbstractSQLFragment {
        public CellReferenceOptions() {
            this.setIgnoreNav(this.getIgnoreNav());
            this.setKeepNav(this.getKeepNav());
            this.setUniqueDimension(this.getUniqueDimension());
            this.setUniqueSingleReference(this.getUniqueSingleReference());
        }

        public void setIgnoreNav(boolean bl) {
            this.setProperty("ignoreNav", bl);
        }

        public boolean getIgnoreNav() {
            return (Boolean)this.getProperty("ignoreNav", false);
        }

        public void setKeepNav(boolean bl) {
            this.setProperty("keepNav", bl);
        }

        public boolean getKeepNav() {
            return (Boolean)this.getProperty("keepNav", false);
        }

        public void setUniqueDimension(boolean bl) {
            this.setProperty("uniqueDimension", bl);
        }

        public boolean getUniqueDimension() {
            return (Boolean)this.getProperty("uniqueDimension", false);
        }

        public void setUniqueSingleReference(boolean bl) {
            this.setProperty("uniqueSingleReference", bl);
        }

        public boolean getUniqueSingleReference() {
            return (Boolean)this.getProperty("uniqueSingleReference", false);
        }

        @Override
        public String getSQLText() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getIgnoreNav()) {
                stringBuilder.append(" ").append(ModelObject.IGNORE).append(" ").append(ModelObject.NAV);
            } else if (this.getKeepNav()) {
                stringBuilder.append(" ").append(ModelObject.KEEP).append(" ").append(ModelObject.NAV);
            }
            if (this.getUniqueDimension()) {
                stringBuilder.append(" ").append(ModelObject.UNIQUE).append(" ").append(ModelObject.DIMENSION);
            } else if (this.getUniqueSingleReference()) {
                stringBuilder.append(" ").append(ModelObject.UNIQUE).append(" ").append(ModelObject.SINGLE).append(" ").append(ModelObject.REFERENCE);
            }
            return stringBuilder.toString();
        }
    }

    public static class MultiColumnForLoop
    extends AbstractSQLFragment {
        public void setDimensionColumns(ExpressionList expressionList) {
            this.setProperty("dimensionColumns", expressionList);
        }

        public ExpressionList getDimensionColumns() {
            return (ExpressionList)this.getProperty("dimensionColumns");
        }

        public void setLiterals(ExpressionList expressionList) {
            this.setProperty("literals", expressionList);
        }

        public ExpressionList getLiterals() {
            return (ExpressionList)this.getProperty("literals");
        }

        @Override
        public String getSQLText() {
            StringBuilder stringBuilder = new StringBuilder();
            ExpressionList expressionList = this.getLiterals();
            boolean bl = expressionList.getArgumentCount() == 1;
            stringBuilder.append(ModelObject.FOR).append(" ").append(this.getDimensionColumns().getSQLText());
            stringBuilder.append(" ").append(ModelObject.IN).append(" ");
            if (bl) {
                stringBuilder.append(ModelObject.LEFT_PAREN).append(" ");
            }
            stringBuilder.append(expressionList.getSQLText());
            if (bl) {
                stringBuilder.append(ModelObject.RIGHT_PAREN).append(" ");
            }
            return stringBuilder.toString();
        }
    }

    public static class SingleColumnForLoop
    extends AbstractSQLFragment {
        public void setDimensionColumn(String string) {
            this.setProperty("dimensionColumn", string);
        }

        public String getDimensionColumn() {
            return (String)this.getProperty("dimensionColumn");
        }

        public void setInExpressionList(ExpressionList expressionList) {
            this.setProperty("inExpressionList", expressionList);
        }

        public ExpressionList getInExpressionList() {
            return (ExpressionList)this.getProperty("inExpressionList");
        }

        public void setLikePattern(String string) {
            this.setProperty("likePattern", string);
        }

        public String getLikePattern() {
            return (String)this.getProperty("likePattern");
        }

        public void setFromLiteral(String string) {
            this.setProperty("fromLiteral", string);
        }

        public String getFromLiteral() {
            return (String)this.getProperty("fromLiteral");
        }

        public void setToLiteral(String string) {
            this.setProperty("toLiteral", string);
        }

        public String getToLiteral() {
            return (String)this.getProperty("toLiteral");
        }

        public void setIncrementLiteral(String string) {
            this.setProperty("incrementLiteral", string);
        }

        public String getIncrementLiteral() {
            return (String)this.getProperty("incrementLiteral");
        }

        public void setDecrementLiteral(String string) {
            this.setProperty("decrementLiteral", string);
        }

        public String getDecrementLiteral() {
            return (String)this.getProperty("decrementLiteral");
        }

        @Override
        public String getSQLText() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ModelObject.FOR).append(" ").append(this.getDimensionColumn());
            ExpressionList expressionList = this.getInExpressionList();
            if (expressionList != null) {
                stringBuilder.append(" ").append(ModelObject.IN).append(expressionList.getSQLText());
            } else {
                String string = this.getLikePattern();
                if (ModelUtil.hasLength((String)string)) {
                    stringBuilder.append(" ").append(ModelObject.LIKE).append(string);
                }
                stringBuilder.append(" ").append(ModelObject.FROM).append(" ").append(this.getFromLiteral());
                stringBuilder.append(" ").append(ModelObject.TO).append(" ").append(this.getToLiteral());
                String string2 = this.getIncrementLiteral();
                if (ModelUtil.hasLength((String)string2)) {
                    stringBuilder.append(" ").append(ModelObject.INCREMENT);
                } else {
                    string2 = this.getDecrementLiteral();
                    stringBuilder.append(" ").append(ModelObject.DECREMENT);
                }
                stringBuilder.append(" ").append(string2);
            }
            return stringBuilder.toString();
        }
    }

    public static class CellAssignment
    extends AbstractSQLFragment {
        public void setMeasureColumn(String string) {
            this.setProperty("measureColumn", string);
        }

        public String getMeasureColumn() {
            return (String)this.getProperty("measureColumn");
        }

        public void setCellAssignment(SQLFragment[] sQLFragmentArray) {
            this.getChildSupport("cellAssignment").setChildArray(sQLFragmentArray);
        }

        public SQLFragment[] getCellAssignment() {
            return this.getChildSupport("cellAssignment").getChildArray(SQLFragment.class);
        }

        @Override
        public String getSQLText() {
            SQLFragment[] sQLFragmentArray;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getMeasureColumn()).append(" ").append(ModelObject.LEFT_SQUARE_BRACKET);
            boolean bl = true;
            for (SQLFragment sQLFragment : sQLFragmentArray = this.getCellAssignment()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(ModelObject.COMMA).append(" ");
                }
                stringBuilder.append(sQLFragment.getSQLText());
            }
            stringBuilder.append(ModelObject.RIGHT_SQUARE_BRACKET);
            return stringBuilder.toString();
        }
    }

    public static class ModelRulesCellAssignmentExpr
    extends AbstractSQLFragment {
        public ModelRulesCellAssignmentExpr() {
            this.setUpdate(this.getUpdate());
            this.setUpsert(this.getUpsert());
            this.setAll(this.getAll());
        }

        public void setUpdate(boolean bl) {
            this.setProperty("update", bl);
        }

        public boolean getUpdate() {
            return (Boolean)this.getProperty("update", false);
        }

        public void setUpsert(boolean bl) {
            this.setProperty("upsert", bl);
        }

        public boolean getUpsert() {
            return (Boolean)this.getProperty("upsert", false);
        }

        public void setAll(boolean bl) {
            this.setProperty("all", bl);
        }

        public boolean getAll() {
            return (Boolean)this.getProperty("all", false);
        }

        public void setModelRulesCellAssignment(SQLFragment sQLFragment) {
            this.setProperty("modelRulesCellAssignment", sQLFragment);
        }

        public SQLFragment getModelRulesCellAssignment() {
            return (SQLFragment)this.getProperty("modelRulesCellAssignment");
        }

        public void setOrderBy(SQLFragment sQLFragment) {
            this.setProperty("orderBy", sQLFragment);
        }

        public SQLFragment getOrderBy() {
            return (SQLFragment)this.getProperty("orderBy");
        }

        public void setExpr(SQLFragment sQLFragment) {
            this.setProperty("expr", sQLFragment);
        }

        public SQLFragment getExpr() {
            return (SQLFragment)this.getProperty("expr");
        }

        @Override
        public String getSQLText() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getUpdate()) {
                stringBuilder.append(ModelObject.UPDATE);
                stringBuilder.append(" ");
            } else if (this.getUpsert()) {
                stringBuilder.append(ModelObject.UPSERT);
                if (this.getAll()) {
                    stringBuilder.append(ModelObject.ALL);
                }
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.getModelRulesCellAssignment().getSQLText());
            SQLFragment sQLFragment = this.getOrderBy();
            if (sQLFragment != null) {
                stringBuilder.append(" ").append(sQLFragment.getSQLText());
            }
            stringBuilder.append(" ").append(ModelObject.EQUALS).append(" ");
            stringBuilder.append(this.getExpr().getSQLText());
            stringBuilder.append(" ").append("\n");
            return stringBuilder.toString();
        }
    }

    public static class ModelRulesClause
    extends AbstractSQLFragment {
        public ModelRulesClause() {
            this.setRulesPresent(this.getRulesPresent());
            this.setRulesUpdate(this.getRulesUpdate());
            this.setRulesUpsert(this.getRulesUpsert());
            this.setRulesAll(this.getRulesAll());
            this.setAutomatic(this.getAutomatic());
            this.setSequential(this.getSequential());
            this.setOrder(this.getOrder());
        }

        public void setRulesPresent(boolean bl) {
            this.setProperty("rulesPresent", bl);
        }

        public boolean getRulesPresent() {
            return (Boolean)this.getProperty("rulesPresent", false);
        }

        public void setRulesUpdate(boolean bl) {
            this.setProperty("rulesUpdate", bl);
        }

        public boolean getRulesUpdate() {
            return (Boolean)this.getProperty("rulesUpdate", false);
        }

        public void setRulesUpsert(boolean bl) {
            this.setProperty("rulesUpsert", bl);
        }

        public boolean getRulesUpsert() {
            return (Boolean)this.getProperty("rulesUpsert", false);
        }

        public void setRulesAll(boolean bl) {
            this.setProperty("rulesAll", bl);
        }

        public boolean getRulesAll() {
            return (Boolean)this.getProperty("rulesAll", false);
        }

        public void setAutomatic(boolean bl) {
            this.setProperty("automatic", bl);
        }

        public boolean getAutomatic() {
            return (Boolean)this.getProperty("automatic", false);
        }

        public void setSequential(boolean bl) {
            this.setProperty("sequential", bl);
        }

        public boolean getSequential() {
            return (Boolean)this.getProperty("sequential", false);
        }

        public void setOrder(boolean bl) {
            this.setProperty("order", bl);
        }

        public boolean getOrder() {
            return (Boolean)this.getProperty("order", false);
        }

        public void setIterateNumber(String string) {
            this.setProperty("iterateNumber", string);
        }

        public String getIterateNumber() {
            return (String)this.getProperty("iterateNumber");
        }

        public void setUntilCondition(SQLFragment sQLFragment) {
            this.setProperty("untilCondition", sQLFragment);
        }

        public SQLFragment getUntilCondition() {
            return (SQLFragment)this.getProperty("untilCondition");
        }

        public void setCellAssignmentExprs(ExpressionList expressionList) {
            this.setProperty("cellAssignmentExprs", expressionList);
        }

        public ExpressionList getCellAssignmentExprs() {
            return (ExpressionList)this.getProperty("cellAssignmentExprs");
        }

        @Override
        public String getSQLText() {
            SQLFragment sQLFragment;
            CharSequence charSequence;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getRulesPresent()) {
                stringBuilder.append(ModelObject.RULES);
                if (this.getRulesUpdate()) {
                    stringBuilder.append(" ").append(ModelObject.UPDATE);
                } else if (this.getRulesUpsert()) {
                    stringBuilder.append(" ").append(ModelObject.UPSERT);
                    if (this.getRulesAll()) {
                        stringBuilder.append(" ").append(ModelObject.ALL);
                    }
                }
                if (this.getAutomatic()) {
                    stringBuilder.append(" ").append(ModelObject.AUTOMATIC);
                } else if (this.getSequential()) {
                    stringBuilder.append(" ").append(ModelObject.SEQUENTIAL);
                }
                if (this.getOrder()) {
                    stringBuilder.append(" ").append(ModelObject.ORDER);
                }
                if ((charSequence = this.getIterateNumber()) != null) {
                    stringBuilder.append(" ").append(ModelObject.ITERATE).append(" ").append(ModelObject.LEFT_PAREN).append((String)charSequence).append(ModelObject.RIGHT_PAREN);
                    sQLFragment = this.getUntilCondition();
                    if (sQLFragment != null) {
                        stringBuilder.append(" ").append(ModelObject.UNTIL).append(" ").append(ModelObject.LEFT_PAREN).append(sQLFragment.getSQLText()).append(ModelObject.RIGHT_PAREN);
                    }
                }
            }
            charSequence = stringBuilder.append("\n");
            sQLFragment = this.getCellAssignmentExprs();
            stringBuilder.append(" ").append(((ExpressionList)sQLFragment).getSQLText());
            return stringBuilder.toString();
        }
    }

    public static class ReferenceModel
    extends AbstractSQLFragment {
        public void setReferenceModelName(String string) {
            this.setProperty("referenceModelName", string);
        }

        public String getReferenceModelName() {
            return (String)this.getProperty("referenceModelName");
        }

        public void setSubquery(SQLQuery sQLQuery) {
            this.setProperty("subquery", sQLQuery);
        }

        public SQLQuery getSubquery() {
            return (SQLQuery)this.getProperty("subquery");
        }

        public void setModelColumnClauses(SQLFragment sQLFragment) {
            this.setProperty("modelColumnClauses", sQLFragment);
        }

        public SQLFragment getModelColumnClauses() {
            return (SQLFragment)this.getProperty("modelColumnClauses");
        }

        public void setCellReferenceOptions(SQLFragment sQLFragment) {
            this.setProperty("cellReferenceOptions", sQLFragment);
        }

        public SQLFragment getCellReferenceOptions() {
            return (SQLFragment)this.getProperty("cellReferenceOptions");
        }

        @Override
        public String getSQLText() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getReferenceModelName();
            SQLQuery sQLQuery = this.getSubquery();
            SQLFragment sQLFragment = this.getCellReferenceOptions();
            SQLFragment sQLFragment2 = this.getModelColumnClauses();
            stringBuilder.append(ModelObject.REFERENCE).append(" ").append(string).append(" ").append(ModelObject.ON).append(" ").append(ModelObject.LEFT_PAREN).append(sQLQuery.getSQLText()).append(ModelObject.RIGHT_PAREN).append(sQLFragment2);
            if (sQLFragment != null) {
                stringBuilder.append(" ").append(sQLFragment.getSQLText());
            }
            return stringBuilder.toString();
        }
    }

    public static class ModelColumnClauses
    extends AbstractSQLFragment {
        public void setPartitionByExpressionList(SQLFragment sQLFragment) {
            this.setProperty("partitionByExpressionList", sQLFragment);
        }

        public SQLFragment getPartitionByExpressionList() {
            return (SQLFragment)this.getProperty("partitionByExpressionList");
        }

        public void setDimensionByExpressionList(SQLFragment sQLFragment) {
            this.setProperty("dimensionByExpressionList", sQLFragment);
        }

        public SQLFragment getDimensionByExpressionList() {
            return (SQLFragment)this.getProperty("dimensionByExpressionList");
        }

        public void setMeasuresExpressionList(SQLFragment sQLFragment) {
            this.setProperty("measuresExpressionList", sQLFragment);
        }

        public SQLFragment getMeasuresExpressionList() {
            return (SQLFragment)this.getProperty("measuresExpressionList");
        }

        @Override
        public String getSQLText() {
            StringBuilder stringBuilder = new StringBuilder();
            SQLFragment sQLFragment = this.getPartitionByExpressionList();
            SQLFragment sQLFragment2 = this.getDimensionByExpressionList();
            SQLFragment sQLFragment3 = this.getMeasuresExpressionList();
            this.appendModelColumnClause(stringBuilder, ModelObject.PARTITION_BY, sQLFragment);
            this.appendModelColumnClause(stringBuilder, ModelObject.DIMENSION_BY, sQLFragment2);
            this.appendModelColumnClause(stringBuilder, ModelObject.MEASURES, sQLFragment3);
            return stringBuilder.toString();
        }

        private void appendModelColumnClause(StringBuilder stringBuilder, String string, SQLFragment sQLFragment) {
            if (sQLFragment != null) {
                stringBuilder.append(string);
                String string2 = sQLFragment.getSQLText();
                stringBuilder.append(" ");
                if (string2.startsWith(ModelObject.LEFT_PAREN) && string2.endsWith(ModelObject.RIGHT_PAREN)) {
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.append(ModelObject.LEFT_PAREN).append(string2).append(ModelObject.RIGHT_PAREN);
                }
                stringBuilder.append(" ").append("\n");
            }
        }
    }
}

