/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLQueryException;

public class InvalidSQLException
extends SQLQueryException {
    private final String m_sql;
    private final Integer m_offset;

    public InvalidSQLException(String string, String string2) {
        this(string, string2, null);
    }

    public InvalidSQLException(String string, String string2, Integer n) {
        super(string2);
        this.m_sql = string;
        if (n != null && (this.m_sql == null || n >= this.m_sql.length())) {
            DBLog.getLogger(this).log(Level.WARNING, "Invalid offset {0} for error {1}", new Object[]{n, this.m_sql});
            n = null;
        }
        this.m_offset = n;
    }

    public String getSQL() {
        return this.m_sql;
    }

    public Integer getOffset() {
        return this.m_offset;
    }

    public Integer getLineNumber() {
        String string = this.getSQL();
        Integer n = this.getOffset();
        Integer n2 = null;
        if (string != null && n != null) {
            int n3 = string.lastIndexOf("\n", (int)this.getOffset());
            n2 = 1;
            while (n3 >= 0) {
                Integer n4 = n2;
                n2 = n2 + 1;
                n3 = string.lastIndexOf("\n", n3 - 1);
            }
        }
        return n2;
    }

    public Integer getColumnNumber() {
        String string = this.getSQL();
        Integer n = this.getOffset();
        Integer n2 = null;
        if (string != null && n != null) {
            int n3 = string.lastIndexOf("\n", (int)n);
            n2 = n3 < 0 ? n : Integer.valueOf(n - (n3 + 1));
        }
        return n2;
    }

    public String getSQLWithError() {
        String string = this.getSQL();
        Integer n = this.getOffset();
        if (n != null && string != null) {
            try {
                int n2 = string.lastIndexOf("\n", (int)n);
                int n3 = string.indexOf("\n", (int)n);
                StringBuilder stringBuilder = new StringBuilder();
                if (n3 < 0) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(string.substring(0, n3));
                }
                stringBuilder.append('\n');
                int n4 = n2 < 0 ? n : n - (n2 + 1);
                for (int i = 0; i < n4; ++i) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("^");
                if (n3 > 0) {
                    stringBuilder.append(string.substring(n3));
                }
                string = stringBuilder.toString();
            }
            catch (Exception exception) {
                DBLog.getLogger(this).log(Level.WARNING, "Error constructing query text with error", exception);
            }
        }
        return string;
    }

    @Override
    public String getMessage() {
        String string = super.getMessage();
        Integer n = this.getLineNumber();
        Integer n2 = this.getColumnNumber();
        if (n != null && n2 != null) {
            string = APIBundle.format("SQL_INVALID_MSG", n, n2, string);
        }
        return string;
    }
}

