/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLCallable;
import oracle.javatools.util.Copyable;

public class FunctionUsage
extends Operation
implements DBObjectUsage {
    private DBObjectProvider m_pro;

    public FunctionUsage() {
        this.setFunctionFormat(true);
    }

    @Override
    protected String getOperatorText() {
        return this.getFunction();
    }

    public String getFunction() {
        String string = null;
        for (DBObject dBObject = this; dBObject != null; dBObject = dBObject.getParent()) {
            if (dBObject instanceof Schema) {
                string = ((Schema)dBObject).getName();
                break;
            }
            if (!(dBObject instanceof SchemaObject) || ((SchemaObject)dBObject).getSchema() == null) continue;
            string = ((SchemaObject)dBObject).getSchema().getName();
            break;
        }
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (DBObjectID dBObjectID = this.getObjectID(); dBObjectID != null; dBObjectID = dBObjectID.getParent()) {
            String string3;
            Copyable copyable;
            if (dBObjectID instanceof BaseObjectID) {
                copyable = (BaseObjectID)dBObjectID;
                string3 = copyable.getName();
                if (this.m_pro != null) {
                    string3 = this.m_pro.getExternalName(string3);
                }
                stringBuffer.insert(0, string3);
                stringBuffer.insert(0, ".");
                string2 = copyable.getSchemaName();
                continue;
            }
            copyable = null;
            try {
                copyable = dBObjectID.resolveID();
                string3 = copyable.getName();
                if (this.m_pro != null) {
                    string3 = this.m_pro.getExternalName(string3);
                }
                stringBuffer.insert(0, string3);
                stringBuffer.insert(0, ".");
                if (!(copyable instanceof SchemaObject) || ((SchemaObject)copyable).getSchema() == null) continue;
                string2 = ((SchemaObject)copyable).getSchema().getName();
                continue;
            }
            catch (DBException dBException) {
                DBLog.getLogger(this).warning(dBException.getMessage());
            }
        }
        int n = 1;
        if (string2 != null && !string2.equals(string)) {
            if (this.m_pro != null) {
                string2 = this.m_pro.getExternalName(string2);
            }
            stringBuffer.insert(0, string2);
            n = 0;
        }
        if (n > stringBuffer.length()) {
            n = stringBuffer.length();
        }
        return stringBuffer.substring(n);
    }

    @Override
    public void setObjectID(DBObjectID dBObjectID) {
        this.setProperty("objectID", dBObjectID);
    }

    @Override
    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    @Override
    public void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    @Override
    public DBObjectID getDataTypeID() {
        DBObjectID dBObjectID = null;
        DBObjectID dBObjectID2 = this.getObjectID();
        if (dBObjectID2 != null) {
            DBObject dBObject;
            try {
                dBObject = dBObjectID2.resolveID();
            }
            catch (DBException dBException) {
                dBObject = null;
            }
            if (dBObject instanceof PlSqlSubProgram) {
                dBObjectID = ((PlSqlSubProgram)dBObject).getReturnTypeID();
            }
        }
        return dBObjectID;
    }

    @Override
    protected String surroundWithBrackets(String string, boolean bl) {
        boolean bl2 = true;
        if (this.getArgumentCount() == 0) {
            DBObjectID dBObjectID = this.getObjectID();
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject instanceof SQLCallable && !((SQLCallable)((Object)dBObject)).isParenthesesRequired()) {
                    bl2 = false;
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger(this).warning(dBException.getMessage());
            }
        }
        if (bl2) {
            return super.surroundWithBrackets(string, bl);
        }
        return string;
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        super.copyToImpl(abstractDBObject, dBObject, iDPolicy);
        ((FunctionUsage)abstractDBObject).m_pro = this.m_pro;
    }
}

