/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.refactoring.CascadeWorker;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.RefactoringProcessor;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.validators.DBObjectValidator;

public class CascadeProcessor
extends RefactoringProcessor {
    private Set<String> m_cascadeProps;

    @Override
    protected void processObjectDelete(DBObjectTransaction dBObjectTransaction, SystemObject systemObject) throws DBException {
        CascadeManager cascadeManager = dBObjectTransaction.getProvider().getCascadeManager();
        Collection<DBObjectID> collection = cascadeManager.listTopLevelReferers(systemObject, false);
        HashSet<DBObjectID> hashSet = new HashSet<DBObjectID>(collection);
        hashSet.removeAll(dBObjectTransaction.getDeleteIDs());
        Object var6_6 = null;
        if (hashSet.size() > 0) {
            for (DBObjectID dBObjectID : hashSet) {
                CancelledException.checkInterrupt();
                SystemObject systemObject2 = (SystemObject)dBObjectID.resolveID();
                if ((systemObject2 = dBObjectTransaction.getCopyForUpdate(systemObject2)) == null) continue;
                try {
                    this.cascadeDelete(dBObjectTransaction, systemObject, systemObject2);
                }
                catch (CascadeRequiredException cascadeRequiredException) {
                    CascadeRequiredException cascadeRequiredException2 = new CascadeRequiredException((DBObject)systemObject, hashSet);
                    dBObjectTransaction.addException(cascadeRequiredException2);
                }
            }
        }
    }

    protected final void cascadeDelete(DBObjectTransaction dBObjectTransaction, DBObject dBObject, SystemObject systemObject) throws DBException {
        CascadeAction cascadeAction;
        DBObjectProvider dBObjectProvider = dBObjectTransaction.getProvider();
        DBObjectValidator dBObjectValidator = ((AbstractDBObjectProvider)dBObjectProvider).getValidatorForType(systemObject.getType());
        if (dBObjectValidator != null && (cascadeAction = dBObjectValidator.cascadeDelete(dBObject, systemObject)) != null) {
            if (cascadeAction == CascadeAction.NONE) {
                this.getLogger().fine("dependent object " + systemObject + "required no cascade.");
            } else if (dBObjectTransaction.isCascade()) {
                if (cascadeAction == CascadeAction.DELETE) {
                    dBObjectTransaction.includeUpdate(systemObject, null);
                } else if (cascadeAction == CascadeAction.UPDATE) {
                    dBObjectTransaction.includeUpdate(systemObject);
                }
            } else {
                throw new CascadeRequiredException(dBObject);
            }
        }
    }

    @Override
    protected void processObjectUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        this.processObjectUpdateImpl(dBObjectTransaction, difference);
    }

    private void processObjectUpdateImpl(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        if (!difference.isSame()) {
            this.processSingleObjectUpdate(dBObjectTransaction, difference);
            for (Difference difference2 : difference.getChildren()) {
                CancelledException.checkInterrupt();
                if (!difference2.isLoaded() && difference2.isDerived() || difference2.isSame()) continue;
                if ("properties".equals(difference2.getPropertyName()) && difference2.isMap()) {
                    for (Difference difference3 : difference2.getChildren()) {
                        this.processPropertyDifference(dBObjectTransaction, difference3);
                    }
                    continue;
                }
                this.processPropertyDifference(dBObjectTransaction, difference2);
            }
        }
    }

    private void processPropertyDifference(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        Object object;
        Class<?> clazz = DBUtil.decodeArrayClass(difference.getDifferenceClass());
        if (clazz != null && DBObject.class.isAssignableFrom(clazz) && !"schema".equals(difference.getPropertyName()) && (object = difference.getOriginalObject()) != null) {
            if (difference.isList()) {
                for (Difference difference2 : difference.getChildren()) {
                    DBObject dBObject = (DBObject)difference2.getOriginalObject();
                    if (dBObject == null) continue;
                    if (difference2.getUpdatedObject() == null) {
                        this.processChildObjectDelete(dBObjectTransaction, dBObject);
                        continue;
                    }
                    this.processObjectUpdateImpl(dBObjectTransaction, difference2);
                }
            } else if (difference.getUpdatedObject() == null) {
                this.processChildObjectDelete(dBObjectTransaction, (DBObject)object);
            } else {
                this.processObjectUpdateImpl(dBObjectTransaction, difference);
            }
        }
    }

    private void processChildObjectDelete(DBObjectTransaction dBObjectTransaction, DBObject dBObject) throws DBException {
        CascadeManager cascadeManager = dBObjectTransaction.getProvider().getCascadeManager();
        Set<DBObjectID> set = this.getSystemObjectIDs(cascadeManager.listReferers(dBObject));
        for (DBObjectID dBObjectID : set) {
            CancelledException.checkInterrupt();
            SystemObject systemObject = (SystemObject)dBObjectID.resolveID();
            if ((systemObject = dBObjectTransaction.getCopyForUpdate(systemObject)) == null) continue;
            try {
                this.cascadeDelete(dBObjectTransaction, dBObject, systemObject);
            }
            catch (CascadeRequiredException cascadeRequiredException) {
                CascadeRequiredException cascadeRequiredException2 = new CascadeRequiredException(dBObject, set);
                dBObjectTransaction.addException(cascadeRequiredException2);
            }
        }
    }

    private Set<DBObjectID> getSystemObjectIDs(Collection<DBObjectID> collection) {
        DBObjectIDSet dBObjectIDSet = new DBObjectIDSet(true);
        for (DBObjectID dBObjectID : collection) {
            Object object = null;
            if (dBObjectID instanceof TemporaryObjectID) {
                DBObjectID dBObjectID2;
                var6_6 = ((TemporaryObjectID)dBObjectID).getDBObject();
                SystemObject systemObject = DBUtil.getSystemObject((DBObject)var6_6);
                if (systemObject != null && (dBObjectID2 = systemObject.getID()) instanceof BaseObjectID) {
                    object = dBObjectID2;
                }
            } else {
                var6_6 = DBUtil.getUppermostParent(dBObjectID);
                if (Metadata.getInstance().isTypeOf(SystemObject.class, var6_6.getType())) {
                    object = var6_6;
                }
            }
            if (object == null) {
                this.getLogger().warning("Found reference with no valid SystemObject : " + dBObjectID);
                continue;
            }
            dBObjectIDSet.add(object);
        }
        return dBObjectIDSet;
    }

    protected void processSingleObjectUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        if (this.requiresCascadeUpdate(dBObjectTransaction, difference)) {
            DBObject dBObject = (DBObject)difference.getOriginalObject();
            CascadeManager cascadeManager = dBObjectTransaction.getProvider().getCascadeManager();
            Set<DBObjectID> set = this.getSystemObjectIDs(cascadeManager.listReferers(dBObject));
            for (DBObjectID dBObjectID : set) {
                CancelledException.checkInterrupt();
                SystemObject systemObject = (SystemObject)dBObjectID.resolveID();
                if ((systemObject = dBObjectTransaction.getCopyForUpdate(systemObject)) == null) continue;
                try {
                    this.cascadeUpdate(dBObjectTransaction, difference, systemObject);
                }
                catch (CascadeRequiredException cascadeRequiredException) {
                    CascadeRequiredException cascadeRequiredException2 = new CascadeRequiredException((DBObject)difference.getUpdatedObject(), set);
                    dBObjectTransaction.addException(cascadeRequiredException2);
                }
            }
        }
    }

    protected final void cascadeUpdate(DBObjectTransaction dBObjectTransaction, Difference difference, SystemObject systemObject) throws DBException {
        CascadeAction cascadeAction;
        DBObjectProvider dBObjectProvider = dBObjectTransaction.getProvider();
        DBObjectValidator dBObjectValidator = ((AbstractDBObjectProvider)dBObjectProvider).getValidatorForType(systemObject.getType());
        if (dBObjectValidator != null && (cascadeAction = dBObjectValidator.cascadeUpdate(difference, systemObject)) != null) {
            if (cascadeAction == CascadeAction.NONE) {
                this.getLogger().fine("dependent object " + systemObject + "required no cascade.");
            } else if (dBObjectTransaction.isCascade()) {
                if (cascadeAction == CascadeAction.DELETE) {
                    dBObjectTransaction.includeUpdate(systemObject, null);
                } else if (cascadeAction == CascadeAction.UPDATE) {
                    dBObjectTransaction.includeUpdate(systemObject);
                }
            } else if (cascadeAction == CascadeAction.DELETE) {
                throw new CascadeRequiredException((DBObject)difference.getUpdatedObject());
            }
        }
    }

    private boolean requiresCascadeUpdate(DBObjectTransaction dBObjectTransaction, Difference difference) {
        boolean bl = false;
        if (!difference.isSame()) {
            Set<String> set = this.getCascadeProperties(dBObjectTransaction.getProvider());
            for (Difference difference2 : difference.getChildren()) {
                if (difference2.isSame() || !set.contains(difference2.getPropertyName())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Set<String> getCascadeProperties(DBObjectProvider dBObjectProvider) {
        if (this.m_cascadeProps == null) {
            this.m_cascadeProps = new HashSet<String>();
            Map<String, DBObjectValidator> map = dBObjectProvider.getDescriptor().getValidators(dBObjectProvider);
            for (CascadeWorker cascadeWorker : map.values()) {
                this.m_cascadeProps.addAll(cascadeWorker.getCascadeProperties());
            }
        }
        return this.m_cascadeProps;
    }
}

