/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public class PropertyAction {
    private Collection<String> m_props;
    private Collection<ChildAction> m_childActions;
    private final Type m_type;

    public PropertyAction(Type type) {
        this(type, null);
    }

    public PropertyAction(Type type, Collection<ChildAction> collection) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (!Type.ALTER.equals((Object)type) && collection != null && !collection.isEmpty()) {
            throw new IllegalArgumentException("childActions can only be specified for ALTER");
        }
        this.m_type = type;
        this.m_childActions = collection;
    }

    public Type getType() {
        return this.m_type;
    }

    public Collection<String> getProperties() {
        return this.m_props == null ? Collections.emptyList() : this.m_props;
    }

    void addProperty(String string) {
        if (this.m_props == null) {
            this.m_props = new TreeSet<String>();
        }
        this.m_props.add(string);
    }

    public boolean supportsChildAction(ChildAction childAction) {
        return this.m_childActions != null && this.m_childActions.contains((Object)childAction);
    }

    public static enum Type {
        CREATE,
        ALTER,
        REPLACE,
        DELETE,
        UNDELETE;

    }

    public static enum ChildAction {
        ADD,
        REMOVE,
        MODIFY;

    }
}

