/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractPropertyManager
implements PropertyManager {
    private final DBObjectProvider m_pro;
    private final Metadata m_meta = Metadata.getInstance();
    private final PropertyHelper m_propHelper;

    protected AbstractPropertyManager(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
        this.m_propHelper = new PropertyHelper(dBObjectProvider);
    }

    protected final PropertyHelper getPropertyHelper() {
        return this.m_propHelper;
    }

    protected AbstractPropertyManager getDelegate() {
        return null;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Class<? extends DBObjectProvider> getProviderClass() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        return dBObjectProvider == null ? null : dBObjectProvider.getClass();
    }

    @Override
    public final boolean supportsProperty(String string, String string2) {
        return this.supportsProperty(this.m_meta.getObjectClass(string), string2);
    }

    @Override
    public boolean supportsProperty(Class<? extends DBObject> clazz, String string) {
        boolean bl = false;
        if (clazz != null) {
            PropertyInfo propertyInfo = this.findPropertyInfo(clazz, string);
            boolean bl2 = bl = propertyInfo != null;
            if (!bl && SystemObject.class.isAssignableFrom(clazz)) {
                bl = this.isProcessorProperty(clazz, string);
            }
        }
        return bl;
    }

    @Override
    public PropertyAction supportsPropertyChange(Class<? extends SystemObject> clazz, String string) {
        PropertyAction propertyAction = null;
        AbstractPropertyManager abstractPropertyManager = this.getDelegate();
        if (abstractPropertyManager != null) {
            propertyAction = abstractPropertyManager.supportsPropertyChange(clazz, string);
        }
        return propertyAction;
    }

    @Override
    public PropertyInfo findPropertyInfo(Class<? extends DBObject> clazz, String string) {
        PropertyInfo propertyInfo;
        block2: {
            Class<? extends DBObjectProvider> clazz2;
            propertyInfo = null;
            if (this.m_pro != null) {
                propertyInfo = PropertyHelper.findPropertyInfo(clazz, string, this.m_pro);
            }
            if (propertyInfo != null) break block2;
            Iterator<Class<? extends DBObjectProvider>> iterator = this.getProviderClasses(false).iterator();
            while (iterator.hasNext() && (propertyInfo = PropertyHelper.findPropertyInfo(clazz, string, clazz2 = iterator.next())) == null) {
            }
        }
        return propertyInfo;
    }

    private Iterable<Class<? extends DBObjectProvider>> getProviderClasses(boolean bl) {
        Class<? extends DBObjectProvider> clazz;
        AbstractPropertyManager abstractPropertyManager;
        Class<?> clazz2;
        LinkedHashSet<Class<? extends DBObjectProvider>> linkedHashSet = new LinkedHashSet<Class<? extends DBObjectProvider>>();
        Class<? extends DBObjectProvider> clazz3 = this.getProviderClass();
        Class<?> clazz4 = clazz2 = this.m_pro == null ? null : this.m_pro.getClass();
        if (clazz2 != null) {
            if (bl) {
                linkedHashSet.add(clazz2);
            }
            if (!clazz3.isAssignableFrom(clazz2)) {
                linkedHashSet.add(clazz3);
            }
        } else {
            linkedHashSet.add(clazz3);
        }
        if (!((abstractPropertyManager = this.getDelegate()) == null || (clazz = abstractPropertyManager.getProviderClass()).isAssignableFrom(clazz3) || clazz2 != null && clazz.isAssignableFrom(clazz2))) {
            linkedHashSet.add(clazz);
        }
        return linkedHashSet;
    }

    @Override
    public Map<String, PropertyInfo> getPropertyInfos(Class<? extends DBObject> clazz, PropertyCriteria propertyCriteria) {
        Iterable<Class<? extends DBObjectProvider>> iterable = this.getProviderClasses(true);
        propertyCriteria.addPredicate(propertyInfo -> this.supportsAnyProvider((PropertyInfo)propertyInfo, iterable));
        return PropertyHelper.getPropertyInfos(clazz, null, propertyCriteria);
    }

    private boolean supportsAnyProvider(PropertyInfo propertyInfo, Iterable<Class<? extends DBObjectProvider>> iterable) {
        boolean bl = false;
        for (Class<? extends DBObjectProvider> clazz : iterable) {
            if (!propertyInfo.isSupported(clazz, null)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean canCreateProperty(SystemObject systemObject, String string) {
        Trigger.BaseType baseType;
        String string2 = systemObject.getType();
        if ("PROCEDURE".equals(string2) && "returnTypeReference".equals(string)) {
            return false;
        }
        if ("TRIGGER".equals(string2) && ((baseType = ((Trigger)systemObject).getBaseType()) == Trigger.BaseType.DATABASE ? "baseObjectID".equals(string) || "statementLevel".equals(string) || "referencingNewAs".equals(string) || "referencingOldAs".equals(string) || "whenClause".equals(string) || "columnIDs".equals(string) : (baseType == Trigger.BaseType.SCHEMA ? "statementLevel".equals(string) || "referencingNewAs".equals(string) || "referencingOldAs".equals(string) || "whenClause".equals(string) || "columnIDs".equals(string) : baseType == Trigger.BaseType.VIEW && ("statementLevel".equals(string) || "whenClause".equals(string) || "columnIDs".equals(string))))) {
            return false;
        }
        boolean bl = false;
        Class<?> clazz = systemObject.getClass();
        if (this.supportsProperty(clazz, string)) {
            String[] stringArray;
            bl = this.canCreate(clazz, string);
            if (!bl && (stringArray = this.findPropertyInfo(systemObject.getClass(), string)) != null && stringArray.isDerived()) {
                String string3 = stringArray.getDerivedSourceProperty();
                bl = this.canCreate(clazz, string.replaceAll(stringArray.getPropertyName(), string3));
            }
            if (!bl && string.contains("dataTypeUsage") && (stringArray = Property.getProperties(string)).length > 1 && "dataTypeUsage".equals(stringArray[stringArray.length - 1])) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public final boolean canAlterProperty(SystemObject systemObject, SystemObject systemObject2, String string) {
        boolean bl = false;
        PropertyAction propertyAction = this.canChangeProperty(systemObject, systemObject2, string);
        if (propertyAction != null) {
            bl = propertyAction.getType() == PropertyAction.Type.ALTER;
        }
        return bl;
    }

    @Override
    public final PropertyAction canChangeProperty(SystemObject systemObject, SystemObject systemObject2, String string) {
        if (this.supportsProperty(systemObject2.getClass(), string)) {
            if (systemObject == null) {
                if (this.canCreate(systemObject2, string)) {
                    return new PropertyAction(PropertyAction.Type.CREATE);
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for CREATE on {1} {2}", new Object[]{string, systemObject2.getType(), systemObject2.getName()});
            } else {
                if (this.canChangeWithAlter(systemObject, systemObject2, string)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: can ALTER on {1} {2}", new Object[]{string, systemObject2.getType(), systemObject2.getName()});
                    return new PropertyAction(PropertyAction.Type.ALTER);
                }
                if (this.canChangeWithReplace(systemObject, systemObject2, string)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: cannot ALTER but can REPLACE on {1} {2}", new Object[]{string, systemObject2.getType(), systemObject2.getName()});
                    return new PropertyAction(PropertyAction.Type.REPLACE);
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for ALTER or REPLACE on {1} {2}", new Object[]{string, systemObject2.getType(), systemObject2.getName()});
            }
        }
        return null;
    }

    protected boolean canCreate(SystemObject systemObject, String string) {
        return this.canCreate(systemObject.getClass(), string);
    }

    protected boolean canCreate(Class<? extends SystemObject> clazz, String string) {
        boolean bl = true;
        AbstractPropertyManager abstractPropertyManager = this.getDelegate();
        if (abstractPropertyManager != null) {
            bl = abstractPropertyManager.canCreate(clazz, string);
        }
        if (!bl) {
            bl = this.isProcessorProperty(clazz, string);
        }
        return bl;
    }

    @Deprecated
    protected boolean canCreate(String string, String string2) {
        return true;
    }

    protected boolean canChangeWithAlter(SystemObject systemObject, SystemObject systemObject2, String string) {
        boolean bl = false;
        AbstractPropertyManager abstractPropertyManager = this.getDelegate();
        if (abstractPropertyManager == null) {
            PropertyInfo propertyInfo;
            PropertyAction propertyAction = this.supportsPropertyChange(systemObject2.getClass(), string);
            if (propertyAction != null && PropertyAction.Type.ALTER.equals((Object)propertyAction.getType()) && (propertyInfo = this.findPropertyInfo(systemObject2.getClass(), string)) != null) {
                bl = true;
                if (propertyInfo.getPropertyClass().isArray()) {
                    Difference difference;
                    PropertyHelper propertyHelper = this.getPropertyHelper();
                    Object object = propertyHelper.getPropertyValue(systemObject, string);
                    Object object2 = propertyHelper.getPropertyValue(systemObject2, string);
                    DBObjectProvider dBObjectProvider = this.getProvider();
                    if (dBObjectProvider != null && (object != null || object2 != null) && (difference = dBObjectProvider.getDiffEngine().difference(object, object2)).isList()) {
                        for (Difference difference2 : difference.getChildren()) {
                            if (difference2.isSame()) continue;
                            Object object3 = difference2.getOriginalObject();
                            Object object4 = difference2.getUpdatedObject();
                            PropertyAction.ChildAction childAction = object3 == null ? PropertyAction.ChildAction.ADD : (object4 == null ? PropertyAction.ChildAction.REMOVE : PropertyAction.ChildAction.MODIFY);
                            if (propertyAction.supportsChildAction(childAction)) continue;
                            bl = false;
                            break;
                        }
                    }
                }
            }
        } else {
            bl = abstractPropertyManager.canChangeWithAlter(systemObject, systemObject2, string);
        }
        return bl;
    }

    protected boolean canChangeWithReplace(SystemObject systemObject, SystemObject systemObject2, String string) {
        String string2 = systemObject2.getType();
        return (this.supportsAction(string2, PropertyAction.Type.REPLACE) || this.supportsAction(string2, PropertyAction.Type.DELETE)) && this.canCreate(systemObject2, string);
    }

    @Override
    public final PropertyAction canUpdateObject(SystemObject systemObject, SystemObject systemObject2) {
        DiffEngine diffEngine;
        PropertyAction propertyAction = null;
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider != null && (diffEngine = this.getProvider().getDiffEngine()) != null) {
            Difference difference = diffEngine.difference(systemObject, systemObject2);
            propertyAction = this.canUpdateObject(difference);
        }
        return propertyAction;
    }

    @Override
    public final PropertyAction canUpdateObject(Difference difference) {
        SystemObject systemObject = (SystemObject)difference.getOriginalObject();
        SystemObject systemObject2 = (SystemObject)difference.getUpdatedObject();
        PropertyAction propertyAction = new PropertyAction(systemObject == null ? PropertyAction.Type.CREATE : PropertyAction.Type.ALTER);
        if (difference.isModified()) {
            Collection<? extends Difference> collection = difference.getChildren();
            propertyAction = this.processDiffs(systemObject, systemObject2, collection, null, propertyAction);
        }
        return propertyAction;
    }

    private PropertyAction processDiffs(SystemObject systemObject, SystemObject systemObject2, Collection<? extends Difference> collection, String string, PropertyAction propertyAction) {
        for (Difference difference : collection) {
            String string2;
            if (propertyAction == null) break;
            if (difference.isSame() || difference.isDerived()) continue;
            String string3 = difference.getPropertyName();
            String string4 = string2 = ModelUtil.hasLength((String)string) ? string + "/" + string3 : string3;
            if (difference.isMap()) {
                propertyAction = this.processDiffs(systemObject, systemObject2, difference.getChildren(), string2, propertyAction);
                continue;
            }
            PropertyAction propertyAction2 = this.canChangeProperty(systemObject, systemObject2, string2);
            if (propertyAction2 == null) {
                PropertyInfo propertyInfo = this.findPropertyInfo(systemObject2.getClass(), string2);
                Level level = propertyInfo != null && propertyInfo.isDerived() ? Level.FINE : Level.WARNING;
                this.getLogger().log(level, "Unsupported property: " + string2);
                propertyAction = null;
                continue;
            }
            if (propertyAction.getType() != propertyAction2.getType() && propertyAction.getType() == PropertyAction.Type.ALTER) {
                propertyAction = propertyAction2;
            }
            if (propertyAction.getType() != propertyAction2.getType()) continue;
            propertyAction.addProperty(string2);
        }
        return propertyAction;
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        Nullable.NullBehaviour nullBehaviour;
        PropertyInfo propertyInfo;
        Collection collection = null;
        AbstractPropertyManager abstractPropertyManager = this.getDelegate();
        if (abstractPropertyManager != null) {
            collection = abstractPropertyManager.getAllowedPropertyValues(dBObject, dBObject2, string);
            if (collection != null) {
                Nullable.NullBehaviour nullBehaviour2 = abstractPropertyManager.getNullBehaviour(dBObject, dBObject2, string);
                Nullable.NullBehaviour nullBehaviour3 = this.getNullBehaviour(dBObject, dBObject2, string);
                if (nullBehaviour3 != nullBehaviour2) {
                    if (nullBehaviour2 == Nullable.NullBehaviour.NOT_NULLABLE) {
                        if (!collection.contains(null)) {
                            ArrayList arrayList = new ArrayList();
                            arrayList.add(null);
                            arrayList.addAll(collection);
                            collection = arrayList;
                        }
                    } else if (nullBehaviour3 == Nullable.NullBehaviour.NOT_NULLABLE) {
                        collection.remove(null);
                    }
                }
            }
        } else if (Property.getLastProperty(string).equals("constraintType")) {
            collection = new ArrayList<String>();
            if (dBObject2 instanceof Relation && this.supportsProperty(dBObject2.getClass(), "constraints")) {
                collection.add("PKConstraint");
            }
        } else if (string.contains("attributeValues")) {
            Column column;
            DataTypeUsage dataTypeUsage;
            if (dBObject2 instanceof Column && (dataTypeUsage = (column = (Column)dBObject2).getDataTypeUsage()) != null) {
                DataType dataType = null;
                try {
                    dataType = DataTypeHelper.getDataType(dataTypeUsage, false);
                }
                catch (DBException dBException) {
                    this.getLogger().log(Level.FINE, "Error getting data type attributes allowable values for \"" + string + "\" : " + dBException.getMessage());
                }
                if (dataType != null) {
                    DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute(Property.getLastProperty(string));
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (dataTypeAttribute != null) {
                        if (!dataTypeAttribute.isMandatory()) {
                            arrayList.add(null);
                        }
                        Collections.addAll(arrayList, dataTypeAttribute.getValues());
                    }
                    collection = arrayList;
                }
            }
        } else if (dBObject2 != null && (propertyInfo = this.findPropertyInfo(dBObject2.getClass(), string)) != null && (collection = propertyInfo.getAllowedValues()) != null && (nullBehaviour = this.getNullBehaviour(dBObject, dBObject2, string)) == Nullable.NullBehaviour.NOT_NULLABLE) {
            collection.remove(null);
        }
        if (dBObject2 instanceof Trigger && Property.getLastProperty(string).equals("timing")) {
            if (Trigger.BaseType.VIEW == ((Trigger)dBObject2).getBaseType()) {
                collection.retainAll(Collections.singleton(Trigger.Timing.INSTEAD_OF));
            } else {
                collection.remove((Object)Trigger.Timing.INSTEAD_OF);
            }
        }
        return collection;
    }

    @Override
    public Collection<String> getRestrictingProperties(Class<? extends SystemObject> clazz, String string) {
        Collection<String> collection = Collections.emptyList();
        AbstractPropertyManager abstractPropertyManager = this.getDelegate();
        if (abstractPropertyManager != null) {
            collection = abstractPropertyManager.getRestrictingProperties(clazz, string);
        }
        return collection;
    }

    @Override
    public Nullable.NullBehaviour getNullBehaviour(DBObject dBObject, DBObject dBObject2, String string) {
        PropertyInfo propertyInfo;
        Nullable.NullBehaviour nullBehaviour = null;
        if (dBObject2 != null && (propertyInfo = this.findPropertyInfo(dBObject2.getClass(), string)) != null) {
            nullBehaviour = this.getNullBehaviour(propertyInfo, dBObject != null);
        }
        return nullBehaviour;
    }

    protected Nullable.NullBehaviour getNullBehaviour(PropertyInfo propertyInfo, boolean bl) {
        Nullable.NullBehaviour nullBehaviour = propertyInfo.getNullBehaviour();
        if (bl && nullBehaviour == Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED) {
            nullBehaviour = Nullable.NullBehaviour.NOT_NULLABLE;
        }
        return nullBehaviour;
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(DBObject dBObject, String string) {
        Collection<String> collection;
        AbstractPropertyManager abstractPropertyManager = this.getDelegate();
        if (abstractPropertyManager != null) {
            collection = abstractPropertyManager.getAllowedReferenceTypes(dBObject, string);
        } else if (dBObject instanceof Trigger && "baseObjectID".equals(string)) {
            String string2;
            Trigger.BaseType baseType = ((Trigger)dBObject).getBaseType();
            String string3 = string2 = baseType == null ? null : baseType.toString();
            collection = this.m_meta.getObjectClass(string2) != null ? Collections.singleton(baseType == null ? "TABLE" : baseType.toString()) : null;
        } else {
            collection = this.getAllowedReferenceTypes(dBObject.getType(), string);
        }
        return collection;
    }

    @Override
    public final Collection<String> getAllowedReferenceTypes(String string, String string2) {
        PropertyInfo propertyInfo;
        Collection<String> collection = null;
        Class<? extends DBObject> clazz = this.m_meta.getObjectClass(string);
        if (clazz != null && (propertyInfo = this.findPropertyInfo(clazz, string2)) != null) {
            collection = this.getAllowedReferenceTypes(propertyInfo);
        }
        return collection;
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(PropertyInfo propertyInfo) {
        return propertyInfo == null ? null : propertyInfo.getAllowedReferenceTypes();
    }

    @Override
    public Collection<String> getAllowedReferenceParentTypes(DBObject dBObject, String string) {
        Collection<String> collection;
        AbstractPropertyManager abstractPropertyManager = this.getDelegate();
        if (abstractPropertyManager != null) {
            collection = abstractPropertyManager.getAllowedReferenceParentTypes(dBObject, string);
        } else if (dBObject instanceof FKConstraint && "referenceID".equals(string)) {
            collection = Collections.singleton("TABLE");
        } else {
            Collection<String> collection2 = this.getAllowedReferenceTypes(dBObject, string);
            if (collection2 == null) {
                collection = null;
            } else {
                collection = new HashSet<String>();
                for (String string2 : collection2) {
                    if ("SCHEMA".equals(string2)) continue;
                    collection.addAll(this.m_meta.getOwnerTypes(string2));
                }
            }
        }
        return collection;
    }

    @Override
    public Object getImplicitDefaultValue(DBObject dBObject, String string) {
        return null;
    }

    protected final boolean isProcessorProperty(Class<? extends SystemObject> clazz, String string) {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider != null) {
            for (UpdateProcessor updateProcessor : dBObjectProvider.getDescriptor().getUpdateProcessors()) {
                if (!updateProcessor.getProcessorProperties(dBObjectProvider).contains(string)) continue;
                return true;
            }
        }
        return false;
    }
}

