/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Tuple;

public abstract class PlSqlParser {
    private final PlSqlSourceObject m_root;
    private final String m_source;
    private final DBObjectProvider m_pro;

    protected PlSqlParser(DBObjectProvider dBObjectProvider, PlSqlSourceObject plSqlSourceObject, String string) {
        if (dBObjectProvider == null) {
            throw new IllegalArgumentException("DBObjectProvider pro must not be null");
        }
        if (plSqlSourceObject == null && string == null || plSqlSourceObject != null && string != null) {
            throw new IllegalArgumentException("Please provide a PlSqlSourceObject or String, but not both");
        }
        this.m_pro = dBObjectProvider;
        if (plSqlSourceObject != null) {
            this.m_root = plSqlSourceObject;
        } else {
            Class<? extends DBObject> clazz;
            PlSqlSourceObject plSqlSourceObject2 = null;
            String string2 = PlSqlUtilCore.getTypeFromSource(string);
            if (string2 != null && (clazz = Metadata.getInstance().getObjectClass(string2)) != null && PlSqlSourceObject.class.isAssignableFrom(clazz)) {
                plSqlSourceObject2 = (PlSqlSourceObject)this.m_pro.getObjectFactory().newObject(clazz, null, false, false);
                plSqlSourceObject2.setSource(string);
            }
            this.m_root = plSqlSourceObject2;
        }
        this.m_source = string == null ? this.m_root.getSource() : string;
    }

    public final PlSqlSourceObject getRoot() {
        return this.m_root;
    }

    public abstract PlSqlToken getTokenAtOffset(int var1) throws CancelledException;

    public abstract boolean isWrapped() throws CancelledException;

    public abstract PlSqlToken getTypeToken() throws CancelledException;

    public abstract PlSqlToken getSchemaToken() throws CancelledException;

    public abstract PlSqlToken getNameToken() throws CancelledException;

    public abstract int getStartOffsetOfObject() throws CancelledException;

    public abstract int getEndOffsetOfObject() throws CancelledException;

    public abstract List<Tuple<PlSqlToken, PlSqlToken>> getAlterStatements() throws CancelledException;

    public final List<Integer> getLocationOffsets(String string) throws CancelledException {
        String string2 = this.getSource();
        if (string2 != null) {
            return this.getLocationOffsets(string, 0, string2.length() - 1);
        }
        return Collections.emptyList();
    }

    public final List<Integer> getLocationOffsets(String string, int n, int n2) throws CancelledException {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        char c = Character.toLowerCase(string.charAt(0));
        char c2 = Character.toUpperCase(string.charAt(0));
        int n4 = string.length();
        boolean bl = false;
        for (n3 = 0; n3 < n4; ++n3) {
            char c3 = string.charAt(n3);
            if (!(n3 != 0 || Character.isLetter(c3) && Character.isUpperCase(c3))) {
                bl = true;
                break;
            }
            if (c3 == '_' || c3 == '$' || c3 == '#') continue;
            if (!Character.isLetterOrDigit(c3)) {
                bl = true;
                break;
            }
            if (!Character.isLetter(c3) || !Character.isLowerCase(c3)) continue;
            bl = true;
            break;
        }
        n3 = 1;
        for (char c4 : string.toCharArray()) {
            if (!Character.isLetter(c4) || !Character.isLowerCase(c4)) continue;
            n3 = 0;
            break;
        }
        Object object = this.getSource();
        int n5 = n;
        while (n5 <= n2 - n4 + 1) {
            PlSqlToken plSqlToken;
            String string2;
            char c4;
            int n6 = ((String)object).charAt(n5);
            c4 = '\u0000';
            if ((n6 == c || n6 == c2) && (string2 = ((String)object).substring(n5, n5 + n4)).equalsIgnoreCase(string) && (plSqlToken = this.getTokenAtOffset(n5)).isCode(true)) {
                if (plSqlToken.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
                    String string3 = plSqlToken.getSource();
                    string3 = string3.substring(1, string3.length() - 1);
                    c4 = (char)(string.equals(string3) ? 1 : 0);
                } else if (!bl) {
                    c4 = (char)(plSqlToken.matches(string) ? 1 : 0);
                }
            }
            if (c4 != '\u0000') {
                arrayList.add(n5);
                n5 += n4;
                continue;
            }
            ++n5;
        }
        return arrayList;
    }

    public abstract Object getParseNode(int var1) throws CancelledException;

    public abstract int getStartOffset(Object var1) throws IllegalArgumentException, CancelledException;

    public abstract int getEndOffset(Object var1) throws IllegalArgumentException, CancelledException;

    public abstract List getChildParseNodes(DBObjectPlSqlFragment var1, Object var2) throws IllegalArgumentException, CancelledException;

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected final String getSource() {
        return this.m_source;
    }

    public abstract Object getParseNode(DBObjectPlSqlFragment var1) throws CancelledException;

    public abstract DBObjectPlSqlFragment createFragment(DBObjectPlSqlFragment var1, Object var2, Object var3) throws CancelledException;

    public final Object getPropertyNode(DBObjectPlSqlFragment dBObjectPlSqlFragment, String string) throws CancelledException {
        Object[] objectArray = this.getPropertyNodesImpl(dBObjectPlSqlFragment, string);
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        if (objectArray.length == 1) {
            return objectArray[0];
        }
        throw new UnsupportedOperationException("getPropertyNode() should not be called on a collection property");
    }

    public final Object[] getPropertyNodes(DBObjectPlSqlFragment dBObjectPlSqlFragment, String string) throws CancelledException {
        Object[] objectArray = this.getPropertyNodesImpl(dBObjectPlSqlFragment, string);
        if (objectArray == null) {
            return new Object[0];
        }
        return objectArray;
    }

    protected abstract Object[] getPropertyNodesImpl(DBObjectPlSqlFragment var1, String var2) throws CancelledException;

    public abstract List<Issue> getIssues() throws CancelledException;

    public abstract List<Issue> getIssues(String var1);

    public static interface Issue {
        public int getStartOffset();

        public int getEndOffset();

        public Severity getSeverity();

        public String getMessage();
    }

    public static enum Severity {
        ERROR,
        WARNING,
        INFO;

    }
}

