/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.StringTokenizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.DBLog;

public class PlSqlCompilerOptions
extends HashStructureAdapter {
    public static final String KEY = "PlSqlCompilerOptions";
    private static final String GENERATE_DEBUG = "generateDebugPlsql";

    public PlSqlCompilerOptions(HashStructure hashStructure) {
        super(hashStructure);
    }

    public WarningValue getWarningValue(WarningCategory warningCategory) {
        String string;
        if (warningCategory != null && (string = this._hash.getString(warningCategory.toString())) != null) {
            try {
                return WarningValue.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBLog.logStackTrace(illegalArgumentException);
            }
        }
        return null;
    }

    public void setWarningValue(WarningCategory warningCategory, WarningValue warningValue) {
        if (warningCategory != null) {
            this._hash.putString(warningCategory.toString(), warningValue == null ? null : warningValue.toString());
        }
    }

    public void setWarningFlags(String string) {
        this._hash.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n <= 0) continue;
            try {
                WarningValue warningValue = WarningValue.valueOf(string2.substring(0, n));
                WarningCategory warningCategory = WarningCategory.valueOf(string2.substring(n + 1));
                this.setWarningValue(warningCategory, warningValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DBLog.logStackTrace(illegalArgumentException);
            }
        }
    }

    public String getWarningFlags() {
        StringBuffer stringBuffer = new StringBuffer();
        for (WarningCategory warningCategory : WarningCategory.values()) {
            WarningValue warningValue = this.getWarningValue(warningCategory);
            if (warningValue == null) continue;
            stringBuffer.append((Object)warningValue).append(':').append((Object)warningCategory).append('|');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public boolean isGeneratePlSqlDebugInfo() {
        return this._hash.getBoolean(GENERATE_DEBUG, true);
    }

    public void setGeneratePlSqlDebugInfo(boolean bl) {
        this._hash.putBoolean(GENERATE_DEBUG, bl);
    }

    public static enum WarningCategory {
        ALL,
        INFORMATIONAL,
        SEVERE,
        PERFORMANCE;

    }

    public static enum WarningValue {
        ENABLE,
        DISABLE,
        ERROR;

    }
}

