/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

public class LOBDescriptor
extends AbstractChildDBObject {
    public static final String TYPE = "LOB DESCRIPTOR";
    @Deprecated
    public static final String LOB_PARAMETER_CACHE = LOBCache.CACHE.toString();
    @Deprecated
    public static final String LOB_PARAMETER_NOCACHE = LOBCache.NOCACHE.toString();
    @Deprecated
    public static final String LOB_PARAMETER_CACHEREADS = LOBCache.CACHE_READS.toString();

    public LOBDescriptor() {
        this.setRetention(false);
    }

    @Override
    public String getName() {
        Relation relation;
        Object object = super.getName();
        if (!ModelUtil.hasLength((String)object) && (relation = this.findParent(Relation.class)) != null) {
            object = "";
            for (DBObjectID dBObjectID : this.getColumns()) {
                DBObject dBObject;
                if (dBObjectID == null || !((dBObject = relation.findOwnedObject(dBObjectID)) instanceof Column)) continue;
                if (((String)object).length() > 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + dBObject.getName();
            }
            this.setName((String)object);
        }
        return object;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setLOBSegName(String string) {
        this.setProperty("LOBSegName", string);
    }

    @TextProperty(internalName=true)
    public String getLOBSegName() {
        return (String)this.getProperty("LOBSegName");
    }

    public void setColumns(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("columns").setChildArray(dBObjectIDArray);
        this.setName(null);
    }

    public DBObjectID[] getColumns() {
        return this.getChildSupport("columns").getChildArray(DBObjectID.class);
    }

    public void addColumn(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this.getChildSupport("columns").addChild(dBObjectID);
            this.setName(null);
        }
    }

    public void removeColumn(DBObjectID dBObjectID) {
        if (this.getChildSupport("columns").removeChild(dBObjectID)) {
            this.setName(null);
        }
    }

    public void setChunk(Integer n) {
        this.setProperty("chunk", n);
    }

    public Integer getChunk() {
        return (Integer)this.getProperty("chunk");
    }

    public void setPctVersion(Integer n) {
        this.setProperty("pctVersion", n);
    }

    public Integer getPctVersion() {
        return (Integer)this.getProperty("pctVersion");
    }

    public void setFreepools(Integer n) {
        this.setProperty("freepools", n);
    }

    public Integer getFreepools() {
        return (Integer)this.getProperty("freepools");
    }

    public void setStorage(OracleStorageProperties oracleStorageProperties) {
        this.setProperty("storage", oracleStorageProperties);
    }

    public OracleStorageProperties getStorage() {
        return (OracleStorageProperties)this.getProperty("storage");
    }

    public void setRetention(boolean bl) {
        this.setProperty("retention", bl);
    }

    public boolean isRetention() {
        return (Boolean)this.getProperty("retention", false);
    }

    @Deprecated
    @Transient
    public void setStorageEnabledInRow(boolean bl) {
        this.setStorageInRow(bl);
    }

    @Deprecated
    public boolean isStorageEnabledInRow() {
        Boolean bl = this.getStorageInRow();
        return !Boolean.FALSE.equals(bl);
    }

    public void setStorageInRow(Boolean bl) {
        this.setProperty("storageInRow", bl);
    }

    public Boolean getStorageInRow() {
        return (Boolean)this.getProperty("storageInRow");
    }

    @Deprecated
    @Transient
    public void setCache(String string) {
        this.setLOBCache((LOBCache)((Object)DBUtil.findEnumFromString(string, LOBCache.class)));
    }

    @Deprecated
    public String getCache() {
        LOBCache lOBCache = this.getLOBCache();
        return lOBCache == null ? null : lOBCache.toString();
    }

    public void setLOBCache(LOBCache lOBCache) {
        this.setProperty("LOBCache", (Object)lOBCache);
    }

    public LOBCache getLOBCache() {
        return (LOBCache)((Object)this.getProperty("LOBCache"));
    }

    @Deprecated
    public static boolean isLOBColumn(DBObjectID dBObjectID) {
        return false;
    }

    public static boolean isLOBColumn(DBObjectID dBObjectID, DBObject dBObject) {
        Column column;
        boolean bl = false;
        Relation relation = DBUtil.findParentOfType(dBObject, Relation.class);
        if (relation != null && LOBDescriptor.isLOBColumn(column = (Column)relation.findOwnedObject(dBObjectID))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isLOBColumn(Column column) {
        DataTypeUsage dataTypeUsage = column == null ? null : column.getDataTypeUsage();
        DBObjectID dBObjectID = dataTypeUsage == null ? null : dataTypeUsage.getDataTypeID();
        return dBObjectID instanceof DataTypeID && LOBDescriptor.isLOBType(((DataTypeID)dBObjectID).getTypeName());
    }

    public static boolean isLOBType(DataType dataType) {
        boolean bl = false;
        if (dataType != null) {
            String string = dataType.getName();
            bl = LOBDescriptor.isLOBType(string);
        }
        return bl;
    }

    private static boolean isLOBType(String string) {
        return "BLOB".equalsIgnoreCase(string) || "CLOB".equalsIgnoreCase(string) || "NCLOB".equalsIgnoreCase(string);
    }

    @Deprecated
    public static boolean isVARRAYColumn(DBObjectID dBObjectID) {
        return false;
    }

    public static boolean isVARRAYColumn(DBObjectID dBObjectID, DBObject dBObject) {
        Column column;
        boolean bl = false;
        Relation relation = DBUtil.findParentOfType(dBObject, Relation.class);
        if (relation != null && LOBDescriptor.isVARRAYColumn(column = (Column)relation.findOwnedObject(dBObjectID))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isVARRAYColumn(Column column) {
        boolean bl = false;
        try {
            DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
            if (dataTypeUsage != null) {
                DataType dataType = DataTypeHelper.getDataType(dataTypeUsage, false);
                bl = LOBDescriptor.isVARRAYType(dataType);
            }
        }
        catch (DBException dBException) {
            DBLog.getLogger(LOBDescriptor.class).fine(dBException.getMessage());
        }
        return bl;
    }

    public static boolean isVARRAYType(DataType dataType) {
        boolean bl = false;
        if (dataType instanceof Type) {
            bl = "VARYING ARRAY".equals(((Type)dataType).getCollectionType());
        }
        return bl;
    }

    public static enum LOBCache {
        CACHE,
        NOCACHE,
        CACHE_READS;


        public String toString() {
            return super.toString().replace('_', ' ');
        }
    }
}

