/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.resource.APIBundle;

public class ConnectionWrapper {
    private final Database m_db;
    private final String m_desc;

    public ConnectionWrapper(Database database, String string) {
        if (database == null) {
            throw new IllegalArgumentException("Database cannot be null.");
        }
        this.m_db = database;
        this.m_desc = string;
    }

    public void run(SQLRunnable sQLRunnable) throws DBException {
        this.call(sQLRunnable);
    }

    public <T> T call(SQLCallable<T> sQLCallable) throws DBException {
        return this.call(sQLCallable, 0);
    }

    private <T> T call(SQLCallable<T> sQLCallable, int n) throws DBException {
        Serializable serializable;
        Connection connection;
        SQLException sQLException;
        DBException dBException;
        T t;
        block13: {
            t = null;
            dBException = null;
            sQLException = null;
            connection = sQLCallable.getConnection();
            try {
                t = sQLCallable.callImpl();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            catch (DBException dBException2) {
                dBException = dBException2;
                serializable = dBException2.getCause();
                if (!(serializable instanceof SQLException)) break block13;
                sQLException = (SQLException)serializable;
            }
        }
        boolean bl = true;
        if (sQLException != null && n < 5) {
            serializable = this.m_db.isConnectionClosed(sQLException);
            if (serializable == null) {
                serializable = Boolean.valueOf(!this.m_db.isConnectionAlive(connection));
            }
            if (Boolean.TRUE.equals(serializable)) {
                String string = Thread.currentThread().getName() + ": ";
                DBLog.getLogger(this).info(string + APIBundle.format("CLOSED_EX", this.m_db.getName()));
                try {
                    Connection connection2 = this.m_db.getConnection(true);
                    if (connection2 == connection) {
                        DBLog.getLogger(this).info(string + APIBundle.format("RECONNECT_FAILED", this.m_db.getName()));
                    } else {
                        bl = false;
                        sQLCallable.m_connection = connection2;
                        t = this.call(sQLCallable, n++);
                    }
                }
                catch (DBException dBException3) {
                    bl = true;
                }
            }
        }
        if (bl) {
            if (dBException != null) {
                throw dBException;
            }
            if (sQLException != null) {
                throw StatementWrapper.createDBSQLException(this.m_db, null, this.m_desc, sQLException);
            }
        }
        return t;
    }

    public abstract class SQLCallable<T> {
        private Connection m_connection;

        protected SQLCallable() {
            try {
                this.m_connection = ConnectionWrapper.this.m_db.getConnection(false);
            }
            catch (DBException dBException) {
                throw new RuntimeException(dBException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T callImpl() throws SQLException, DBException {
            Connection connection = this.m_connection;
            synchronized (connection) {
                return this.call();
            }
        }

        public abstract T call() throws SQLException, DBException;

        protected final Connection getConnection() {
            return this.m_connection;
        }
    }

    public abstract class SQLRunnable
    extends SQLCallable<Object> {
        @Override
        public final Object call() throws SQLException, DBException {
            this.run();
            return null;
        }

        public abstract void run() throws SQLException, DBException;
    }
}

