/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngineCancelledException;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public final class DiffEngine {
    private boolean m_cancelled;
    private boolean m_allowMultipleDiffers;
    private Map<Class, List<Differ>> m_registeredDiffers;
    private Map<Class, Differ> m_registeredListDiffers;
    private Map<Class, Comparator> m_registeredComparators;

    public DiffEngine() {
        this(false);
    }

    public DiffEngine(boolean bl) {
        this.m_allowMultipleDiffers = bl;
        this.m_registeredDiffers = new HashMap<Class, List<Differ>>();
        this.m_registeredListDiffers = new HashMap<Class, Differ>();
        this.m_registeredComparators = new HashMap<Class, Comparator>();
    }

    public DiffEngine(DiffEngine diffEngine) {
        this.m_allowMultipleDiffers = diffEngine.m_allowMultipleDiffers;
        this.m_registeredDiffers = new HashMap<Class, List<Differ>>(diffEngine.m_registeredDiffers);
        this.m_registeredListDiffers = new HashMap<Class, Differ>(diffEngine.m_registeredListDiffers);
        this.m_registeredComparators = new HashMap<Class, Comparator>(diffEngine.m_registeredComparators);
    }

    public Difference difference(Object object, Object object2) {
        DiffContext diffContext = object instanceof Object[] || object2 instanceof Object[] ? this.diff((Object[])object, (Object[])object2) : this.diff(object, object2);
        return diffContext.getResult();
    }

    public DiffContext diff(Object object, Object object2) {
        this.checkProgress();
        ResultSet resultSet = new ResultSet(null, object, object2, null, "MAP");
        DiffContext diffContext = new DiffContext(this, resultSet);
        return this.diff(object, object2, resultSet, diffContext);
    }

    public DiffContext diff(Object[] objectArray, Object[] objectArray2) {
        this.checkProgress();
        ResultSet resultSet = new ResultSet(null, objectArray, (Object)objectArray2, null, "LIST");
        DiffContext diffContext = new DiffContext(this, resultSet);
        return this.diff(objectArray, objectArray2, resultSet, diffContext);
    }

    public DiffContext diff(Object object, Object object2, ResultSet resultSet, DiffContext diffContext) {
        block3: {
            this.checkProgress();
            if (object == null && object2 == null) {
                throw new IllegalArgumentException("At least one object must be non-null to be able to diff");
            }
            Class<?> clazz = object == null ? object2.getClass() : object.getClass();
            List<Differ> list = this.getDiffers(clazz);
            assert (list != null) : "no differ for class " + clazz.getName();
            if (list == null) break block3;
            for (Differ differ : list) {
                if (differ.diff(object, object2, resultSet, diffContext)) break;
            }
        }
        return diffContext;
    }

    public DiffContext diff(Object[] objectArray, Object[] objectArray2, ResultSet resultSet) {
        this.checkProgress();
        DiffContext diffContext = new DiffContext(this, resultSet);
        return this.diff(objectArray, objectArray2, resultSet, diffContext);
    }

    public DiffContext diff(Object[] objectArray, Object[] objectArray2, ResultSet resultSet, DiffContext diffContext) {
        this.checkProgress();
        Class<?> clazz = objectArray == null ? objectArray2.getClass() : objectArray.getClass();
        Differ differ = this.getListDiffer(clazz);
        differ.diff(objectArray == null ? null : Arrays.asList(objectArray), objectArray2 == null ? null : Arrays.asList(objectArray2), resultSet, diffContext);
        return diffContext;
    }

    public DiffContext diff(List list, List list2, ResultSet resultSet, DiffContext diffContext) {
        this.checkProgress();
        resultSet.setA(list);
        resultSet.setB(list2);
        Differ differ = null;
        if (null != list && list.size() > 0 && null != this.getEntryClass(list)) {
            differ = this.getListDiffer(this.getEntryClass(list));
        } else if (null != list2 && list2.size() > 0 && null != this.getEntryClass(list2)) {
            differ = this.getListDiffer(this.getEntryClass(list2));
        } else {
            resultSet.setSame(true);
        }
        if (differ != null) {
            differ.diff(list, list2, resultSet, diffContext);
        }
        return diffContext;
    }

    private Class getEntryClass(List list) {
        Class<?> clazz = null;
        if (!list.isEmpty()) {
            for (Object e : list) {
                if (e == null) continue;
                clazz = e.getClass();
                break;
            }
        }
        return clazz;
    }

    public void registerDiffer(Differ differ, Class clazz) {
        List<Differ> list = this.m_registeredDiffers.get(clazz);
        if (list == null) {
            list = new ArrayList<Differ>();
            this.m_registeredDiffers.put(clazz, list);
        }
        if (!this.m_allowMultipleDiffers) {
            list.clear();
        }
        list.add(0, differ);
    }

    public void registerListDiffer(Differ differ, Class clazz) {
        this.m_registeredListDiffers.put(DBUtil.decodeArrayClass(clazz), differ);
    }

    public <T> void registerComparator(Comparator<? super T> comparator, Class<T> clazz) {
        this.m_registeredComparators.put(clazz, comparator);
    }

    private static <T> T searchMap(Map<Class, T> map, Class clazz) {
        Object var2_2 = null;
        block0: while (clazz != null && (!map.containsKey(clazz) || (var2_2 = DiffEngine.get(map, clazz, var2_2)) instanceof List) && clazz != Object.class) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (map.containsKey(classArray[i]) && !((var2_2 = DiffEngine.get(map, classArray[i], var2_2)) instanceof List)) break block0;
            }
            Class clazz2 = clazz;
            if ((clazz = clazz.getSuperclass()) != null || clazz2 == Object.class) continue;
            clazz = Object.class;
        }
        return var2_2;
    }

    private static <K, V> V get(Map<K, V> map, K k, V v) {
        Object object = map.get(k);
        if (object instanceof List) {
            if (v instanceof List) {
                ((List)v).addAll((List)object);
                object = v;
            } else {
                object = new ArrayList((List)object);
            }
        }
        return object;
    }

    private List<Differ> getDiffers(Class clazz) {
        return DiffEngine.searchMap(this.m_registeredDiffers, clazz);
    }

    private Differ getListDiffer(Class clazz) {
        return DiffEngine.searchMap(this.m_registeredListDiffers, DBUtil.decodeArrayClass(clazz));
    }

    public <T> Comparator<? super T> getComparator(Class<T> clazz) {
        return DiffEngine.searchMap(this.m_registeredComparators, clazz);
    }

    boolean hasRegisteredDiffer(Class clazz) {
        List<Differ> list = this.m_registeredDiffers.get(clazz);
        return list == null ? false : !list.isEmpty();
    }

    public synchronized void checkProgress() {
        if (this.m_cancelled) {
            throw new DiffEngineCancelledException();
        }
    }

    public synchronized void cancelDiff() {
        this.m_cancelled = true;
    }

    public DiffEngine copy() {
        DiffEngine diffEngine = new DiffEngine(this.m_allowMultipleDiffers);
        ModelUtil.deepCopy(this.m_registeredDiffers, diffEngine.m_registeredDiffers);
        ModelUtil.deepCopy(this.m_registeredListDiffers, diffEngine.m_registeredListDiffers);
        ModelUtil.deepCopy(this.m_registeredComparators, diffEngine.m_registeredComparators);
        return diffEngine;
    }
}

