/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DefaultTokenGenerator;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class BundleDDLGenerator<T extends DDLType>
extends TokenDDLGenerator<T> {
    private final List<DDLList> m_bundles = new ArrayList<DDLList>();

    @Deprecated
    public BundleDDLGenerator(DBObjectProvider dBObjectProvider, String ... stringArray) {
        this(dBObjectProvider.getClass(), dBObjectProvider, stringArray);
    }

    public BundleDDLGenerator(Class<? extends Database> clazz, DBObjectProvider dBObjectProvider, String ... stringArray) {
        super(clazz, dBObjectProvider);
        this.addResourceNames(stringArray);
    }

    protected void addResourceNames(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!ModelUtil.hasLength((String)string)) continue;
                PropertiesDDLList propertiesDDLList = new PropertiesDDLList(string);
                this.m_bundles.add(0, propertiesDDLList);
            }
            this.registerBundleTokens();
        }
    }

    protected void addBundles(ResourceBundle ... resourceBundleArray) {
        if (resourceBundleArray != null) {
            for (ResourceBundle resourceBundle : resourceBundleArray) {
                if (resourceBundle == null) continue;
                BundleDDLList bundleDDLList = new BundleDDLList(resourceBundle);
                this.m_bundles.add(0, bundleDDLList);
            }
            this.registerBundleTokens();
        }
    }

    protected final String findResource(String string) {
        MissingResourceException missingResourceException = null;
        if (this.m_bundles != null) {
            for (int i = 0; i < this.m_bundles.size() - 1; ++i) {
                DDLList dDLList = this.m_bundles.get(i);
                try {
                    return dDLList.getString(string);
                }
                catch (MissingResourceException missingResourceException2) {
                    missingResourceException = missingResourceException2;
                    continue;
                }
            }
        }
        if (missingResourceException == null) {
            missingResourceException = new MissingResourceException("no resource found for " + string, null, string);
        }
        throw missingResourceException;
    }

    protected final void registerBundleTokens() {
        if (this.m_bundles.isEmpty()) {
            this.getLogger().fine(this.getClass().getSimpleName() + ": no registered resource bundles");
        } else {
            HashSet<String> hashSet = new HashSet<String>();
            for (DDLList dDLList : this.m_bundles) {
                Enumeration<String> enumeration = dDLList.getKeys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (hashSet.contains(string)) continue;
                    this.registerBundleEntry(string, dDLList.getString(string));
                    hashSet.add(string);
                }
            }
        }
    }

    protected void registerBundleEntry(String string, String string2) {
        String[] stringArray = string.split("\\.");
        if (string.startsWith("GLOBAL")) {
            if (stringArray.length > 1) {
                if (ModelUtil.hasLength((String)string2)) {
                    this.registerTokenGenerator(string.substring(7), new DefaultTokenGenerator(string2));
                }
            } else {
                this.getLogger().log(Level.WARNING, "GLOBAL keyword found with no following .tokenName: " + string);
            }
        } else if (stringArray.length == 3) {
            this.registerDDLFromBundle(stringArray, string, string2);
        } else if (stringArray.length == 4) {
            try {
                Integer.parseInt(stringArray[3]);
                this.registerDDLFromBundle(stringArray, string, string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.getLogger().log(Level.WARNING, "fourth component not an int for: " + string);
            }
        }
    }

    private void registerDDLFromBundle(String[] stringArray, String string, String string2) {
        if (!ModelUtil.hasLength((String)string2)) {
            return;
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        if (!ModelUtil.hasLength((String)string3)) {
            this.getLogger().severe("invalid bundle key (missing type): " + string);
        } else {
            if (Metadata.getInstance().getObjectClass(string3) == null) {
                this.getLogger().warning("unknown object type for: " + string);
            }
            DDLType dDLType = null;
            try {
                dDLType = (DDLType)this.getDDLType(string5);
            }
            catch (Exception exception) {
                this.getLogger().log(Level.SEVERE, "invalid bundle key (invalid ddltype): " + string, exception);
            }
            if (dDLType == null) {
                this.getLogger().severe("invalid bundle key (no ddltype): " + string);
            } else if (string4.equals("CREATE")) {
                this.registerCreateDDL(string3, string2, dDLType);
            } else if (string4.equals("ALTER")) {
                this.registerAlterDDL(string3, string2, dDLType);
            } else if (string4.equals("DROP")) {
                this.registerDropDDL(string3, string2, dDLType);
            } else if (string4.equals("UNDELETE")) {
                this.registerUndeleteDDL(string3, string2, dDLType);
            } else {
                this.getLogger().severe("invalid bundle key (unknown action): " + string);
            }
        }
    }

    protected abstract T getDDLType(String var1);

    protected final void registerBundleCreateDDL(String string, String string2, T t) {
        this.registerCreateDDL(string, this.findResource(string2), (DDLType)t);
    }

    protected final void registerBundleDropDDL(String string, String string2, T t) {
        this.registerDropDDL(string, this.findResource(string2), (DDLType)t);
    }

    protected final void registerBundleUndeleteDDL(String string, String string2, T t) {
        this.registerUndeleteDDL(string, this.findResource(string2), (DDLType)t);
    }

    protected final void registerBundleAlterDDL(String string, String string2, T t) {
        this.registerAlterDDL(string, this.findResource(string2), (DDLType)t);
    }

    private class PropertiesDDLList
    implements DDLList {
        private String m_name;
        private final Properties m_props = new Properties();

        public PropertiesDDLList(String string) {
            this.m_name = string;
            this.load();
        }

        private void load() {
            block6: {
                this.m_props.clear();
                try {
                    InputStream inputStream = BundleDDLGenerator.this.getClass().getResourceAsStream(this.m_name);
                    if (inputStream == null) {
                        BundleDDLGenerator.this.getLogger().log(Level.WARNING, "Error: resource " + this.m_name + " not found for ddl generation.");
                        break block6;
                    }
                    try {
                        this.m_props.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    BundleDDLGenerator.this.getLogger().log(Level.WARNING, "Error opening resource " + this.m_name + " for ddl generator: " + exception.getMessage());
                }
            }
        }

        @Override
        public String getString(String string) {
            if (this.m_props.containsKey(string)) {
                return this.m_props.getProperty(string);
            }
            throw new MissingResourceException("No such resource in bundle.", this.m_name, string);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.m_props.propertyNames();
        }
    }

    private class BundleDDLList
    implements DDLList {
        private ResourceBundle m_bundle;

        public BundleDDLList(ResourceBundle resourceBundle) {
            this.m_bundle = resourceBundle;
        }

        @Override
        public String getString(String string) {
            return this.m_bundle.getString(string);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.m_bundle.getKeys();
        }
    }

    private static interface DDLList {
        public String getString(String var1);

        public Enumeration<String> getKeys();
    }
}

