/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.Column;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.util.ModelUtil;

public class View
extends Relation
implements SQLQueryOwner {
    public static final String TYPE = "VIEW";
    @Deprecated
    public static final String READ_ONLY = "WITH READ ONLY";
    @Deprecated
    public static final String CHECK_OPTION = "WITH CHECK OPTION";

    public View() {
        this((String)null, (Schema)null);
    }

    public View(String string, Schema schema) {
        super(string, schema);
        this.setForceOnCreate(false);
    }

    @TextProperty(multiLine=true)
    @Internal
    public String getViewText() {
        SQLQuery sQLQuery = this.getSQLQuery();
        if (sQLQuery == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sQLQuery.getSQLText().trim());
        Restriction restriction = this.getRestriction();
        if (restriction != null) {
            stringBuilder.append("\n");
            stringBuilder.append("WITH ");
            stringBuilder.append(restriction.toString());
        }
        return stringBuilder.toString();
    }

    public void setViewText(String string) {
        Restriction restriction;
        SQLQuery sQLQuery;
        if (string == null) {
            sQLQuery = null;
            restriction = null;
        } else if (string.trim().endsWith(READ_ONLY)) {
            sQLQuery = new SQLQuery(string.substring(0, string.lastIndexOf(READ_ONLY)).trim());
            restriction = Restriction.READ_ONLY;
        } else if (string.trim().endsWith(CHECK_OPTION)) {
            sQLQuery = new SQLQuery(string.substring(0, string.lastIndexOf(CHECK_OPTION)).trim());
            restriction = Restriction.CHECK_OPTION;
        } else {
            sQLQuery = new SQLQuery(string);
            restriction = null;
        }
        this.setSQLQuery(sQLQuery);
        this.setRestriction(restriction);
    }

    @Override
    public SQLQuery getSQLQuery() {
        return (SQLQuery)this.getProperty("SQLQuery");
    }

    @Override
    public void setSQLQuery(SQLQuery sQLQuery) {
        this.setProperty("SQLQuery", sQLQuery);
    }

    @Override
    @Derived(value="SQLQuery")
    public Column[] getColumns() {
        return super.getColumns();
    }

    @Override
    public boolean isDeclarative() {
        SQLQuery sQLQuery = this.getSQLQuery();
        return sQLQuery != null && sQLQuery.isDeclarative();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public Restriction getRestriction() {
        return (Restriction)((Object)this.getProperty("restriction"));
    }

    public void setRestriction(Restriction restriction) {
        this.setProperty("restriction", (Object)restriction);
    }

    @Deprecated
    public String getQueryRestriction() {
        Restriction restriction = this.getRestriction();
        return restriction != null ? restriction.toString() : null;
    }

    @Deprecated
    @Transient
    public void setQueryRestriction(String string) {
        if (!ModelUtil.hasLength((String)string)) {
            this.setRestriction(null);
        } else {
            String string2 = string.replaceAll(" ", "_").replaceFirst("WITH_", "");
            this.setRestriction(Restriction.valueOf(string2));
        }
    }

    public boolean isForceOnCreate() {
        return (Boolean)this.getProperty("forceOnCreate", false);
    }

    public void setForceOnCreate(boolean bl) {
        this.setProperty("forceOnCreate", bl);
    }

    public static enum Restriction {
        READ_ONLY,
        CHECK_OPTION;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

