/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public class TemporaryObjectID
implements DBObjectID {
    private DBObject m_obj;
    private DBObject m_original;

    private TemporaryObjectID(DBObject dBObject) {
        this.m_obj = dBObject;
        this.m_original = null;
    }

    public Object copyTo(Object object) {
        TemporaryObjectID temporaryObjectID = object == null ? new TemporaryObjectID(null) : (TemporaryObjectID)object;
        temporaryObjectID.m_obj = this.m_obj;
        temporaryObjectID.m_original = this.m_original;
        return temporaryObjectID;
    }

    public final boolean equals(Object object) {
        return object instanceof DBObjectID && this.equals((DBObjectID)object, true);
    }

    @Override
    public boolean equals(DBObjectID dBObjectID, boolean bl) {
        boolean bl2;
        if (dBObjectID == null) {
            bl2 = false;
        } else if (dBObjectID instanceof TemporaryObjectID) {
            bl2 = this.equalsImpl((TemporaryObjectID)dBObjectID, bl);
        } else if (this.m_original != null && dBObjectID.equals(this.m_original.getID(), bl)) {
            if (bl && dBObjectID instanceof NameBasedID) {
                String string;
                String string2 = string = this.m_obj == null ? null : this.m_obj.getName();
                bl2 = string == null ? true : ModelUtil.areEqual((Object)string, (Object)((NameBasedID)dBObjectID).getName());
            } else {
                bl2 = true;
            }
        } else {
            bl2 = !bl && this.isSameTypeAndName(dBObjectID);
        }
        return bl2;
    }

    private boolean equalsImpl(TemporaryObjectID temporaryObjectID, boolean bl) {
        boolean bl2 = this == temporaryObjectID || this.m_obj == temporaryObjectID.m_obj ? true : (this.m_original == temporaryObjectID.m_original ? (this.m_original == null ? this.isSameTypeAndName(temporaryObjectID) : true) : (this.isInOriginalHeirachy(temporaryObjectID.m_obj) ? true : (temporaryObjectID.isInOriginalHeirachy(this.m_obj) ? true : (!bl ? this.isSameTypeAndName(temporaryObjectID) : false))));
        return bl2;
    }

    private NameBasedID getNameBasedID() {
        PropertyInfo propertyInfo;
        NameBasedID nameBasedID = null;
        DBObject dBObject = null;
        dBObject = this.m_obj != null && !this.isObjectRemovedFromParent() ? this.m_obj : this.m_original;
        if (dBObject != null && (propertyInfo = PropertyHelper.findPropertyInfo(dBObject.getClass(), "name", (Class<? extends DBObjectProvider>)null)) != null && (!propertyInfo.isInternal() || DBUtil.getFrozenProperties(dBObject).containsKey("name"))) {
            DBObjectID dBObjectID;
            nameBasedID = new NameBasedID(dBObject, (AbstractDBObjectProvider)null);
            DBObject dBObject2 = dBObject.getParent();
            if (dBObject2 != null && (dBObjectID = dBObject2.getID()) instanceof TemporaryObjectID) {
                nameBasedID.setParent(((TemporaryObjectID)dBObjectID).getNameBasedID());
            }
        }
        return nameBasedID;
    }

    private boolean isObjectRemovedFromParent() {
        boolean bl = false;
        if (this.m_original != null && this.m_obj instanceof ChildDBObject && this.m_obj.getParent() == null && this.m_original.getParent() != null) {
            bl = true;
        }
        return bl;
    }

    private boolean isSameTypeAndName(DBObjectID dBObjectID) {
        NameBasedID nameBasedID;
        boolean bl = false;
        if (ModelUtil.areEqual((Object)this.getType(), (Object)dBObjectID.getType()) && (nameBasedID = this.getNameBasedID()) != null) {
            bl = this.isSameName(nameBasedID, dBObjectID);
        }
        return bl;
    }

    private boolean isSameName(NameBasedID nameBasedID, DBObjectID dBObjectID) {
        boolean bl = false;
        if (dBObjectID instanceof TemporaryObjectID) {
            NameBasedID nameBasedID2 = ((TemporaryObjectID)dBObjectID).getNameBasedID();
            bl = nameBasedID2 != null && nameBasedID.equals(nameBasedID2, false);
        } else if (dBObjectID instanceof BaseObjectID) {
            bl = dBObjectID.equals(nameBasedID, false);
        } else {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject != null) {
                    NameBasedID nameBasedID3 = new NameBasedID(dBObject, (AbstractDBObjectProvider)null);
                    bl = nameBasedID3.equals(nameBasedID, false);
                }
            }
            catch (DBException dBException) {
                DBLog.getLogger(this).warning("Could not resolve " + dBObjectID.toString() + " for comparison: " + dBException.getMessage());
            }
        }
        return bl;
    }

    private boolean isInOriginalHeirachy(DBObject dBObject) {
        if (dBObject != null) {
            DBObjectID dBObjectID;
            if (dBObject == this.m_original) {
                return true;
            }
            DBObjectID dBObjectID2 = dBObjectID = this.m_original == null ? null : this.m_original.getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                return ((TemporaryObjectID)dBObjectID).isInOriginalHeirachy(dBObject);
            }
        }
        return false;
    }

    @Override
    public String getType() {
        return this.m_obj.getType();
    }

    @Override
    public DBObjectID getParent() {
        return null;
    }

    @Override
    public DBObject resolveID() throws DBException {
        return this.m_obj;
    }

    public DBObject getOriginalObject() {
        return this.m_original;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    @Deprecated
    public DBObject resolveOriginalID() throws DBException {
        return this.m_original;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TempObjID:");
        stringBuilder.append(this.getType()).append(':');
        if (this.m_original != null) {
            if (this.m_original.getParent() == null && this.m_obj != null && this.m_obj.getParent() != null) {
                stringBuilder.append(DBUtil.getFullyQualifiedName(this.m_obj.getParent(), true)).append('.').append(this.m_original.getName());
            } else {
                stringBuilder.append(DBUtil.getFullyQualifiedName(this.m_original, true));
            }
            stringBuilder.append(" copy ");
        } else if (this.m_obj != null) {
            stringBuilder.append(DBUtil.getFullyQualifiedName(this.m_obj, true));
            stringBuilder.append(" new ");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static DBObjectID createID(DBObject dBObject) {
        assert (dBObject != null);
        return new TemporaryObjectID(dBObject);
    }

    public static void setID(DBObject dBObject, boolean bl) {
        if (dBObject != null) {
            if (dBObject.getID() == null) {
                dBObject.setID(TemporaryObjectID.createID(dBObject));
            }
            if (bl && dBObject instanceof AbstractDBObject) {
                for (DBObject dBObject2 : ((AbstractDBObject)dBObject).getPropertySupport().getOwnedObjects(null)) {
                    TemporaryObjectID.setID(dBObject2, true);
                }
            }
        }
    }

    public static DBObjectID createID(DBObject dBObject, DBObject dBObject2) {
        assert (dBObject != null);
        TemporaryObjectID temporaryObjectID = new TemporaryObjectID(dBObject);
        temporaryObjectID.m_original = dBObject2;
        return temporaryObjectID;
    }

    public static DBObjectID findOriginalID(TemporaryObjectID temporaryObjectID) {
        if (temporaryObjectID.m_original != null) {
            DBObjectID dBObjectID = temporaryObjectID.m_original.getID();
            if (dBObjectID == temporaryObjectID) {
                throw new IllegalStateException("Infinite TemporaryObjectID loop.");
            }
            if (dBObjectID instanceof TemporaryObjectID) {
                return TemporaryObjectID.findOriginalID((TemporaryObjectID)dBObjectID);
            }
            return dBObjectID;
        }
        return null;
    }

    public static DBObject findOriginalObject(TemporaryObjectID temporaryObjectID) {
        DBObjectID dBObjectID;
        DBObject dBObject = temporaryObjectID.m_original;
        if (dBObject != null && (dBObjectID = dBObject.getID()) instanceof TemporaryObjectID) {
            dBObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID);
        }
        return dBObject;
    }

    public static <T extends DBObject> T findOriginalObject(T t) {
        DBObjectID dBObjectID;
        DBObject dBObject = null;
        if (t != null && (dBObjectID = t.getID()) instanceof TemporaryObjectID) {
            dBObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID);
        }
        return (T)dBObject;
    }

    public static <T extends DBObject> T getOriginalObject(T t) {
        DBObjectID dBObjectID;
        DBObject dBObject = null;
        if (t != null && (dBObjectID = t.getID()) instanceof TemporaryObjectID) {
            dBObject = ((TemporaryObjectID)dBObjectID).m_original;
        }
        return (T)dBObject;
    }

    public static class CopyBackPolicy
    extends IDPolicy.DefaultIDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject dBObject, DBObject dBObject2) {
            DBObjectID dBObjectID;
            DBObjectID dBObjectID2 = super.getNewID(dBObject, dBObject2);
            if (dBObjectID2 != null && (dBObjectID = dBObject.getID()) instanceof TemporaryObjectID && (((TemporaryObjectID)dBObjectID).m_original == null || ((TemporaryObjectID)dBObjectID).m_original.getID() instanceof TemporaryObjectID)) {
                ((TemporaryObjectID)dBObjectID).m_original = dBObject2;
            }
            return dBObjectID2;
        }
    }

    public static class TemporaryIDPolicy
    extends IDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject dBObject, DBObject dBObject2) {
            return TemporaryObjectID.createID(dBObject2, dBObject);
        }
    }
}

