/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.ColumnConstraintReferenceID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.Procedure;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.ModelUtil;

public class ReferenceID
extends BaseObjectID
implements ColumnConstraintReferenceID {
    private String m_subtype;
    private Object m_identifier;
    private List<String> m_childObjectNames = new ArrayList<String>();

    public ReferenceID() {
        this.setType("UNSPECIFIED_TYPE");
    }

    public ReferenceID(DBObjectID dBObjectID) throws DBException {
        this(dBObjectID, null);
    }

    public ReferenceID(DBObjectID dBObjectID, DBObjectProvider dBObjectProvider) throws DBException {
        DBObject dBObject = null;
        dBObject = dBObjectID.resolveID();
        this.initialise(dBObject, dBObjectID, dBObjectProvider);
    }

    public ReferenceID(DBObject dBObject) {
        this(dBObject, (DBObjectProvider)null);
    }

    public ReferenceID(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        try {
            this.initialise(dBObject, dBObject.getID(), dBObjectProvider);
        }
        catch (DBException dBException) {
            this.getLogger().warning("Error initialising reference: " + dBException.getMessage());
        }
    }

    public ReferenceID(String string, String string2, String string3) {
        this(string, string2, null, string3, null, null, null);
    }

    public ReferenceID(String string, Schema schema, String string2) {
        this(string, schema, string2, null);
    }

    public ReferenceID(String string, Schema schema, String string2, String string3) {
        this(string, null, null, string2, null, string3, null);
        this.setSchema(schema);
    }

    public ReferenceID(String string, DBObjectID dBObjectID, String string2, String string3, String[] stringArray) {
        this(string, null, dBObjectID, string2, string3, null, stringArray);
    }

    private ReferenceID(String string, String string2, DBObjectID dBObjectID, String string3, String string4, String string5, String[] stringArray) {
        this.setType(string);
        this.setName(string3);
        this.setSchemaName(string2);
        this.setParent(dBObjectID);
        this.setDatabaseName(string5);
        this.setChildObjectNames(stringArray);
        this.m_subtype = string4;
    }

    @Override
    public void construct(String string) {
        Object object;
        String[] stringArray = string.split(":");
        int n = 3;
        if (stringArray.length > 2) {
            this.setType(" ".equals(stringArray[0]) ? null : stringArray[0]);
            this.setSchemaName(" ".equals(stringArray[1]) ? null : stringArray[1]);
            this.setName(" ".equals(stringArray[2]) ? null : stringArray[2]);
        }
        if (stringArray.length > 3 && !ReferenceID.isRecognizedType((String)(object = stringArray[3] + ":"))) {
            this.setDatabaseName(" ".equals(stringArray[3]) ? null : stringArray[3]);
            n = 4;
        }
        object = new StringBuilder();
        for (int i = n; i < stringArray.length; ++i) {
            ((StringBuilder)object).append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            ((StringBuilder)object).append(":");
        }
        if (((StringBuilder)object).length() > 0) {
            this.setParent(BaseObjectID.createFromString(((StringBuilder)object).toString()));
        }
    }

    private void initialise(DBObject dBObject, DBObjectID dBObjectID, DBObjectProvider dBObjectProvider) throws DBException {
        DBObjectID dBObjectID2;
        if (dBObject != null) {
            this.initialise(dBObject);
        } else if (dBObjectID instanceof BaseObjectID) {
            dBObjectID.copyTo(this);
        }
        if (dBObjectProvider instanceof AbstractDBObjectProvider) {
            this.setProviderImpl((AbstractDBObjectProvider)dBObjectProvider);
        }
        if ((dBObjectID2 = this.getParent()) != null && !(dBObjectID2 instanceof ReferenceID)) {
            dBObjectID2 = new ReferenceID(dBObjectID2, this.getProvider());
            this.setParent(dBObjectID2);
        }
        if (dBObjectID instanceof IdentifierBasedID) {
            this.m_identifier = ((IdentifierBasedID)dBObjectID).getIdentifier();
        }
    }

    private void initialise(DBObject dBObject) {
        DBObject dBObject2 = dBObject.getParent();
        if (dBObject2 != null) {
            this.setParent(new ReferenceID(dBObject2));
        }
        this.setType(dBObject.getType());
        this.setName(dBObject.getName());
        if (dBObject instanceof SchemaObject) {
            this.setSchema(((SchemaObject)dBObject).getSchema());
        }
        if (dBObject instanceof Constraint) {
            this.setSubType(((Constraint)dBObject).getConstraintType());
        } else if (dBObject instanceof Type) {
            this.setSubType(((Type)dBObject).getCollectionType());
        }
        if (dBObject instanceof ColumnConstraint) {
            for (DBObjectID dBObjectID : ((ColumnConstraint)dBObject).getColumnIDs()) {
                this.addChildObjectName(dBObjectID);
            }
        }
    }

    public final String[] getChildObjectNames() {
        return this.m_childObjectNames.toArray(new String[this.m_childObjectNames.size()]);
    }

    public final void setChildObjectNames(String[] stringArray) {
        this.m_childObjectNames.clear();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.m_childObjectNames.add(string);
            }
        }
    }

    @Override
    public final String getSubType() {
        return this.m_subtype;
    }

    public final void setSubType(String string) {
        this.m_subtype = string;
    }

    public final Object getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(Object object) {
        this.m_identifier = object;
    }

    @Override
    @Deprecated
    public final DBObject resolveReference(Database database) {
        try {
            return DBUtil.resolveInOtherProvider(this, database);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    @Override
    @Deprecated
    public final DBObjectID getNewID() {
        return null;
    }

    @Override
    @Deprecated
    public final String[] getColumnNames() {
        return this.getChildObjectNames();
    }

    @Override
    protected boolean equalsImpl(DBObjectID dBObjectID, boolean bl) {
        boolean bl2 = dBObjectID instanceof ReferenceID && this.equalsImpl((ReferenceID)dBObjectID);
        String string = this.getName();
        if (!bl2 && "DATATYPE".equals(this.getType())) {
            String string2;
            if (dBObjectID instanceof BaseObjectID && ("TYPE".equals(string2 = dBObjectID.getType()) || "SYNONYM".equals(string2))) {
                bl2 = ModelUtil.areEqual((Object)string, (Object)((BaseObjectID)dBObjectID).getName()) && ModelUtil.areEqual((Object)this.getSchemaName(), (Object)((BaseObjectID)dBObjectID).getSchemaName());
            }
        } else if (!bl2 && !bl) {
            Object object;
            if (dBObjectID instanceof IdentifierBasedID && this.m_identifier != null && (object = ((IdentifierBasedID)dBObjectID).getIdentifier()) != null && this.m_identifier != null && object.getClass() == this.m_identifier.getClass() && ModelUtil.areEqual((Object)this.getType(), (Object)dBObjectID.getType()) && object.equals(this.m_identifier)) {
                bl2 = true;
            }
            if (!bl2 && dBObjectID instanceof BaseObjectID && this.hasSameObjectName((BaseObjectID)dBObjectID)) {
                bl2 = true;
            }
            if (!bl2 && !(dBObjectID instanceof ReferenceID)) {
                try {
                    object = dBObjectID.resolveID();
                    bl2 = this.resolvesTo((DBObject)object);
                }
                catch (DBException dBException) {
                    this.getLogger().fine(dBException.getMessage());
                }
            }
        }
        return bl2;
    }

    protected boolean resolvesTo(DBObject dBObject) {
        boolean bl = false;
        if (dBObject != null) {
            int n;
            Schema schema;
            DBObjectID dBObjectID = this.getParent();
            String string = this.getType();
            if ("DATATYPE".equals(string)) {
                string = "TYPE";
            }
            String string2 = this.getName();
            boolean bl2 = dBObject instanceof SchemaObject ? (schema = ((SchemaObject)dBObject).getSchema()) != null && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getSchemaName()) : true;
            if (bl2 && ModelUtil.areEqual((Object)string2, (Object)dBObject.getName()) && (ModelUtil.areEqual((Object)string, (Object)dBObject.getType()) || "UNSPECIFIED_TYPE".equals(string))) {
                bl = true;
            } else if (string2 != null && dBObject instanceof PlSqlSubProgram && (n = string2.indexOf("(")) > 0) {
                String string3 = string2.substring(0, n);
                if (this.getParent() == null) {
                    if (dBObject instanceof Procedure && bl2 && ModelUtil.areEqual((Object)dBObject.getName(), (Object)string3)) {
                        bl = true;
                    }
                } else {
                    DBObjectID dBObjectID2;
                    DBObject dBObject2 = dBObject.getParent();
                    DBObjectID dBObjectID3 = dBObjectID2 = dBObject2 == null ? null : dBObject2.getID();
                    if (this.getParent().equals(dBObjectID2, false)) {
                        DBObject dBObject3 = dBObject.getParent().findOwnedObject(this);
                        bl = dBObject == dBObject3;
                    }
                }
            }
        }
        return bl;
    }

    protected boolean equalsImpl(ReferenceID referenceID) {
        return super.equalsImpl(referenceID) && ModelUtil.areEqual((Object)referenceID.m_subtype, (Object)this.m_subtype) && ModelUtil.areEqual(referenceID.m_childObjectNames, this.m_childObjectNames) && ModelUtil.areEqual((Object)referenceID.m_identifier, (Object)this.m_identifier);
    }

    public Object copyTo(Object object) {
        if (object instanceof BaseObjectID && !(object instanceof ReferenceID)) {
            this.copyToImpl((BaseObjectID)object);
            return object;
        }
        ReferenceID referenceID = object == null ? new ReferenceID() : (ReferenceID)object;
        this.copyToImpl(referenceID);
        return referenceID;
    }

    protected void copyToImpl(ReferenceID referenceID) {
        super.copyToImpl(referenceID);
        referenceID.m_identifier = this.m_identifier;
        referenceID.m_subtype = this.m_subtype;
        referenceID.setChildObjectNames(this.getChildObjectNames());
    }

    @Override
    protected String toStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getType();
        String string2 = this.getSchemaName();
        String string3 = this.getName();
        stringBuilder.append(string).append(":");
        stringBuilder.append(ModelUtil.hasLength((String)string2) ? string2 : " ").append(":");
        stringBuilder.append(ModelUtil.hasLength((String)string3) ? string3 : " ");
        if (this.getParent() instanceof BaseObjectID) {
            stringBuilder.append(":").append(this.getParent().toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public DBObject resolveID() throws DBException {
        DBObject dBObject;
        if ("DATATYPE".equals(this.getType())) {
            dBObject = DataTypeHelper.resolveDataTypeReferenceID(this);
        } else {
            try {
                dBObject = super.resolveID();
            }
            catch (MissingProviderException missingProviderException) {
                dBObject = null;
            }
        }
        return dBObject;
    }

    @Override
    public DBObject resolveInParentObject(DBObject dBObject) throws DBException {
        return this.resolveInParentObject(dBObject, null);
    }

    private DBObject resolveInParentObject(DBObject dBObject, ReferenceInfo referenceInfo) throws DBException {
        Object object;
        if (dBObject instanceof Synonym) {
            object = DBUtil.getSynonymReferenceChain((Synonym)dBObject);
            int n = object.size();
            if (referenceInfo != null) {
                for (int i = 1; i < n; ++i) {
                    referenceInfo.add((DBObject)object.get(i));
                }
            }
            dBObject = (DBObject)object.get(n - 1);
        }
        if ((object = super.resolveInParentObject(dBObject)) == null) {
            object = dBObject.findOwnedObject(this.getType(), this.getName());
        }
        return object;
    }

    public void addChildObjectName(DBObjectID dBObjectID) {
        Object object;
        if (dBObjectID instanceof BaseObjectID && ModelUtil.hasLength((String)(object = ((BaseObjectID)dBObjectID).getName()))) {
            this.addChildObjectName((String)object);
            return;
        }
        try {
            object = dBObjectID.resolveID();
            if (object != null) {
                this.addChildObjectName((DBObject)object);
                return;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public void addChildObjectName(DBObject dBObject) {
        if (dBObject != null) {
            this.addChildObjectName(dBObject.getName());
        }
    }

    public void addChildObjectName(String string) {
        this.m_childObjectNames.add(string);
    }

    public ReferenceInfo getReferenceInfo() throws DBException {
        DBObject dBObject;
        ReferenceInfo referenceInfo = new ReferenceInfo();
        DBObjectID dBObjectID = this.getParent();
        if (dBObjectID != null) {
            DBObject dBObject2;
            if (dBObjectID instanceof ReferenceID) {
                ReferenceInfo referenceInfo2 = ((ReferenceID)dBObjectID).getReferenceInfo();
                referenceInfo.addAll(referenceInfo2);
                dBObject2 = referenceInfo2.getResult();
            } else {
                dBObject2 = dBObjectID.resolveID();
            }
            dBObject = dBObject2 == null ? null : this.resolveInParentObject(dBObject2, referenceInfo);
        } else {
            dBObject = this.resolveID();
        }
        referenceInfo.add(dBObject);
        return referenceInfo;
    }

    public class ReferenceInfo {
        private final List<DBObject> m_objs = new ArrayList<DBObject>();

        private ReferenceInfo() {
        }

        public DBObject getResult() {
            if (this.m_objs.isEmpty()) {
                return null;
            }
            return this.m_objs.get(this.m_objs.size() - 1);
        }

        public List<SystemObject> getSystemObjects() {
            DBObject dBObject;
            ArrayList<SystemObject> arrayList = new ArrayList<SystemObject>();
            int n = this.m_objs.size();
            for (int i = 0; i < n && (dBObject = this.m_objs.get(i)) instanceof SystemObject; ++i) {
                arrayList.add((SystemObject)dBObject);
            }
            return arrayList;
        }

        private void add(DBObject dBObject) {
            this.m_objs.add(dBObject);
        }

        private void addAll(ReferenceInfo referenceInfo) {
            this.m_objs.addAll(referenceInfo.getSystemObjects());
        }
    }
}

