/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.ModelUtil;

final class ObjectCache {
    private Map<String, ObjectTypeEntry> m_typeMap = new TreeMap<String, ObjectTypeEntry>();
    private boolean m_weak;
    private AbstractDBObjectProvider m_pro;
    private String[] m_objTypes;

    ObjectCache(AbstractDBObjectProvider abstractDBObjectProvider, boolean bl) {
        this.m_pro = abstractDBObjectProvider;
        this.m_weak = bl;
    }

    public void registerBuilder(String string, DBObjectBuilder dBObjectBuilder) {
        this.registerType(string, dBObjectBuilder, null);
    }

    public synchronized DBObjectBuilder getBuilderForType(String string) {
        ObjectTypeEntry objectTypeEntry = this.m_typeMap.get(string);
        return objectTypeEntry != null ? objectTypeEntry.getBuilder() : null;
    }

    public void registerValidator(String string, DBObjectValidator dBObjectValidator) {
        this.registerType(string, null, dBObjectValidator);
    }

    protected final DBObjectValidator getValidatorForType(String string) {
        ObjectTypeEntry objectTypeEntry = this.m_typeMap.get(string);
        return objectTypeEntry != null ? objectTypeEntry.getValidator() : null;
    }

    public synchronized void registerType(String string, DBObjectBuilder dBObjectBuilder, DBObjectValidator dBObjectValidator) {
        ObjectTypeEntry objectTypeEntry = this.m_typeMap.get(string);
        if (objectTypeEntry == null) {
            objectTypeEntry = new ObjectTypeEntry();
            this.m_typeMap.put(string, objectTypeEntry);
            this.m_objTypes = null;
        }
        if (dBObjectBuilder != null) {
            objectTypeEntry.setBuilder(dBObjectBuilder);
        }
        if (dBObjectValidator != null) {
            objectTypeEntry.setValidator(dBObjectValidator);
        }
    }

    public synchronized boolean hasTypeEntry(String string) {
        return string != null && this.m_typeMap.containsKey(string);
    }

    public synchronized String[] listObjectTypes() {
        if (this.m_objTypes == null) {
            Set<Map.Entry<String, ObjectTypeEntry>> set = this.m_typeMap.entrySet();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, ObjectTypeEntry> entry : set) {
                ObjectTypeEntry objectTypeEntry = entry.getValue();
                if (objectTypeEntry == null || objectTypeEntry.getBuilder() == null) continue;
                arrayList.add(entry.getKey());
            }
            this.m_objTypes = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort(this.m_objTypes);
        }
        return Arrays.copyOf(this.m_objTypes, this.m_objTypes.length);
    }

    public synchronized void destroyCache() {
        this.m_typeMap.clear();
    }

    public synchronized void clearAllCaches() {
        for (ObjectTypeEntry objectTypeEntry : this.m_typeMap.values()) {
            objectTypeEntry.clearCache();
        }
    }

    public synchronized void cacheObject(SystemObject systemObject) {
        ObjectTypeEntry objectTypeEntry;
        if (systemObject != null && (objectTypeEntry = this.m_typeMap.get(systemObject.getType())) != null) {
            objectTypeEntry.addObjectToCache(systemObject);
        }
    }

    public synchronized void uncacheObject(SystemObject systemObject) {
        ObjectTypeEntry objectTypeEntry;
        if (systemObject != null && (objectTypeEntry = this.m_typeMap.get(systemObject.getType())) != null) {
            objectTypeEntry.removeObjectFromCache(systemObject);
        }
    }

    public synchronized SystemObject findObject(String string, String string2, Schema schema, String string3) {
        SystemObject systemObject = null;
        ObjectTypeEntry objectTypeEntry = this.m_typeMap.get(string);
        if (objectTypeEntry != null) {
            systemObject = objectTypeEntry.findObject(string2, schema, string3);
        }
        return systemObject;
    }

    public synchronized SystemObject findObject(DBObjectID dBObjectID) {
        ObjectTypeEntry objectTypeEntry;
        SystemObject systemObject = null;
        if (dBObjectID instanceof BaseObjectID && (objectTypeEntry = this.m_typeMap.get(dBObjectID.getType())) != null) {
            systemObject = objectTypeEntry.findObject((BaseObjectID)dBObjectID);
        }
        return systemObject;
    }

    public synchronized <T extends SystemObject> Collection<T> listObjectsFromCache(DBObjectCriteria<T> dBObjectCriteria) {
        ArrayList<SystemObject> arrayList = new ArrayList<SystemObject>();
        for (String string : dBObjectCriteria.getTypes()) {
            ObjectTypeEntry objectTypeEntry = this.m_typeMap.get(string);
            if (objectTypeEntry == null) continue;
            for (ObjectValue objectValue : objectTypeEntry.m_objectMap.values()) {
                SystemObject systemObject = this.getListedObject(objectValue, dBObjectCriteria);
                if (systemObject == null) continue;
                arrayList.add(systemObject);
            }
        }
        return arrayList;
    }

    private SystemObject getListedObject(ObjectValue objectValue, DBObjectCriteria dBObjectCriteria) {
        String string = dBObjectCriteria.getSchemaName();
        String string2 = dBObjectCriteria.getNameLike();
        SystemObject systemObject = objectValue.getObject();
        if (systemObject != null && !dBObjectCriteria.accept(systemObject)) {
            systemObject = null;
        }
        return systemObject;
    }

    private static String getIDKeyString(BaseObjectID baseObjectID) {
        Object object;
        String string = null;
        if (baseObjectID instanceof IdentifierBasedID && (object = ((IdentifierBasedID)baseObjectID).getIdentifier()) != null) {
            string = ObjectCache.appendDatabaseName(String.valueOf(object), baseObjectID.getDatabaseName());
        }
        return string;
    }

    private static String appendDatabaseName(String string, String string2) {
        Object object = ModelUtil.hasLength((String)string2) ? string + "@" + string2 : string;
        return object;
    }

    private static String getKeyString(SystemObject systemObject) {
        String string = systemObject.getID() instanceof BaseObjectID ? ((BaseObjectID)systemObject.getID()).getDatabaseName() : null;
        Schema schema = null;
        if (systemObject instanceof SchemaObject) {
            schema = ((SchemaObject)systemObject).getSchema();
        }
        return ObjectCache.getKeyString(string, schema, systemObject.getName());
    }

    private static String getKeyString(String string, Schema schema, String string2) {
        return ObjectCache.getKeyString(string, schema == null ? null : schema.getName(), string2);
    }

    private static String getKeyString(String string, String string2, String string3) {
        return ObjectCache.appendDatabaseName((String)(string2 == null ? "" : string2 + ".") + string3, string);
    }

    private class ObjectTypeEntry {
        private final Map<String, ObjectValue> m_objectMap = new HashMap<String, ObjectValue>();
        private final Map<String, String> m_identifierMap = new HashMap<String, String>();
        private DBObjectBuilder m_builder;
        private DBObjectValidator m_validator;

        private ObjectTypeEntry() {
        }

        private DBObjectBuilder getBuilder() {
            return this.m_builder;
        }

        private void setBuilder(DBObjectBuilder dBObjectBuilder) {
            this.m_builder = dBObjectBuilder;
        }

        private DBObjectValidator getValidator() {
            return this.m_validator;
        }

        private void setValidator(DBObjectValidator dBObjectValidator) {
            this.m_validator = dBObjectValidator;
        }

        private SystemObject findObject(String string, Schema schema, String string2) {
            return this.get(ObjectCache.getKeyString(string, schema, string2));
        }

        private SystemObject findObject(SystemObject systemObject) {
            SystemObject systemObject2 = null;
            if (systemObject != null) {
                String string = systemObject.getID() instanceof BaseObjectID ? ((BaseObjectID)systemObject.getID()).getDatabaseName() : null;
                Schema schema = systemObject instanceof SchemaObject ? ((SchemaObject)systemObject).getSchema() : null;
                systemObject2 = this.findObject(string, schema, systemObject.getName());
            }
            return systemObject2;
        }

        private SystemObject findObject(BaseObjectID baseObjectID) {
            String string = ObjectCache.getIDKeyString(baseObjectID);
            String string2 = string == null ? ObjectCache.getKeyString(baseObjectID.getDatabaseName(), baseObjectID.getSchemaName(), baseObjectID.getName()) : this.m_identifierMap.get(string);
            return this.get(string2);
        }

        private SystemObject get(String string) {
            ObjectValue objectValue = string == null ? null : this.m_objectMap.get(string);
            SystemObject systemObject = null;
            if (objectValue != null && (systemObject = objectValue.getObject()) == null) {
                this.m_objectMap.remove(string);
            }
            return systemObject;
        }

        private void cacheObject(SystemObject systemObject) {
            SystemObject systemObject2;
            DBObjectID dBObjectID = systemObject.getID();
            if (!(dBObjectID instanceof BaseObjectID)) {
                throw new IllegalStateException("All objects must have a BaseObjectID");
            }
            String string = ObjectCache.getIDKeyString((BaseObjectID)dBObjectID);
            String string2 = ObjectCache.getKeyString(systemObject);
            ObjectValue objectValue = this.createValue(systemObject);
            ObjectValue objectValue2 = this.m_objectMap.put(string2, objectValue);
            if (objectValue2 != null && (systemObject2 = objectValue2.getObject()) != null && systemObject2 != systemObject) {
                DBLog.getLogger(this).log(Level.FINE, "Caching " + systemObject.getType() + " " + systemObject.getName() + " but we already have one!");
            }
            if (string != null) {
                this.m_identifierMap.put(string, string2);
            }
        }

        private void clearCache() {
            this.m_objectMap.clear();
            this.m_identifierMap.clear();
        }

        private void addObjectToCache(SystemObject systemObject) {
            SystemObject systemObject2 = this.findObject(systemObject);
            if (systemObject2 != systemObject) {
                if (systemObject2 != null) {
                    this.removeObjectFromCache(systemObject);
                }
                if (systemObject != null) {
                    this.cacheObject(systemObject);
                }
            }
        }

        private void removeObjectFromCache(SystemObject systemObject) {
            if (systemObject != null) {
                String string;
                DBObjectID dBObjectID = systemObject.getID();
                if (dBObjectID instanceof BaseObjectID && (string = ObjectCache.getIDKeyString((BaseObjectID)dBObjectID)) != null) {
                    this.m_identifierMap.remove(string);
                }
                this.m_objectMap.remove(ObjectCache.getKeyString(systemObject));
            }
        }

        private ObjectValue createValue(SystemObject systemObject) {
            return ObjectCache.this.m_weak ? new WeakObjectValue(systemObject) : new StrongObjectValue(systemObject);
        }
    }

    private abstract class ObjectValue {
        private ObjectValue() {
        }

        public abstract SystemObject getObject();
    }

    private class WeakObjectValue
    extends ObjectValue {
        private Reference<SystemObject> m_ref;

        public WeakObjectValue(SystemObject systemObject) {
            this.m_ref = new WeakReference<SystemObject>(systemObject);
        }

        @Override
        public SystemObject getObject() {
            return this.m_ref.get();
        }
    }

    private class StrongObjectValue
    extends ObjectValue {
        private SystemObject m_obj;

        public StrongObjectValue(SystemObject systemObject) {
            this.m_obj = systemObject;
        }

        @Override
        public SystemObject getObject() {
            return this.m_obj;
        }
    }
}

