/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Map;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.util.DBObjectIDMap;

public abstract class IDPolicy {
    private Map<DBObjectID, DBObjectID> m_idMap = new DBObjectIDMap<DBObjectID>(true);

    protected final void copyID(DBObject dBObject, DBObject dBObject2) {
        DBObjectID dBObjectID = this.getNewID(dBObject, dBObject2);
        if (dBObjectID != null) {
            dBObject2.setID(dBObjectID);
            DBObjectID dBObjectID2 = dBObject.getID();
            if (dBObjectID2 != null) {
                this.m_idMap.put(dBObjectID2, dBObjectID);
            }
        }
    }

    protected abstract DBObjectID getNewID(DBObject var1, DBObject var2);

    public final Map<DBObjectID, DBObjectID> getIDMap() {
        return this.m_idMap;
    }

    public final Map<DBObjectID, DBObjectID> getReverseIDMap() {
        DBObjectIDMap<DBObjectID> dBObjectIDMap = new DBObjectIDMap<DBObjectID>(true);
        for (Map.Entry<DBObjectID, DBObjectID> entry : this.m_idMap.entrySet()) {
            DBObjectID dBObjectID = entry.getValue();
            if (dBObjectID == null) continue;
            dBObjectIDMap.put(dBObjectID, entry.getKey());
        }
        return dBObjectIDMap;
    }

    public static class DBLinkIDPolicy
    extends IDPolicy {
        private final AbstractDBObjectProvider m_pro;
        private final String m_dbname;

        public DBLinkIDPolicy(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
            this.m_pro = abstractDBObjectProvider;
            this.m_dbname = string;
        }

        @Override
        protected DBObjectID getNewID(DBObject dBObject, DBObject dBObject2) {
            BaseObjectID baseObjectID = null;
            DBObjectID dBObjectID = dBObject.getID();
            if (dBObjectID instanceof BaseObjectID) {
                baseObjectID = BaseObjectID.copyWithNewProvider((BaseObjectID)dBObjectID, this.m_pro);
                baseObjectID.setDatabaseName(this.m_dbname);
            }
            return baseObjectID;
        }
    }

    public static class DefaultIDPolicy
    extends IDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject dBObject, DBObject dBObject2) {
            if (dBObject.getID() != null && dBObject2.getID() == null) {
                return TemporaryObjectID.createID(dBObject2);
            }
            return null;
        }
    }

    public static class SameIDPolicy
    extends IDPolicy {
        @Override
        protected DBObjectID getNewID(DBObject dBObject, DBObject dBObject2) {
            DBObjectID dBObjectID;
            DBObjectID dBObjectID2 = dBObjectID = dBObject.getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                DBObject dBObject3 = ((TemporaryObjectID)dBObjectID).getOriginalObject();
                if (dBObject3 == dBObject2) {
                    DBObjectID dBObjectID3 = dBObject2.getID();
                    if (dBObjectID3 != null) {
                        dBObjectID2 = dBObjectID3;
                    }
                } else {
                    dBObjectID2 = TemporaryObjectID.createID(dBObject2, dBObject3);
                }
            }
            return dBObjectID2;
        }
    }

    @Deprecated
    public static class TemporaryIDPolicy
    extends TemporaryObjectID.TemporaryIDPolicy {
    }
}

