/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.util.ModelUtil;

@Deprecated
public class Ddl {
    public static final String ACO = "ACO";
    public static final String CMT = "CMT";
    public static final String CMC = "CMC";
    public static final String CONUK = "CONUK";
    public static final String CONFK = "CONFK";
    public static final String CONCC = "CONCC";
    public static final String OET = "OET";
    public static final String IOT = "IOT";
    public static final String TP = "TP";
    public static final String LOBP = "LOBP";
    public static final String IND = "IND";
    public static final String MVW = "MVW";
    public static final String MVL = "MVL";
    public static final String SEQ = "SEQ";
    public static final String SYN = "SYN";
    public static final String TAB = "TAB";
    public static final String TRG = "TRG";
    public static final String TRG_DIS = "TRG_DIS";
    public static final String VW = "VW";
    public static final String DROP = "DROP";
    public static final String DROP_XMLSCHEMA = "DROP_XMLSCHEMA";
    public static final String DROPMVL = "DROPMVL";
    public static final String FLASHBACK = "FLASHBACK";
    public static final String DROPCON = "DROPCON";
    public static final String RENTAB = "RENTAB";
    public static final String INCOMPLETE_TYPE = "INCOMPLETE_TYPE";
    public static final String SPEC = "SPEC";
    public static final String EVOLVED_TYPE_ALTER = "EVOLVED_TYPE_ALTER";
    public static final String BODY = "BODY";
    public static final String SPOOLON = "SPOOLON";
    public static final String SPOOLOFF = "SPOOLOFF";
    public static final String SCHEMA = "SCHEMA";
    public static final String GRANT = "GRANT";
    public static final String DATABASELINK = "DATABASELINK";
    public static final String XMLSCHEMA = "XMLSCHEMA";
    public static final String[] s_ddlOrder = new String[]{"DROPCON", "DROPMVL", "DROP", "INCOMPLETE_TYPE", "DATABASELINK", "XMLSCHEMA", "TAB", "ACO", "LOBP", "CONUK", "CONFK", "CONCC", "OET", "IOT", "TP", "VW", "RENTAB", "MVW", "CMT", "CMC", "MVL", "IND", "SEQ", "SYN", "SPEC", "EVOLVED_TYPE_ALTER", "BODY", "TRG", "TRG_DIS", "SCHEMA", "GRANT"};
    public static final HashSet s_ddlTerminatorRequired = new HashSet<String>(Arrays.asList("DROPCON", "DROPMVL", "DROP", "DROP_XMLSCHEMA", "DATABASELINK", "XMLSCHEMA", "TAB", "VW", "MVW", "MVL", "ACO", "LOBP", "CONUK", "CONFK", "CONCC", "OET", "IOT", "TP", "CMT", "CMC", "RENTAB", "IND", "SEQ", "SYN", "TRG_DIS", "SCHEMA", "GRANT", "EVOLVED_TYPE_ALTER"));
    private static final String NEWLINE = "\n";
    private Map<String, Object> m_map = new HashMap<String, Object>();
    private String m_sqlTerminator = ";\n";

    @Deprecated
    public Ddl() {
    }

    public void setSqlTerminator(String string) {
        this.m_sqlTerminator = string;
    }

    public String getSqlTerminator() {
        return this.m_sqlTerminator;
    }

    public boolean isArray(String string) {
        boolean bl = false;
        Object object = this.m_map.get(string);
        if (null != object) {
            bl = this.m_map.get(string).getClass().isArray();
        }
        return bl;
    }

    public boolean containsKey(String string) {
        return this.m_map.containsKey(string);
    }

    public void put(String string, String string2) {
        this.m_map.put(string, string2);
    }

    public void putOne(String string, String string2) {
        if (!this.m_map.containsKey(string)) {
            this.m_map.put(string, string2);
        }
    }

    public void put(String string, String[] stringArray) {
        this.m_map.put(string, stringArray);
    }

    public void put(String string, Collection collection) {
        if (collection.size() > 0) {
            String[] stringArray = new String[]{};
            stringArray = collection.toArray(stringArray);
            this.put(string, stringArray);
        }
    }

    public String get(String string) {
        String string2 = null;
        Object object = this.m_map.get(string);
        if (this.isArray(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = (String[])object;
            boolean bl = false;
            for (String string3 : stringArray) {
                if (!ModelUtil.hasLength((String)string3)) continue;
                if (bl) {
                    if (s_ddlTerminatorRequired.contains(string) && stringBuffer.lastIndexOf(this.m_sqlTerminator) != stringBuffer.length() - this.m_sqlTerminator.length()) {
                        stringBuffer.append(this.m_sqlTerminator);
                    }
                    stringBuffer.append(NEWLINE);
                }
                stringBuffer.append(string3);
                bl = true;
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = (String)object;
        }
        return string2;
    }

    public String getOne(String string) {
        String string2 = null;
        if (this.isArray(string)) {
            String[] stringArray = (String[])this.m_map.get(string);
            string2 = stringArray[0];
        } else {
            string2 = (String)this.m_map.get(string);
        }
        return string2;
    }

    public String[] getArray(String string) {
        String[] stringArray = null;
        Object object = this.m_map.get(string);
        if (null != object) {
            if (this.isArray(string)) {
                stringArray = (String[])object;
            } else {
                String[] stringArray2 = new String[]{(String)object};
                stringArray = stringArray2;
            }
        }
        return stringArray;
    }

    public String[] getArrayTrimSlash(String string) {
        String[] stringArray = this.getArray(string);
        if (null != stringArray && (INCOMPLETE_TYPE.equals(string) || SPEC.equals(string) || BODY.equals(string) || TRG.equals(string))) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string2.trim().endsWith("/")) continue;
                stringArray[i] = string2.substring(0, string2.lastIndexOf(47));
            }
        }
        return stringArray;
    }

    public List getArrayList(String string) {
        String[] stringArray = this.getArray(string);
        return stringArray == null ? Collections.emptyList() : Arrays.asList(stringArray);
    }

    public String getCreateTable() {
        return this.get(TAB);
    }

    public String[] getAddConstraints() {
        ArrayList arrayList = new ArrayList();
        if (this.containsKey(CONUK)) {
            arrayList.addAll(this.getArrayList(CONUK));
        }
        if (this.containsKey(CONFK)) {
            arrayList.addAll(this.getArrayList(CONFK));
        }
        if (this.containsKey(CONCC)) {
            arrayList.addAll(this.getArrayList(CONCC));
        }
        return arrayList.toArray(new String[0]);
    }

    public Set keySet() {
        return this.m_map.keySet();
    }

    public String getDdl() {
        return this.getDdl(true);
    }

    public String getDdl(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_map.containsKey(SPOOLON)) {
            stringBuffer.append(this.getOne(SPOOLON));
            stringBuffer.append(NEWLINE);
            stringBuffer.append(NEWLINE);
        }
        for (int i = 0; i < s_ddlOrder.length; ++i) {
            String string;
            if (!this.m_map.containsKey(s_ddlOrder[i]) || !ModelUtil.hasLength((String)(string = this.get(s_ddlOrder[i])))) continue;
            stringBuffer.append(string);
            if (!bl) continue;
            if (s_ddlTerminatorRequired.contains(s_ddlOrder[i]) && stringBuffer.lastIndexOf(this.m_sqlTerminator) != stringBuffer.length() - this.m_sqlTerminator.length()) {
                stringBuffer.append(this.m_sqlTerminator);
            }
            stringBuffer.append(NEWLINE);
        }
        if (this.m_map.containsKey(SPOOLOFF)) {
            stringBuffer.append(this.getOne(SPOOLOFF));
            stringBuffer.append(NEWLINE);
        }
        return stringBuffer.toString();
    }

    public Ddl append(Ddl ddl) {
        for (String string : ddl.keySet()) {
            if (this.m_map.containsKey(string)) {
                String[] stringArray = new String[2];
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.getArray(string)));
                arrayList.addAll(Arrays.asList(ddl.getArray(string)));
                this.put(string, arrayList.toArray(stringArray));
                continue;
            }
            if (ddl.isArray(string)) {
                this.put(string, ddl.getArray(string));
                continue;
            }
            this.put(string, ddl.get(string));
        }
        return this;
    }

    public Ddl stripPrompts() {
        Ddl ddl = new Ddl();
        for (String string : this.m_map.keySet()) {
            String[] stringArray = this.getArray(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("PROMPT")) {
                    int n = stringArray[i].indexOf(NEWLINE);
                    String string2 = null;
                    if (n > 0) {
                        string2 = stringArray[i].substring(n + 1);
                    }
                    if (!ModelUtil.hasLength(string2)) continue;
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(stringArray[i]);
            }
            if (arrayList.size() <= 0) continue;
            ddl.put(string, arrayList.toArray(new String[0]));
        }
        return ddl;
    }

    public DDL<OracleDDLType> convertToNew(DBObject dBObject) {
        DDL<OracleDDLType> dDL = new DDL<OracleDDLType>(dBObject);
        for (String string : this.m_map.keySet()) {
            OracleDDLType oracleDDLType = OracleDDLType.getDDLType(string);
            Object object = this.m_map.get(string);
            if (object instanceof String) {
                dDL.append(oracleDDLType, (String)object);
                continue;
            }
            if (!(object instanceof String[])) continue;
            dDL.appendAll(oracleDDLType, Arrays.asList((String[])object));
        }
        return dDL;
    }
}

