/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.util.ModelUtil;

public abstract class CascadeManager {
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator(CascadeManager.class.getName());
    private DBObjectProvider m_pro;

    protected CascadeManager(DBObjectProvider dBObjectProvider) {
        if (dBObjectProvider == null) {
            throw new NullPointerException("DBObjectProvider cannot be null");
        }
        this.m_pro = dBObjectProvider;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public abstract Collection<DBObjectID> listReferers(DBObject var1) throws CancelledException;

    public final Collection<DBObjectID> listTopLevelReferers(SystemObject systemObject, boolean bl) throws CancelledException {
        LookupCriteria lookupCriteria = new LookupCriteria();
        lookupCriteria.setRecurse(bl);
        return this.listTopLevelReferers(systemObject, lookupCriteria);
    }

    public abstract Collection<DBObjectID> listTopLevelReferers(SystemObject var1, LookupCriteria var2) throws CancelledException;

    @Deprecated
    public SystemObject cascadeDelete(DBObject dBObject, SystemObject systemObject) throws NoCascadeRequiredException {
        throw new NoCascadeRequiredException(dBObject);
    }

    @Deprecated
    public SystemObject cascadeDelete(DBObject dBObject, SystemObject systemObject, boolean bl) throws NoCascadeRequiredException {
        throw new NoCascadeRequiredException(dBObject);
    }

    @Deprecated
    public void doCascadeDelete(SystemObject systemObject, SystemObject systemObject2) throws DBException {
        throw new NoCascadeRequiredException(systemObject);
    }

    public Collection<SystemObject> listReferencedObjects(SystemObject systemObject, boolean bl) throws CancelledException {
        LookupCriteria lookupCriteria = new LookupCriteria();
        lookupCriteria.setRecurse(bl);
        return this.listReferencedObjects(systemObject, lookupCriteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SystemObject> listReferencedObjects(SystemObject systemObject, LookupCriteria lookupCriteria) throws CancelledException {
        String string = s_tsKeyGen.next();
        DBUtil.suspendTimestampChecking(this.m_pro, string);
        try {
            if (lookupCriteria == null) {
                lookupCriteria = new LookupCriteria();
            }
            DBObjectSet<SystemObject> dBObjectSet = new DBObjectSet<SystemObject>();
            dBObjectSet.add(systemObject);
            this.addDependencies(dBObjectSet, systemObject, lookupCriteria);
            dBObjectSet.remove(systemObject);
            DBObjectSet<SystemObject> dBObjectSet2 = dBObjectSet;
            return dBObjectSet2;
        }
        finally {
            DBUtil.resumeTimestampChecking(this.m_pro, string);
        }
    }

    private void ensureDerivedPropertiesBuilt(DBObject dBObject) throws CancelledException {
        CancelledException.checkInterrupt();
        DBObjectID dBObjectID = dBObject.getID();
        DBObjectProvider dBObjectProvider = null;
        if (dBObjectID instanceof BaseObjectID) {
            dBObjectProvider = ((BaseObjectID)dBObjectID).getProvider();
        }
        if (dBObjectProvider == null) {
            dBObjectProvider = this.getProvider();
        }
        try {
            DBUtil.ensureDerivedPropertiesBuilt(dBObject, dBObjectProvider);
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.INFO, "Could not build derived properties of {0} : {1}", new Object[]{DBUtil.getFullyQualifiedName(dBObject), dBException.getMessage()});
        }
    }

    private final void addDependencies(Set<SystemObject> set, DBObject dBObject, LookupCriteria lookupCriteria) throws CancelledException {
        this.ensureDerivedPropertiesBuilt(dBObject);
        for (Map.Entry<String, Object> entry : dBObject.getProperties().entrySet()) {
            CancelledException.checkInterrupt();
            String string = entry.getKey();
            if (lookupCriteria.isIgnoredProperty(string)) continue;
            Object object = entry.getValue();
            if (object instanceof DBObjectID) {
                this.addDependency(dBObject, (DBObjectID)object, lookupCriteria, set);
                continue;
            }
            if (object instanceof DBObject) {
                this.addDependencies(set, (DBObject)object, lookupCriteria);
                continue;
            }
            if (!(object instanceof Object[])) continue;
            for (Object object2 : (Object[])object) {
                if (object2 instanceof DBObjectID) {
                    this.addDependency(dBObject, (DBObjectID)object2, lookupCriteria, set);
                    continue;
                }
                if (!(object2 instanceof DBObject)) continue;
                this.addDependencies(set, (DBObject)object2, lookupCriteria);
            }
        }
    }

    private void addDependency(DBObject dBObject, DBObjectID dBObjectID, LookupCriteria lookupCriteria, Set<SystemObject> set) throws CancelledException {
        try {
            SystemObject systemObject;
            Object object;
            Object object2;
            if (dBObjectID instanceof BaseObjectID && ModelUtil.hasLength((String)(object2 = ((BaseObjectID)dBObjectID).getDatabaseName()))) {
                object = DBUtil.getSchema(dBObject);
                systemObject = this.getProvider().getObject(DBObjectCriteria.createSingleObjectCriteria("DATABASE LINK", (Schema)object, (String)object2));
                if (systemObject == null) {
                    CancelledException.checkInterrupt();
                    String string = this.getProvider().getDescriptor().getPublicSchemaName();
                    if (string != null) {
                        systemObject = this.getProvider().getObject(DBObjectCriteria.createSingleObjectCriteria("DATABASE LINK", string, (String)object2));
                    }
                }
                if (systemObject != null && !set.contains(systemObject)) {
                    lookupCriteria.addIfRequired(systemObject, set);
                }
            }
            if (!(dBObject instanceof PlSqlReference) || dBObjectID instanceof ReferenceID) {
                object2 = new ArrayList();
                if (dBObjectID instanceof ReferenceID) {
                    object = ((ReferenceID)dBObjectID).getReferenceInfo();
                    object2.addAll(((ReferenceID.ReferenceInfo)object).getSystemObjects());
                } else {
                    object = dBObjectID.resolveID();
                    if (object != null) {
                        systemObject = DBUtil.getSystemObject((DBObject)object);
                        if (systemObject != null) {
                            object2.add(systemObject);
                        }
                    } else {
                        this.getLogger().log(Level.FINEST, "Reference type {0} resolved to null on {1}", new Object[]{dBObjectID.getClass().getSimpleName(), DBUtil.getFullyQualifiedName(dBObject)});
                    }
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    systemObject = (SystemObject)object.next();
                    if (set.contains(systemObject)) continue;
                    lookupCriteria.addIfRequired(systemObject, set);
                    if (!lookupCriteria.isRecurse()) continue;
                    this.addDependencies(set, systemObject, lookupCriteria);
                }
            }
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Failed to resolve reference on {0}: {1}", new Object[]{DBUtil.getFullyQualifiedName(dBObject), dBException.getMessage()});
        }
    }

    private boolean ignoreForUnresolvedReferences(PropertyInfo propertyInfo) {
        return propertyInfo.isDerived() || propertyInfo.isInternalReference() || propertyInfo.isStaticReference();
    }

    public boolean isUnresolvedReference(DBObjectID dBObjectID) {
        return dBObjectID instanceof ReferenceID && DBUtil.getUppermostParent(dBObjectID) instanceof ReferenceID;
    }

    @Deprecated
    public Collection<Difference> resolveUnresolvedReferences(SystemObject systemObject) throws CancelledException {
        return Collections.emptyList();
    }

    protected Collection<SystemObject> listUnresolvedReferers(SystemObject systemObject) throws CancelledException {
        return Collections.emptyList();
    }

    public void resolveUnresolvedReferences(SystemObject systemObject, DBObjectTransaction dBObjectTransaction) throws DBException {
        for (SystemObject systemObject2 : this.listUnresolvedReferers(systemObject)) {
            SystemObject systemObject3;
            if (dBObjectTransaction.findExistingUpdate(systemObject2) != null || !this.resolveUnresolvedReferences(systemObject, systemObject3 = dBObjectTransaction.getCopyForUpdate(systemObject2))) continue;
            dBObjectTransaction.includeUpdate(systemObject2, systemObject3);
        }
    }

    private boolean resolveUnresolvedReferences(SystemObject systemObject, DBObject dBObject) {
        boolean bl = false;
        for (Map.Entry<String, Object> entry : DBUtil.getFrozenProperties(dBObject).entrySet()) {
            String string = entry.getKey();
            PropertyInfo propertyInfo = this.getProvider().getPropertyManager().findPropertyInfo(dBObject.getClass(), string);
            if (this.ignoreForUnresolvedReferences(propertyInfo)) continue;
            Object object = entry.getValue();
            DBObjectID[] dBObjectIDArray = null;
            if (object instanceof DBObjectID) {
                if (this.isUnresolvedReference((DBObjectID)object)) {
                    dBObjectIDArray = this.resolveUnresolvedReference(systemObject, (DBObjectID)object);
                }
            } else if (object instanceof DBObjectID[]) {
                Object[] objectArray = (DBObjectID[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    DBObjectID dBObjectID;
                    if (!this.isUnresolvedReference((DBObjectID)objectArray[i]) || (dBObjectID = this.resolveUnresolvedReference(systemObject, (DBObjectID)objectArray[i])) == null) continue;
                    if (dBObjectIDArray == null) {
                        dBObjectIDArray = new DBObjectID[objectArray.length];
                        System.arraycopy(objectArray, 0, dBObjectIDArray, 0, objectArray.length);
                    }
                    ((DBObjectID[])dBObjectIDArray)[i] = dBObjectID;
                }
            } else if (object instanceof DBObject) {
                if (this.resolveUnresolvedReferences(systemObject, (DBObject)object)) {
                    bl = true;
                }
            } else if (object instanceof DBObject[]) {
                for (DBObject dBObject2 : (DBObject[])object) {
                    if (!this.resolveUnresolvedReferences(systemObject, dBObject2)) continue;
                    bl = true;
                }
            }
            if (dBObjectIDArray == null) continue;
            try {
                propertyInfo.setPropertyValue(dBObject, dBObjectIDArray);
                bl = true;
            }
            catch (Exception exception) {
                DBLog.logStackTrace(exception);
            }
        }
        return bl;
    }

    private DBObjectID resolveUnresolvedReference(DBObject dBObject, DBObjectID dBObjectID) {
        DBObjectID dBObjectID2;
        block3: {
            DBObject dBObject2;
            dBObjectID2 = null;
            DBObjectID dBObjectID3 = dBObject.getID();
            if (this.resolvesUnresolvedReference(dBObject, dBObjectID3, dBObjectID)) {
                if (dBObjectID3 == null) {
                    dBObjectID3 = TemporaryObjectID.createID(dBObject);
                    dBObject.setID(dBObjectID3);
                }
                dBObjectID2 = dBObjectID3;
            }
            if (dBObjectID2 != null) break block3;
            Iterator<DBObject> iterator = DBUtil.getExistingOwnedObjects(dBObject).iterator();
            while (iterator.hasNext() && (dBObjectID2 = this.resolveUnresolvedReference(dBObject2 = iterator.next(), dBObjectID)) == null) {
            }
        }
        return dBObjectID2;
    }

    private boolean resolvesUnresolvedReference(DBObject dBObject, DBObjectID dBObjectID, DBObjectID dBObjectID2) {
        boolean bl = dBObjectID2 instanceof ReferenceID ? ((ReferenceID)dBObjectID2).resolvesTo(dBObject) : dBObjectID2.equals(dBObjectID, false);
        return bl;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected Set<DBObjectID> createIDSet() {
        return new DBObjectIDSet(true);
    }

    protected <T> Map<DBObjectID, T> createIDMap() {
        return new DBObjectIDMap(true);
    }

    public final Map<PropertyInfo, Object> findPropertyReferences(DBObject dBObject, DBObjectID dBObjectID) {
        return this.findReferencesImpl(dBObject, dBObjectID, false);
    }

    private Map<PropertyInfo, Object> findReferencesImpl(DBObject dBObject, DBObjectID dBObjectID, boolean bl) {
        LinkedHashMap<PropertyInfo, Object> linkedHashMap = null;
        Map<String, Object> map = dBObject.getProperties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            boolean bl2 = false;
            if (object instanceof DBObjectID && this.matches((DBObjectID)object, dBObjectID)) {
                bl2 = true;
            } else if (object instanceof Object[]) {
                for (Object object2 : (Object[])object) {
                    if (!(object2 instanceof DBObjectID)) break;
                    if (!this.matches((DBObjectID)object2, dBObjectID)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) continue;
            String string = entry.getKey();
            PropertyInfo propertyInfo = this.getProvider().getPropertyManager().findPropertyInfo(dBObject.getClass(), string);
            if (propertyInfo == null) {
                this.getLogger().fine("Found id to cacade to but it has no PropertyInfo");
                propertyInfo = new PropertyDefinition(string, DBObjectID.class, null, new Class[0]);
            }
            if (propertyInfo.isStaticReference()) continue;
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<PropertyInfo, Object>();
            }
            linkedHashMap.put(propertyInfo, object);
            if (!bl) continue;
            break;
        }
        return linkedHashMap;
    }

    private boolean matches(DBObjectID dBObjectID, DBObjectID dBObjectID2) {
        boolean bl = DBUtil.isSameOrChildOf(dBObjectID, dBObjectID2, this.useStrictComparison(dBObjectID, dBObjectID2));
        if (!bl && dBObjectID instanceof BaseObjectID && dBObjectID2 instanceof BaseObjectID) {
            String string;
            if ("SCHEMA".equals(dBObjectID2.getType())) {
                String string2 = ((BaseObjectID)dBObjectID).getSchemaName();
                if (string2 != null) {
                    bl = string2.equals(((BaseObjectID)dBObjectID2).getName());
                }
            } else if ("DATABASE LINK".equals(dBObjectID2.getType()) && (string = ((BaseObjectID)dBObjectID).getDatabaseName()) != null) {
                bl = string.equals(((BaseObjectID)dBObjectID2).getName());
            }
        }
        return bl;
    }

    private boolean useStrictComparison(Object object, DBObjectID dBObjectID) {
        return !(object instanceof BaseObjectID);
    }

    public final Collection<DBObjectID> findReferers(DBObject dBObject, DBObjectID dBObjectID, Collection<DBObjectID> collection, boolean bl) throws CancelledException {
        DBObject[] dBObjectArray;
        boolean bl2 = false;
        this.ensureDerivedPropertiesBuilt(dBObject);
        CancelledException.checkInterrupt();
        Map<PropertyInfo, Object> map = this.findReferencesImpl(dBObject, dBObjectID, true);
        boolean bl3 = dBObject instanceof PlSqlSourceObject;
        if (!(!bl && bl3 || map == null || map.isEmpty())) {
            if (collection == null) {
                collection = this.createIDSet();
            }
            if ((dBObjectArray = dBObject.getID()) == null) {
                this.getLogger().log(Level.WARNING, "Dependent object has no ID set: " + DBUtil.getFullyQualifiedName(dBObject));
            } else if (bl) {
                collection.add(DBUtil.getUppermostParent((DBObjectID)dBObjectArray));
                bl2 = true;
            } else {
                collection.add((DBObjectID)dBObjectArray);
            }
        }
        if (!bl2) {
            if (bl3) {
                DBObject[] dBObjectArray2 = PlSqlUtilCore.getPlSqlFragmentReferers((PlSqlSourceObject)dBObject, dBObjectID, this.getProvider());
                dBObjectArray = dBObjectArray2.toArray(new DBObject[dBObjectArray2.size()]);
            } else {
                dBObjectArray = dBObject instanceof DBObjectPlSqlFragment && !(dBObject instanceof PlSqlReference) ? new DBObject[]{} : dBObject.getOwnedObjects();
            }
            for (DBObject dBObject2 : dBObjectArray) {
                collection = this.findReferers(dBObject2, dBObjectID, collection, bl);
            }
        }
        return collection;
    }

    protected final Collection<DBObjectID> includeSchemaObjects(Schema schema, Collection<DBObjectID> collection) throws CancelledException {
        try {
            DBObjectProvider dBObjectProvider = this.getProvider();
            DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createCriteria(DBUtil.filterSchemaObjectTypes(dBObjectProvider.listObjectTypes()), schema, null);
            dBObjectCriteria.setUserOnly(true);
            Collection<SystemObject> collection2 = dBObjectProvider.listObjects(dBObjectCriteria);
            for (SystemObject systemObject : collection2) {
                DBObjectID dBObjectID;
                if (collection == null) {
                    collection = this.createIDSet();
                }
                if ((dBObjectID = systemObject.getID()) == null) continue;
                collection.add(dBObjectID);
            }
        }
        catch (CancelledException cancelledException) {
            throw cancelledException;
        }
        catch (DBException dBException) {
            this.getLogger().warning(dBException.getMessage());
        }
        return collection;
    }

    public static class LookupCriteria {
        private boolean m_recurse;
        private String[] m_types;
        private String[] m_ignoredProps;

        public void setRecurse(boolean bl) {
            this.m_recurse = bl;
        }

        public boolean isRecurse() {
            return this.m_recurse;
        }

        public void setTypes(String ... stringArray) {
            this.m_types = this.convertAndSort(stringArray);
        }

        private String[] convertAndSort(String[] stringArray) {
            Object[] objectArray;
            if (stringArray == null || stringArray.length == 0) {
                objectArray = null;
            } else {
                objectArray = new String[stringArray.length];
                System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
                Arrays.sort(objectArray);
            }
            return objectArray;
        }

        public String[] getTypes() {
            return this.m_types;
        }

        public boolean isRequiredType(String string) {
            boolean bl = true;
            if (this.m_types != null) {
                bl = Arrays.binarySearch(this.m_types, string) >= 0;
            }
            return bl;
        }

        public <T extends DBObject> boolean addIfRequired(T t, Collection<? super T> collection) {
            boolean bl = false;
            if (this.isRequiredType(t.getType())) {
                bl = collection.add(t);
            }
            return bl;
        }

        public <T extends DBObjectID> boolean addIfRequired(T t, Collection<? super T> collection) {
            boolean bl = false;
            if (this.isRequiredType(t.getType())) {
                bl = collection.add(t);
            }
            return bl;
        }

        public void setIgnoredProperties(String ... stringArray) {
            this.m_ignoredProps = this.convertAndSort(stringArray);
        }

        public String[] getIgnoredProperties() {
            return this.m_ignoredProps;
        }

        public boolean isIgnoredProperty(String string) {
            boolean bl = false;
            if (this.m_ignoredProps != null) {
                bl = Arrays.binarySearch(this.m_ignoredProps, string) >= 0;
            }
            return bl;
        }
    }

    @Deprecated
    public static class NoCascadeRequiredException
    extends DBException {
        public NoCascadeRequiredException(DBObject dBObject) {
            super(dBObject, "No cascade required.");
        }
    }
}

