/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class BaseObjectID
extends AbstractDBObjectID {
    private String m_dbName;
    private String m_schemaName;
    private String m_name;
    private transient AbstractDBObjectProvider m_pro;
    private transient String m_toString;
    private static Map<String, Class> ID_TYPE_MAP = new HashMap<String, Class>();
    private static Map<String, Class> ID_LEGACY_TYPE_MAP;
    public static final String SEP = ":";
    private static final String AT = "@";

    protected BaseObjectID() {
    }

    protected BaseObjectID(String string, DBObjectID dBObjectID) {
        super(string, dBObjectID);
    }

    protected BaseObjectID(String string, AbstractDBObjectProvider abstractDBObjectProvider) {
        super(string);
        this.m_pro = abstractDBObjectProvider;
    }

    protected BaseObjectID(DBObject dBObject, DBObjectID dBObjectID) {
        this(dBObject, null, dBObjectID);
    }

    protected BaseObjectID(DBObject dBObject, AbstractDBObjectProvider abstractDBObjectProvider) {
        this(dBObject, abstractDBObjectProvider, null);
    }

    private BaseObjectID(DBObject dBObject, AbstractDBObjectProvider abstractDBObjectProvider, DBObjectID dBObjectID) {
        super(dBObject.getType());
        DBObject dBObject2;
        this.setName(dBObject.getName());
        this.setProviderImpl(abstractDBObjectProvider);
        Schema schema = DBUtil.getSchema(dBObject);
        this.setSchemaName(schema == null ? null : schema.getName());
        if (dBObjectID == null && (dBObject2 = dBObject.getParent()) != null) {
            dBObjectID = dBObject2.getID();
        }
        this.setParent(dBObjectID);
    }

    protected void copyToImpl(BaseObjectID baseObjectID) {
        super.copyToImpl(baseObjectID);
        baseObjectID.m_dbName = this.m_dbName;
        baseObjectID.m_schemaName = this.m_schemaName;
        baseObjectID.m_name = this.m_name;
        baseObjectID.m_pro = this.m_pro;
    }

    @Override
    public final synchronized String toString() {
        if (this.m_toString == null) {
            String string = BaseObjectID.getPrefix(this.getClass());
            StringBuilder stringBuilder = new StringBuilder();
            if (ModelUtil.hasLength((String)string)) {
                stringBuilder.append(string).append(SEP);
            }
            if (ModelUtil.hasLength((String)this.m_dbName)) {
                stringBuilder.append(this.m_dbName).append(AT);
            }
            stringBuilder.append(this.toStringImpl());
            this.m_toString = stringBuilder.toString();
        }
        return this.m_toString;
    }

    protected abstract String toStringImpl();

    public abstract void construct(String var1);

    protected synchronized void clearToString() {
        this.m_toString = null;
    }

    @Override
    public DBObject resolveID() throws DBException {
        DBObject dBObject = null;
        DBObjectID dBObjectID = this.getParent();
        dBObject = dBObjectID != null ? this.resolveFromParent() : this.resolveFromProvider();
        return dBObject;
    }

    @Override
    public DBObject resolveInParentObject(DBObject dBObject) throws DBException {
        DBObject dBObject2;
        if (dBObject instanceof Schema) {
            BaseObjectID baseObjectID = (BaseObjectID)this.copyTo(null);
            baseObjectID.setParent(null);
            baseObjectID.setSchemaName(dBObject.getName());
            dBObject2 = baseObjectID.resolveID();
        } else {
            dBObject2 = super.resolveInParentObject(dBObject);
        }
        return dBObject2;
    }

    protected final DBObject resolveFromProvider() throws DBException {
        if (this.m_pro == null) {
            throw new MissingProviderException();
        }
        return this.m_pro.resolveID(this);
    }

    @Internal
    public final DBObjectProvider getProvider() {
        DBObjectID dBObjectID;
        if (this.m_pro == null && (dBObjectID = this.getParent()) instanceof BaseObjectID) {
            return ((BaseObjectID)dBObjectID).m_pro;
        }
        return this.m_pro;
    }

    public final void setProvider(DBObjectProvider dBObjectProvider) {
        if (dBObjectProvider instanceof AbstractDBObjectProvider) {
            if (this.m_pro != null && this.m_pro != dBObjectProvider) {
                this.getLogger().log(Level.WARNING, "changing the provider of id {0} from {1} to {2}", new Object[]{this.toString(), this.m_pro.getName(), dBObjectProvider == null ? "null" : ((AbstractDBObjectProvider)dBObjectProvider).getName()});
            }
            this.setProviderImpl((AbstractDBObjectProvider)dBObjectProvider);
        }
    }

    protected void setProviderImpl(AbstractDBObjectProvider abstractDBObjectProvider) {
        this.m_pro = abstractDBObjectProvider;
        DBObjectID dBObjectID = this.getParent();
        if (dBObjectID instanceof BaseObjectID) {
            ((BaseObjectID)dBObjectID).setProviderImpl(abstractDBObjectProvider);
        }
    }

    protected boolean hasSameProvider(BaseObjectID baseObjectID) {
        return baseObjectID.getProvider() == this.getProvider();
    }

    @Override
    public final void setParent(DBObjectID dBObjectID) {
        AbstractDBObjectProvider abstractDBObjectProvider;
        super.setParent(dBObjectID);
        if (dBObjectID instanceof BaseObjectID && (abstractDBObjectProvider = ((BaseObjectID)dBObjectID).m_pro) != null) {
            if (this.m_pro != null && abstractDBObjectProvider != this.m_pro) {
                throw new IllegalStateException("Parent ID is from a different DBObjectProvider.");
            }
            this.m_pro = abstractDBObjectProvider;
        }
    }

    public final String getSchemaName() {
        return this.m_schemaName;
    }

    public final void setSchemaName(String string) {
        this.m_schemaName = string;
        this.clearToString();
    }

    public final void setSchema(Schema schema) {
        this.m_schemaName = schema == null ? null : schema.getName();
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String string) {
        this.m_name = ModelUtil.hasLength((String)string) ? string : null;
        this.clearToString();
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    public final void setDatabaseName(String string) {
        this.m_dbName = string;
        this.clearToString();
    }

    protected boolean equalsImpl(BaseObjectID baseObjectID) {
        boolean bl;
        boolean bl2 = bl = super.equalsImpl(baseObjectID) && ModelUtil.areEqual((Object)this.m_name, (Object)baseObjectID.m_name);
        if (bl && this.getParent() == null && baseObjectID.getParent() == null) {
            bl = ModelUtil.areEqual((Object)this.m_schemaName, (Object)baseObjectID.m_schemaName) && ModelUtil.areEqual((Object)this.m_dbName, (Object)baseObjectID.m_dbName);
        }
        return bl;
    }

    private DBObject resolveIDWithoutType(String string) throws DBException {
        SystemObject systemObject = null;
        String string2 = this.getName();
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string3 = this.getDatabaseName();
        if (dBObjectProvider != null && ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string2)) {
            String string4;
            DBObjectCriteria<SystemObject> dBObjectCriteria;
            String[] stringArray = dBObjectProvider.listObjectTypes();
            Arrays.sort(stringArray, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    String string3 = "1";
                    String string4 = "1";
                    if ("TABLE".equals(string)) {
                        string3 = "0";
                    } else if (!Metadata.getInstance().isSchemaObject(string)) {
                        string3 = "2";
                    }
                    if ("TABLE".equals(string2)) {
                        string4 = "0";
                    } else if (!Metadata.getInstance().isSchemaObject(string2)) {
                        string4 = "2";
                    }
                    return (string3 + string).compareTo(string4 + string2);
                }
            });
            Object object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n && (systemObject = dBObjectProvider.getObject(dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria(string4 = object[i], string3, string, string2))) == null; ++i) {
            }
            if (systemObject == null && string2.indexOf("(") > -1) {
                DBObjectCriteria<SystemObject> dBObjectCriteria2;
                object = string2.substring(0, string2.indexOf("("));
                for (n = 0; n < stringArray.length && systemObject == null && (!stringArray[n].equals("PROCEDURE") && !stringArray[n].equals("FUNCTION") || (systemObject = dBObjectProvider.getObject(dBObjectCriteria2 = DBObjectCriteria.createSingleObjectCriteria(stringArray[n], string3, string, (String)object))) == null); ++n) {
                }
            }
        }
        return systemObject;
    }

    protected boolean hasSameObjectName(BaseObjectID baseObjectID) {
        if (this.m_name == null || baseObjectID.m_name == null) {
            return false;
        }
        return this.equalsImpl(baseObjectID);
    }

    private static final String getPrefix(Class clazz) {
        String string = "";
        if (ID_TYPE_MAP.containsValue(clazz)) {
            for (String string2 : ID_TYPE_MAP.keySet()) {
                if (!ID_TYPE_MAP.get(string2).equals(clazz)) continue;
                string = string2;
                break;
            }
        } else if (clazz.getSuperclass() != null) {
            string = BaseObjectID.getPrefix(clazz.getSuperclass());
        }
        return string;
    }

    public static <T extends BaseObjectID> T copyWithNewProvider(T t, AbstractDBObjectProvider abstractDBObjectProvider) {
        BaseObjectID baseObjectID = (BaseObjectID)t.copyTo(null);
        baseObjectID.setProviderImpl(abstractDBObjectProvider);
        return (T)baseObjectID;
    }

    public static BaseObjectID createFromString(String string) {
        String string2;
        BaseObjectID baseObjectID = null;
        if (string == null || string.indexOf(SEP) == -1) {
            return null;
        }
        if (BaseObjectID.isRecognizedType(string)) {
            string2 = string.substring(0, string.indexOf(SEP));
            Class clazz = ID_TYPE_MAP.get(string2);
            if (clazz == null) {
                clazz = ID_LEGACY_TYPE_MAP.get(string2);
            }
            if (clazz != null) {
                try {
                    baseObjectID = (BaseObjectID)clazz.newInstance();
                }
                catch (Exception exception) {
                    DBLog.logStackTrace(exception);
                }
            } else {
                DBLog.getLogger(BaseObjectID.class).warning("Cannot instantiate ID");
            }
        }
        if (baseObjectID == null) {
            baseObjectID = new IdentifierBasedID();
        }
        if (BaseObjectID.isRecognizedType(string)) {
            int n = string.indexOf(SEP);
            int n2 = string.indexOf(SEP, n + SEP.length());
            int n3 = string.indexOf(AT);
            if (n > 0 && n3 > n && n2 > n3) {
                String string3 = string.substring(n + SEP.length(), n3 - 1);
                baseObjectID.setDatabaseName(string3);
                string2 = string.substring(n3 + AT.length());
            } else {
                string2 = string.substring(n + SEP.length());
            }
        } else {
            string2 = string;
        }
        baseObjectID.construct(string2);
        return baseObjectID;
    }

    public static final boolean isRecognizedType(String string) {
        return BaseObjectID.isInTypeMap(ID_TYPE_MAP, string) || BaseObjectID.isInTypeMap(ID_LEGACY_TYPE_MAP, string);
    }

    private static final boolean isInTypeMap(Map<String, Class> map, String string) {
        if (!ModelUtil.hasLength((String)string)) {
            return false;
        }
        int n = string.indexOf(SEP);
        if (n < 1) {
            return false;
        }
        String string2 = string.substring(0, n);
        return map.containsKey(string2);
    }

    static {
        ID_TYPE_MAP.put("N", NameBasedID.class);
        ID_TYPE_MAP.put("I", IdentifierBasedID.class);
        ID_TYPE_MAP.put("R", ReferenceID.class);
        ID_LEGACY_TYPE_MAP = new HashMap<String, Class>();
        ID_LEGACY_TYPE_MAP.put("S", IdentifierBasedID.class);
    }
}

