/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.ocidbmetrics;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONComposer;
import com.fasterxml.jackson.jr.ob.comp.ArrayComposer;
import com.fasterxml.jackson.jr.ob.comp.ObjectComposer;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TimeZone;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.ocidbmetrics.CDBMetrics;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParameterBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.util.OCIUtil;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class OCIMetricsCommand
extends CommandListener
implements IHelp {
    private final String cmdName = "OCIDBMetrics";
    private HashSet<String> slowfilenames = new HashSet();
    private int loopCount = 0;
    private int skipLoops = 20;
    private final double waitThreshold = 10.0;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block9: {
            String[] args = cmd.getSQLOrig().replace("\n", " ").split("\\s+");
            if (args[0].equalsIgnoreCase("OCIDBMetrics")) {
                if (args.length == 2 && args[1].equalsIgnoreCase("examples")) {
                    ctx.write(Messages.getString("OCIDBMETRICS_EXAMPLES"));
                    return true;
                }
                if (args.length > 1) {
                    if (ctx.getProperty("oci.profile.name") == null) {
                        ctx.write(Messages.getString("OCI_PROFILE_NOT_SET"));
                        return true;
                    }
                    OCIMetricsCommand ociMetrics = new OCIMetricsCommand();
                    Type type = ociMetrics.createType(ctx);
                    Parser parser = new Parser(type, ctx.getEnvironment());
                    Optional<ParsedCommand> parsedCommand = parser.parse(cmd.getSQLOrig(), error -> System.out.println((String)error));
                    try {
                        String subcmd = parsedCommand.get().getType().getName();
                        if (subcmd.equalsIgnoreCase("setup")) {
                            CDBMetrics cdbMetrics = new CDBMetrics();
                            ctx.write(MessageFormat.format(Messages.getString("OCIDBMETRICS_SETUP_HELP"), args[2]));
                            ctx.write(cdbMetrics.getSetupScript(args.length > 2 ? args[2] : "<username>") + "\n");
                            return true;
                        }
                        if (subcmd.equalsIgnoreCase("collect")) {
                            String compartmentOCID = (String)parsedCommand.get().getOptionValue(Symbol.COMPARTMENTID);
                            String region = (String)parsedCommand.get().getOptionValue(Symbol.REGION);
                            if (this.compartmentIdChecking(compartmentOCID, ctx).booleanValue() && this.regionChecking((String)ctx.getProperty("oci.profile.name"), region, ctx).booleanValue()) {
                                this.processCollection(conn, ctx, args);
                                return true;
                            }
                            return true;
                        }
                        break block9;
                    }
                    catch (NoSuchElementException e) {
                        ctx.write(Messages.getString("OCIMETRIC.HELP"));
                        return true;
                    }
                }
                ctx.write(Messages.getString("OCIMETRIC.HELP"));
                return true;
            }
        }
        return false;
    }

    public Type createType(ScriptRunnerContext ctx) {
        Type setupMetricsType = Factory.type(Symbol.SETUP).abbrevs("S").add(((ParameterBuilder)Factory.parameter(Symbol.USERNAME).required()).build()).build();
        Type collectType = Factory.type(Symbol.COLLECT).abbrevs("C").add(Factory.option(Symbol.NAMESPACE).build()).add(((OptionBuilder)Factory.option(Symbol.COMPARTMENTID).required()).build()).add(Factory.option(Symbol.RESOURCEGROUP).build()).add(Factory.option(Symbol.SQLDIR).build()).add(((OptionBuilder)Factory.option(Symbol.REGION).required()).build()).add(((OptionBuilder)Factory.option(Symbol.SLEEP).dataType(Integer.class)).build()).build();
        Type type = Factory.type(Symbol.OCIDBMETRICS).base().add(setupMetricsType).add(collectType).build();
        return type;
    }

    private Boolean compartmentIdChecking(String compartmentOCID, ScriptRunnerContext ctx) {
        if (new OCIUtil().checkOCID(compartmentOCID, ctx, "compartment", Messages.getString("INCORRECT_COMPARTMENTOCID"), Messages.getString("EXPECTED_COMPARTMENTOCID"))) {
            return true;
        }
        return false;
    }

    private Boolean regionChecking(String profile, String regionID, ScriptRunnerContext ctx) {
        if (new OCIUtil().isRegionMatch(profile, regionID, ctx).booleanValue()) {
            return true;
        }
        ctx.write(MessageFormat.format(Messages.getString("REGION_NOT_SUBSCRIBED"), regionID));
        return false;
    }

    private void processCollection(Connection conn, ScriptRunnerContext ctx, String[] args) {
        try {
            String namespace = "sqlcl_db_metrics";
            String compartmentId = null;
            String resourceGroup = null;
            String region = null;
            String sqldir = null;
            int sleep = 15;
            block24: for (int i = 1; i < args.length; ++i) {
                switch (args[i]) {
                    case "collect": {
                        continue block24;
                    }
                    case "-namespace": {
                        namespace = args[i + 1];
                        ++i;
                        continue block24;
                    }
                    case "-sleep": {
                        try {
                            sleep = Integer.parseInt(args[i + 1]);
                        }
                        catch (NumberFormatException e) {
                            ctx.write("Invalid number:" + args[i + 1] + "\n");
                        }
                        ++i;
                        continue block24;
                    }
                    case "-compartmentId": {
                        compartmentId = args[i + 1];
                        ++i;
                        continue block24;
                    }
                    case "-sqldir": {
                        sqldir = args[i + 1];
                        ++i;
                        continue block24;
                    }
                    case "-resourceGroup": {
                        resourceGroup = args[i + 1];
                        ++i;
                        continue block24;
                    }
                    case "-region": {
                        region = args[i + 1];
                        ++i;
                        continue block24;
                    }
                    default: {
                        ctx.write(Messages.getString("OCIMETRIC.HELP"));
                        ctx.write(MessageFormat.format(Messages.getString("OCI_FLAG"), args[i]));
                    }
                }
            }
            boolean run = true;
            if (ctx.getProperty("oci.profile.name") == null) {
                ctx.write(Messages.getString("OCI_PROFILE_NOT_SET"));
                run = false;
            }
            if (region == null) {
                OCIProfiles p = new OCIProfiles();
                String profileRegion = p.getProperties().getProperty(ctx.getProperty("oci.profile.name") + "/region");
                if (profileRegion != null) {
                    region = profileRegion;
                } else {
                    ctx.write(Messages.getString("OCI_REGION_NOT_SET"));
                    run = false;
                }
            }
            if (compartmentId == null) {
                ctx.write(Messages.getString("OCIDBMETRICS_COMPARTMENTID_REQUIRED"));
                run = false;
            }
            if (run) {
                while (run && !ctx.isInterrupted()) {
                    ++this.loopCount;
                    long startTime = System.nanoTime();
                    run = sqldir != null ? this.runCustomFolderMetrics(conn, ctx, namespace, compartmentId, resourceGroup, region, sqldir) : this.runCoreMetrics(conn, ctx, namespace, compartmentId, resourceGroup, region, run);
                    long execTime = System.nanoTime() - startTime;
                    try {
                        Thread.sleep(sleep * 1000);
                    }
                    catch (InterruptedException e) {
                        run = false;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            ctx.write(Messages.getString("OCIDBMETRICS_FAILED"));
        }
    }

    private boolean runCustomFolderMetrics(Connection conn, ScriptRunnerContext ctx, String namespace, String compartmentId, String resourceGroup, String region, String sqldir) {
        Path p = Paths.get(sqldir, new String[0]);
        if (p.toFile().exists() && p.toFile().isDirectory()) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(p);){
                for (Path child : children) {
                    if (this.loopCount % this.skipLoops != 0 && this.slowfilenames.contains(child.getFileName())) continue;
                    int sent = this.processSQLScript(conn, (String)ctx.getProperty("oci.profile.name"), region, child.toFile().getAbsolutePath(), namespace, compartmentId, resourceGroup, ctx);
                    System.out.printf("\r                                                                                                                  ", new Object[0]);
                    System.out.printf("\r%s - %d", child.getFileName(), sent);
                }
            }
            catch (IOException e) {
                ctx.write(Messages.getString("FILE_READ_FAILED"));
                return false;
            }
        }
        return true;
    }

    private boolean runCoreMetrics(Connection conn, ScriptRunnerContext ctx, String namespace, String compartmentId, String resourceGroup, String region, boolean run) throws IOException, SQLException {
        CDBMetrics cdbMetrics = new CDBMetrics();
        for (String name : cdbMetrics.getFiles()) {
            if (this.loopCount % this.skipLoops != 0 && this.slowfilenames.contains(name)) continue;
            long startTime = System.nanoTime();
            int sent = this.processSQL(conn, (String)ctx.getProperty("oci.profile.name"), region, cdbMetrics.getSQL(conn.getSchema(), name), namespace, compartmentId, resourceGroup, ctx);
            long execTime = System.nanoTime() - startTime;
            double seconds = execTime / 1000000000L;
            if (seconds > this.waitThreshold) {
                this.slowfilenames.add(name);
            }
            System.out.print("\r                                                                                                                  ");
            System.out.printf("\r%s - %d", name, sent);
        }
        return run;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "OCIDBMetrics".toUpperCase(Locale.ROOT);
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        HelpPages helpPages = new HelpPagesBuilder(ctx.getEnvironment()).addHelpContainerFor(this).addPages(new CommandPageAssemblers(this.createType(ctx), new Type[0])).build();
        return helpPages.get(pagePath);
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    public int processSQLScript(Connection conn, String profile, String region, String sqlName, String namespace, String compartmentId, String resourceGroup, ScriptRunnerContext ctx) throws IOException {
        Path f = Paths.get(sqlName, new String[0]);
        String sql = Files.readString(f);
        long startTime = System.nanoTime();
        int sent = this.processSQL(conn, profile, region, sql, namespace, compartmentId, resourceGroup, ctx);
        long execTime = System.nanoTime() - startTime;
        double seconds = execTime / 1000000000L;
        if (seconds > this.waitThreshold) {
            this.slowfilenames.add(sqlName);
        }
        System.out.printf("\r                                                                                                                  ", new Object[0]);
        System.out.printf("\r%s - %d", sqlName, sent);
        return sent;
    }

    public int processSQL(Connection conn, String profile, String region, String sql, String namespace, String compartmentId, String resourceGroup, ScriptRunnerContext ctx) throws IOException {
        List<Map<String, ?>> ret = DBUtil.getInstance(conn).executeReturnList(sql, null);
        Date dt = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String now = sdf.format(dt);
        ArrayList<String> metrics = new ArrayList<String>();
        int total = 0;
        for (int i = 0; i < ret.size(); ++i) {
            Iterator key2;
            if (i % 50 == 0 && i > 0) {
                this.sendBatch(profile, region, metrics, ctx);
                total += metrics.size();
                metrics.clear();
            }
            if (ret.get(i).get("METRIC_DIMENSIONS") != null && ret.get(i).get("METRIC_VALUE") != null) {
                BigDecimal v = (BigDecimal)ret.get(i).get("METRIC_VALUE");
                Map dims = JSON.std.mapFrom(ret.get(i).get("METRIC_DIMENSIONS"));
                dims.put("host", ret.get(i).get("HOST"));
                for (Iterator key2 : dims.keySet()) {
                    dims.put(key2, dims.get(key2).toString().substring(0, dims.get(key2).toString().length() > 100 ? 100 : dims.get(key2).toString().length()));
                }
                String metric = (String)((JSONComposer)((ObjectComposer)((ArrayComposer)JSON.std.with(new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT}).composeString().startObject().put("namespace", namespace == null ? (String)ret.get(i).get("PROJECT") : namespace).put("compartmentId", compartmentId).put("resourceGroup", resourceGroup == null ? (String)ret.get(i).get("FLEET") : namespace).put("name", (String)ret.get(i).get("METRIC_NAME")).putObject("dimensions", (Object)dims).startArrayField("datapoints").startObject().put("timestamp", now).put("value", (double)v.floatValue()).end()).end()).end()).finish();
                metrics.add(metric);
            }
            List<String> baseCols = Arrays.asList("NAMESPACE", "COMPARTMENT_ID", "RESOURCE_GROUP", "NAME", "DIMENSIONS", "VALUE");
            if (ret.get(i).get("DIMENSIONS") == null || ret.get(i).get("VALUE") == null) continue;
            BigDecimal v = (BigDecimal)ret.get(i).get("VALUE");
            Map dims = JSON.std.mapFrom(ret.get(i).get("DIMENSIONS") != null ? ret.get(i).get("DIMENSIONS") : "{}");
            for (String key3 : ret.get(i).keySet()) {
                if (baseCols.contains(key3)) continue;
                dims.put(key3, ret.get(i).get(key3));
            }
            key2 = dims.keySet().iterator();
            while (key2.hasNext()) {
                String key3;
                key3 = (String)key2.next();
                dims.put(key3, dims.get(key3).toString().substring(0, dims.get(key3).toString().length() > 100 ? 100 : dims.get(key3).toString().length()));
            }
            String metric = (String)((JSONComposer)((ObjectComposer)((ArrayComposer)JSON.std.with(new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT}).composeString().startObject().put("namespace", namespace == null ? (String)ret.get(i).get("NAMESPACE") : namespace).put("compartmentId", compartmentId).put("resourceGroup", resourceGroup).put("name", (String)ret.get(i).get("NAME")).putObject("dimensions", (Object)dims).startArrayField("datapoints").startObject().put("timestamp", now).put("value", (double)v.floatValue()).end()).end()).end()).finish();
            metrics.add(metric);
        }
        this.sendBatch(profile, region, metrics, ctx);
        return total + metrics.size();
    }

    public void sendBatch(String profile, String region, ArrayList<String> metrics, ScriptRunnerContext ctx) {
        if (metrics.size() == 0) {
            return;
        }
        OCIRESTClient client = null;
        try {
            int failedCount;
            StringBuilder metric = new StringBuilder("{  \"metricData\":[");
            for (int i = 0; i < metrics.size(); ++i) {
                metric.append(metrics.get(i));
                if (i == metrics.size() - 1) continue;
                metric.append(",");
            }
            metric.append("]}");
            client = new OCIProfiles().getOciClient(profile);
            OCIRequest req = new OCIRequest.Builder().body(metric.toString()).method("post").contentType("application/json").host("telemetry-ingestion." + region + ".oraclecloud.com").target("/20180401/metrics").build();
            CloseableHttpResponse response = client.getResponse(req);
            String ret = response != null && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
            Map map = JSON.std.mapFrom((Object)ret);
            if (response.getCode() != 200) {
                ctx.write((String)map.get("message") + "\n");
            }
            if ((failedCount = ((Integer)map.get("failedMetricsCount")).intValue()) > 0) {
                ctx.write(MessageFormat.format(Messages.getString("OCI_CONNECTION_ERROR"), response.getCode(), ret));
            } else {
                System.out.print(":" + metrics.size());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            ctx.write(Messages.getString("OCI_SENDBATCH_FAIL"));
        }
    }

    public static enum Symbol implements Id
    {
        OCIDBMETRICS,
        SETUP,
        USERNAME,
        COLLECT,
        NAMESPACE,
        COMPARTMENTID,
        RESOURCEGROUP,
        SQLDIR,
        REGION,
        SLEEP;

    }
}

