/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.handlers;

import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class SQLCliPromptedConnectFieldsProvider
implements IGetPromptedConnectFieldsProvider {
    boolean ctrld = false;

    @Override
    public ConnectionDetails get3Fields(ScriptRunnerContext scriptRunnerContext, ConnectionDetails inCd, boolean retry) {
        String promptDatabase;
        String namePlus;
        ConnectionDetails cd;
        ConnectionDetails retCd = null;
        String connectName = inCd.getConnectName();
        TextSecret connectPassword = inCd.getConnectPassword();
        String connectDB = inCd.getConnectDB();
        if (scriptRunnerContext.getProperty("script.runner.jline") == null) {
            return null;
        }
        this.ctrld = false;
        if (!retry && connectName != null && !connectName.equals("") && connectPassword != null && connectPassword.isPresent() && connectDB != null && !connectDB.equals("")) {
            return inCd;
        }
        Object retrying = "";
        if (retry) {
            retrying = ScriptRunnerDbArb.getString("CONNECT_RETRYING") + " ";
        }
        Object redacted = "";
        Object name = inCd.getConnectName();
        String password = connectPassword != null ? (String)connectPassword.map(String::new) : "";
        String db = inCd.getConnectDB();
        String role = inCd.getRole();
        if (name != null && !((String)name).equals("")) {
            if (((String)name).indexOf(" ") != -1 && !((String)name).startsWith("\"")) {
                name = "\"" + (String)name + "\"";
            }
            redacted = name;
        }
        if (password != null && !password.equals("")) {
            redacted = (String)redacted + "/*********";
        } else if (inCd.getSlash() != -1) {
            redacted = (String)redacted + "/";
        }
        if (db != null && !db.equals("")) {
            redacted = (String)redacted + "@" + db;
        }
        if (role != null && !role.equals("")) {
            redacted = (String)redacted + " " + role.trim();
        }
        if ((cd = ScriptUtils.getConnectionDetails("connect " + (namePlus = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_USERNAME") + " " + (String)retrying, inCd.getFullString(), (String)redacted, false, retry)))) != null && cd.getCallUsage()) {
            return cd;
        }
        if (!(namePlus == null || namePlus.equals("") || cd.getSlash() == -1 && cd.getAt() == -1)) {
            connectName = cd.getConnectName();
            if (cd.getSlash() != -1) {
                connectPassword = cd.getConnectPassword();
            } else {
                password = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_PASSWORD") + " " + (String)retrying, password, password, true, retry);
                connectPassword = Secrets.instance().of(password.toCharArray(), true);
            }
            connectDB = cd.getConnectDB();
            cd.setConnectPassword(connectPassword);
            retCd = cd;
        } else {
            password = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_PASSWORD") + " " + (String)retrying, password, password, true, retry);
            cd.setConnectPassword(Secrets.instance().of(password.toCharArray(), true));
            retCd = cd;
        }
        if (System.getenv("SQLCLDBPROMPT") != null && !System.getenv("SQLCLDBPROMPT").equals("") && cd != null && cd.getAt() == -1 && (promptDatabase = this.getOneField(scriptRunnerContext, ScriptRunnerDbArb.getString("CONNECT_DATABASE") + " " + (String)retrying, connectDB, connectDB, false, retry)) != null) {
            cd.setConnectDB(promptDatabase);
        }
        if (this.ctrld) {
            return null;
        }
        return retCd;
    }

    String getOneField(ScriptRunnerContext ctx, String prompt, String existing, String redacted, boolean hide, boolean retry) {
        ConsoleService reader;
        if (this.ctrld) {
            return "";
        }
        if ((retry || existing == null || existing.equals("")) && (reader = (ConsoleService)ctx.getProperty("script.runner.jline")) != null) {
            Object haveASpace = "";
            if (ctx.getProperty("script.runner.sqlplus.silent") == null) {
                if (hide) {
                    haveASpace = prompt + "(**********?) ";
                } else {
                    if (redacted == null) {
                        redacted = "";
                    }
                    haveASpace = prompt + "('" + redacted + "'?) ";
                }
            }
            String fromConsole = null;
            try {
                fromConsole = ctx.getProperty("script.runner.sqlplus.silent") == null ? (hide ? reader.readInput((String)haveASpace, Character.valueOf('*')) : reader.readInput((String)haveASpace)) : reader.readInput((String)haveASpace, Character.valueOf(' '));
                if (retry && fromConsole != null && fromConsole.equals("")) {
                    fromConsole = existing;
                }
                if (fromConsole == null) {
                    this.ctrld = true;
                    fromConsole = "";
                }
            }
            catch (Exception e) {
                ExceptionHandler.handleException(e);
            }
            return fromConsole;
        }
        return existing;
    }
}

