/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.console.HighlighterService;
import oracle.dbtools.raptor.console.impl.ParseUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.impl.ReaderUtils;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.WCWidth;

public class SqlclHighlighter
implements Highlighter,
HighlighterService {
    public static final String SYNTAX_HIGHLIGHTING_ENABLED = "syntax-highlighting-enabled";
    public static final String FOREGROUND_COLOR = "hightlight-foreground-color-";
    public static final String BACKGROUND_COLOR = "hightlight-background-color-";
    public static final String BOLD = "hightlight-bold-";
    public static final String UNDERLINE = "hightlight-underline-";
    public static final String INVERSE = "hightlight-inverse-";
    private LineReader reader;
    private Pattern errorPattern;
    private int errorIndex = -1;

    public SqlclHighlighter reader(LineReader reader) {
        this.reader = reader;
        this.reset();
        return this;
    }

    public void setErrorPattern(Pattern errorPattern) {
        this.errorPattern = errorPattern;
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    public AttributedString highlight(LineReader reader, String buffer) {
        AttributedString attribString = this.isEnabled() ? this.highlightSyntax(buffer) : new AttributedString((CharSequence)buffer);
        String search = reader.getSearchTerm();
        if (search != null && search.length() > 0 || reader.getRegionActive() != LineReader.RegionType.NONE) {
            attribString = this.overlayHighlightSearchOrActiveRegion(buffer, attribString);
        }
        return attribString;
    }

    @Override
    public String styleText(HighlighterService.InputType type, String text) {
        AttributedStyle style = this.getStyleFor(type);
        AttributedStringBuilder sb = new AttributedStringBuilder();
        return sb.append((CharSequence)text, style).toAnsi();
    }

    @Override
    public String highlightText(String text) {
        AttributedString attribString = this.isEnabled() ? this.highlightSyntax(text) : new AttributedString((CharSequence)text);
        return attribString.toAnsi();
    }

    @Override
    public boolean isEnabled() {
        return ReaderUtils.getBoolean((LineReader)this.reader, (String)SYNTAX_HIGHLIGHTING_ENABLED, (boolean)false);
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.reader.setVariable(SYNTAX_HIGHLIGHTING_ENABLED, (Object)newValue);
    }

    @Override
    public HighlighterService.TerminalColor getForegroundColor(HighlighterService.InputType type) {
        return this.getTerminalColor(FOREGROUND_COLOR, type);
    }

    @Override
    public HighlighterService.TerminalColor getBackgroundColor(HighlighterService.InputType type) {
        return this.getTerminalColor(BACKGROUND_COLOR, type);
    }

    @Override
    public boolean isBold(HighlighterService.InputType type) {
        Boolean flag = this.getFlag(BOLD, type);
        return flag != null ? flag : false;
    }

    @Override
    public boolean isUnderline(HighlighterService.InputType type) {
        Boolean flag = this.getFlag(UNDERLINE, type);
        return flag != null ? flag : false;
    }

    @Override
    public boolean isInverse(HighlighterService.InputType type) {
        Boolean flag = this.getFlag(INVERSE, type);
        return flag != null ? flag : false;
    }

    @Override
    public void setForegroundColor(HighlighterService.InputType type, HighlighterService.TerminalColor color) {
        this.setTerminalColor(FOREGROUND_COLOR, type, color);
    }

    @Override
    public void setBackgroundColor(HighlighterService.InputType type, HighlighterService.TerminalColor color) {
        this.setTerminalColor(BACKGROUND_COLOR, type, color);
    }

    @Override
    public void setBold(HighlighterService.InputType type, boolean bold) {
        this.setFlag(BOLD, type, bold);
    }

    @Override
    public void setUnderline(HighlighterService.InputType type, boolean underline) {
        this.setFlag(UNDERLINE, type, underline);
    }

    @Override
    public void setInverse(HighlighterService.InputType type, boolean inverse) {
        this.setFlag(INVERSE, type, inverse);
    }

    @Override
    public void resetForegroundColor(HighlighterService.InputType type) {
        switch (type) {
            case KEYWORD: {
                this.setForegroundColor(HighlighterService.InputType.KEYWORD, HighlighterService.TerminalColor.CYAN);
                break;
            }
            case ERROR: {
                this.setForegroundColor(HighlighterService.InputType.ERROR, HighlighterService.TerminalColor.RED);
                break;
            }
            default: {
                this.clearVariable(FOREGROUND_COLOR, type);
            }
        }
    }

    @Override
    public void resetBackgroundColor(HighlighterService.InputType type) {
        this.clearVariable(BACKGROUND_COLOR, type);
    }

    @Override
    public void resetBold(HighlighterService.InputType type) {
        this.clearVariable(BOLD, type);
    }

    @Override
    public void resetUnderline(HighlighterService.InputType type) {
        switch (type) {
            case ERROR: {
                this.setUnderline(HighlighterService.InputType.ERROR, true);
                break;
            }
            default: {
                this.clearVariable(UNDERLINE, type);
            }
        }
    }

    @Override
    public void resetInverse(HighlighterService.InputType type) {
        this.clearVariable(INVERSE, type);
    }

    @Override
    public void reset(HighlighterService.InputType type) {
        this.resetForegroundColor(type);
        this.resetBackgroundColor(type);
        this.resetBold(type);
        this.resetUnderline(type);
        this.resetInverse(type);
    }

    @Override
    public void reset() {
        this.reset(HighlighterService.InputType.DEFAULT);
        this.reset(HighlighterService.InputType.COMMENT);
        this.reset(HighlighterService.InputType.STRING);
        this.reset(HighlighterService.InputType.NUMBER);
        this.reset(HighlighterService.InputType.PUNCTUATION);
        this.reset(HighlighterService.InputType.KEYWORD);
        this.reset(HighlighterService.InputType.IDENTIFIER);
        this.reset(HighlighterService.InputType.ERROR);
    }

    private AttributedString highlightSyntax(String buffer) {
        String s0;
        List src;
        AttributedStringBuilder sb = new AttributedStringBuilder();
        SqlEarley earley = SqlEarley.getInstance();
        Set<String> symbols = earley.symbolIndexes.keySet();
        ISQLCommand cmd = ParseUtil.parseLast(buffer);
        SQLCommand.StmtType stmtType = cmd != null ? cmd.getStmtType() : SQLCommand.StmtType.G_C_UNKNOWN;
        List<LexerToken> tokens = ParseUtil.tokenize(buffer);
        SyntaxError error = null;
        if (buffer.length() < 10000 && 2 < (src = LexerToken.parse((String)buffer)).size() && ("select".equals(s0 = ((LexerToken)src.get((int)0)).content.toLowerCase()) || "with".equals(s0) || "insert".equals(s0) || "delete".equals(s0) || "update".equals(s0) || "merge".equals(s0) || "create".equals(s0) || "alter".equals(s0) || "drop".equals(s0) || "grant".equals(s0) || "declare".equals(s0) || "begin".equals(s0))) {
            Matrix matrix = new Matrix((Parser)earley);
            earley.parse(src, matrix);
            error = SyntaxError.checkSyntax((String)buffer, (String[])new String[]{"sql_statements"}, (List)src, (Earley)earley, (Matrix)matrix);
        }
        int numTokens = tokens.size();
        for (int t = 0; t < numTokens; ++t) {
            AttributedStyle style;
            LexerToken token = tokens.get(t);
            if (!this.isFilePathComponent(tokens, t)) {
                HighlighterService.InputType type = this.getInputType(symbols, stmtType, token);
                if (error != null && error.end <= token.begin && token.type != Token.WS) {
                    type = HighlighterService.InputType.ERROR;
                    error = null;
                }
                style = this.getStyleFor(type);
            } else {
                style = AttributedStyle.DEFAULT;
            }
            sb.append((CharSequence)token.content, style);
        }
        return sb.toAttributedString();
    }

    private AttributedString overlayHighlightSearchOrActiveRegion(String buffer, AttributedString baseAttribString) {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        int underlineStart = -1;
        int underlineEnd = -1;
        int negativeStart = -1;
        int negativeEnd = -1;
        String search = this.reader.getSearchTerm();
        if (search != null && search.length() > 0 && (underlineStart = buffer.indexOf(search)) >= 0) {
            underlineEnd = underlineStart + search.length() - 1;
        }
        if (this.reader.getRegionActive() != LineReader.RegionType.NONE) {
            negativeStart = this.reader.getRegionMark();
            if (negativeStart > (negativeEnd = this.reader.getBuffer().cursor())) {
                int x = negativeEnd;
                negativeEnd = negativeStart;
                negativeStart = x;
            }
            if (this.reader.getRegionActive() == LineReader.RegionType.LINE) {
                while (negativeStart > 0 && this.reader.getBuffer().atChar(negativeStart - 1) != 10) {
                    --negativeStart;
                }
                while (negativeEnd < this.reader.getBuffer().length() - 1 && this.reader.getBuffer().atChar(negativeEnd + 1) != 10) {
                    ++negativeEnd;
                }
            }
        }
        AttributedStyle overlayStyle = new AttributedStyle();
        for (int i = 0; i < buffer.length(); ++i) {
            if (i == underlineStart) {
                overlayStyle = overlayStyle.underline();
            }
            if (i == negativeStart) {
                overlayStyle = overlayStyle.inverse();
            }
            if (i == this.errorIndex) {
                overlayStyle = overlayStyle.inverse();
            }
            AttributedStyle baseStyle = baseAttribString.styleAt(i);
            AttributedStyle style = new AttributedStyle(baseStyle.getStyle() | overlayStyle.getStyle(), baseStyle.getMask() | overlayStyle.getMask());
            sb.style(style);
            char c = buffer.charAt(i);
            if (c == '\t' || c == '\n') {
                sb.append(c);
            } else if (c < ' ') {
                sb.style(AttributedStyle::inverseNeg).append('^').append((char)(c + 64)).style(AttributedStyle::inverseNeg);
            } else {
                int w = WCWidth.wcwidth((int)c);
                if (w > 0) {
                    sb.append(c);
                }
            }
            if (i == underlineEnd) {
                overlayStyle = overlayStyle.underlineOff();
            }
            if (i == negativeEnd) {
                overlayStyle = overlayStyle.inverseOff();
            }
            if (i != this.errorIndex) continue;
            overlayStyle = overlayStyle.inverseOff();
        }
        if (this.errorPattern != null) {
            sb.styleMatches(this.errorPattern, AttributedStyle.INVERSE);
        }
        return sb.toAttributedString();
    }

    private HighlighterService.InputType getInputType(Set<String> symbols, SQLCommand.StmtType stmtType, LexerToken token) {
        HighlighterService.InputType highlightType;
        switch (token.type) {
            case COMMENT: 
            case LINE_COMMENT: {
                highlightType = HighlighterService.InputType.COMMENT;
                break;
            }
            case QUOTED_STRING: {
                highlightType = HighlighterService.InputType.STRING;
                break;
            }
            case DQUOTED_STRING: {
                highlightType = HighlighterService.InputType.IDENTIFIER;
                break;
            }
            case BQUOTED_STRING: {
                highlightType = HighlighterService.InputType.STRING;
                break;
            }
            case DIGITS: {
                highlightType = HighlighterService.InputType.NUMBER;
                break;
            }
            case OPERATION: {
                highlightType = HighlighterService.InputType.PUNCTUATION;
                break;
            }
            case IDENTIFIER: {
                highlightType = this.getKeywordOrIdentifier(symbols, stmtType, token.content);
                break;
            }
            case UNKNOWN: 
            case INCOMPLETE: {
                highlightType = HighlighterService.InputType.ERROR;
                break;
            }
            default: {
                highlightType = HighlighterService.InputType.DEFAULT;
            }
        }
        return highlightType;
    }

    private HighlighterService.InputType getKeywordOrIdentifier(Set<String> symbols, SQLCommand.StmtType stmtType, String content) {
        HighlighterService.InputType type = HighlighterService.InputType.IDENTIFIER;
        switch (stmtType) {
            case G_C_SQL: 
            case G_C_PLSQL: 
            case G_C_SQLPLUS: 
            case G_C_USERDEFINED: {
                if (!this.isSymbol(symbols, content)) break;
                type = HighlighterService.InputType.KEYWORD;
            }
        }
        return type;
    }

    private boolean isSymbol(Set<String> symbols, String content) {
        return content.length() > 1 && symbols.contains("'" + content.toUpperCase() + "'");
    }

    private boolean isFilePathComponent(List<LexerToken> tokens, int t) {
        boolean result = false;
        if (t > 0) {
            String leftToken = tokens.get((int)(t - 1)).content;
            boolean bl = result = File.separator.equals(leftToken) || ":".equals(leftToken);
        }
        if (!result && t < tokens.size() - 1) {
            String rightToken = tokens.get((int)(t + 1)).content;
            result = File.separator.equals(rightToken) || ":".equals(rightToken);
        }
        return result;
    }

    private HighlighterService.TerminalColor getTerminalColor(String keyPrefix, HighlighterService.InputType type) {
        Object colorRep = this.reader.getVariable(keyPrefix + type.toString());
        if (colorRep != null && colorRep instanceof HighlighterService.TerminalColor) {
            return (HighlighterService.TerminalColor)((Object)colorRep);
        }
        if (type != HighlighterService.InputType.DEFAULT) {
            return this.getTerminalColor(keyPrefix, HighlighterService.InputType.DEFAULT);
        }
        return null;
    }

    private Boolean getFlag(String keyPrefix, HighlighterService.InputType type) {
        Object flagRep = this.reader.getVariable(keyPrefix + type.toString());
        if (flagRep != null && flagRep instanceof Boolean) {
            return (Boolean)flagRep;
        }
        if (type != HighlighterService.InputType.DEFAULT) {
            return this.getFlag(keyPrefix, HighlighterService.InputType.DEFAULT);
        }
        return null;
    }

    private void clearVariable(String keyPrefix, HighlighterService.InputType type) {
        this.reader.getVariables().remove(keyPrefix + type.toString());
    }

    private void setTerminalColor(String keyPrefix, HighlighterService.InputType type, HighlighterService.TerminalColor color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.reader.setVariable(keyPrefix + type.toString(), (Object)color);
    }

    private void setFlag(String keyPrefix, HighlighterService.InputType type, boolean flag) {
        this.reader.setVariable(keyPrefix + type.toString(), (Object)flag);
    }

    private AttributedStyle getStyleFor(HighlighterService.InputType type) {
        Boolean inverse;
        Boolean underline;
        Boolean bold;
        HighlighterService.TerminalColor backgroundColor;
        AttributedStyle style = AttributedStyle.DEFAULT;
        HighlighterService.TerminalColor foregroundColor = this.getTerminalColor(FOREGROUND_COLOR, type);
        if (foregroundColor != null) {
            style = style.foreground(this.getColorCode(foregroundColor));
        }
        if ((backgroundColor = this.getTerminalColor(BACKGROUND_COLOR, type)) != null) {
            style = style.background(this.getColorCode(backgroundColor));
        }
        if ((bold = this.getFlag(BOLD, type)) != null) {
            style = bold != false ? style.bold() : style.boldOff();
        }
        if ((underline = this.getFlag(UNDERLINE, type)) != null) {
            style = underline != false ? style.underline() : style.underlineOff();
        }
        if ((inverse = this.getFlag(INVERSE, type)) != null) {
            style = inverse != false ? style.inverse() : style.inverseOff();
        }
        return style;
    }

    private int getColorCode(HighlighterService.TerminalColor color) {
        switch (color) {
            case RED: {
                return 1;
            }
            case BLUE: {
                return 4;
            }
            case BLACK: {
                return 0;
            }
            case CYAN: {
                return 6;
            }
            case GREEN: {
                return 2;
            }
            case MAGENTA: {
                return 5;
            }
            case WHITE: {
                return 7;
            }
            case YELLOW: {
                return 3;
            }
        }
        return 0;
    }
}

