/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.util.List;
import oracle.dbtools.raptor.console.impl.CommandCompleter;
import oracle.dbtools.raptor.console.impl.CompletionProperties;
import oracle.dbtools.raptor.console.impl.SqlclCompleter;
import oracle.dbtools.raptor.console.impl.SqlclFileNameCompleter;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

class SqlclAggregateCompleter
implements Completer {
    private final CompletionProperties completionProperties = new CompletionProperties();
    private final Completer commandCompleter;
    private final Completer fileNameCompleter;
    private final Completer sqlclCompleter;

    SqlclAggregateCompleter(ScriptRunnerContext ctx) {
        this.commandCompleter = new CommandCompleter(ctx, this.completionProperties);
        this.fileNameCompleter = new SqlclFileNameCompleter(ctx);
        this.sqlclCompleter = new SqlclCompleter(ctx, this.completionProperties);
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        this.completionProperties.setCommandToken(null);
        this.commandCompleter.complete(reader, line, candidates);
        String commandToken = this.completionProperties.getCommandToken();
        if (commandToken == null) {
            this.fileNameCompleter.complete(reader, line, candidates);
        }
        if (commandToken == null || commandToken.startsWith("CONN") && candidates.size() == 0) {
            this.sqlclCompleter.complete(reader, line, candidates);
        }
    }
}

