/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreOptions;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.util.CommandContext;

public abstract class Importer<T> {
    protected final Path importPath;
    private final ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy;
    protected final Set<String> existingConnections = new HashSet<String>();
    protected final CommandContext cmdCtx;
    protected final TextSecret key;

    protected Importer(Path path, ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy, Collection<String> existingConnections, CommandContext ctx, TextSecret key) {
        this.importPath = path;
        this.duplicatesPolicy = duplicatesPolicy;
        this.cmdCtx = ctx;
        this.existingConnections.addAll(existingConnections);
        this.key = key;
    }

    protected abstract Map<String, T> loadConnections();

    public Collection<ImportedConnectionResult> importConnections() {
        ArrayList<ImportedConnectionResult> results = new ArrayList<ImportedConnectionResult>();
        for (Map.Entry<String, T> entry : this.loadConnections().entrySet()) {
            String cName = entry.getKey();
            T conn = entry.getValue();
            ImportedConnectionResult result = null;
            if (this.existingConnections.contains(cName)) {
                switch (this.duplicatesPolicy) {
                    case IGNORE: {
                        result = ImportedConnectionResult.failure(cName, ConnectionStoreResources.getString("FAILURE_DUPLICATION_CONNECTION"));
                        break;
                    }
                    case RENAME: {
                        cName = Importer.findNewName(this.existingConnections, cName);
                        break;
                    }
                }
            }
            if (result == null) {
                result = this.importConnection(conn, cName);
            }
            results.add(result);
            this.existingConnections.add(cName);
        }
        return results;
    }

    private static String findNewName(Set<String> names, String duplicate) {
        Object newName = duplicate;
        if (names.contains(duplicate)) {
            int i = 1;
            while (true) {
                String candidate;
                if (!names.contains(candidate = duplicate + "_" + i)) {
                    newName = candidate;
                    break;
                }
                ++i;
            }
        }
        return newName;
    }

    protected ImportedConnectionResult importConnection(T connectionDefinition, String name) {
        return ImportedConnectionResult.failure(this.getConnectionName(connectionDefinition), ConnectionStoreResources.getString("FAILURE_UNSUPPORTED_CONNECTION"));
    }

    protected abstract String getConnectionName(T var1);
}

