/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;

public final class ImportedConnectionResult {
    private final String name;
    private final ResultState state;
    private final String msg;

    public static ImportedConnectionResult success(String name) {
        return new ImportedConnectionResult(name, ResultState.SUCCESS, null);
    }

    public static ImportedConnectionResult failure(String name, String reason) {
        return new ImportedConnectionResult(name, ResultState.FAILURE, reason);
    }

    private ImportedConnectionResult(String name, ResultState state, String msg) {
        this.name = name;
        this.state = state;
        this.msg = msg;
    }

    public ResultState getResult() {
        return this.state;
    }

    public String getResultMessage() {
        return this.msg;
    }

    public void logResult(MessageLogger logger) {
        String resultMessage = "";
        switch (this.state) {
            case SUCCESS: {
                resultMessage = ConnectionStoreResources.getString("IMPORT_SUCCESS");
                break;
            }
            case FAILURE: {
                resultMessage = ConnectionStoreResources.format("IMPORT_FAILURE", this.msg);
            }
        }
        logger.logUserMessage(ConnectionStoreResources.format("IMPORT_RESULT_MESSAGE", this.name, resultMessage));
    }

    public static enum ResultState {
        SUCCESS,
        FAILURE;

    }
}

