/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.helpers.ProductConnectDetails;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionsConnector;
import oracle.jdbc.datasource.impl.OracleDataSource;

public class ConnectionTester {
    private static final String TEST_QUERY = "select banner from v$version";
    private final ConnectionHelper creator;
    private final ScriptRunnerContext ctx;
    private final MessageLogger logger;

    public static Builder builder(ConnectionDefinition definition) {
        return new Builder().connectionDefinition(definition);
    }

    private ConnectionTester(Builder builder) {
        this.creator = ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)builder.definition, (MessageLogger)builder.logger));
        this.ctx = builder.ctx;
        this.logger = builder.logger;
    }

    public void testConnection(String user) throws SQLException {
        String connSpec = this.creator.getConnectionSpec();
        ConnectionDetails cd = new ConnectionDetails(connSpec, false, user, null, connSpec, null, false, -1, -1, null);
        this.creator.completeConnectionDetails((ProductConnectDetails)NamedConnectionsConnector.SqlClConnectDetails.of(cd));
        ConnectionDetails updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false);
        if (updatedDetails != null) {
            String connectUser = updatedDetails.getConnectName();
            TextSecret connectPwd = updatedDetails.getConnectPassword();
            OracleDataSource ds = new OracleDataSource();
            ds.setURL(this.creator.getURL());
            ds.setUser(connectUser);
            ds.setPassword((String)connectPwd.map(String::new));
            this.creator.configureDataSource((oracle.jdbc.datasource.OracleDataSource)ds);
            try (Connection conn = ds.getConnection();
                 Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(TEST_QUERY);){
                if (rs.next()) {
                    this.logger.logUserMessage(rs.getString(1));
                }
            }
        }
    }

    public static class Builder {
        private ConnectionDefinition definition;
        private ScriptRunnerContext ctx;
        private MessageLogger logger;

        public Builder connectionDefinition(ConnectionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder scriptRunnerContext(ScriptRunnerContext ctx) {
            this.ctx = ctx;
            return this;
        }

        public Builder messageLogger(MessageLogger logger) {
            this.logger = logger;
            return this;
        }

        public ConnectionTester build() {
            return new ConnectionTester(this);
        }
    }
}

