/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.editor;

import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.util.Enumeration;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.accessibility.AccessibleGraphicPlugin;
import oracle.diagram.framework.accessibility.DefaultAccessibleGraphicPlugin;
import oracle.diagram.framework.accessibility.KeyboardNavigationPlugin;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.accessibility.NavigateContextMenuPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.controller.ControllerChain;
import oracle.diagram.framework.controller.DiagramController;
import oracle.diagram.framework.dragdrop.ManagerViewDragAndDropController;
import oracle.diagram.framework.editor.CommonDiagram;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.view.HintTextViewDecoration;
import oracle.diagram.sdm.accessibility.DefaultSDMKeyboardNavigationPlugin;
import oracle.diagram.sdm.accessibility.DefaultSDMNavigableGraphicPlugin;
import oracle.diagram.sdm.accessibility.DefaultSDMNavigateContextMenuPlugin;
import oracle.diagram.sdm.accessibility.DefaultSDMPresentableGraphicPlugin;
import oracle.diagram.sdm.action.handler.SDMDeleteHandler;
import oracle.diagram.sdm.action.handler.SDMInPlaceEditHandler;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.dragdrop.SDMManagerViewDragAndDropController;
import oracle.diagram.sdm.interaction.DefaultSDMInPlaceEditPlugin;
import oracle.diagram.sdm.renderer.HelpTagRenderer;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;

public abstract class SDMDiagram
extends CommonDiagram {
    protected static final Controller SDM_FALLBACK_CONTROLLER = new ControllerChain(new SDMInPlaceEditHandler(), new SDMDeleteHandler(), COMMON_FALLBACK_CONTROLLER);
    private final Controller _controller = new DiagramController(SDM_FALLBACK_CONTROLLER);

    public SDMDiagram() {
        DiagramContext dc = this.getDiagramContext();
        dc.addPlugin(KeyboardNavigationPlugin.class, new DefaultSDMKeyboardNavigationPlugin(dc));
    }

    @Override
    public void open() {
        super.open();
        DiagramContext dc = this.getDiagramContext();
        dc.addPlugin(NavigateContextMenuPlugin.class, new DefaultSDMNavigateContextMenuPlugin(true));
        dc.addPlugin(PresentableGraphicPlugin.class, new DefaultSDMPresentableGraphicPlugin(dc));
        dc.addPlugin(NavigableGraphicPlugin.class, new DefaultSDMNavigableGraphicPlugin());
        dc.addPlugin(AccessibleGraphicPlugin.class, new DefaultAccessibleGraphicPlugin());
        dc.addPlugin(InPlaceEditPlugin.class, new DefaultSDMInPlaceEditPlugin(dc));
    }

    @Override
    protected ManagerViewDragAndDropController createDragAndDropController() {
        IlvManagerView view = this.getDiagramContext().getManagerView();
        return new SDMManagerViewDragAndDropController(DragSource.getDefaultDragSource(), view, view.getParent() instanceof Autoscroll ? (Autoscroll)((Object)view.getParent()) : null, 3, this.createDropTargetListener());
    }

    @Override
    public Controller getController() {
        return this._controller;
    }

    @Override
    public HelpInfo getHelpInfo() {
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext());
        String defaultTopic = HelpTagRenderer.getDefaultTopic(engine);
        if (defaultTopic == null) {
            return super.getHelpInfo();
        }
        String topic = defaultTopic;
        boolean first = true;
        Enumeration e = engine.getSelectedObjects();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String myTopic = HelpTagRenderer.getHelpTopic(engine, o);
            if (first) {
                first = false;
                topic = myTopic;
                continue;
            }
            if (myTopic == topic) continue;
            topic = defaultTopic;
            break;
        }
        if (topic == null) {
            topic = defaultTopic;
        }
        return new HelpInfo(topic);
    }

    @Override
    protected HintTextViewDecoration createHintTextViewDecoration(IlvManagerView view, String hintText) {
        return new HintTextViewDecoration(view, hintText);
    }
}

