/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.util;

import ilog.views.IlvGraphic;
import java.awt.Color;
import java.awt.Font;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.diagram.framework.util.TextType;

public class TextUtil {
    private static final String NEWLINE = "\n";
    private static final String PROPERTY_TEXT_TYPE = "TextUtil.TextType";
    private static final String FONT_OPEN = "<font";
    private static final String FONT_CLOSE = "</font>";
    private static final String CLOSE_BRACKET = ">";
    private static final String NBSP1 = "&nbsp;";
    private static final String NBSP2 = "&#160;";
    private static final String SPACE = " ";
    private static final String FORMATTING_BREAK = "\n      ";

    public static void setTextType(IlvGraphic textGraphic, TextType type) {
        textGraphic.setProperty(PROPERTY_TEXT_TYPE, (Object)type);
    }

    public static TextType getTextType(IlvGraphic textGraphic) {
        TextType type = (TextType)((Object)textGraphic.getProperty(PROPERTY_TEXT_TYPE));
        return type == null ? TextType.PLAIN_TEXT : type;
    }

    public static String convertSpacesInHTML(String text) {
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        int searchIndex = text.indexOf(FONT_OPEN);
        while (searchIndex != -1) {
            int closeIndex = text.indexOf(CLOSE_BRACKET, searchIndex);
            sb.append(text.substring(lastIndex, closeIndex + 1));
            int endFontIndex = text.indexOf(FONT_CLOSE, closeIndex);
            String realText = text.substring(closeIndex + 1, endFontIndex);
            realText = realText.replaceAll(FORMATTING_BREAK, "");
            int baseIndex = 0;
            int len = realText.length();
            do {
                int spaceIndex;
                if ((spaceIndex = realText.indexOf(SPACE, baseIndex)) == -1 || spaceIndex == len - 1) {
                    sb.append(realText.substring(baseIndex));
                    break;
                }
                if (Character.isSpaceChar(realText.charAt(spaceIndex + 1))) {
                    int testIndex;
                    sb.append(realText.substring(baseIndex, spaceIndex));
                    for (testIndex = spaceIndex + 2; testIndex <= len - 1 && Character.isSpaceChar(realText.charAt(testIndex)); ++testIndex) {
                    }
                    for (int i = spaceIndex; i < testIndex; ++i) {
                        sb.append(NBSP1);
                    }
                    baseIndex = testIndex;
                    continue;
                }
                sb.append(realText.substring(baseIndex, spaceIndex + 1));
                baseIndex = spaceIndex + 1;
            } while (baseIndex < len);
            lastIndex = endFontIndex;
            searchIndex = text.indexOf(FONT_OPEN, lastIndex);
        }
        sb.append(text.substring(lastIndex));
        String newText = sb.toString();
        return newText;
    }

    public static String convertNBSPInHTML(String text) {
        String newText = text.replaceAll(NBSP1, SPACE);
        newText = text.replaceAll(NBSP2, SPACE);
        return newText;
    }

    public static String convertHTMLToPlain(String text) {
        String plainText = "";
        if (text == null) {
            text = "";
        }
        if (!TextUtil.isHTML(text)) {
            return text;
        }
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
            StringReader r = new StringReader(text);
            HTML2PlainTextParserCallback cb = new HTML2PlainTextParserCallback();
            doc.getParser().parse(r, cb, true);
            plainText = cb.getText();
            cb.clean();
        }
        catch (Throwable exc) {
            exc.printStackTrace();
        }
        return plainText;
    }

    public static String convertPlainToHTML(String text) {
        return TextUtil.convertPlainToHTML(text, null, null);
    }

    public static String convertPlainToHTML(String text, Font font, Color fontColor) {
        if (text == null) {
            text = "";
        }
        if (TextUtil.isHTML(text)) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(TextUtil.createTag(HTML.Tag.HTML, true));
        builder.append(NEWLINE);
        builder.append(TextUtil.createTag(HTML.Tag.HEAD, true));
        builder.append(NEWLINE);
        builder.append(TextUtil.createTag(HTML.Tag.HEAD, false));
        builder.append(NEWLINE);
        builder.append(TextUtil.createTag(HTML.Tag.BODY, true));
        builder.append(NEWLINE);
        String[] lines = text.split(NEWLINE);
        if (lines != null && lines.length > 0) {
            String startParagraph = TextUtil.createTag(HTML.Tag.P, true);
            String endParagraph = TextUtil.createTag(HTML.Tag.P, false);
            for (String line : lines) {
                builder.append(startParagraph);
                builder.append(NEWLINE);
                builder.append(line);
                builder.append(endParagraph);
                builder.append(NEWLINE);
            }
        }
        builder.append(TextUtil.createTag(HTML.Tag.BODY, false));
        builder.append(NEWLINE);
        builder.append(TextUtil.createTag(HTML.Tag.HTML, false));
        builder.append(NEWLINE);
        String newHTML = builder.toString();
        if (font != null && fontColor != null) {
            try {
                HTMLDocument doc = new HTMLDocument();
                HTMLEditorKit kit = new HTMLEditorKit();
                doc.remove(0, doc.getLength());
                kit.read(new StringReader(newHTML), (Document)doc, 0);
                SimpleAttributeSet a = new SimpleAttributeSet();
                StyleConstants.setFontFamily(a, font.getFamily());
                StyleConstants.setFontSize(a, font.getSize());
                StyleConstants.setForeground(a, fontColor);
                StyleConstants.setBold(a, font.isBold());
                StyleConstants.setItalic(a, font.isItalic());
                doc.setCharacterAttributes(0, doc.getLength(), a, false);
                StringWriter writer = new StringWriter();
                kit.write(writer, (Document)doc, 0, doc.getLength());
                newHTML = writer.toString();
            }
            catch (Exception exc) {
                System.out.println(exc);
                exc.printStackTrace();
            }
        }
        return newHTML;
    }

    public static String changeFontInHTML(String html, Font font) {
        String newHTML = html;
        if (font != null) {
            try {
                HTMLDocument doc = new HTMLDocument();
                HTMLEditorKit kit = new HTMLEditorKit();
                doc.remove(0, doc.getLength());
                kit.read(new StringReader(newHTML), (Document)doc, 0);
                SimpleAttributeSet a = new SimpleAttributeSet();
                StyleConstants.setFontFamily(a, font.getFamily());
                StyleConstants.setFontSize(a, font.getSize());
                StyleConstants.setBold(a, font.isBold());
                StyleConstants.setItalic(a, font.isItalic());
                doc.setCharacterAttributes(0, doc.getLength(), a, false);
                StringWriter writer = new StringWriter();
                kit.write(writer, (Document)doc, 0, doc.getLength());
                newHTML = writer.toString();
            }
            catch (Exception exc) {
                System.out.println(exc);
                exc.printStackTrace();
            }
        }
        return newHTML;
    }

    public static String changeFontColorInHTML(String html, Color fontColor) {
        String newHTML = html;
        if (TextUtil.isHTML(html) && fontColor != null) {
            try {
                HTMLEditorKit kit = new HTMLEditorKit();
                HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
                ChangeHTMLFontColorParserCallback cb = new ChangeHTMLFontColorParserCallback(fontColor, doc.getReader(0));
                doc.getParser().parse(new StringReader(newHTML), cb, false);
                cb.flush();
                cb.clean();
                if (cb.hasText()) {
                    StringWriter writer = new StringWriter();
                    kit.write(writer, (Document)doc, 0, doc.getLength());
                    newHTML = writer.toString();
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace();
            }
        }
        return newHTML;
    }

    public static boolean isHTML(String text) {
        return text == null ? false : text.toUpperCase().startsWith(TextUtil.createTag(HTML.Tag.HTML, true).toUpperCase());
    }

    public static StyleSheet getDefaultHTMLStyleSheet() {
        StyleSheet styles = new StyleSheet(){

            @Override
            public AttributeSet getViewAttributes(View v) {
                AttributeSet aSet = super.getViewAttributes(v);
                SimpleAttributeSet newSet = new SimpleAttributeSet();
                newSet.addAttributes(aSet);
                StyleConstants.setLineSpacing(newSet, -0.12f);
                return newSet;
            }
        };
        return styles;
    }

    public static HTMLEditorKit createHTMLEditorKit() {
        return new BetterLineSpacingHTMLEditorKit();
    }

    public static HTMLAttributes getHTMLAttributes(String html) {
        HTMLAttributes a = new HTMLAttributes();
        if (TextUtil.isHTML(html)) {
            try {
                HTMLEditorKit kit = new HTMLEditorKit();
                HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
                StringReader r = new StringReader(html);
                AttributeGatherer cb = new AttributeGatherer();
                doc.getParser().parse(r, cb, true);
                a.font = cb.getFont();
                a.color = cb.getColor();
                cb.clean();
            }
            catch (Throwable exc) {
                exc.printStackTrace();
            }
        }
        return a;
    }

    private static String createTag(HTML.Tag tag, boolean isStart) {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        if (!isStart) {
            builder.append("/");
        }
        builder.append(tag.toString());
        builder.append(CLOSE_BRACKET);
        return builder.toString();
    }

    private TextUtil() {
    }

    private static class HTML2PlainTextParserCallback
    extends HTMLEditorKit.ParserCallback {
        private StringBuilder _builder = new StringBuilder();

        public String getText() {
            return this._builder.toString();
        }

        public void clean() {
            this._builder = null;
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            if (HTML.Tag.P.equals(t)) {
                this._builder.append(TextUtil.NEWLINE);
            }
            super.handleEndTag(t, pos);
        }

        @Override
        public void handleText(char[] data, int pos) {
            this._builder.append(data);
            super.handleText(data, pos);
        }
    }

    private static class ChangeHTMLFontColorParserCallback
    extends HTMLEditorKit.ParserCallback {
        private boolean _hasText = false;
        private Color _newColor;
        private String _newHexColor;
        private HTMLEditorKit.ParserCallback _delegate;

        public ChangeHTMLFontColorParserCallback(Color newColor, HTMLEditorKit.ParserCallback delegate) {
            this._newColor = newColor;
            this._delegate = delegate;
            this._newHexColor = String.format("#%02X%02X%02X", this._newColor.getRed(), this._newColor.getGreen(), this._newColor.getBlue());
        }

        public void clean() {
            this._newColor = null;
            this._newHexColor = null;
            this._delegate = null;
        }

        public boolean hasText() {
            return this._hasText;
        }

        @Override
        public void flush() throws BadLocationException {
            this._delegate.flush();
        }

        @Override
        public void handleText(char[] data, int pos) {
            this._hasText = true;
            this._delegate.handleText(data, pos);
        }

        @Override
        public void handleComment(char[] data, int pos) {
            this._delegate.handleComment(data, pos);
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            this.changeAttributes(t, a);
            this._delegate.handleStartTag(t, a, pos);
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            this._delegate.handleEndTag(t, pos);
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            this.changeAttributes(t, a);
            this._delegate.handleSimpleTag(t, a, pos);
        }

        @Override
        public void handleError(String errorMsg, int pos) {
            this._delegate.handleError(errorMsg, pos);
        }

        @Override
        public void handleEndOfLineString(String eol) {
            this._delegate.handleEndOfLineString(eol);
        }

        private void changeAttributes(HTML.Tag t, MutableAttributeSet a) {
            if (HTML.Tag.FONT.equals(t)) {
                a.addAttribute(HTML.Attribute.COLOR, this._newHexColor);
            } else {
                StyleConstants.setForeground(a, this._newColor);
            }
        }
    }

    private static class BetterLineSpacingHTMLEditorKit
    extends HTMLEditorKit {
        private StyleSheet _betterStyleSheet;

        private BetterLineSpacingHTMLEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (this._betterStyleSheet == null) {
                final StyleSheet basicStyleSheet = super.getStyleSheet();
                this._betterStyleSheet = new StyleSheet(){

                    @Override
                    public AttributeSet getViewAttributes(View v) {
                        AttributeSet aSet = basicStyleSheet.getViewAttributes(v);
                        SimpleAttributeSet newSet = new SimpleAttributeSet();
                        newSet.addAttributes(aSet);
                        StyleConstants.setLineSpacing(newSet, -0.12f);
                        return newSet;
                    }
                };
            }
            return this._betterStyleSheet;
        }
    }

    public static class HTMLAttributes {
        public Font font;
        public Color color;
    }

    private static class AttributeGatherer
    extends HTMLEditorKit.ParserCallback {
        private TextAttributes _currentAttr = new TextAttributes();
        private TextAttributes _lastAttr;
        private boolean _isFontEqual = true;
        private boolean _isColorEqual = true;

        public void clean() {
            this._currentAttr = null;
            this._lastAttr = null;
        }

        public Font getFont() {
            if (!this._isFontEqual || this._lastAttr == null || this._lastAttr.fontFace == null) {
                return null;
            }
            int style = 0;
            if (this._lastAttr.isBold) {
                style |= 1;
            }
            if (this._lastAttr.isItalic) {
                style |= 2;
            }
            int size = Integer.parseInt(this._lastAttr.fontSize);
            return new Font(this._lastAttr.fontFace, style, size);
        }

        public Color getColor() {
            if (!this._isColorEqual || this._lastAttr == null || this._lastAttr.fontColor == null) {
                return null;
            }
            String color = this._lastAttr.fontColor;
            int red = Integer.parseInt(color.substring(1, 2), 16);
            int green = Integer.parseInt(color.substring(3, 4), 16);
            int blue = Integer.parseInt(color.substring(5, 6), 16);
            return new Color(red, green, blue);
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (HTML.Tag.B.equals(t)) {
                this._currentAttr.isBold = true;
            } else if (HTML.Tag.I.equals(t)) {
                this._currentAttr.isItalic = true;
            } else if (HTML.Tag.FONT.equals(t)) {
                this._currentAttr.fontFace = (String)a.getAttribute(HTML.Attribute.FACE);
                this._currentAttr.fontColor = (String)a.getAttribute(HTML.Attribute.COLOR);
                this._currentAttr.fontSize = (String)a.getAttribute(HTML.Attribute.SIZE);
            }
            super.handleStartTag(t, a, pos);
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            if (HTML.Tag.B.equals(t)) {
                this._currentAttr.isBold = false;
            } else if (HTML.Tag.I.equals(t)) {
                this._currentAttr.isItalic = false;
            } else if (HTML.Tag.FONT.equals(t)) {
                this._currentAttr.fontFace = null;
                this._currentAttr.fontColor = null;
                this._currentAttr.fontSize = null;
            }
            super.handleEndTag(t, pos);
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            super.handleSimpleTag(t, a, pos);
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (this._lastAttr != null) {
                if (this._isFontEqual) {
                    this._isFontEqual = this._lastAttr.isFontEqual(this._currentAttr);
                } else if (this._isColorEqual) {
                    this._isColorEqual = this._lastAttr.isColorEqual(this._currentAttr);
                }
            }
            this._lastAttr = this._currentAttr.copy();
            super.handleText(data, pos);
        }
    }

    private static class TextAttributes {
        public boolean isItalic;
        public boolean isBold;
        public String fontFace;
        public String fontColor;
        public String fontSize;

        private TextAttributes() {
        }

        public TextAttributes copy() {
            TextAttributes a = new TextAttributes();
            a.isItalic = this.isItalic;
            a.isBold = this.isBold;
            a.fontFace = this.fontFace;
            a.fontColor = this.fontColor;
            a.fontSize = this.fontSize;
            return a;
        }

        public boolean isFontEqual(TextAttributes other) {
            return other.fontFace == this.fontFace && other.fontSize == this.fontSize && other.isBold == this.isBold && other.isItalic == this.isItalic;
        }

        public boolean isColorEqual(TextAttributes other) {
            return other.fontColor == this.fontColor;
        }
    }
}

