/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.toolbar;

import javax.swing.Action;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.controller.modular.ModularController;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;

public abstract class AbstractToolbarPlugin
extends AbstractPlugin
implements ToolbarPlugin {
    private int _refCount = 0;
    private Toolbar _toolbar = null;
    private ModularController _controller = new ModularController();
    private boolean _initialized = false;

    protected AbstractToolbarPlugin() {
    }

    @Override
    public final Toolbar getToolbar() {
        return this._toolbar;
    }

    @Override
    public void update(Context context) {
        this.initialize();
        Action[] actions = this._toolbar.getActions();
        if (actions != null) {
            for (int i = 0; i < actions.length; ++i) {
                Action a = actions[i];
                if (!(a instanceof IdeAction)) continue;
                ((IdeAction)a).updateAction(context);
            }
        }
    }

    @Override
    public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
        super.attach(pluginManager, pluginType);
        ++this._refCount;
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
        super.detach(pluginManager, pluginType);
        if (--this._refCount == 0) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        if (this._toolbar != null) {
            this._toolbar.dispose();
            this._toolbar.removeAll();
            this._toolbar = null;
        }
    }

    @Override
    public final void createToolbar(View view) {
        this._toolbar = this.createToolbarImpl(view);
    }

    protected abstract Toolbar createToolbarImpl(View var1);

    protected void installControllerItems(ModularController mc) {
    }

    @Override
    public Controller getController() {
        this.initialize();
        return this._controller;
    }

    private synchronized void initialize() {
        if (!this._initialized) {
            this._initialized = true;
            this.installControllerItems(this._controller);
        }
    }
}

