/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.testability;

import ilog.views.IlvPoint;
import javax.swing.tree.TreePath;
import oracle.bm.javatools.util.CommonUtils;

public final class JViewsComponentLocation {
    private final TreePath path;
    private final IlvPoint point;
    private final boolean isAbsolute;
    static final String UNNAMED_PREFIX = "unnamed";

    public JViewsComponentLocation(TreePath path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path must not be null");
        }
        this.path = path;
        this.point = null;
        this.isAbsolute = false;
    }

    public JViewsComponentLocation(TreePath path, IlvPoint point, boolean isAbsolute) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path must not be null");
        }
        this.path = path;
        this.point = point;
        this.isAbsolute = isAbsolute;
    }

    public TreePath getPath() {
        return new TreePath(this.path.getPath());
    }

    public IlvPoint getPoint() {
        return this.point != null ? new IlvPoint(this.point) : null;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public final boolean isPathTraceable() {
        if (this.path == null || this.path.getPathCount() == 0) {
            return false;
        }
        for (Object pathComp : this.path.getPath()) {
            if (pathComp == null) {
                return false;
            }
            assert (pathComp instanceof String) : pathComp.getClass().getName();
            String s = (String)pathComp;
            if (s.trim().length() != 0 && !s.startsWith(UNNAMED_PREFIX) && !"null".equals(s)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (!(rhs instanceof JViewsComponentLocation)) {
            return false;
        }
        JViewsComponentLocation rhsLoc = (JViewsComponentLocation)rhs;
        return CommonUtils.equals((Object)this.path, (Object)rhsLoc.path) && CommonUtils.equals((Object)this.point, (Object)rhsLoc.point) && CommonUtils.equals((Object)this.isAbsolute, (Object)rhsLoc.isAbsolute);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.path).append(",");
        str.append(this.point != null ? this.point.toString() : "null").append(",");
        str.append(this.isAbsolute);
        return str.toString();
    }
}

