/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.testability;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.bm.util.DebugUtils;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.shape.SubSelectableShape;
import oracle.diagram.framework.testability.ComponentNameLookupPlugin;
import oracle.diagram.framework.testability.ComponentPositioningServicePlugin;
import oracle.diagram.framework.testability.CoordinateTransformationUtils;
import oracle.diagram.framework.testability.DefaultJViewsDepthFirstSearch;
import oracle.diagram.framework.testability.DefaultJViewsTestabilityChecker;
import oracle.diagram.framework.testability.IComponentNameLookup;
import oracle.diagram.framework.testability.IlvGraphicComponent;
import oracle.diagram.framework.testability.JViewsComponent;
import oracle.diagram.framework.testability.JViewsComponentLocation;
import oracle.diagram.framework.testability.TestabilityChecker;

public class DefaultComponentPositioningServicePlugin
extends AbstractPlugin
implements ComponentPositioningServicePlugin {
    private final DiagramContext diagramContext;
    private volatile IComponentNameLookup nameLookup;
    private volatile boolean recordNameAndClassForAll = false;
    private volatile DefaultJViewsDepthFirstSearch search;
    private volatile TestabilityChecker<JViewsComponent> testabilityChecker;

    public DefaultComponentPositioningServicePlugin(DiagramContext diagramContext, IComponentNameLookup nameLookup) {
        if (diagramContext == null) {
            throw new IllegalArgumentException("Argument diagramContext must not be null");
        }
        this.diagramContext = diagramContext;
        this.nameLookup = nameLookup;
    }

    @Override
    public void recordNameAndClassForAll(boolean record) {
        this.recordNameAndClassForAll = record;
    }

    @Override
    public JViewsComponent getComponent(TreePath path, IlvManagerView view) {
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        assert (SwingUtilities.isEventDispatchThread());
        if (path == null || path.getPathCount() == 0) {
            return null;
        }
        DefaultJViewsDepthFirstSearch dfs = this.getSearch();
        JViewsComponent comp = dfs.search(new IlvGraphicComponent((IlvGraphic)view.getManager()), path);
        return comp;
    }

    @Override
    public JViewsComponent getComponent(IlvPoint location, IlvManagerView view) {
        IlvGraphic graphic;
        if (location == null) {
            throw new IllegalArgumentException("Argument location must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        assert (SwingUtilities.isEventDispatchThread());
        IlvPoint p = new IlvPoint(location);
        IlvGraphic obj = view.getManager().getObject(p, view, true);
        if (obj == null) {
            obj = view.getManager();
            return new IlvGraphicComponent(obj);
        }
        if (obj instanceof SubSelectableShape && (graphic = ((SubSelectableShape)obj).getSubShape(p, view)) != null) {
            return new IlvGraphicComponent(graphic);
        }
        return new IlvGraphicComponent(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IComponentNameLookup getNameLookup() {
        DefaultComponentPositioningServicePlugin defaultComponentPositioningServicePlugin = this;
        synchronized (defaultComponentPositioningServicePlugin) {
            if (this.nameLookup == null) {
                this.nameLookup = this.diagramContext.getPlugin(ComponentNameLookupPlugin.class);
            }
        }
        assert (this.nameLookup != null) : " Cannot find component name lookup plugin";
        return this.nameLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestabilityChecker<JViewsComponent> getTestabilityChecker() {
        DefaultComponentPositioningServicePlugin defaultComponentPositioningServicePlugin = this;
        synchronized (defaultComponentPositioningServicePlugin) {
            if (this.testabilityChecker == null) {
                IComponentNameLookup lookup = this.getNameLookup();
                this.testabilityChecker = new DefaultJViewsTestabilityChecker(lookup);
            }
        }
        return this.testabilityChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultJViewsDepthFirstSearch getSearch() {
        DefaultComponentPositioningServicePlugin defaultComponentPositioningServicePlugin = this;
        synchronized (defaultComponentPositioningServicePlugin) {
            if (this.search == null) {
                this.search = new DefaultJViewsDepthFirstSearch(this.getNameLookup());
            }
        }
        assert (this.search != null);
        return this.search;
    }

    @Override
    public JViewsComponentLocation getLocation(IlvPoint absoluteCoordinates, IlvManagerView view) {
        if (absoluteCoordinates == null) {
            throw new IllegalArgumentException("Argument absoluteCoordinates must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        assert (SwingUtilities.isEventDispatchThread());
        IComponentNameLookup lookup = this.getNameLookup();
        JViewsComponent compAtPoint = this.getComponent(absoluteCoordinates, view);
        assert (compAtPoint != null);
        TestabilityChecker<JViewsComponent> testable = this.getTestabilityChecker();
        ArrayList<Object> pathComponents = new ArrayList<Object>();
        for (JViewsComponent comp = compAtPoint; comp != null; comp = comp.getParent()) {
            String name = lookup.getName(comp);
            if (!this.recordNameAndClassForAll) {
                if (!testable.isTestable(comp)) continue;
                pathComponents.add(name);
                continue;
            }
            String prefix = name == null || name.trim().length() == 0 ? "unnamed" : name;
            pathComponents.add(prefix + "(" + comp.getComponentClass().getSimpleName() + ")");
        }
        Collections.reverse(pathComponents);
        TreePath treePath = new TreePath(pathComponents.toArray());
        IlvPoint rel = this.getRelativeCoordinates(absoluteCoordinates, compAtPoint, view);
        if (rel != null) {
            return new JViewsComponentLocation(treePath, rel, false);
        }
        return new JViewsComponentLocation(treePath);
    }

    @Override
    public IlvPoint getRelativeCoordinates(IlvPoint absoluteCoordinates, JViewsComponent comp, IlvManagerView view) {
        if (absoluteCoordinates == null) {
            throw new IllegalArgumentException("Argument absoluteCoordinates must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument comp must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        IlvPoint localPoint = CoordinateTransformationUtils.toLocalPoint(absoluteCoordinates, comp, view);
        return localPoint;
    }

    @Override
    public IlvPoint getAbsoluteCoordinates(IlvPoint relativeCoordinates, JViewsComponent comp, IlvManagerView view) {
        if (relativeCoordinates == null) {
            throw new IllegalArgumentException("Argument normalizedCoordinates must not be null");
        }
        if (comp == null) {
            throw new IllegalArgumentException("Argument comp must not be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        return CoordinateTransformationUtils.toViewPoint(relativeCoordinates, comp, view);
    }

    @Override
    public IlvPoint getPoint(JViewsComponentLocation loc, IlvManagerView view) {
        if (view == null) {
            throw new IllegalArgumentException("Argument view must not be null");
        }
        assert (SwingUtilities.isEventDispatchThread());
        if (loc == null) {
            return null;
        }
        IlvPoint p = loc.getPoint();
        if (p != null && loc.isAbsolute()) {
            return p;
        }
        JViewsComponent comp = this.getComponent(loc.getPath(), view);
        assert (comp != null || DebugUtils.warning((String)("Cannot find component with path: " + loc.getPath())));
        if (comp == null) {
            return null;
        }
        if (p != null) {
            IlvPoint abs = this.getAbsoluteCoordinates(p, comp, view);
            assert (abs != null);
            return abs;
        }
        IlvPoint center = CoordinateTransformationUtils.getCenterInViewCoordinates(comp, view);
        assert (center != null);
        return center;
    }
}

