/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.util.Translator;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.layout.column.ColumnContainer;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.swimlanes.interaction.AbstractSwimlanesMoveGraphicsHelper;
import oracle.diagram.framework.undo.CompositeUndoableStep;
import oracle.diagram.framework.undo.UndoableStep;

public abstract class AutoExpandSwimlanesMoveGraphicsHelper
extends AbstractSwimlanesMoveGraphicsHelper {
    private MultivaluedMap<SwimlaneGraphic, IlvGraphic> _swimlaneToGraphicsMap = new MultivaluedMap();
    private LinkedList<SwimlaneGraphic> _orderedSwimlanes;

    public AutoExpandSwimlanesMoveGraphicsHelper(DiagramContext context, SwimlanesPlugin plugin, IlvManager topManager, Set<IlvGraphic> movingGraphics) {
        super(context, plugin, topManager, movingGraphics);
        for (IlvGraphic g : this._movingGraphics) {
            this._swimlaneToGraphicsMap.put((Object)this._plugin.getSwimlaneForGraphic(g), (Object)g);
        }
        SwimlaneGraphic topSwimlane = plugin.getTopSwimlane(topManager);
        final int flowDirection = topSwimlane.getFlowDirection();
        this._orderedSwimlanes = new LinkedList(this._swimlaneToGraphicsMap.keySet());
        Collections.sort(this._orderedSwimlanes, new Comparator<SwimlaneGraphic>(){

            @Override
            public int compare(SwimlaneGraphic o1, SwimlaneGraphic o2) {
                return flowDirection == 8 ? (o1.boundingBox(null).x - o2.boundingBox(null).x < 0.0f ? -1 : 1) : (o1.boundingBox(null).y - o2.boundingBox(null).y < 0.0f ? -1 : 1);
            }
        });
    }

    @Override
    public void cleanUp() {
        this._swimlaneToGraphicsMap.clear();
        this._swimlaneToGraphicsMap = null;
        this._orderedSwimlanes.clear();
        this._orderedSwimlanes = null;
        super.cleanUp();
    }

    @Override
    public void translateGraphics(Translator translator, float cdx, float cdy) {
        if (cdx == 0.0f && cdy == 0.0f) {
            return;
        }
        float view_dx = 0.0f;
        float view_dy = 0.0f;
        SwimlaneGraphic topSwimlane = this._plugin.getTopSwimlane(this._context.getManagerView().getManager());
        ((IlvManager)topSwimlane.getGraphicBag()).setContentsAdjusting(true, true);
        int flowDirection = topSwimlane.getFlowDirection();
        for (SwimlaneGraphic sg : this._orderedSwimlanes) {
            IlvRect sgBBox = new IlvRect(sg.boundingBox(null));
            float x_max = sgBBox.x;
            float y_max = sgBBox.y;
            float x_min = sgBBox.x + sgBBox.width;
            float y_min = sgBBox.y + sgBBox.height;
            IlvGraphic x_min_graphic = null;
            IlvGraphic y_min_graphic = null;
            float dx = cdx;
            float dy = cdy;
            for (IlvGraphic g : this._swimlaneToGraphicsMap.get((Object)sg)) {
                IlvRect bbox = g.boundingBox(null);
                x_max = Math.max(x_max, bbox.x + bbox.width + cdx);
                y_max = Math.max(y_max, bbox.y + bbox.height + cdy);
                if (bbox.x + cdx < x_min) {
                    x_min = bbox.x + cdx;
                    x_min_graphic = g;
                }
                if (!(bbox.y + cdy < y_min)) continue;
                y_min = bbox.y + cdy;
                y_min_graphic = g;
            }
            if (flowDirection == 8 && sgBBox.x + sgBBox.width <= x_max) {
                float newWidth = x_max + 1.0f + sg.getShapeLineThickness().floatValue() - sgBBox.x;
                float delta = newWidth - sgBBox.width;
                ColumnContainer container = (ColumnContainer)sg.getGraphicBag();
                int index = container.getColumnGraphicIndex(sg);
                container.resizeColumn(index, newWidth);
                cdx -= delta;
            } else if (flowDirection == 2 && sgBBox.y + sgBBox.height <= y_max) {
                float newHeight = y_max + 1.0f + sg.getShapeLineThickness().floatValue() - sgBBox.y;
                float delta = newHeight - sgBBox.height;
                RowContainer container = (RowContainer)sg.getGraphicBag();
                int index = container.getRowGraphicIndex(sg);
                container.resizeRow(index, newHeight);
                cdy -= delta;
            } else if (flowDirection == 8 && x_min < sgBBox.x) {
                float newWidth = sgBBox.x + sgBBox.width - (x_min - (1.0f + sg.getShapeLineThickness().floatValue()));
                view_dx = sgBBox.width - newWidth;
                container = (ColumnContainer)sg.getGraphicBag();
                int index = container.getColumnGraphicIndex(sg);
                container.resizeColumn(index, newWidth);
                HashSet<IlvGraphic> others = new HashSet<IlvGraphic>(this._plugin.getGraphicsInSwimlane(sg));
                others.removeAll(this._swimlaneToGraphicsMap.get((Object)sg));
                for (IlvGraphic g : others) {
                    mgr = (IlvManager)g.getGraphicBag();
                    mgr.setContentsAdjusting(true, true);
                    translator.init(view_dx * -1.0f, 0.0f, mgr.getDrawingTransformer(this._context.getManagerView()));
                    translator.translateObj(mgr, g, true);
                }
                dx = sg.boundingBox(null).x + 1.0f + sg.getShapeLineThickness().floatValue() - x_min_graphic.boundingBox(null).x;
            } else if (flowDirection == 2 && y_min < sgBBox.y) {
                float newHeight = sgBBox.y + sgBBox.height - (y_min - (1.0f + sg.getShapeLineThickness().floatValue()));
                view_dy = sgBBox.height - newHeight;
                container = (RowContainer)sg.getGraphicBag();
                int index = container.getRowGraphicIndex(sg);
                container.resizeRow(index, newHeight);
                HashSet<IlvGraphic> others = new HashSet<IlvGraphic>(this._plugin.getGraphicsInSwimlane(sg));
                others.removeAll(this._swimlaneToGraphicsMap.get((Object)sg));
                for (IlvGraphic g : others) {
                    mgr = (IlvManager)g.getGraphicBag();
                    mgr.setContentsAdjusting(true, true);
                    translator.init(0.0f, view_dy * -1.0f, mgr.getDrawingTransformer(this._context.getManagerView()));
                    translator.translateObj(mgr, g, true);
                }
                dy = sg.boundingBox(null).y + 1.0f + sg.getShapeLineThickness().floatValue() - y_min_graphic.boundingBox(null).y;
            }
            if (dx != 0.0f || dy != 0.0f) {
                for (IlvGraphic g : this._swimlaneToGraphicsMap.get((Object)sg)) {
                    IlvManager mgr = (IlvManager)g.getGraphicBag();
                    mgr.setContentsAdjusting(true, true);
                    translator.init(dx, dy, mgr.getDrawingTransformer(this._context.getManagerView()));
                    translator.translateObj(mgr, g, true);
                }
            }
            if (view_dx != 0.0f || view_dy != 0.0f) {
                this._context.getManagerView().translate(view_dx, view_dy, false);
            }
            if (cdx != 0.0f || cdy != 0.0f) continue;
            break;
        }
        ((IlvManager)topSwimlane.getGraphicBag()).setContentsAdjusting(false, true);
    }

    @Override
    public DimensionFloat getConstrainedMoveVector(float dx, float dy) {
        float cdx = dx;
        float cdy = dy;
        SwimlaneGraphic topSwimlane = this._plugin.getTopSwimlane(this._context.getManagerView().getManager());
        int flowDirection = topSwimlane.getFlowDirection();
        for (IlvGraphic g : this._movingGraphics) {
            SwimlaneGraphic sg = this._plugin.getSwimlaneForGraphic(g);
            if (sg == null) continue;
            IlvRect sgBBox = sg.getInteriorBoundingBox(null);
            IlvRect currentBBox = g.boundingBox(null);
            if (flowDirection == 8) {
                if (!(currentBBox.y + cdy < sgBBox.y)) continue;
                cdy = sgBBox.y - currentBBox.y;
                continue;
            }
            if (flowDirection != 2 || !(currentBBox.x + cdx < sgBBox.x)) continue;
            cdx = sgBBox.x - currentBBox.x;
        }
        return new DimensionFloat(cdx, cdy);
    }

    @Override
    public UndoableStep createUndoableStep() {
        if (!this._orderedSwimlanes.isEmpty()) {
            CompositeUndoableStep cs = new CompositeUndoableStep();
            for (SwimlaneGraphic sg : this._orderedSwimlanes) {
                cs.addUndoableStep(((PoolGraphic)sg.getGraphicBag()).createLaneGraphicUndoableStep(sg));
            }
            if (cs.hasSteps()) {
                return cs;
            }
        }
        return null;
    }
}

