/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.util.List;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.OpenRectangleOutline;
import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.graphic.layout.GraphicBorderLayout;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.swimlanes.graphic.AbstractHeaderGraphic;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.HorizontalHeaderGraphic;
import oracle.diagram.framework.swimlanes.graphic.HorizontalPoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;

public class HorizontalSwimlaneGraphic
extends ExtendedSwimlaneGraphic {
    public HorizontalSwimlaneGraphic(IlvRect rect, String title, Anchor titleAnchor, SwimlaneGraphic pool) {
        super(rect, new GraphicBorderLayout());
        this.addSubComponents(title, titleAnchor, pool);
    }

    @Override
    protected void addSubComponents(String title, Anchor titleAnchor, SwimlaneGraphic pool) {
        this.setChildren(new IlvGraphic[]{this.getOutline()});
        if (title != null && titleAnchor != null) {
            AbstractHeaderGraphic oldHeader = this.getHeader();
            HorizontalHeaderGraphic header = new HorizontalHeaderGraphic(title, titleAnchor);
            if (oldHeader != null) {
                header.setShapeFillColor(oldHeader.getShapeFillColor());
                header.setShapeFont(oldHeader.getShapeFont());
                header.setShapeFontColor(oldHeader.getShapeFontColor());
                header.setShapeLineColor(oldHeader.getShapeLineColor());
                header.setShapeLineThickness(oldHeader.getShapeLineThickness().floatValue());
                header.setFillOn(oldHeader.isFillOn());
                OpenRectangleOutline oldOutline = header.getOutline();
                header.setOpenBorders(oldOutline.isTopOpen(), oldOutline.isLeftOpen(), oldOutline.isBottomOpen(), oldOutline.isRightOpen());
            } else {
                if (this.getShapeFillColor() != null) {
                    header.setShapeFillColor(this.getShapeFillColor());
                }
                if (this.getShapeFont() != null) {
                    header.setShapeFont(this.getShapeFont());
                }
                if (this.getShapeFontColor() != null) {
                    header.setShapeFontColor(this.getShapeFontColor());
                }
                if (this.getShapeLineColor() != null) {
                    header.setShapeLineColor(this.getShapeLineColor());
                }
                if (this.getShapeLineThickness() != null) {
                    header.setShapeLineThickness(this.getShapeLineThickness().floatValue());
                }
                header.setFillOn(false);
                header.setOpenBorders(this.getShapeLineThickness().floatValue() > 0.0f, true, true, true);
            }
            this.addContent(header, "West");
            SubSelectionManager.setSelectable((IlvGraphic)header, false);
            this.setHeader(header);
        } else {
            this.setHeader(null);
        }
        if (pool != null) {
            pool.setTopLevel(false);
            this.addContent(pool, "Center");
            SubSelectionManager.setSelectable((IlvGraphic)pool, false);
        }
        this.setPool(pool);
    }

    @Override
    public int getFlowDirection() {
        return 2;
    }

    @Override
    public IlvRect getInteriorBoundingBox(IlvTransformer t) {
        IlvRect intRect = new IlvRect(super.getInteriorBoundingBox(t));
        IlvRect headerRect = this.getHeader().boundingBox(t);
        intRect.width -= headerRect.width;
        intRect.x += headerRect.width;
        return intRect;
    }

    @Override
    public boolean isLayoutCurrent() {
        if (this.getPool() != null) {
            return this.getPool().isLayoutCurrent();
        }
        DimensionFloat prefSize = this.getPreferedSize(new DimensionFloat());
        IlvRect bbox = this.boundingBox(null);
        return prefSize.height == bbox.height && bbox.width >= prefSize.width;
    }

    @Override
    public DimensionFloat getMinimumSwimlaneSize(DimensionFloat minimum) {
        DimensionFloat dim = super.getMinimumSwimlaneSize(minimum);
        IlvRect r = this.computeContentsBBox();
        if (r != null) {
            dim.height = Math.max(dim.height, r.height);
        }
        if (this.getPool() != null) {
            DimensionFloat d2 = this.getPool().getMinimumSwimlaneSize(new DimensionFloat());
            dim.height = Math.max(dim.height, d2.height);
        }
        return dim;
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        DimensionFloat d = super.getMinimumSize(minimum);
        d.height = Math.max(d.height, 4.0f);
        DimensionFloat d1 = this.getHeader().getMinimumSize(new DimensionFloat());
        d.height = Math.max(d.height, d1.height);
        if (this.getPool() != null) {
            DimensionFloat d2 = this.getPool().getMinimumSize(new DimensionFloat());
            d.height = Math.max(d.height, d2.height);
        }
        return d;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        DimensionFloat d = this.getPool() != null ? this.getPool().getPreferedSize(prefered) : super.getPreferedSize(prefered);
        d.height = Math.max(d.height, 4.0f);
        return d;
    }

    @Override
    public void setPreferedSize(DimensionFloat prefered) {
        if (this.getPool() != null) {
            List<SwimlaneGraphic> lanes = ((HorizontalPoolGraphic)this.getPool()).getLanes();
            int count = lanes.size();
            if (count == 0) {
                super.setPreferedSize(prefered);
            } else {
                float delta = prefered.height - this.getPool().getPreferedSize((DimensionFloat)new DimensionFloat()).height;
                SwimlaneGraphic lastLane = lanes.get(count - 1);
                DimensionFloat d = lastLane.getPreferedSize(new DimensionFloat());
                lastLane.setPreferedSize(new DimensionFloat(d.width, d.height + delta));
            }
        } else {
            super.setPreferedSize(prefered);
        }
    }
}

