/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.publish;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import oracle.bm.util.LoggerUtils;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.manager.ExtendedLayerVisibilityFilter;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.DiagramRenderingHints;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.publish.PublishPlugin;
import oracle.diagram.framework.view.ViewUtil;
import oracle.diagram.res.PublishResources;
import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserAdapter;
import oracle.ide.net.URLChooserEvent;
import oracle.ide.net.URLChooserListener;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class AbstractPublishPlugin
extends AbstractPlugin
implements PublishPlugin {
    private final DiagramContext _context;
    private static URL s_lastUsedURLExport;
    private static WildcardURLFilter s_svgFilter;
    private static WildcardURLFilter s_svgzFilter;
    private static WildcardURLFilter s_pngFilter;
    private static WildcardURLFilter s_jpgFilter;
    public static final float IMAGE_INSET = 20.0f;

    public AbstractPublishPlugin(DiagramContext context) {
        this._context = context;
    }

    public static boolean isSVGGraphics(Graphics g) {
        return g instanceof SVGGraphics2D;
    }

    private IlvRect getViewExtent(IlvManagerView view) {
        IlvRect extent = null;
        IlvManager mgr = view.getManager();
        IlvTransformer t = mgr.getDrawingTransformer(view);
        IlvGraphicEnumeration objects = mgr.getObjects();
        IlvGraphic g = null;
        while (objects.hasMoreElements()) {
            g = objects.nextElement();
            if (!g.isVisible()) continue;
            IlvRect bounds = g.boundingBox();
            if (extent == null) {
                extent = bounds;
                continue;
            }
            extent.add(bounds);
        }
        if (extent == null) {
            extent = new IlvRect();
        }
        if (t != null && !extent.isEmpty()) {
            t.apply(extent);
        }
        return extent;
    }

    @Override
    public Boolean publish() {
        URL containerURL;
        Context context = this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        ResourceBundle rb = PublishResources.getBundle();
        String dialogTitle = rb.getString("ExportDiagramDialog.text");
        IlvManagerView view = this.getDiagramContext().getManagerView();
        IlvRect extent = this.getViewExtent(view);
        extent.expand(20.0f);
        int sizeInBytes = (int)(extent.getWidth() * extent.getHeight()) * 4;
        int sizeInMegs = (int)Math.ceil((float)sizeInBytes / 1048576.0f);
        if (sizeInMegs > 140) {
            MessageDialog.optionalInformation((String)"publishDiagramTooBig", (Component)view, (Object)MessageFormat.format(rb.getString("ExportDiagramTooBig.text"), sizeInMegs), (String)dialogTitle, null);
        }
        if ((containerURL = s_lastUsedURLExport) == null) {
            URL diagramURL = context.getNode().getURL();
            containerURL = URLFileSystem.getParent((URL)diagramURL);
            if (URLFileSystem.isDirectoryPath((URL)containerURL)) {
                URLFileSystem.mkdirs((URL)containerURL);
            } else {
                containerURL = null;
            }
        }
        final URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.clearChooseableURLFilters();
        chooser.setHelpID("f1_mcomdexportdiagram_html");
        if (containerURL == null) {
            chooser.setFileNameURL(this.getDocumentName() + ".png");
        } else {
            chooser.setSelectedURL(URLFactory.newURL((URL)containerURL, (String)(this.getDocumentName() + ".png")));
        }
        AbstractPublishPlugin.ensureFilters();
        chooser.addChooseableURLFilter((URLFilter)s_svgFilter);
        chooser.addChooseableURLFilter((URLFilter)s_svgzFilter);
        chooser.addChooseableURLFilter((URLFilter)s_jpgFilter);
        chooser.addChooseableURLFilter((URLFilter)s_pngFilter);
        chooser.setURLFilter((URLFilter)s_pngFilter);
        chooser.setSelectionMode(0);
        URLChooserAdapter adapter = new URLChooserAdapter(){

            public void listSelectionChanged(URLChooserEvent event) {
            }

            public void urlFilterChanged(URLChooserEvent event) {
                String currentURL = chooser.getFileNameURL();
                URLFilter current = event.getCurrentFilter();
                String newEnding = AbstractPublishPlugin.this.getExtensionForFilter(current);
                int index = currentURL.indexOf(".");
                if (index != -1) {
                    currentURL = currentURL.substring(0, index);
                }
                chooser.setFileNameURL(currentURL + newEnding);
            }
        };
        chooser.addURLChooserListener((URLChooserListener)adapter);
        HelpSystem.getHelpSystem().registerTopic((JComponent)chooser, rb.getString("ExportDiagramDialog.help"));
        if (chooser.showSaveDialog((Component)view, dialogTitle) != 0) {
            return false;
        }
        URL file = chooser.getSelectedURL();
        String hintedExtension = this.getExtensionForFilter(chooser.getSelectedFilter());
        if (URLFileSystem.exists((URL)(file = URLFileSystem.convertSuffix((URL)file, (String)URLFileSystem.getSuffix((URL)file), (String)hintedExtension)))) {
            String fileName = URLFileSystem.getFileName((URL)file);
            if (!MessageDialog.confirm((Component)view, (Object)MessageFormat.format(rb.getString("ExportDiagramFileExists.text"), fileName), (String)dialogTitle, null, (boolean)true)) {
                return false;
            }
        }
        s_lastUsedURLExport = URLFileSystem.getParent((URL)file);
        try {
            this.publishDiagram(file, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError memError) {
            MessageDialog.error((Component)view, (Object)rb.getString("ExportDiagramNoMemory.text"), (String)dialogTitle, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimensionFloat publishDiagram(URL file, Map clientProperties) throws Exception {
        URL parent = URLFileSystem.getParent((URL)file);
        if (!URLFileSystem.exists((URL)file)) {
            URLFileSystem.mkdirs((URL)parent);
        }
        ResourceBundle rb = PublishResources.getBundle();
        OutputStream out = URLFileSystem.openOutputStream((URL)file);
        IlvManagerView view = this.getDiagramContext().getManagerView();
        IlvManager mgr = view.getManager();
        IlvManagerView publishView = this.createPublishingView(mgr);
        DiagramContext diagramContext = DiagramContext.getDiagramContext(view);
        diagramContext.setManagerView(null);
        diagramContext.setManagerView(publishView);
        HideSelectionLayerFilter hideSelectionFilter = new HideSelectionLayerFilter(publishView);
        try {
            ManagerUtil.setLayerVisibilityFilter(hideSelectionFilter, mgr, true, true);
            publishView.setTransformer(view.getTransformer());
            ViewUtil.zoomActualSize(publishView, false);
            IlvRect rect = this.getViewExtent(publishView);
            rect.expand(1.0f);
            rect.x = (float)Math.floor((double)rect.x + 0.5);
            rect.y = (float)Math.floor((double)rect.y + 0.5);
            rect.width = (float)Math.floor((double)rect.width + 0.5);
            rect.height = (float)Math.floor((double)rect.height + 0.5);
            publishView.setBounds(view.getBounds());
            DimensionFloat size = new DimensionFloat(rect.width, rect.height);
            if (file.getPath().endsWith(".jpg")) {
                DimensionFloat dimensionFloat = this.doImageIO(publishView, rb, clientProperties, "jpg", out, rect, size);
                return dimensionFloat;
            }
            if (file.getPath().endsWith(".png")) {
                DimensionFloat dimensionFloat = this.doImageIO(publishView, rb, clientProperties, "png", out, rect, size);
                return dimensionFloat;
            }
            if (file.getPath().endsWith(".svgz")) {
                DimensionFloat dimensionFloat = this.doSVG(publishView, rb, clientProperties, out, rect, size, true);
                return dimensionFloat;
            }
            if (file.getPath().endsWith(".svg")) {
                DimensionFloat dimensionFloat = this.doSVG(publishView, rb, clientProperties, out, rect, size, false);
                return dimensionFloat;
            }
            DimensionFloat dimensionFloat = new DimensionFloat(0.0f, 0.0f);
            return dimensionFloat;
        }
        finally {
            diagramContext.setManagerView(null);
            diagramContext.setManagerView(view);
            ManagerUtil.removeLayerVisibilityFilter(hideSelectionFilter, mgr);
        }
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected abstract IlvManagerView createPublishingView(IlvManager var1);

    protected String getDocumentName() {
        Context context = this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        Node node = context.getNode();
        if (node != null) {
            return URLFileSystem.getName((URL)node.getURL());
        }
        return this.getDefaultDocumentName();
    }

    protected String getDefaultDocumentName() {
        ResourceBundle rb = PublishResources.getBundle();
        return rb.getString("GenericDocumentName.text");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimensionFloat doImageIO(IlvManagerView view, ResourceBundle rb, Map clientProperties, String imageType, OutputStream out, IlvRect rect, DimensionFloat size) throws Exception {
        long timingStart;
        long timingLast = timingStart = System.currentTimeMillis();
        String indent = "  ";
        Logger logger = LoggerUtils.getLoggerForClass(AbstractPublishPlugin.class);
        LoggerUtils.printHeader((Logger)logger, (String)"PublishPlugin.doImageIO()");
        IlvRect imageRect = new IlvRect(0.0f, 0.0f, (float)rect.widthFloor() + 40.0f, (float)rect.heightFloor() + 40.0f);
        BufferedImage image = new BufferedImage(imageRect.widthFloor(), imageRect.heightFloor(), 4);
        try {
            LoggerUtils.printTiming((Logger)logger, (long)(System.currentTimeMillis() - timingLast), (String)"Created BufferedImage", (String)"  ");
            timingLast = System.currentTimeMillis();
            Graphics2D g = (Graphics2D)image.getGraphics().create();
            HashMap<RenderingHints.Key, Object> map = new HashMap<RenderingHints.Key, Object>();
            map.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            map.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            map.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            map.put(DiagramRenderingHints.PUBLISH_RENDERING_HINT, Boolean.TRUE);
            g.setRenderingHints(new RenderingHints(map));
            LoggerUtils.printTiming((Logger)logger, (long)(System.currentTimeMillis() - timingLast), (String)"Created DrawingContext", (String)"  ");
            timingLast = System.currentTimeMillis();
            g.setColor(Color.white);
            g.fill((Shape)imageRect);
            g.translate(-1.0f * rect.x + 20.0f, -1.0f * rect.y + 20.0f);
            g.setClip((Shape)rect);
            IlvManager mgr = view.getManager();
            mgr.initReDraws();
            int redrawMode = view.getRedrawMode();
            try {
                mgr.invalidateRegion(rect);
            }
            finally {
                try {
                    view.setRedrawMode(1);
                    mgr.reDrawViews();
                }
                finally {
                    view.setRedrawMode(redrawMode);
                }
            }
            view.paint((Graphics)g);
            g.dispose();
            LoggerUtils.printTiming((Logger)logger, (long)(System.currentTimeMillis() - timingLast), (String)"Performed Drawing", (String)"  ");
            timingLast = System.currentTimeMillis();
            ImageIO.write((RenderedImage)image, imageType, out);
            LoggerUtils.printTiming((Logger)logger, (long)(System.currentTimeMillis() - timingLast), (String)"ImageIO.write()", (String)"  ");
            timingLast = System.currentTimeMillis();
            out.flush();
            out.close();
        }
        finally {
            if (image != null) {
                image.flush();
            }
        }
        LoggerUtils.printTiming((Logger)logger, (long)(System.currentTimeMillis() - timingStart), (String)"Overall doImageIO()", (String)"  ");
        return new DimensionFloat(imageRect.width, imageRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimensionFloat doSVG(IlvManagerView view, ResourceBundle rb, Map clientProperties, OutputStream out, IlvRect rect, DimensionFloat size, boolean gzip) throws Exception {
        if (gzip) {
            out = new GZIPOutputStream(out);
        }
        IlvRect imageRect = new IlvRect(0.0f, 0.0f, (float)rect.widthFloor() + 40.0f, (float)rect.heightFloor() + 40.0f);
        try {
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = domImpl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            svgGenerator.setSVGCanvasSize(new Dimension(imageRect.widthFloor(), imageRect.heightFloor()));
            String comment = MessageFormat.format(rb.getString("SVGComment.text"), this.getDocumentName());
            svgGenerator.getGeneratorContext().setComment(comment);
            RenderingHints map = svgGenerator.getRenderingHints();
            map.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            map.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            map.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            svgGenerator.setRenderingHints((Map)new RenderingHints(map));
            svgGenerator.setColor(Color.white);
            svgGenerator.fill((Shape)imageRect);
            svgGenerator.translate((double)(-1.0f * rect.x + 20.0f), (double)(-1.0f * rect.y + 20.0f));
            svgGenerator.setClip((Shape)rect);
            IlvManager mgr = view.getManager();
            mgr.initReDraws();
            int redrawMode = view.getRedrawMode();
            try {
                mgr.invalidateRegion(rect);
            }
            finally {
                try {
                    view.setRedrawMode(1);
                    mgr.reDrawViews();
                }
                finally {
                    view.setRedrawMode(redrawMode);
                }
            }
            view.paint((Graphics)svgGenerator);
            boolean useCSS = true;
            OutputStreamWriter outsw = new OutputStreamWriter(out, "UTF-8");
            svgGenerator.stream((Writer)outsw, useCSS);
            out.flush();
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return new DimensionFloat(imageRect.width, imageRect.height);
    }

    private static void ensureFilters() {
        try {
            ResourceBundle rb = PublishResources.getBundle();
            s_svgFilter = new WildcardURLFilter("*.svg", true, rb.getString("SVGFilter.text"));
            s_svgzFilter = new WildcardURLFilter("*.svgz", true, rb.getString("SVGZFilter.text"));
            s_jpgFilter = new WildcardURLFilter("*.jpg", true, rb.getString("JPGFilter.text"));
            s_pngFilter = new WildcardURLFilter("*.png", true, rb.getString("PNGFilter.text"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getExtensionForFilter(URLFilter current) {
        String newEnding = current == s_svgFilter ? ".svg" : (current == s_svgzFilter ? ".svgz" : (current == s_jpgFilter ? ".jpg" : ".png"));
        return newEnding;
    }

    private static class HideSelectionLayerFilter
    extends ExtendedLayerVisibilityFilter {
        private final IlvManagerView _view;

        HideSelectionLayerFilter(IlvManagerView view) {
            this._view = view;
        }

        public boolean isVisible(IlvManagerLayer layer, IlvManagerView managerView) {
            if (this._view == managerView) {
                return this.isVisible(layer);
            }
            return true;
        }

        public boolean isPersistent() {
            return false;
        }

        private boolean isVisible(IlvManagerLayer layer) {
            int layerCount;
            IlvManager manager = layer.getManager();
            int layerIndex = layer.getIndex();
            return layerIndex != (layerCount = manager.getLayersCount());
        }

        @Override
        public boolean isVisible(IlvManagerLayer layer, Graphics graphics) {
            return this.isVisible(layer);
        }
    }
}

