/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.diagram.framework.preference.propertyeditor.PropertyEditorFactoryDelegate;

public class IntegerRangePropertyEditor
extends PropertyEditorFactoryDelegate {
    public IntegerRangePropertyEditor(int minValue, int maxValue) {
        super(new RangePropertyEditor(minValue, maxValue), Integer.class);
    }

    private static class RangePropertyEditor
    implements PropertyEditor {
        private PropertyEditor _pe = PropertyEditorManager.findEditor(Integer.TYPE);
        private int _minValue;
        private int _maxValue;

        public RangePropertyEditor(int minValue, int maxValue) {
            this._minValue = minValue;
            this._maxValue = maxValue;
        }

        @Override
        public void setValue(Object value) {
            this.testValueRange(value);
            this._pe.setValue(value);
        }

        @Override
        public Object getValue() {
            return this._pe.getValue();
        }

        @Override
        public boolean isPaintable() {
            return this._pe.isPaintable();
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            this._pe.paintValue(gfx, box);
        }

        @Override
        public String getJavaInitializationString() {
            return this._pe.getJavaInitializationString();
        }

        @Override
        public String getAsText() {
            return this._pe.getAsText();
        }

        @Override
        public void setAsText(String text) {
            String trimmed;
            String string = trimmed = text != null ? text.trim() : null;
            if (trimmed != null && trimmed.length() > 0) {
                Integer value = null;
                try {
                    value = Integer.valueOf(trimmed);
                    this.testValueRange(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._pe.setAsText(text);
        }

        @Override
        public String[] getTags() {
            return this._pe.getTags();
        }

        @Override
        public Component getCustomEditor() {
            return this._pe.getCustomEditor();
        }

        @Override
        public boolean supportsCustomEditor() {
            return this._pe.supportsCustomEditor();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._pe.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._pe.removePropertyChangeListener(listener);
        }

        private void testValueRange(Object value) {
            if (value != null && value instanceof Integer && ((Integer)value < this._minValue || (Integer)value > this._maxValue)) {
                ResourceBundle rb = ResourceBundle.getBundle("oracle.diagram.res.PreferenceResource");
                String format = rb.getString("OutOfRangeErrorMessageFormat.text");
                String errorMessage = MessageFormat.format(format, this._minValue, this._maxValue);
                throw new IllegalArgumentException(errorMessage);
            }
        }
    }
}

