/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.features;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.features.StraightenLinkPlugin;

public class DefaultStraightenLinkPlugin
implements StraightenLinkPlugin {
    private final DiagramContext _context;

    public DefaultStraightenLinkPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public void straightenLink() {
        IlvManager manager = this._context.getManagerView().getManager();
        IlvGraphicVector links = new IlvGraphicVector();
        IlvGraphicEnumeration selection = manager.getSelectedObjects(true);
        while (selection.hasMoreElements()) {
            IlvLinkImage link;
            IlvGraphic element = selection.nextElement();
            if (!(element instanceof IlvLinkImage) || (link = (IlvLinkImage)element).getFrom() == link.getTo()) continue;
            links.addElement(element);
        }
        this.storeUndoRequirements(links.elements());
        IlvGraphicEnumeration e = links.elements();
        while (e.hasMoreElements()) {
            final IlvLinkImage lImage = (IlvLinkImage)e.nextElement();
            final IlvPoint fromPoint = lImage.getPointAt(0, null);
            final IlvPoint toPoint = lImage.getPointAt(lImage.getPointsCardinal() - 1, null);
            final IlvPoint[] newPoints = LinkUtil.calcStraightLine(lImage);
            if (newPoints == null) {
                this.changePolicyToOblique(lImage);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (lImage.getGraphicBag() != null) {
                        lImage.getGraphicBag().applyToObject((IlvGraphic)lImage, new IlvApplyObject(){

                            public void apply(IlvGraphic ilvgraphic, Object obj) {
                                lImage.movePoint(0, newPoints != null ? newPoints[0].x : fromPoint.x, newPoints != null ? newPoints[0].y : fromPoint.y, null);
                                lImage.movePoint(lImage.getPointsCardinal() - 1, newPoints != null ? newPoints[1].x : toPoint.x, newPoints != null ? newPoints[1].y : toPoint.y, null);
                                lImage.setIntermediateLinkPoints(null, 0, 0);
                            }
                        }, null, true);
                    } else {
                        lImage.movePoint(0, newPoints != null ? newPoints[0].x : fromPoint.x, newPoints != null ? newPoints[0].y : fromPoint.y, null);
                        lImage.movePoint(lImage.getPointsCardinal() - 1, newPoints != null ? newPoints[1].x : toPoint.x, newPoints != null ? newPoints[1].y : toPoint.y, null);
                        lImage.setIntermediateLinkPoints(null, 0, 0);
                    }
                }
            });
        }
        this.completeUndoRequirements();
    }

    @Override
    public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
    }

    protected void storeUndoRequirements(IlvGraphicEnumeration links) {
    }

    protected void completeUndoRequirements() {
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected void changePolicyToOblique(IlvLinkImage lImage) {
        if (lImage instanceof IlvPolicyAwareLinkImage) {
            ((IlvPolicyAwareLinkImage)lImage).setLinkShapePolicy(null);
            IlvClippingLinkConnector newFromCon = new IlvClippingLinkConnector();
            newFromCon.attach(lImage, true, false);
            IlvClippingLinkConnector newToCon = new IlvClippingLinkConnector();
            newToCon.attach(lImage, false, false);
        }
    }
}

