/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.linkconnector.IlvPinLinkConnector;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.framework.geom.GeomUtil;
import oracle.diagram.framework.geom.Vector2DUtil;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.diagram.logging.DiagramLogPage;
import oracle.diagram.logging.EmphasizedMessage;

public class LinkUtil {
    public static final int CLOSE_TO_LEFT = 1;
    public static final int CLOSE_TO_RIGHT = 2;
    public static final int CLOSE_TO_TOP = 4;
    public static final int CLOSE_TO_BOTTOM = 8;
    public static final String LINK_ORIGIN_INVALID_HINT = "Link origin coordinates are possibly invalid";
    public static final String LINK_DESTINATION_INVALID_HINT = "Link destination coordinates are possibly invalid";

    private LinkUtil() {
    }

    public static void updatePoints(IlvLinkImage link, IlvPoint[] ailvpoint, int i) {
        int pointsBefore = link.getPointsCardinal();
        int pointsAfterInter = 0;
        int pointsAfterFirstMove = 0;
        try {
            link.setIntermediateLinkPoints(ailvpoint, 1, i - 2);
            pointsAfterInter = link.getPointsCardinal();
            link.movePoint(0, ailvpoint[0].x, ailvpoint[0].y, null);
            pointsAfterFirstMove = link.getPointsCardinal();
            link.movePoint(link.getPointsCardinal() - 1, ailvpoint[i - 1].x, ailvpoint[i - 1].y, null);
        }
        catch (Exception npe) {
            System.out.println("---------- Start - Dumping points from updatePoints ----------");
            System.out.println("Number of Points to use from the array: " + i);
            System.out.println("pointsBefore => " + pointsBefore);
            System.out.println("pointsAfterInter => " + pointsAfterInter);
            System.out.println("pointsAfterFirstMove => " + pointsAfterFirstMove);
            System.out.println("final link.getPointsCardinal => " + link.getPointsCardinal());
            for (IlvPoint point : ailvpoint) {
                if (point != null) {
                    System.out.println("point => " + point.x + ", " + point.y);
                    continue;
                }
                System.out.println("That point is null and that is wrong");
            }
            System.out.println("---------- End - Dumping points from updatePoints ----------");
            npe.printStackTrace();
        }
    }

    public static void updatePointsWithApply(final IlvLinkImage link, final IlvPoint[] points, final int i) {
        if (link.getGraphicBag() != null) {
            link.getGraphicBag().applyToObject((IlvGraphic)link, new IlvApplyObject(){

                public void apply(IlvGraphic ilvgraphic, Object obj) {
                    LinkUtil.updatePoints(link, points, i);
                }
            }, null, true);
        } else {
            LinkUtil.updatePoints(link, points, i);
        }
    }

    public static int getRelativePosToRectangle(IlvPoint point, IlvRect rect) {
        float xDistToLeftCorner = Math.abs(rect.x - point.x);
        float xDistToRightCorner = Math.abs(rect.x + rect.width - point.x);
        float yDistToTopCorner = Math.abs(rect.y - point.y);
        float yDistToBottomCorner = Math.abs(rect.y + rect.height - point.y);
        if (rect.inside(point.x, point.y)) {
            if (xDistToLeftCorner < xDistToRightCorner) {
                if (yDistToTopCorner < yDistToBottomCorner) {
                    return xDistToLeftCorner >= yDistToTopCorner ? 4 : 1;
                }
                return xDistToLeftCorner >= yDistToBottomCorner ? 8 : 1;
            }
            if (yDistToTopCorner < yDistToBottomCorner) {
                return xDistToRightCorner >= yDistToTopCorner ? 4 : 2;
            }
            return xDistToRightCorner >= yDistToBottomCorner ? 8 : 2;
        }
        if (rect.x <= point.x && point.x <= rect.x + rect.width) {
            return point.y >= rect.y + 0.5f * rect.height ? 8 : 4;
        }
        if (rect.y <= point.y && point.y <= rect.y + rect.height) {
            return point.x >= rect.x + 0.5f * rect.width ? 2 : 1;
        }
        if (xDistToLeftCorner < xDistToRightCorner) {
            if (yDistToTopCorner < yDistToBottomCorner) {
                return xDistToLeftCorner >= yDistToTopCorner ? 1 : 4;
            }
            return xDistToLeftCorner >= yDistToBottomCorner ? 1 : 8;
        }
        if (yDistToTopCorner < yDistToBottomCorner) {
            return xDistToRightCorner >= yDistToTopCorner ? 2 : 4;
        }
        return xDistToRightCorner >= yDistToBottomCorner ? 2 : 8;
    }

    public static boolean isHorizontalToRectangle(IlvPoint point, IlvRect rect) {
        int i = LinkUtil.getRelativePosToRectangle(point, rect);
        return i == 1 || i == 2;
    }

    public static boolean isHorizontalRelativeToPoint(IlvPoint sPoint, IlvPoint basePoint) {
        float linearUp = basePoint.y - basePoint.x;
        float linearDown = basePoint.y + basePoint.x;
        return sPoint.y > sPoint.x + linearUp && sPoint.y < -sPoint.x + linearDown || sPoint.y > -sPoint.x + linearDown && sPoint.y < sPoint.x + linearUp;
    }

    public static boolean isLinkOrthogonal(IlvPoint[] points) {
        for (int i = 1; i < points.length; ++i) {
            if (points[i].x == points[i - 1].x || points[i].y == points[i - 1].y) continue;
            return false;
        }
        return true;
    }

    public static boolean isLinkEntirelyInShape(Shape shape, IlvPoint[] points) {
        for (int i = 1; i < points.length - 1; ++i) {
            if (shape.contains(points[i].x, points[i].y)) continue;
            return false;
        }
        return true;
    }

    public static boolean existsStraightRectilinearPath(IlvRect rect1, IlvRect rect2) {
        boolean exists = true;
        if ((rect1.x + rect1.width < rect2.x || rect1.x > rect2.x + rect2.width) && (rect1.y + rect1.height < rect2.y || rect1.y > rect2.y + rect2.height)) {
            exists = false;
        }
        return exists;
    }

    public static PathIterator getPathIterator(IlvGraphic node, IlvTransformer trans) {
        PathIterator pathIte;
        if (node == null) {
            throw new IllegalArgumentException("LinkUtil.getPathIterator - node is null");
        }
        PathIterator pathIterator = pathIte = node instanceof IlvShapePath ? ((IlvShapePath)node).getShapePath(trans) : node.boundingBox(trans).getPathIterator(new AffineTransform());
        assert (pathIte != null);
        return pathIte;
    }

    public static IlvPoint getOriginConnectionPoint(IlvLinkImage link, IlvTransformer trans, IlvPoint[] points) {
        IlvTransformer fromTransformer;
        IlvClippingLinkConnector clippingLinkConnector;
        IlvPoint point;
        IlvLinkConnector linkConnector = IlvLinkConnector.Get((IlvLinkImage)link, (boolean)true);
        if (linkConnector != null && linkConnector instanceof IlvClippingLinkConnector && (point = (clippingLinkConnector = (IlvClippingLinkConnector)linkConnector).getUnclippedConnectionPoint(link, true, fromTransformer = link.getFromTransformer(trans))) != null) {
            return point;
        }
        return points[0];
    }

    public static IlvPoint getDestinationConnectionPoint(IlvLinkImage link, IlvTransformer trans, IlvPoint[] points) {
        IlvClippingLinkConnector clippingLinkConnector;
        IlvPoint ilvpoint;
        IlvLinkConnector linkConnector = IlvLinkConnector.Get((IlvLinkImage)link, (boolean)false);
        if (linkConnector != null && linkConnector instanceof IlvClippingLinkConnector && (ilvpoint = (clippingLinkConnector = (IlvClippingLinkConnector)linkConnector).getUnclippedConnectionPoint(link, false, link.getToTransformer(trans))) != null) {
            return ilvpoint;
        }
        return points[points.length - 1];
    }

    public static IlvPoint[] getLinkPointsUnclipped(IlvLinkImage link, IlvTransformer trans) {
        IlvPoint[] points = link.getLinkPoints(trans);
        points[0] = LinkUtil.getOriginConnectionPoint(link, trans, points);
        points[points.length - 1] = LinkUtil.getDestinationConnectionPoint(link, trans, points);
        return points;
    }

    public static IlvPoint getClosestIntersectionPoint(IlvPoint controlPoint, IlvPoint attachPoint, PathIterator pathIte) {
        IlvPoint[] interPoint = LinkUtil.getClosestIntersectionPoint(new IlvPoint[]{controlPoint}, new IlvPoint[]{attachPoint}, pathIte);
        return interPoint[0] == null ? null : interPoint[0];
    }

    public static IlvPoint[] getClosestIntersectionPoint(IlvPoint[] cPoints, IlvPoint[] aPoints, PathIterator pathIte) {
        int i;
        int nbLines = cPoints.length;
        IlvPoint[] interPoint = new IlvPoint[nbLines];
        ArrayList interPoints = new ArrayList();
        for (int iCre = 0; iCre < nbLines; ++iCre) {
            interPoints.add(new ArrayList());
        }
        float[] lastMoveToPoint = new float[2];
        float[] segment = new float[6];
        IlvPoint[] segmentPoints = new IlvPoint[4];
        for (i = 0; i < segmentPoints.length; ++i) {
            segmentPoints[i] = new IlvPoint();
        }
        while (!pathIte.isDone()) {
            switch (pathIte.currentSegment(segment)) {
                case 0: {
                    lastMoveToPoint[0] = segment[0];
                    lastMoveToPoint[1] = segment[1];
                    segmentPoints[0].move(segment[0], segment[1]);
                    break;
                }
                case 1: {
                    int i2;
                    segmentPoints[1].move(segment[0], segment[1]);
                    IlvPoint interRes = new IlvPoint();
                    for (i2 = 0; i2 < nbLines; ++i2) {
                        if (!IlvClippingUtil.LineIntersectsSegment((IlvPoint)cPoints[i2], (IlvPoint)aPoints[i2], (IlvPoint)segmentPoints[0], (IlvPoint)segmentPoints[1], (IlvPoint)interRes)) continue;
                        ((ArrayList)interPoints.get(i2)).add(interRes);
                    }
                    segmentPoints[0].move(segment[0], segment[1]);
                    break;
                }
                case 2: {
                    int i2;
                    segmentPoints[1].move(segment[0], segment[1]);
                    segmentPoints[2].move(segment[2], segment[3]);
                    IlvPoint[] interRes = new IlvPoint[2];
                    for (i2 = 0; i2 < nbLines; ++i2) {
                        if (IlvClippingUtil.LineIntersectsQuadSpline((IlvPoint)cPoints[i2], (IlvPoint)aPoints[i2], (IlvPoint[])segmentPoints, (int)0, (IlvPoint[])interRes) <= 0) continue;
                        for (IlvPoint iPoint : interRes) {
                            if (iPoint == null) continue;
                            ((ArrayList)interPoints.get(i2)).add(iPoint);
                        }
                    }
                    segmentPoints[0].move(segment[2], segment[3]);
                    break;
                }
                case 3: {
                    int i2;
                    segmentPoints[1].move(segment[0], segment[1]);
                    segmentPoints[2].move(segment[2], segment[3]);
                    segmentPoints[3].move(segment[4], segment[5]);
                    IlvPoint[] interRes = new IlvPoint[3];
                    for (i2 = 0; i2 < nbLines; ++i2) {
                        if (LinkUtil.lineIntersectsCubicSpline(cPoints[i2], aPoints[i2], segmentPoints, 0, interRes) <= 0) continue;
                        for (IlvPoint iPoint : interRes) {
                            if (iPoint == null) continue;
                            ((ArrayList)interPoints.get(i2)).add(iPoint);
                        }
                    }
                    segmentPoints[0].move(segment[4], segment[5]);
                    break;
                }
                case 4: {
                    int i2;
                    if (segmentPoints[0].x == lastMoveToPoint[0] && segmentPoints[0].y == lastMoveToPoint[1]) break;
                    IlvPoint interRes = new IlvPoint();
                    for (i2 = 0; i2 < nbLines; ++i2) {
                        if (!IlvClippingUtil.LineIntersectsSegment((IlvPoint)cPoints[i2], (IlvPoint)aPoints[i2], (IlvPoint)segmentPoints[0], (IlvPoint)new IlvPoint(lastMoveToPoint[0], lastMoveToPoint[1]), (IlvPoint)interRes)) continue;
                        ((ArrayList)interPoints.get(i2)).add(interRes);
                    }
                    break;
                }
            }
            pathIte.next();
        }
        for (i = 0; i < nbLines; ++i) {
            List iPoints = (List)interPoints.get(i);
            if (iPoints.size() <= 0) continue;
            IlvPoint[] arrayInterPoints = iPoints.toArray(new IlvPoint[iPoints.size()]);
            interPoint[i] = IlvClippingUtil.BestClipPointOnRay((IlvPoint)aPoints[i], (IlvPoint)cPoints[i], (IlvPoint[])arrayInterPoints, (int)arrayInterPoints.length);
            boolean inArray = false;
            for (int j = 0; j < arrayInterPoints.length && !inArray; ++j) {
                if (!arrayInterPoints[j].equals((Object)interPoint[i])) continue;
                inArray = true;
            }
            if (inArray) continue;
            interPoint[i] = null;
        }
        return interPoint;
    }

    public static IlvPoint getClosestIntersectionPoint(Point2D controlPoint, Point2D attachPoint, PathIterator pathIte) {
        IlvPoint cPoint = new IlvPoint((float)controlPoint.getX(), (float)controlPoint.getY());
        IlvPoint aPoint = new IlvPoint((float)attachPoint.getX(), (float)attachPoint.getY());
        return LinkUtil.getClosestIntersectionPoint(cPoint, aPoint, pathIte);
    }

    private static void logIntersection(IlvPoint cPoint, IlvPoint aPoint, IlvPoint[] sPoints, IlvPoint res, String message) {
        DiagramLogPage msgPage = DiagramLogPage.makeDiagramLogPage();
        msgPage.log((Object)new EmphasizedMessage("--- Starting Intersection Info: " + message + " ---\n"));
        msgPage.log("Control Point = [" + cPoint.x + "," + cPoint.y + "]\n");
        msgPage.log("Attach Point = [" + aPoint.x + "," + aPoint.y + "]\n");
        if (sPoints != null) {
            msgPage.logPointArray(sPoints, "Solutions");
        } else {
            msgPage.log("NO Solutions\n");
        }
        if (res != null) {
            msgPage.log("Result = [" + res.x + "," + res.y + "]\n");
        } else {
            msgPage.log("Result = None\n");
        }
        msgPage.log((Object)new EmphasizedMessage("--- Ending Intersection Info: " + message + " ---\n"));
    }

    private static boolean checkPointInList(IlvPoint p, IlvPoint[] pList) {
        boolean pointIsIn = false;
        for (IlvPoint point : pList) {
            if (point == null || !point.equals((Object)p)) continue;
            pointIsIn = true;
        }
        return pointIsIn;
    }

    public static boolean isPointInLine(Point2D p1, Point2D p2, Point2D pointToSearch) {
        boolean pointInLine = false;
        double quot = p1.getX() - p2.getX();
        if (quot != 0.0) {
            double a = (p1.getY() - p2.getY()) / quot;
            double b = p1.getY() - a * p1.getX();
            if (pointToSearch.getY() == a * pointToSearch.getX() + b) {
                pointInLine = true;
            }
        } else if (pointToSearch.getX() == p1.getX()) {
            pointInLine = true;
        }
        return pointInLine;
    }

    public static boolean isPointInSegment(Point2D p1, Point2D p2, Point2D pointToSearch) {
        if (pointToSearch.getX() > p1.getX() && pointToSearch.getX() > p2.getX() || pointToSearch.getX() < p1.getX() && pointToSearch.getX() < p2.getX() || pointToSearch.getY() > p1.getY() && pointToSearch.getY() > p2.getY() || pointToSearch.getY() < p1.getY() && pointToSearch.getY() < p2.getY()) {
            return false;
        }
        return LinkUtil.isPointInLine(p1, p2, pointToSearch);
    }

    public static int lineIntersectsCubicSpline(IlvPoint ilvpoint, IlvPoint ilvpoint1, IlvPoint[] ailvpoint, int i, IlvPoint[] ailvpoint1) {
        int nbInters = IlvClippingUtil.LineIntersectsCubicSpline((IlvPoint)ilvpoint, (IlvPoint)ilvpoint1, (IlvPoint[])ailvpoint, (int)i, (IlvPoint[])ailvpoint1);
        boolean startIn = LinkUtil.isPointInSegment((Point2D)ilvpoint, (Point2D)ilvpoint1, (Point2D)ailvpoint[0]);
        boolean endIn = LinkUtil.isPointInSegment((Point2D)ilvpoint, (Point2D)ilvpoint1, (Point2D)ailvpoint[ailvpoint.length - 1]);
        if (!LinkUtil.checkPointInList(ailvpoint[0], ailvpoint1) && startIn) {
            ailvpoint1[nbInters++] = new IlvPoint(ailvpoint[0]);
        }
        if (!LinkUtil.checkPointInList(ailvpoint[ailvpoint.length - 1], ailvpoint1) && endIn) {
            ailvpoint1[nbInters++] = new IlvPoint(ailvpoint[ailvpoint.length - 1]);
        }
        return nbInters;
    }

    public static boolean isSegmentOrthogonal(IlvPoint p1, IlvPoint p2) {
        boolean isOrtho = false;
        if (p1.x == p2.x || p1.y == p2.y) {
            isOrtho = true;
        }
        return isOrtho;
    }

    public static IlvPoint[] truncateLink(IlvPoint[] points, IlvLinkImage link, IlvTransformer trans, float errorTolerance) {
        ArrayList<IlvPoint> newPointList = new ArrayList<IlvPoint>();
        IlvRect fromBox = LinkUtil.getFromBoundingBox(link, trans);
        IlvRect toBox = LinkUtil.getToBoundingBox(link, trans);
        IlvTransformer fromTrans = new IlvTransformer();
        fromTrans.postCompose(link.getFromTransformer(trans));
        IlvGraphic fromNode = LinkUtil.getEndGraphic(link, true);
        PathIterator fromPathIte = fromNode instanceof IlvShapePath ? ((IlvShapePath)fromNode).getShapePath(fromTrans) : fromBox.getPathIterator(new AffineTransform());
        IlvTransformer toTrans = new IlvTransformer();
        toTrans.postCompose(link.getToTransformer(trans));
        IlvGraphic toNode = LinkUtil.getEndGraphic(link, false);
        PathIterator toPathIte = toNode instanceof IlvShapePath ? ((IlvShapePath)toNode).getShapePath(toTrans) : toBox.getPathIterator(new AffineTransform());
        GeneralPath fromPath = new GeneralPath();
        fromPath.append(fromPathIte, false);
        GeneralPath toPath = new GeneralPath();
        toPath.append(toPathIte, false);
        IlvPoint changedFromPoint = points[0];
        IlvPoint changedToPoint = points[points.length - 1];
        int firstFromPointIndex = 1;
        int firstToPointIndex = -1;
        boolean fromIsPinned = IlvLinkConnector.Get((IlvLinkImage)link, (boolean)true) instanceof IlvPinLinkConnector;
        boolean toIsPinned = IlvLinkConnector.Get((IlvLinkImage)link, (boolean)false) instanceof IlvPinLinkConnector;
        for (int i = 1; i < points.length && firstToPointIndex < 0; ++i) {
            float lowX = points[i - 1].x <= points[i].x ? points[i - 1].x : points[i].x;
            lowX -= errorTolerance;
            float highX = points[i - 1].x <= points[i].x ? points[i].x : points[i - 1].x;
            highX += errorTolerance;
            float lowY = points[i - 1].y <= points[i].y ? points[i - 1].y : points[i].y;
            lowY -= errorTolerance;
            float highY = points[i - 1].y <= points[i].y ? points[i].y : points[i - 1].y;
            highY += errorTolerance;
            if (!fromIsPinned) {
                IlvPoint interFromPt = LinkUtil.getClosestIntersectionPoint(points[i], points[i - 1], fromPath.getPathIterator(new AffineTransform()));
                if (!(interFromPt == null || lowX <= interFromPt.x && interFromPt.x <= highX && lowY <= interFromPt.y && interFromPt.y <= highY || i == 1)) {
                    interFromPt = null;
                }
                if (interFromPt != null) {
                    changedFromPoint = interFromPt;
                    firstFromPointIndex = i;
                }
            }
            float lowXTo = points[i - 1].x <= points[i].x ? points[i - 1].x : points[i].x;
            lowXTo -= errorTolerance;
            float highXTo = points[i - 1].x <= points[i].x ? points[i].x : points[i - 1].x;
            highXTo += errorTolerance;
            float lowYTo = points[i - 1].y <= points[i].y ? points[i - 1].y : points[i].y;
            lowYTo -= errorTolerance;
            float highYTo = points[i - 1].y <= points[i].y ? points[i].y : points[i - 1].y;
            highYTo += errorTolerance;
            if (toIsPinned) continue;
            IlvPoint interToPt = LinkUtil.getClosestIntersectionPoint(points[i - 1], points[i], toPath.getPathIterator(new AffineTransform()));
            if (!(interToPt == null || lowXTo <= interToPt.x && interToPt.x <= highXTo && lowYTo <= interToPt.y && interToPt.y <= highYTo || i == points.length - 1)) {
                interToPt = null;
            }
            if (interToPt == null) continue;
            changedToPoint = interToPt;
            firstToPointIndex = i;
        }
        if (toIsPinned) {
            firstToPointIndex = points.length - 1;
        }
        newPointList.add(changedFromPoint);
        for (int j = firstFromPointIndex; j < firstToPointIndex; ++j) {
            newPointList.add(points[j]);
        }
        newPointList.add(changedToPoint);
        return newPointList.toArray(new IlvPoint[newPointList.size()]);
    }

    public static IlvPoint[] cleanLinkFromCycles(IlvPoint[] points) {
        HashMap<IlvPoint, CyclePoint> cycleFree = new HashMap<IlvPoint, CyclePoint>();
        int index = 0;
        for (IlvPoint p : points) {
            CyclePoint cp = (CyclePoint)cycleFree.get(p);
            if (cp == null) {
                cp = new CyclePoint(index, 1);
                cycleFree.put(p, cp);
            } else {
                cp.next = index;
                ++cp.nbOccurences;
            }
            ++index;
        }
        ArrayList<IlvPoint> pList = new ArrayList<IlvPoint>();
        pList.add(points[0]);
        for (int i = 1; i < points.length - 1; ++i) {
            IlvPoint p = points[i];
            CyclePoint cp = (CyclePoint)cycleFree.get(p);
            if (cp == null) {
                return null;
            }
            if (cp.next == i) {
                pList.add(p);
                continue;
            }
            if (cp.nbOccurences % 2 != 0) {
                pList.add(p);
            }
            i = cp.next;
        }
        pList.add(points[points.length - 1]);
        return pList.toArray(new IlvPoint[pList.size()]);
    }

    public static void reconnect(IlvGraphic target, IlvLinkImage link, IlvPoint connectionPoint, boolean reconnectSource) {
        if (target != null) {
            GraphicConnector gc = GraphicConnector.findConnector(target);
            if (gc != null) {
                LinkUtil.reconnectUnified(target, link, connectionPoint, reconnectSource);
                return;
            }
            IlvLinkConnector ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)target);
            if (ilvlinkconnector != null) {
                LinkUtil.reconnectLinkConnector(target, link, connectionPoint, reconnectSource);
                return;
            }
            LinkUtil.reconnectBruteForce(target, link, reconnectSource);
            return;
        }
    }

    private static void reconnectUnified(IlvGraphic target, IlvLinkImage link, IlvPoint connectionPoint, boolean reconnectSource) {
        GraphicConnector gc = GraphicConnector.findConnector(target);
        IlvManager mgr = ManagerUtil.getTransformingManager(target);
        IlvManager linkMgr = (IlvManager)link.getGraphicBag();
        IlvTransformer t = ManagerUtil.getConversionTransformer(linkMgr, mgr);
        gc.connectLink(link, connectionPoint, reconnectSource, t);
    }

    private static void reconnectLinkConnector(IlvGraphic target, IlvLinkImage link, IlvPoint connectionPoint, boolean reconnectSource) {
        IlvLinkConnector ilvlinkconnector = IlvLinkConnector.GetAttached((IlvGraphic)target);
        IlvManager mgr = ManagerUtil.getTransformingManager(target);
        IlvManager linkMgr = (IlvManager)link.getGraphicBag();
        IlvTransformer t = ManagerUtil.getConversionTransformer(linkMgr, mgr);
        if (ilvlinkconnector != null) {
            ilvlinkconnector.connectLink(link, connectionPoint, reconnectSource, t);
        }
    }

    public static void reconnectBruteForce(IlvGraphic target, IlvLinkImage link, boolean reconnectSource) {
        IlvManager mgr = (IlvManager)link.getGraphicBag();
        int layer = mgr.getLayer((IlvGraphic)link);
        if (mgr instanceof IlvGrapher) {
            mgr.removeObject((IlvGraphic)link, false);
        }
        if (reconnectSource) {
            link.setFrom(target);
        } else {
            link.setTo(target);
        }
        IlvGrapher grapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)link.getFrom(), (IlvGraphic)link.getTo());
        grapher.addLink(link, layer, false);
    }

    public static IlvPoint[] calcStraightLine(IlvLinkImage link) {
        IlvRect toBox;
        IlvPoint[] newPoints = null;
        IlvRect fromBox = LinkUtil.getFromBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER);
        if (LinkUtil.existsStraightRectilinearPath(fromBox, toBox = LinkUtil.getToBoundingBox(link, TransformerUtil.IDENTITY_TRANSFORMER))) {
            IlvPoint[] linkPoints = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
            IlvTransformer fromTrans = new IlvTransformer();
            fromTrans.postCompose(link.getFromTransformer(TransformerUtil.IDENTITY_TRANSFORMER));
            IlvGraphic fromNode = LinkUtil.getEndGraphic(link, true);
            PathIterator fromPathIte = fromNode instanceof IlvShapePath ? ((IlvShapePath)fromNode).getShapePath(fromTrans) : fromBox.getPathIterator(new AffineTransform());
            IlvTransformer toTrans = new IlvTransformer();
            toTrans.postCompose(link.getToTransformer(TransformerUtil.IDENTITY_TRANSFORMER));
            IlvGraphic toNode = LinkUtil.getEndGraphic(link, false);
            PathIterator toPathIte = toNode instanceof IlvShapePath ? ((IlvShapePath)toNode).getShapePath(toTrans) : toBox.getPathIterator(new AffineTransform());
            GeneralPath fromPath = new GeneralPath();
            fromPath.append(fromPathIte, false);
            GeneralPath toPath = new GeneralPath();
            toPath.append(toPathIte, false);
            IlvPoint toCenterPoint = new IlvPoint((float)toBox.getCenterX(), (float)toBox.getCenterY());
            if (LinkUtil.isHorizontalToRectangle(toCenterPoint, fromBox)) {
                float[] yInterval = GeomUtil.getRangeIntersection(fromBox.y, fromBox.y + fromBox.height, toBox.y, toBox.y + toBox.height);
                if (yInterval != null) {
                    float newY = (yInterval[0] + yInterval[1]) / 2.0f;
                    newPoints = new IlvPoint[]{new IlvPoint(linkPoints[0].x, newY), new IlvPoint(linkPoints[linkPoints.length - 1].x, newY)};
                }
            } else {
                float[] xInterval = GeomUtil.getRangeIntersection(fromBox.x, fromBox.x + fromBox.width, toBox.x, toBox.x + toBox.width);
                if (xInterval != null) {
                    float newX = (xInterval[0] + xInterval[1]) / 2.0f;
                    newPoints = new IlvPoint[]{new IlvPoint(newX, linkPoints[0].y), new IlvPoint(newX, linkPoints[linkPoints.length - 1].y)};
                }
            }
        }
        return newPoints;
    }

    public static IlvPoint[] fetchStraightLine(IlvLinkImage link) {
        IlvPoint[] line = new IlvPoint[2];
        IlvPoint[] linkPoints = LinkUtil.getLinkPointsUnclipped(link, TransformerUtil.IDENTITY_TRANSFORMER);
        IlvPoint srcPoint = linkPoints[0];
        IlvPoint dstPoint = linkPoints[linkPoints.length - 1];
        IlvPoint[] cPoints = new IlvPoint[2];
        IlvPoint[] aPoints = new IlvPoint[2];
        IlvTransformer trans = new IlvTransformer();
        IlvRect toBox = LinkUtil.getToBoundingBox(link, trans);
        IlvTransformer toTrans = new IlvTransformer();
        toTrans.postCompose(link.getToTransformer(trans));
        IlvGraphic toNode = LinkUtil.getEndGraphic(link, false);
        PathIterator toPathIte = toNode instanceof IlvShapePath ? ((IlvShapePath)toNode).getShapePath(toTrans) : toBox.getPathIterator(new AffineTransform());
        cPoints[0] = new IlvPoint(srcPoint.x, srcPoint.y);
        aPoints[0] = new IlvPoint(dstPoint.x, srcPoint.y);
        cPoints[1] = new IlvPoint(srcPoint.x, srcPoint.y);
        aPoints[1] = new IlvPoint(srcPoint.x, dstPoint.y);
        IlvPoint[] toInters = LinkUtil.getClosestIntersectionPoint(cPoints, aPoints, toPathIte);
        boolean found = false;
        for (int i = 0; i < toInters.length && !found; ++i) {
            IlvPoint p = toInters[i];
            if (p == null) continue;
            line[0] = cPoints[i];
            line[1] = aPoints[i];
            found = true;
        }
        if (found) {
            return line;
        }
        IlvRect fromBox = LinkUtil.getFromBoundingBox(link, trans);
        IlvTransformer fromTrans = new IlvTransformer();
        fromTrans.postCompose(link.getFromTransformer(trans));
        IlvGraphic fromNode = LinkUtil.getEndGraphic(link, true);
        PathIterator fromPathIte = fromNode instanceof IlvShapePath ? ((IlvShapePath)fromNode).getShapePath(fromTrans) : fromBox.getPathIterator(new AffineTransform());
        cPoints[0] = new IlvPoint(srcPoint.x, dstPoint.y);
        aPoints[0] = new IlvPoint(dstPoint.x, dstPoint.y);
        cPoints[1] = new IlvPoint(dstPoint.x, srcPoint.y);
        aPoints[1] = new IlvPoint(dstPoint.x, dstPoint.y);
        IlvPoint[] fromInters = LinkUtil.getClosestIntersectionPoint(cPoints, aPoints, fromPathIte);
        for (int i = 0; i < fromInters.length && !found; ++i) {
            IlvPoint p = fromInters[i];
            if (p == null) continue;
            line[0] = cPoints[i];
            line[1] = aPoints[i];
            found = true;
        }
        if (found) {
            return line;
        }
        return null;
    }

    public static IlvGraphic getConnectedEnd(IlvLinkImage link, boolean origin) {
        GraphicConnector connector;
        if (link == null) {
            throw new IllegalArgumentException("Link is null");
        }
        IlvGraphic connectedEnd = null;
        GraphicPin pin = GraphicPin.findPin(link, origin);
        if (pin != null && (connector = pin.getConnector()) != null) {
            connectedEnd = connector.getGraphic();
        }
        return connectedEnd;
    }

    public static IlvGraphic getEndGraphic(IlvLinkImage link, boolean origin) {
        IlvGraphic jviewsEnd;
        if (link == null) {
            throw new IllegalArgumentException("Link is null");
        }
        IlvGraphic visibleEnd = origin ? link.getVisibleFrom() : link.getVisibleTo();
        IlvGraphic ilvGraphic = jviewsEnd = origin ? link.getFrom() : link.getTo();
        if (visibleEnd != jviewsEnd) {
            return visibleEnd;
        }
        return LinkUtil.getConnectedEnd(link, origin);
    }

    public static IlvPoint calcLinkMidPoint(IlvLinkImage link) {
        float TOLERANCE = 1.0E-4f;
        if (link == null) {
            throw new IllegalArgumentException("Link is null");
        }
        IlvPoint[] points = link.getLinkPoints(null);
        IlvPoint mp = new IlvPoint();
        float halfLength = LinkUtil.calcLength(points) / 2.0f;
        for (int i = 1; i < points.length; ++i) {
            IlvPoint p1 = points[i - 1];
            IlvPoint p2 = points[i];
            if (Math.abs(halfLength -= (float)Point2D.distance(p1.x, p1.y, p2.x, p2.y)) <= 1.0E-4f) {
                mp.setLocation((Point2D)p2);
                break;
            }
            if (!(halfLength < 0.0f)) continue;
            float[] p = new float[2];
            Vector2DUtil.unit(p2.x - p1.x, p2.y - p1.y, p);
            mp.x = p2.x + halfLength * p[0];
            mp.y = p2.y + halfLength * p[1];
            break;
        }
        return mp;
    }

    static float calcLength(IlvPoint[] linkPoints) {
        float length = 0.0f;
        for (int i = 1; i < linkPoints.length; ++i) {
            IlvPoint p1 = linkPoints[i - 1];
            IlvPoint p2 = linkPoints[i];
            length += (float)Point2D.distance(p1.x, p1.y, p2.x, p2.y);
        }
        return length;
    }

    public static boolean isOriginVisible(IlvLinkImage link) {
        if (link == null) {
            throw new IllegalArgumentException("Argument link must not be null");
        }
        if (link.getFrom() != link.getVisibleFrom()) {
            return false;
        }
        return CoreGraphicUtils.isReallyVisible(link.getFrom());
    }

    public static boolean isDestinationVisible(IlvLinkImage link) {
        if (link == null) {
            throw new IllegalArgumentException("Argument link must not be null");
        }
        if (link.getTo() != link.getVisibleTo()) {
            return false;
        }
        return CoreGraphicUtils.isReallyVisible(link.getTo());
    }

    public static boolean isIntergraphLink(IlvLinkImage link) {
        if (link == null || link.getGraphicBag() == null) {
            return false;
        }
        return link.getFrom().getGraphicBag() != link.getTo().getGraphicBag();
    }

    public static IlvRect getFromBoundingBox(IlvLinkImage link, IlvTransformer t) {
        IlvGraphic visibleFromGraphic;
        IlvGraphic endGraphic = LinkUtil.getEndGraphic(link, true);
        IlvGraphic fromGraphic = link.getFrom();
        if (fromGraphic != (visibleFromGraphic = link.getVisibleFrom())) {
            return visibleFromGraphic.boundingBox(t);
        }
        if (endGraphic == null || endGraphic == fromGraphic) {
            return link.getFromBoundingBox(t);
        }
        IlvRect bbox = new IlvRect(endGraphic.boundingBox(null));
        IlvGraphic managed = CoreGraphicUtils.getManagedParentNode(endGraphic);
        if (managed == null) {
            return link.getFromBoundingBox(t);
        }
        IlvManager endManager = ManagerUtil.getManager(managed);
        IlvManager linkManager = ManagerUtil.getManager((IlvGraphic)link);
        if (linkManager != endManager) {
            ManagerUtil.getConversionTransformer(linkManager, endManager).apply(bbox);
        }
        if (t != null) {
            t.apply(bbox);
        }
        return bbox;
    }

    public static IlvRect getToBoundingBox(IlvLinkImage link, IlvTransformer t) {
        IlvGraphic visibleToGraphic;
        IlvGraphic endGraphic = LinkUtil.getEndGraphic(link, false);
        IlvGraphic toGraphic = link.getVisibleTo();
        if (toGraphic != (visibleToGraphic = link.getVisibleTo())) {
            return visibleToGraphic.boundingBox(t);
        }
        if (endGraphic == null || endGraphic == toGraphic) {
            return link.getToBoundingBox(t);
        }
        IlvRect bbox = new IlvRect(endGraphic.boundingBox(null));
        IlvGraphic managed = CoreGraphicUtils.getManagedParentNode(endGraphic);
        if (managed == null) {
            return link.getToBoundingBox(t);
        }
        IlvManager endManager = ManagerUtil.getManager(managed);
        IlvManager linkManager = ManagerUtil.getManager((IlvGraphic)link);
        if (linkManager != endManager) {
            ManagerUtil.getConversionTransformer(linkManager, endManager).apply(bbox);
        }
        if (t != null) {
            t.apply(bbox);
        }
        return bbox;
    }

    private static class CyclePoint {
        public int next;
        public int nbOccurences;

        public CyclePoint(int next, int nbOccurences) {
            this.next = next;
            this.nbOccurences = nbOccurences;
        }
    }

    public static enum AreaOverlap {
        NO_OVERLAP,
        OVERLAP_TOP,
        OVERLAP_RIGHT,
        OVERLAP_BOTTOM,
        OVERLAP_LEFT;

    }
}

