/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewDecoration;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.NavigationKeyListener;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.interaction.DefaultObjectInteractorCache;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.interaction.LinkReconnectInteractor;
import oracle.diagram.framework.interaction.SelectInteractorMoveSelection;
import oracle.diagram.framework.menu.DiagramContextMenuPlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubSelectableShape;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class SelectInteractor
extends CoreSelectInteractor {
    private SubSelectViewDecoration _subSelectViewDecoration = new SubSelectViewDecoration();
    private DefaultObjectInteractorCache _defaultInteractors = new DefaultObjectInteractorCache(SelectInteractor.class.getPackage().getName(), "ReadOnly");

    public SelectInteractor() {
        this.setEditionAllowed(true);
        this.setMultipleSelectionMode(true);
        this.addKeyListener(new NavigationKeyListener());
    }

    protected final DiagramContext getDiagramContext() {
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            throw new IllegalStateException("Interactor is not attached to a view");
        }
        return DiagramContext.getDiagramContext(view);
    }

    protected void attach(IlvManagerView v) {
        super.attach(v);
        v.addViewDecoration((IlvManagerViewDecoration)this._subSelectViewDecoration);
    }

    @Override
    protected void detach() {
        this.getManagerView().removeViewDecoration((IlvManagerViewDecoration)this._subSelectViewDecoration);
        super.detach();
    }

    public void deSelectObject(IlvGraphic obj) {
        super.deSelectObject(obj);
        SubSelectionManager.getInstance().clearAnchorSelection();
    }

    public void selectObject(IlvGraphic obj) {
        super.selectObject(obj);
        SubSelectionManager.getInstance().clearAnchorSelection();
    }

    @Override
    protected IlvGraphic getSubHitObject(IlvGraphic hit, IlvManagerView view, IlvPoint point) {
        if (hit instanceof SubSelectableShape) {
            return SubSelectionManager.getInstance().getSubObject(hit, point, view);
        }
        return null;
    }

    @Override
    protected boolean isSubHitObjectSelectable(IlvGraphic mainObject, IlvGraphic subObject) {
        if (mainObject instanceof SubSelectableShape) {
            return SubSelectionManager.getInstance().isSubObjectSelectable(mainObject, subObject);
        }
        return false;
    }

    @Override
    protected void deSelectAllSubObjects() {
        SubSelectionManager.getInstance().deselectAll(this.getManager(), true);
    }

    @Override
    protected boolean isSubObjectSelected(IlvGraphic mainObject, IlvGraphic subObject) {
        if (mainObject instanceof SubSelectableShape) {
            return ((SubSelectableShape)mainObject).isSubShapeSelected(subObject);
        }
        return false;
    }

    @Override
    protected boolean canExtendSubObjectSelection(IlvGraphic mainObject, IlvGraphic subObject) {
        if (mainObject instanceof SubSelectableShape) {
            return SubSelectionManager.getInstance().canExtendSelection(mainObject, subObject);
        }
        return false;
    }

    @Override
    protected void extendSubObjectSelection(IlvGraphic mainObject, IlvGraphic subObject) {
        if (mainObject instanceof SubSelectableShape) {
            SubSelectionManager.getInstance().extendSelection(mainObject, subObject, true);
        }
    }

    @Override
    protected void selectSubObject(IlvGraphic mainObject, IlvGraphic subObject) {
        if (mainObject instanceof SubSelectableShape) {
            SubSelectionManager.getInstance().select(mainObject, subObject, true, true);
        }
    }

    @Override
    protected void deSelectSubObject(IlvGraphic mainObject, IlvGraphic subObject) {
        if (mainObject instanceof SubSelectableShape) {
            SubSelectionManager.getInstance().select(mainObject, subObject, false, true);
        }
    }

    @Override
    protected void showContextMenu(MouseEvent event) {
        DiagramContextMenuPlugin dcmp = PluginUtil.getPlugin(this.getDiagramContext(), DiagramContextMenuPlugin.class);
        if (dcmp != null) {
            dcmp.showContextMenu(event);
        }
    }

    @Override
    protected IlvManagerViewInteractor getMoveSelectionInteractor() {
        return new SelectInteractorMoveSelection(this);
    }

    @Override
    public IlvGraphicEnumeration getSelectedMovingSubObjects(IlvManager manager) {
        return SubSelectionManager.getInstance().getSelectedSubObjects(manager);
    }

    protected void drawGhostMove(Graphics g, IlvGraphic obj, IlvRect rect) {
        IlvGraphicBag bag = obj.getGraphicBag();
        while (!(bag instanceof IlvManager)) {
            bag = bag.getGraphicBag();
        }
        IlvTransformer t = ((IlvManager)bag).getDrawingTransformer(this.getManagerView());
        IlvRect r = obj.boundingBox(t);
        IlvTransformer t1 = new IlvTransformer(new IlvPoint(rect.x - r.x, rect.y - r.y));
        t.compose(t1);
        obj.draw(g, t);
    }

    protected final boolean isEditable(IlvManager mgr, IlvGraphic hit, IlvGraphic subHit) {
        IlvGraphic toEdit = subHit != null ? subHit : hit;
        return toEdit instanceof IlvLabelInterface;
    }

    @Override
    protected boolean performInPlaceEdit(IlvManager mgr, IlvGraphic hit, IlvGraphic subHit, IlvPoint point, MouseEvent event) {
        if (!this.isWithinLabel(mgr, hit, subHit, point, event)) {
            return false;
        }
        InPlaceEditPlugin plugin = PluginUtil.getPlugin(this.getManagerView(), InPlaceEditPlugin.class);
        if (plugin != null) {
            return plugin.performInPlaceEdit(mgr, hit, subHit);
        }
        return false;
    }

    @Override
    protected IlvSelection getActiveSelection(IlvManager mgr, IlvPoint point, IlvManagerView view) {
        IlvSelection sel;
        IlvGraphic subHit;
        IlvManager topManager = this.getManager();
        IlvGraphic obj = topManager.getObject(point, view, true);
        if (obj instanceof SubSelectableShape && (subHit = this.getSubHitObject(obj, view, point)) != null && (sel = SubSelectionManager.getInstance().getSelection(obj, subHit)) != null) {
            return sel;
        }
        return super.getActiveSelection(mgr, point, view);
    }

    @Override
    protected IlvManagerViewInteractor getLinkReconnectInteractor() {
        return new LinkReconnectInteractor(this);
    }

    @Override
    protected boolean isSubSelectionMovable(IlvManager manager) {
        IlvGraphicEnumeration selection = this.getSelectedMovingSubObjects(manager);
        return selection != null && selection.hasMoreElements();
    }

    @Override
    protected boolean performEdit(IlvManager mgr, IlvGraphic hitObj, IlvGraphic subHitObj) {
        IdeAction action = IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES);
        if (action != null) {
            Context context = this.getContext();
            action.updateAction(context);
            if (action.isEnabled()) {
                try {
                    action.performAction(context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected Context getContext() {
        return this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
    }

    public boolean isMoveAllowed() {
        return super.isMoveAllowed() && !ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext());
    }

    public boolean isEditionAllowed() {
        return super.isEditionAllowed() && !ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext());
    }

    @Override
    protected IlvObjectInteractor getDefaultObjectInteractor(String defaultName) {
        return this._defaultInteractors.getDefaultObjectInteractor(defaultName);
    }

    @Override
    protected int getSubSelectionCount(IlvManager mgr) {
        int count = 0;
        IlvGraphicEnumeration e = SubSelectionManager.getInstance().getSelectedSubObjects(mgr);
        while (e.hasMoreElements()) {
            e.nextElement();
            ++count;
        }
        return count;
    }

    private class SubSelectViewDecoration
    implements IlvManagerViewDecoration {
        private SubSelectViewDecoration() {
        }

        public void paint(Graphics dst, IlvManagerView view) {
            SubSelectionManager.getInstance().drawSubSelection(dst, SelectInteractor.this.getManager(), view.getTransformer());
        }
    }
}

