/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.graphics.IconRepository;
import oracle.diagram.framework.completion.CompletionDelegate;
import oracle.diagram.framework.completion.CompletionPopup;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.FontInterface;
import oracle.diagram.framework.interaction.ComponentInPlaceEditor;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditContext;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.toolbar.DiagramColorChoiceToolButton;
import oracle.diagram.framework.util.TextType;
import oracle.diagram.framework.util.TextUtil;
import oracle.diagram.res.UndoResource;

public class LabelInPlaceEditor
extends ComponentInPlaceEditor {
    private static final Object LABEL_TEXT = new Object();
    protected static final String UNDO_NAME = UndoResource.getBundle().getString("inplaceEdit.text");
    private boolean m_autoReinvoke;
    private final DocumentListener _documentListener = new MyDocumentListener();
    private CommitListener _commitListener = new CommitListener();
    private final KeyListener _keyListener = new ComponentInPlaceEditor.MyKeyListener();
    private JTextComponent _field;
    private ComponentInPlaceEditor.EditingInputVerifier _inputVerifier;
    private JComponent _toolbarComponent;
    private TextType _textType;
    private final IlvRect _initialBounds = new IlvRect();
    private String _currentlySetLabel;
    private CompletionPopup m_completionPopup;
    private boolean m_completionEnabled;
    private CompletionDelegate m_completionDelegate;

    public LabelInPlaceEditor(EditInteractor editInteractor, InPlaceEditContext initialContext) {
        this(editInteractor, initialContext, false);
    }

    public LabelInPlaceEditor(EditInteractor editInteractor, InPlaceEditContext initialContext, boolean autoReinvoke) {
        super(editInteractor, initialContext);
        this.m_autoReinvoke = autoReinvoke;
    }

    @Override
    public void editImpl(Font font) {
        InPlaceEditContext context = this.getContext();
        IlvGraphic editedObject = this.getEditedObject();
        boolean multi = this.supportMultiline(editedObject);
        this._textType = TextUtil.getTextType(editedObject);
        this._inputVerifier = new ComponentInPlaceEditor.EditingInputVerifier();
        if (multi) {
            if (this._textType == TextType.PLAIN_TEXT) {
                this._field = new JTextArea("", 5, 2);
                ((JTextArea)this._field).setLineWrap(true);
                this.setComponent(new JScrollPane(this._field, 21, 31));
            } else if (this._textType == TextType.HTML_TEXT) {
                HTMLEditPane editorPane = new HTMLEditPane(font, this.getColor(editedObject));
                this._field = editorPane;
                this._toolbarComponent = this.createToolBarComponent(editorPane);
                this.setComponentsEnabled(this._toolbarComponent, false);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)this._toolbarComponent, "North");
                panel.add((Component)this._field, "Center");
                this.setComponent(panel);
            }
        } else {
            this._field = new JTextField(5);
            this.setComponent(this._field);
            ((JTextField)this._field).addActionListener(this._commitListener);
        }
        this._field.setName("DiagramInPlaceEditor");
        this._field.setBorder(new LineBorder(Color.BLACK, 1));
        this._field.setMargin(new Insets(0, 1, 0, 1));
        String label = this.getObjectLabel(editedObject);
        if (label == null) {
            label = "";
        } else if (editedObject instanceof IlvLabelInterface && editedObject.getGraphicBag() instanceof ContainerGraphic) {
            this._currentlySetLabel = ((IlvLabelInterface)editedObject).getLabel();
            String string = this._currentlySetLabel = this._currentlySetLabel == null ? "" : this._currentlySetLabel;
            if (!label.equals(this._currentlySetLabel)) {
                ((IlvLabelInterface)editedObject).setLabel(label);
                IlvGraphic tmp = editedObject;
                while (tmp != null) {
                    if (tmp instanceof ContainerGraphic) {
                        ((ContainerGraphic)tmp).doLayout();
                    } else if (tmp instanceof ExtendedGraphic) {
                        ((ExtendedGraphic)tmp).doLayout();
                    }
                    tmp.reDraw();
                    tmp = tmp.getGraphicBag() instanceof IlvGraphic ? (IlvGraphic)tmp.getGraphicBag() : ManagerUtil.getManager(tmp);
                }
            }
        }
        this._field.setVisible(false);
        this.setText(label);
        this._field.setFont(font);
        this._field.selectAll();
        this.getManagerView().add((Component)this.getComponent());
        this.recalculateDimensions(true);
        this._field.setInputVerifier(this._inputVerifier);
        this._field.addKeyListener(this._keyListener);
        this._field.getDocument().addDocumentListener(this._documentListener);
        String oldLabel = (String)context.getProperty(LABEL_TEXT);
        if (oldLabel != null) {
            this.setText(oldLabel);
        }
        this._field.setVisible(true);
        this._field.requestFocusInWindow();
        new FieldListener();
        if (this.isCompletionEnabled()) {
            if (this.m_completionDelegate == null) {
                throw new IllegalStateException("Completion delegate is null");
            }
            if (this.m_completionPopup != null) {
                this.m_completionPopup.dispose();
            }
            this.m_completionPopup = new CompletionPopup(this._field);
            this.m_completionPopup.setDelegate(this.m_completionDelegate);
        }
    }

    protected JComponent createToolBarComponent(final JEditorPane editorPane) {
        JToolBar tb1 = new JToolBar();
        final JToolBar tb2 = new JToolBar();
        ArrayList<String> fonts = new ArrayList<String>();
        fonts.addAll(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
        String[] fontFamilies = fonts.toArray(new String[fonts.size()]);
        this.addComboBox(tb1, editorPane, "DiagramInPlaceEditorFontFamily", new StyledEditorKit.FontFamilyAction("font-family-Serif", "Serif"), StyleConstants.FontFamily, fontFamilies);
        String[] fontSizes = new String[]{"8", "10", "12", "14", "18", "24", "36"};
        this.addComboBox(tb1, editorPane, "DiagramInPlaceEditorFontSize", new StyledEditorKit.FontSizeAction("font-size-11", 11), StyleConstants.FontSize, fontSizes);
        this.addToggleButton(tb2, editorPane, "DiagramInPlaceEditorBoldButton", new StyledEditorKit.BoldAction(), StyleConstants.Bold, IconRepository.getIcon((Object)IconRepository.BOLD));
        this.addToggleButton(tb2, editorPane, "DiagramInPlaceEditorItalicButton", new StyledEditorKit.ItalicAction(), StyleConstants.Italic, IconRepository.getIcon((Object)IconRepository.ITALIC));
        this.addToggleButton(tb2, editorPane, "DiagramInPlaceEditorUnderlineButton", new StyledEditorKit.UnderlineAction(), StyleConstants.Underline, IconRepository.getIcon((Object)IconRepository.UNDERLINE));
        final StyledEditorKit.ForegroundAction fgAction = new StyledEditorKit.ForegroundAction("fg-color", Color.black);
        final Runnable fgRunnable = new Runnable(){

            @Override
            public void run() {
                Component[] buttons;
                DiagramColorChoiceToolButton colorButton = null;
                for (Component b : buttons = tb2.getComponents()) {
                    if (!(b instanceof DiagramColorChoiceToolButton)) continue;
                    colorButton = (DiagramColorChoiceToolButton)((Object)b);
                    break;
                }
                if (colorButton != null) {
                    final Color selectedColor = colorButton.getSelectedColor();
                    ActionEvent newEvent = new ActionEvent(editorPane, 1001, Integer.toString(selectedColor.getRGB()));
                    fgAction.actionPerformed(newEvent);
                    String hexColor = String.format("#%02X%02X%02X", selectedColor.getRed(), selectedColor.getGreen(), selectedColor.getBlue());
                    HTMLEditorKit kit = (HTMLEditorKit)editorPane.getEditorKit();
                    final SimpleAttributeSet attr = new SimpleAttributeSet();
                    attr.addAttribute(HTML.Attribute.COLOR, hexColor);
                    StyleConstants.setForeground(attr, selectedColor);
                    final boolean force = editorPane.getSelectionStart() == editorPane.getSelectionEnd();
                    ((HTMLEditPane)editorPane).setHTMLFontColor(selectedColor, force);
                    this.setCharacterAttributes(editorPane, attr, false);
                    final TextUI ui = editorPane.getUI();
                    ui.damageRange(editorPane, 0, Integer.MAX_VALUE);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((HTMLEditPane)editorPane).setIsValidating(true);
                            if (editorPane.getParent() != null) {
                                editorPane.getParent().validate();
                            }
                            editorPane.validate();
                            editorPane.repaint();
                            ((HTMLEditPane)editorPane).setIsValidating(false);
                            ((HTMLEditPane)editorPane).setHTMLFontColor(selectedColor, force);
                            this.setCharacterAttributes(editorPane, attr, false);
                            ui.damageRange(editorPane, 0, Integer.MAX_VALUE);
                        }
                    });
                }
            }

            protected final void setCharacterAttributes(JEditorPane editor, AttributeSet attr, boolean replace) {
                int p1;
                int p0 = editor.getSelectionStart();
                if (p0 != (p1 = editor.getSelectionEnd())) {
                    StyledDocument doc = (StyledDocument)editor.getDocument();
                    doc.setCharacterAttributes(p0, p1 - p0, attr, replace);
                    editor.setDocument(doc);
                }
                StyledEditorKit k = (StyledEditorKit)editor.getEditorKit();
                MutableAttributeSet inputAttributes = k.getInputAttributes();
                if (replace) {
                    inputAttributes.removeAttributes(inputAttributes);
                }
                inputAttributes.addAttributes(attr);
            }
        };
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(fgRunnable);
            }
        };
        final DiagramColorChoiceToolButton colorButton = new DiagramColorChoiceToolButton(a);
        colorButton.setName("DiagramInPlaceEditorColorButton");
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                MutableAttributeSet a = ((HTMLEditorKit)editorPane.getEditorKit()).getInputAttributes();
                Color editorTextColor = StyleConstants.getForeground(a);
                Color currentColor = colorButton.getSelectedColor();
                Color newColor = colorButton.getClosestColor(editorTextColor, false);
                if (newColor != null && !newColor.equals(currentColor)) {
                    colorButton.quietlySetSelectedColor(newColor);
                }
            }
        };
        editorPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!((HTMLEditPane)editorPane).isValidating()) {
                    SwingUtilities.invokeLater(r);
                }
            }
        });
        colorButton.setInputVerifier(this._inputVerifier);
        colorButton.setVerifyInputWhenFocusTarget(false);
        JComponent comp = (JComponent)((Object)colorButton.getAccessibleContext().getAccessibleChild(0));
        this.setComponentsInputVerified(comp, false);
        ((JPopupMenu)comp).addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (LabelInPlaceEditor.this._inputVerifier != null) {
                    final ComponentInPlaceEditor.EditingInputVerifier iv = LabelInPlaceEditor.this._inputVerifier;
                    iv.setEnabled(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            iv.setEnabled(true);
                            editorPane.requestFocus();
                        }
                    });
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        tb2.addSeparator();
        tb2.add((Component)((Object)colorButton));
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        panel.add(tb1);
        panel.add(tb2);
        return panel;
    }

    private void addComboBox(JToolBar tb, final JEditorPane editor, String componentName, final Action a, final Object styleConstant, String[] items) {
        final JComboBox<String> cb = new JComboBox<String>(items);
        cb.setName(componentName);
        final ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = (String)((JComboBox)e.getSource()).getSelectedItem();
                ActionEvent newEvent = new ActionEvent(editor, 1001, command);
                a.actionPerformed(newEvent);
                editor.requestFocus();
                if (StyleConstants.FontFamily.equals(styleConstant)) {
                    ((HTMLEditPane)editor).setHTMLFontFamily(command);
                } else if (StyleConstants.FontSize.equals(styleConstant)) {
                    ((HTMLEditPane)editor).setHTMLFontSize(Integer.valueOf(command));
                }
            }
        };
        cb.addActionListener(listener);
        cb.setInputVerifier(this._inputVerifier);
        cb.setVerifyInputWhenFocusTarget(false);
        cb.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JComboBox box = (JComboBox)e.getSource();
                JComponent comp = (JComponent)((Object)box.getUI().getAccessibleChild(box, 0));
                if (!(comp instanceof JPopupMenu)) {
                    return;
                }
                JScrollPane scrollPane = (JScrollPane)comp.getComponent(0);
                comp = (JComponent)scrollPane.getViewport().getView();
                LabelInPlaceEditor.this.setComponentsInputVerified(comp, false);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                cb.removeActionListener(listener);
                MutableAttributeSet a = ((HTMLEditorKit)editor.getEditorKit()).getInputAttributes();
                if (StyleConstants.FontFamily.equals(styleConstant)) {
                    String family = StyleConstants.getFontFamily(a);
                    cb.setSelectedItem(family);
                } else if (StyleConstants.FontSize.equals(styleConstant)) {
                    String size = Integer.toString(StyleConstants.getFontSize(a));
                    cb.setSelectedItem(size);
                }
                cb.addActionListener(listener);
            }
        };
        editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SwingUtilities.invokeLater(r);
            }
        });
        SwingUtilities.invokeLater(r);
        tb.add(cb);
    }

    private void addToggleButton(JToolBar tb, final JEditorPane editor, String componentName, Action a, final Object styleConstant, Icon icon) {
        if (a.getValue("SmallIcon") == null) {
            a.putValue("SmallIcon", icon);
        }
        final JToggleButton b = new JToggleButton();
        b.setName(componentName);
        b.setInputVerifier(this._inputVerifier);
        b.setVerifyInputWhenFocusTarget(false);
        b.putClientProperty("hideActionText", Boolean.TRUE);
        b.setAction(a);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HTMLEditPane editPane = (HTMLEditPane)editor;
                editPane.requestFocus();
                if (StyleConstants.Bold.equals(styleConstant)) {
                    editPane.setHTMLFontIsBold(b.isSelected());
                } else if (StyleConstants.Italic.equals(styleConstant)) {
                    editPane.setHTMLFontIsItalic(b.isSelected());
                } else if (StyleConstants.Underline.equals(styleConstant)) {
                    editPane.setHTMLFontIsUnderline(b.isSelected());
                }
            }
        });
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                MutableAttributeSet a = ((HTMLEditorKit)editor.getEditorKit()).getInputAttributes();
                if (StyleConstants.Bold.equals(styleConstant)) {
                    b.setSelected(StyleConstants.isBold(a));
                } else if (StyleConstants.Italic.equals(styleConstant)) {
                    b.setSelected(StyleConstants.isItalic(a));
                } else if (StyleConstants.Underline.equals(styleConstant)) {
                    b.setSelected(StyleConstants.isUnderline(a));
                }
            }
        };
        editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SwingUtilities.invokeLater(r);
            }
        });
        tb.add(b);
    }

    @Override
    protected void revertImpl() {
        if (this._currentlySetLabel != null) {
            IlvGraphic editedObject = this.getEditedObject();
            ((IlvLabelInterface)editedObject).setLabel(this._currentlySetLabel);
            IlvGraphic tmp = editedObject;
            while (tmp != null) {
                if (tmp instanceof ContainerGraphic) {
                    ((ContainerGraphic)tmp).doLayout();
                } else if (tmp instanceof ExtendedGraphic) {
                    ((ExtendedGraphic)tmp).doLayout();
                }
                tmp.reDraw();
                tmp = tmp.getGraphicBag() instanceof IlvGraphic ? (IlvGraphic)tmp.getGraphicBag() : ManagerUtil.getManager(tmp);
            }
        }
    }

    @Override
    protected Rectangle getEditComponentBounds() {
        if (this._field != null) {
            return this.getComponentBounds();
        }
        return null;
    }

    @Override
    protected void cleanUpComponent() {
        if (this._field != null && this.getManagerView() != null) {
            this._field.removeKeyListener(this._keyListener);
            if (this._field instanceof JTextField) {
                ((JTextField)this._field).removeActionListener(this._commitListener);
            }
            this._field.getDocument().removeDocumentListener(this._documentListener);
            this._inputVerifier.setEnabled(false);
            this._inputVerifier = null;
            this._field.setInputVerifier(null);
            this._field = null;
            this._toolbarComponent = null;
        }
    }

    protected InPlaceEditContext reinvoke(boolean sameText) {
        InPlaceEditContext reinvokeContext = this.reinvoke();
        reinvokeContext.setProperty(LABEL_TEXT, sameText ? this.getText() : null);
        return reinvokeContext;
    }

    protected JTextComponent getTextComponent() {
        return this._field;
    }

    protected String getObjectLabel(IlvGraphic obj) {
        if (!(obj instanceof IlvLabelInterface)) {
            throw new IllegalArgumentException("object must implement IlvLabelInterface");
        }
        return ((IlvLabelInterface)obj).getLabel();
    }

    protected void beginUndo(IlvGraphic g, String newLabel, String taskName) {
    }

    protected void endUndo(IlvGraphic g, String newLabel, String taskName) {
    }

    protected void abortUndo(IlvGraphic g, String newLabel, String taskName) {
    }

    @Override
    protected final void setObjectLabelWithUndo(IlvGraphic obj, String label) {
        EditInteractor.Status status = null;
        if (this.getContext().hasLocalUndoTransactions()) {
            this.beginUndo(obj, label, this.getUndoTask());
            if (this.setObjectLabel(obj, label)) {
                this.endUndo(obj, label, this.getUndoTask());
                status = EditInteractor.Status.COMMIT;
            } else {
                this.abortUndo(obj, label, this.getUndoTask());
                status = EditInteractor.Status.ABORT;
            }
        } else {
            status = this.setObjectLabel(obj, label) ? EditInteractor.Status.COMMIT : EditInteractor.Status.ABORT;
        }
        this.getEditInteractor().setExitStatus(status);
        if (this.m_autoReinvoke && EditInteractor.Status.COMMIT == status && this.getCommitType() == 1) {
            this.reinvoke(false);
        }
    }

    protected String getUndoTask() {
        return UNDO_NAME;
    }

    @Override
    protected boolean setObjectLabel(IlvGraphic obj, String str) {
        if (!(obj instanceof IlvLabelInterface)) {
            throw new IllegalArgumentException("object must implement IlvLabelInterface");
        }
        ((IlvLabelInterface)obj).setLabel(str);
        return true;
    }

    protected boolean supportMultiline(IlvGraphic obj) {
        if (obj != null) {
            if (!(obj instanceof IlvLabelInterface)) {
                throw new IllegalArgumentException("object must implement IlvLabelInterface");
            }
            return ((IlvLabelInterface)obj).supportMultiline();
        }
        return false;
    }

    protected Color getColor(IlvGraphic obj) {
        Color color = null;
        if (obj instanceof FontInterface) {
            color = ((FontInterface)obj).getFontColor();
        }
        if (color == null) {
            color = Color.black;
        }
        return color;
    }

    protected IlvRect getEditingAreaBBox(IlvGraphic obj, int nLines, int labelWidth, int lineHeight, int borderWidth, int borderHeight, IlvTransformer t) {
        boolean multiline = this.supportMultiline(obj);
        IlvRect bbox = this.getLabelBBox(obj, t);
        nLines = Math.max(nLines, multiline ? 4 : 1);
        IlvRect r = new IlvRect(bbox.x - (float)borderWidth, bbox.y - (float)borderHeight - 1.0f, Math.max((float)labelWidth, bbox.width) + (float)(2 * borderWidth), Math.max((float)(nLines * lineHeight), bbox.height) + (float)(2 * borderHeight));
        return r;
    }

    @Override
    protected Object getComponentValue() {
        return this.getText();
    }

    protected void setText(String str) {
        if (this._textType == TextType.HTML_TEXT && TextUtil.isHTML(str)) {
            String formattedText = TextUtil.convertSpacesInHTML(str);
            this._field.setText(formattedText);
        } else {
            this._field.setText(str);
        }
    }

    protected String getText() {
        String text = this._field.getText();
        if (this._textType == TextType.HTML_TEXT && TextUtil.isHTML(text)) {
            String plainString = TextUtil.convertHTMLToPlain(text);
            text = plainString.length() == 0 ? TextUtil.convertPlainToHTML("") : TextUtil.convertNBSPInHTML(text);
        }
        return text;
    }

    protected void recalculateDimensions(boolean initial) {
        Dimension d;
        IlvTransformer transformer = this.getDrawingTransformer();
        Font font = this._field.getFont();
        String label = this._field.getText();
        if (this._textType == TextType.HTML_TEXT) {
            label = TextUtil.convertHTMLToPlain(label);
        }
        FontRenderContext frc = new FontRenderContext(null, false, false);
        LineMetrics lm = font.getLineMetrics(label, frc);
        int lineHeight = (int)lm.getHeight();
        int labelWidth = 0;
        String[] lines = label.split("\n");
        int numLines = lines.length;
        for (String line : lines) {
            int lineWidth = (int)font.getStringBounds(line, frc).getWidth();
            if (labelWidth >= lineWidth) continue;
            labelWidth = lineWidth;
        }
        int borderWidth = 2;
        boolean borderHeight = true;
        IlvRect r = this.getEditingAreaBBox(this.getEditedObject(), numLines, labelWidth, lineHeight, 2, 1, transformer);
        if (initial || this._textType == TextType.HTML_TEXT) {
            d = this._field.getPreferredSize();
            r.width = Math.max(r.width, (float)d.width);
            r.height = Math.max(r.height, (float)d.height);
        }
        if (this._toolbarComponent != null) {
            d = this._toolbarComponent.getMinimumSize();
            r.width = Math.max(r.width, (float)d.width);
            r.height += (float)d.height;
            r.y -= (float)d.height;
        }
        if (initial) {
            this._initialBounds.setRect(r.x, r.y, r.width, r.height);
        } else {
            r.width = Math.max(r.width, this._initialBounds.width);
            r.height = Math.max(r.height, this._initialBounds.height);
        }
        this.setComponentBounds(Math.round(r.x), Math.round(r.y), (int)Math.ceil(r.width), (int)Math.ceil(r.height));
    }

    private final void recalcDimensions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LabelInPlaceEditor.this.isEditing() && LabelInPlaceEditor.this.getTextComponent() != null) {
                    LabelInPlaceEditor.this.recalculateDimensions(false);
                }
            }
        });
    }

    private void setComponentsEnabled(JComponent comp, boolean isEnabled) {
        Component[] children;
        comp.setEnabled(isEnabled);
        for (Component child : children = comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            this.setComponentsEnabled((JComponent)child, isEnabled);
        }
    }

    private void setComponentsInputVerified(JComponent comp, boolean shouldVerifyInput) {
        Component[] children;
        comp.setInputVerifier(this._inputVerifier);
        comp.setVerifyInputWhenFocusTarget(shouldVerifyInput);
        for (Component child : children = comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            this.setComponentsInputVerified((JComponent)child, shouldVerifyInput);
        }
    }

    public void setCompletionEnabled(boolean enable) {
        this.m_completionEnabled = enable;
    }

    public boolean isCompletionEnabled() {
        return this.m_completionEnabled;
    }

    protected void releaseCompletionPopup() {
        if (this.m_completionPopup != null) {
            this.m_completionPopup.dispose();
        }
    }

    public void setCompletionDelegate(CompletionDelegate delegate) {
        this.m_completionDelegate = delegate;
    }

    public CompletionDelegate getCompletionDelegate() {
        return this.m_completionDelegate;
    }

    protected CompletionPopup getCompletionPopup() {
        return this.m_completionPopup;
    }

    protected void setCompletionPopup(CompletionPopup popup) {
        this.m_completionPopup = popup;
    }

    @Override
    public void abort() {
        super.abort();
        this.releaseCompletionPopup();
    }

    @Override
    public void commit(int commitType) {
        this.releaseCompletionPopup();
        super.commit(commitType);
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 27) {
            if (!this.isCompletionEnabled() || this.m_completionPopup == null || !this.m_completionPopup.isShowing()) {
                e.consume();
                this.abort();
            }
        } else if (e.getKeyCode() == 525 || e.getKeyCode() == 121 && e.isShiftDown()) {
            e.consume();
        } else if (this._textType == TextType.HTML_TEXT && e.getKeyCode() == 9) {
            e.consume();
        }
    }

    public final class MyDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processDocumentEvent(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processDocumentEvent(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processDocumentEvent(e);
        }

        private void processDocumentEvent(DocumentEvent e) {
            LabelInPlaceEditor.this.recalcDimensions();
        }
    }

    private final class CommitListener
    implements ActionListener {
        private CommitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LabelInPlaceEditor.this.commit(1);
        }
    }

    private class HTMLEditPane
    extends JEditorPane {
        private Color _fontColor;
        private boolean _isFontColorChanged;
        private boolean _fontIsBold;
        private boolean _fontIsItalic;
        private boolean _fontIsUnderline;
        private String _fontFamily;
        private int _fontSize;
        private boolean _isValidating;

        public HTMLEditPane(Font font, Color fontColor) {
            super("text/html", "");
            this._isFontColorChanged = false;
            this._fontIsBold = false;
            this._fontIsItalic = false;
            this._fontIsUnderline = false;
            this._isValidating = false;
            this._fontColor = fontColor;
            this._isFontColorChanged = true;
            this._fontFamily = font.getFamily();
            this._fontIsBold = font.isBold();
            this._fontIsItalic = font.isItalic();
            this._fontSize = font.getSize();
            this.setEditorKit(new HTMLEditorKit(){

                @Override
                protected void createInputAttributes(Element element, MutableAttributeSet set) {
                    super.createInputAttributes(element, set);
                    if (set.getAttribute(StyleConstants.FontFamily) == null) {
                        StyleConstants.setFontFamily(set, HTMLEditPane.this._fontFamily);
                        StyleConstants.setBold(set, HTMLEditPane.this._fontIsBold);
                        StyleConstants.setItalic(set, HTMLEditPane.this._fontIsItalic);
                        StyleConstants.setUnderline(set, HTMLEditPane.this._fontIsUnderline);
                    }
                    if (set.getAttribute(StyleConstants.FontSize) == null) {
                        StyleConstants.setFontSize(set, HTMLEditPane.this._fontSize);
                    }
                    if (HTMLEditPane.this._isFontColorChanged || set.getAttribute(StyleConstants.Foreground) == null) {
                        StyleConstants.setForeground(set, HTMLEditPane.this._fontColor);
                        HTMLEditPane.this._isFontColorChanged = false;
                    }
                    if (set.getAttribute(StyleConstants.Underline) == null) {
                        StyleConstants.setUnderline(set, HTMLEditPane.this._fontIsUnderline);
                    }
                }
            });
            StyleSheet styles = TextUtil.getDefaultHTMLStyleSheet();
            this.setDocument(new HTMLDocument(styles));
        }

        public boolean isValidating() {
            return this._isValidating;
        }

        public void setIsValidating(boolean isValidating) {
            this._isValidating = isValidating;
        }

        public void setHTMLFontIsBold(boolean isBold) {
            this._fontIsBold = isBold;
        }

        public void setHTMLFontIsItalic(boolean isItalic) {
            this._fontIsItalic = isItalic;
        }

        public void setHTMLFontIsUnderline(boolean isUnderline) {
            this._fontIsUnderline = isUnderline;
        }

        public void setHTMLFontColor(Color fontColor, boolean force) {
            this._fontColor = fontColor;
            this._isFontColorChanged = force;
        }

        public void setHTMLFontFamily(String fontFamily) {
            this._fontFamily = fontFamily;
        }

        public void setHTMLFontSize(int fontSize) {
            this._fontSize = fontSize;
        }

        @Override
        public void requestFocus() {
            if (LabelInPlaceEditor.this._inputVerifier != null) {
                LabelInPlaceEditor.this._inputVerifier.setEnabled(false);
            }
            super.requestFocus();
            if (LabelInPlaceEditor.this._inputVerifier != null) {
                LabelInPlaceEditor.this._inputVerifier.setEnabled(true);
            }
        }

        @Override
        public boolean requestFocus(boolean temporary) {
            if (LabelInPlaceEditor.this._inputVerifier != null) {
                LabelInPlaceEditor.this._inputVerifier.setEnabled(false);
            }
            boolean retVal = super.requestFocus(temporary);
            if (LabelInPlaceEditor.this._inputVerifier != null) {
                LabelInPlaceEditor.this._inputVerifier.setEnabled(true);
            }
            return retVal;
        }
    }

    private class FieldListener
    extends FocusAdapter
    implements ActionListener {
        private JTextComponent _textComponent = null;
        private boolean _focusGained = false;
        private Timer _timer = null;

        public FieldListener() {
            this._textComponent = LabelInPlaceEditor.this._field;
            this._textComponent.addFocusListener(this);
            this._timer = new Timer(500, this);
            this._timer.setRepeats(false);
            this._timer.start();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this._focusGained = true;
            this._textComponent.removeFocusListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean cleanup = true;
            if (LabelInPlaceEditor.this.isEditing() && LabelInPlaceEditor.this._field != null && LabelInPlaceEditor.this._field.isVisible()) {
                cleanup = false;
                if (this._focusGained) {
                    KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    cleanup = LabelInPlaceEditor.this._field.equals(fm.getFocusOwner());
                }
            }
            if (cleanup) {
                this._timer.removeActionListener(this);
                this._timer = null;
                this._textComponent.removeFocusListener(this);
                this._textComponent = null;
                if (LabelInPlaceEditor.this._toolbarComponent != null) {
                    LabelInPlaceEditor.this.setComponentsEnabled(LabelInPlaceEditor.this._toolbarComponent, true);
                }
            } else {
                LabelInPlaceEditor.this._field.requestFocusInWindow();
                this._timer.start();
            }
        }
    }
}

