/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.inspector;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.ArraySelectionModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.ide.Context;
import oracle.ide.inspector.IdeMultiObjectModel;
import oracle.ide.inspector.IdePropertyModel;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.inspector.PropertyModelFactory;

public final class DiagramPropertyModelFactory
implements PropertyModelFactory {
    public PropertyModel createPropertyModel(List<PropertyModel> models, Object inspectableTarget, Context context) throws Exception {
        if (models == null || models.isEmpty()) {
            return null;
        }
        if (context.getProperty("oracle.diagram.inspector.ActiveInspectedView") == null) {
            return null;
        }
        CopyOnWriteArrayList<PropertyModel> withoutNulls = new CopyOnWriteArrayList<PropertyModel>();
        for (PropertyModel model : models) {
            if (model == null) continue;
            withoutNulls.add(model);
        }
        if (withoutNulls.isEmpty()) {
            return null;
        }
        return this.newModel(withoutNulls, inspectableTarget != null ? inspectableTarget.getClass() : null, context);
    }

    private PropertyModel newModel(List<PropertyModel> models, Class targetType, Context context) throws Exception {
        InspectorFactory i = InspectorFactory.getInstance();
        Class type = i.getPropertyModelType(targetType);
        if (IdeMultiObjectModel.class.equals((Object)type)) {
            return null;
        }
        IdePropertyModel model = (IdePropertyModel)type.newInstance();
        model.setContext(context);
        model.setSelectionModel(this.selectionModelFrom(models));
        return model;
    }

    private SelectionModel selectionModelFrom(List<PropertyModel> models) {
        return new ArraySelectionModel(new Vector<PropertyModel>(models));
    }
}

