/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.highlight;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewDecoration;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.interactor.IlvSelectInteractor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.highlight.DefaultHighlightHelper;
import oracle.diagram.framework.highlight.DefaultShapeHighlighterDelegate;
import oracle.diagram.framework.highlight.HighlightHelper;
import oracle.diagram.framework.highlight.SelectorHighlighter;
import oracle.diagram.framework.highlight.ShapeHighlighterDelegate;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditor;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.notification.Notification;
import oracle.diagram.framework.notification.NotificationCenter;
import oracle.diagram.framework.notification.NotificationObserver;
import oracle.diagram.framework.notification.NotificationType;

public class ShapeHighlighter
implements Plugin,
IlvManagerViewDecoration,
NotificationObserver {
    private static final float BORDER_THICKNESS = 4.0f;
    private static final float CORNER_SIZE = 4.0f;
    private static final IlvRect M_TEMPRECT = new IlvRect();
    private static final HighlightHelper DEFAULT_HELPER = new DefaultHighlightHelper();
    private IlvManagerView m_managerView;
    private final Rectangle m_tempBounds = new Rectangle();
    private EnumMap<HighlightGroupType, HighlightGroup> m_highlightGroups = new EnumMap(HighlightGroupType.class);
    private ShapeHighlighterDelegate m_delegate;
    private boolean m_enabled = true;
    private boolean m_enableHighlightGraphic = true;
    private boolean m_attached;
    private DiagramContext m_context;
    private SelectorHighlighter m_selectorHighlighter;
    private InteractorListener m_interactorListener;

    public ShapeHighlighter() {
        HighlightGroup defaultGroup = new HighlightGroup(HighlightGroupType.DEFAULT);
        this.m_highlightGroups.put(HighlightGroupType.DEFAULT, defaultGroup);
        HighlightGroup notificationGroup = new HighlightGroup(HighlightGroupType.NOTIFICATION);
        this.m_highlightGroups.put(HighlightGroupType.NOTIFICATION, notificationGroup);
        this.m_delegate = new DefaultShapeHighlighterDelegate();
    }

    private void disposeGroups() {
        for (Map.Entry<HighlightGroupType, HighlightGroup> entry : this.m_highlightGroups.entrySet()) {
            HighlightGroup group = entry.getValue();
            group.dispose();
        }
    }

    public void dispose() {
        this.disposeGroups();
        this.m_highlightGroups.clear();
    }

    public static ShapeHighlighter getInstance(IlvManagerView view) {
        if (view == null) {
            throw new IllegalArgumentException("IlvManagerView is null");
        }
        DiagramContext ctx = DiagramContext.getDiagramContext(view);
        ShapeHighlighter highlighter = ctx.getPlugin(ShapeHighlighter.class);
        return highlighter;
    }

    public static void highlight(IlvManagerView view, IlvGraphic graphic, boolean immediateRedraw) {
        ShapeHighlighter highlighter = ShapeHighlighter.getInstance(view);
        if (highlighter != null) {
            highlighter.highlightGraphic(graphic, immediateRedraw);
        }
    }

    public static void unhighlight(IlvManagerView view, IlvGraphic graphic, boolean immediateRedraw) {
        ShapeHighlighter highlighter = ShapeHighlighter.getInstance(view);
        if (highlighter != null) {
            highlighter.unhighlightGraphic(graphic, immediateRedraw);
        }
    }

    public void setHighlightGraphicEnabled(boolean enable) {
        this.m_enableHighlightGraphic = enable;
    }

    public void setDelegate(ShapeHighlighterDelegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate cannot be null");
        }
        if (this.m_delegate != delegate) {
            DiagramContext context;
            NotificationCenter notificationCenter;
            if (this.m_attached && (notificationCenter = (context = DiagramContext.getDiagramContext(this.m_managerView)).getPlugin(NotificationCenter.class)) != null) {
                notificationCenter.removeObserver(this);
                Set<NotificationType> types = delegate.getNotificationSet(this);
                notificationCenter.addNotificationObserver(types, (NotificationObserver)this);
            }
            this.m_delegate = delegate;
        }
    }

    public ShapeHighlighterDelegate getDelegate() {
        return this.m_delegate;
    }

    HighlightHelper getHighlightHelper(HighlightGroupType groupType, Notification notification, IlvGraphic graphic) {
        if (groupType == HighlightGroupType.DEFAULT) {
            return this.m_delegate.getDefaultHighlightHelper(this, graphic);
        }
        return this.m_delegate.getHighlightHelper(this, notification, graphic);
    }

    public void highlightGraphic(IlvGraphic graphic, boolean immediateRedraw) {
        if (graphic == null || !this.m_enableHighlightGraphic) {
            return;
        }
        HighlightGroup defaultGroup = this.m_highlightGroups.get((Object)HighlightGroupType.DEFAULT);
        HighlightHelper helper = this.getHighlightHelper(HighlightGroupType.DEFAULT, null, graphic);
        boolean doHighlight = false;
        doHighlight = helper == null ? this.m_delegate.shouldHighlightDefault(this, graphic) : helper.shouldHighlightDefault(graphic);
        if (doHighlight) {
            if (helper == null) {
                helper = DEFAULT_HELPER;
            }
            defaultGroup.highlightGraphic(graphic, helper, immediateRedraw);
        }
    }

    public void unhighlightGraphic(IlvGraphic graphic, boolean immediateRedraw) {
        if (graphic == null || !this.m_enableHighlightGraphic) {
            return;
        }
        HighlightGroup defaultGroup = this.m_highlightGroups.get((Object)HighlightGroupType.DEFAULT);
        defaultGroup.unhighlightGraphic(graphic, immediateRedraw);
        if (!defaultGroup.hasHighlighting()) {
            defaultGroup.dispose();
        }
    }

    public void reset() {
        this.repaintAll(false);
        this.disposeGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintGraphic(HighlighterProxy proxy, boolean immediateRedraw) {
        int drawMode = this.m_managerView.getRedrawMode();
        this.m_managerView.setRedrawMode(immediateRedraw ? 1 : 0);
        try {
            proxy.repaint(this.m_managerView);
        }
        finally {
            this.m_managerView.reDrawViews();
            this.m_managerView.setRedrawMode(drawMode);
        }
    }

    private void repaintAll(boolean immediateRedraw) {
        for (HighlightGroup group : this.m_highlightGroups.values()) {
            group.repaintAll(immediateRedraw);
        }
    }

    public void hideHighlighters(boolean immediateRedraw) {
        this.m_enabled = false;
        this.repaintAll(immediateRedraw);
    }

    public void showHighlighters(boolean immediateRedraw) {
        this.m_enabled = true;
        this.repaintAll(immediateRedraw);
    }

    @Override
    public void attach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
        if (!(pluginManager instanceof DiagramContext)) {
            throw new IllegalArgumentException("Plugin Manager must be a DiagramContext");
        }
        DiagramContext context = (DiagramContext)pluginManager;
        this.m_managerView = context.getManagerView();
        if (this.m_managerView == null) {
            throw new IllegalStateException("manager view is null");
        }
        this.m_managerView.addViewDecoration((IlvManagerViewDecoration)this);
        Set<NotificationType> types = this.m_delegate.getNotificationSet(this);
        this.m_selectorHighlighter = this.createSelectorHighlighter(context);
        this.m_interactorListener = new InteractorListener(){

            public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
                IlvManagerViewInteractor newInteractor;
                IlvManagerViewInteractor oldInteractor = interactorChangedEvent.getOldValue();
                if (oldInteractor != (newInteractor = interactorChangedEvent.getNewValue())) {
                    if (oldInteractor != null) {
                        oldInteractor.removeMouseMotionListener((MouseMotionListener)ShapeHighlighter.this.m_selectorHighlighter);
                        ShapeHighlighter.this.m_selectorHighlighter.reset();
                    }
                    if (newInteractor != null) {
                        newInteractor.addMouseMotionListener((MouseMotionListener)ShapeHighlighter.this.m_selectorHighlighter);
                        boolean enabled = newInteractor instanceof IlvSelectInteractor || newInteractor instanceof EditInteractor || newInteractor instanceof InPlaceEditor;
                        ShapeHighlighter.this.m_selectorHighlighter.setEnabled(enabled);
                        if (enabled) {
                            ShapeHighlighter.this.m_selectorHighlighter.forceMouseMotionEvent();
                        }
                    } else {
                        ShapeHighlighter.this.m_selectorHighlighter.setEnabled(false);
                    }
                }
            }
        };
        this.m_managerView.addInteractorListener(this.m_interactorListener);
        this.register(context, types);
        this.m_attached = true;
    }

    protected SelectorHighlighter createSelectorHighlighter(DiagramContext context) {
        return new SelectorHighlighter(context);
    }

    private void register(DiagramContext context, Set<NotificationType> types) {
        NotificationCenter notificationCenter = context.getPlugin(NotificationCenter.class);
        if (notificationCenter != null) {
            notificationCenter.addNotificationObserver(types, (NotificationObserver)this);
        }
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
        if (!(pluginManager instanceof DiagramContext)) {
            throw new IllegalArgumentException("Plugin Manager must be a DiagramContext");
        }
        DiagramContext context = (DiagramContext)pluginManager;
        IlvManagerView view = context.getManagerView();
        if (this.m_managerView != view) {
            throw new IllegalStateException("manager view is different");
        }
        NotificationCenter notificationCenter = context.getPlugin(NotificationCenter.class);
        if (notificationCenter != null) {
            notificationCenter.removeObserver(this);
        }
        this.m_managerView.removeInteractorListener(this.m_interactorListener);
        this.m_selectorHighlighter = null;
        this.m_interactorListener = null;
        this.m_attached = false;
        this.m_managerView.removeViewDecoration((IlvManagerViewDecoration)this);
        this.m_managerView = null;
        this.dispose();
    }

    public void paint(Graphics graphics, IlvManagerView ilvManagerView) {
        if (!this.m_enabled) {
            return;
        }
        for (HighlightGroup group : this.m_highlightGroups.values()) {
            group.paint(graphics, ilvManagerView);
        }
    }

    @Override
    public void receiveNotification(Notification notification) {
        IlvGraphic graphic;
        ShapeHighlighterDelegate.HighlightType highlightType = this.m_delegate.getHighlightType(this, notification);
        HighlightGroup notificationGroup = this.m_highlightGroups.get((Object)HighlightGroupType.NOTIFICATION);
        if (highlightType == ShapeHighlighterDelegate.HighlightType.HIGHLIGHT_MULTI) {
            IlvManager mgr = this.m_managerView.getManager();
            IlvGraphicEnumeration graphics = mgr.getObjects(true);
            while (graphics.hasMoreElements()) {
                IlvManager localManager;
                IlvGraphic graphic2 = graphics.nextElement();
                if (!mgr.isVisible(graphic2, this.m_managerView) || (localManager = ManagerUtil.getManager(graphic2)) == null) continue;
                this.handleNotificationHighlighting(notificationGroup, notification, graphic2);
            }
        } else if (highlightType == ShapeHighlighterDelegate.HighlightType.HIGHLIGHT_SINGLE && (graphic = this.m_delegate.getSingleHighlightingGraphic(this, notification)) != null) {
            this.handleNotificationHighlighting(notificationGroup, notification, graphic);
        }
    }

    private void handleNotificationHighlighting(HighlightGroup notificationGroup, Notification notification, IlvGraphic graphic) {
        HighlightHelper helper = this.getHighlightHelper(HighlightGroupType.NOTIFICATION, notification, graphic);
        if (helper != null) {
            if (helper.shouldHighlight(notification, graphic)) {
                notificationGroup.highlightGraphic(graphic, helper, true);
            } else {
                notificationGroup.unhighlightGraphic(graphic, true);
            }
        }
    }

    private static enum HighlightGroupType {
        DEFAULT,
        NOTIFICATION;

    }

    private class HighlightGroup {
        private HighlightGroupType m_id;
        private final List<HighlighterProxy> m_invalidGraphics = new LinkedList<HighlighterProxy>();
        private final Map<IlvGraphic, HighlighterProxy> m_highlightMap = new IdentityHashMap<IlvGraphic, HighlighterProxy>();

        HighlightGroup(HighlightGroupType id) {
            this.m_id = id;
        }

        void dispose() {
            for (Map.Entry<IlvGraphic, HighlighterProxy> entry : this.m_highlightMap.entrySet()) {
                HighlighterProxy proxy = entry.getValue();
                proxy.dispose();
            }
            this.m_highlightMap.clear();
            this.m_invalidGraphics.clear();
        }

        boolean hasHighlighting() {
            return this.m_highlightMap.size() > 0;
        }

        void highlightGraphic(IlvGraphic g, HighlightHelper helper, boolean immediateRedraw) {
            HighlighterProxy proxy = this.m_highlightMap.get(g);
            if (proxy == null) {
                proxy = new HighlighterProxy(ShapeHighlighter.this, helper);
                proxy.m_graphic = g;
                this.m_highlightMap.put(g, proxy);
            }
            helper.willHighlightGraphic(g);
            ++proxy.m_refCount;
            ShapeHighlighter.this.repaintGraphic(proxy, immediateRedraw);
        }

        void unhighlightGraphic(IlvGraphic g, boolean immediateRedraw) {
            HighlighterProxy proxy = this.m_highlightMap.get(g);
            if (proxy != null) {
                if (--proxy.m_refCount == 0) {
                    this.m_highlightMap.remove(g);
                }
                proxy.m_helper.willUnhighlightGraphic(g);
                ShapeHighlighter.this.repaintGraphic(proxy, immediateRedraw);
                if (proxy.m_refCount == 0) {
                    proxy.dispose();
                }
            }
        }

        public void paint(Graphics graphics, IlvManagerView ilvManagerView) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.getClipBounds(ShapeHighlighter.this.m_tempBounds);
            for (Map.Entry<IlvGraphic, HighlighterProxy> entry : this.m_highlightMap.entrySet()) {
                HighlighterProxy proxy = entry.getValue();
                IlvGraphic graphic = entry.getKey();
                IlvManager mgr = ManagerUtil.getManager(graphic);
                if (mgr != null) {
                    proxy.drawHighlighted((Graphics2D)graphics, ShapeHighlighter.this.m_managerView, ShapeHighlighter.this.m_tempBounds);
                    continue;
                }
                this.m_invalidGraphics.add(proxy);
            }
            for (HighlighterProxy proxy : this.m_invalidGraphics) {
                this.m_highlightMap.remove(proxy.m_graphic);
                proxy.dispose();
            }
            this.m_invalidGraphics.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void repaintAll(boolean immediateRedraw) {
            int drawMode = ShapeHighlighter.this.m_managerView.getRedrawMode();
            ShapeHighlighter.this.m_managerView.setRedrawMode(immediateRedraw ? 1 : 0);
            try {
                for (Map.Entry<IlvGraphic, HighlighterProxy> entry : this.m_highlightMap.entrySet()) {
                    HighlighterProxy proxy = entry.getValue();
                    ShapeHighlighter.this.repaintGraphic(proxy, immediateRedraw);
                }
                ShapeHighlighter.this.m_managerView.reDrawViews();
            }
            finally {
                ShapeHighlighter.this.m_managerView.setRedrawMode(drawMode);
            }
        }
    }

    private static class HighlighterProxy {
        private static final IlvRect TEMPRECT = new IlvRect();
        ShapeHighlighter m_highLighter;
        int m_refCount;
        HighlightHelper m_helper;
        IlvGraphic m_graphic;
        boolean invalid;

        HighlighterProxy(ShapeHighlighter highLighter, HighlightHelper helper) {
            if (helper == null) {
                throw new IllegalArgumentException("HighlightHelper cannot be null");
            }
            this.m_highLighter = highLighter;
            this.m_helper = helper;
        }

        void dispose() {
            this.m_highLighter = null;
            this.m_helper = null;
            this.m_graphic = null;
        }

        void repaint(IlvManagerView managerView) {
            IlvRect r = this.m_helper.calcHighlightingBounds(this.m_graphic, TEMPRECT);
            float border = 2.0f;
            r.setFrame(r.getX() - (double)border, r.getY() - (double)border, r.getWidth() + 4.0 + 1.0 + 4.0, r.getHeight() + 4.0 + 1.0 + 4.0);
            IlvManager mgr = ManagerUtil.getTransformingManager(this.m_graphic);
            if (mgr != null) {
                IlvTransformer viewTx = mgr.getDrawingTransformer(managerView);
                viewTx.apply(r);
                managerView.invalidateRect(r);
            }
        }

        void drawHighlighted(Graphics2D graphics2D, IlvManagerView ilvManagerView, Rectangle drawRect) {
            IlvGraphic g = this.m_graphic;
            IlvManager mgr = ManagerUtil.getManager(this.m_graphic);
            IlvTransformer viewTrans = ManagerUtil.getTransformingManager(this.m_graphic).getDrawingTransformer(ilvManagerView);
            IlvRect bBox = g.boundingBox(viewTrans);
            if (drawRect.intersects((Rectangle2D)bBox)) {
                this.m_helper.calcHighlightingBounds(g, TEMPRECT);
                viewTrans.apply(TEMPRECT);
                this.m_helper.drawHighlighted(graphics2D, mgr, g, TEMPRECT, viewTrans);
            }
        }
    }
}

