/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.dragdrop;

import java.awt.datatransfer.DataFlavor;
import java.util.List;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.datatransfer.PrioritizedHandlers;
import oracle.diagram.framework.dragdrop.DiagramDropPlugin;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetCommonEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetDragEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetDropEvent;
import oracle.diagram.framework.dragdrop.event.DiagramDropTargetEvent;
import oracle.diagram.framework.dragdrop.handler.DropHandler;

public class DefaultDropPlugin
extends AbstractPlugin
implements DiagramDropPlugin {
    public static final float NO_FLAVOR_PRIORITY = -1.0f;
    private final PrioritizedHandlers<DropHandler> _handlers = new PrioritizedHandlers();
    private DropHandler _cachedHandler = null;

    @Override
    public void dragExit(DiagramDropTargetEvent dte) {
        if (this._cachedHandler != null) {
            this._cachedHandler.dragExit(dte);
        }
    }

    @Override
    public void dragEnter(DiagramDropTargetDragEvent ddte) {
        this.getPriorityDropHandler(ddte);
        if (this._cachedHandler != null) {
            this._cachedHandler.dragEnter(ddte);
        } else {
            ddte.reject();
        }
    }

    @Override
    public void dragOver(DiagramDropTargetDragEvent ddte) {
        this.getPriorityDropHandler(ddte);
        if (this._cachedHandler != null) {
            this._cachedHandler.dragOver(ddte);
        } else {
            ddte.reject();
        }
    }

    @Override
    public void drop(DiagramDropTargetDropEvent ddte) {
        this.getPriorityDropHandler(ddte);
        if (this._cachedHandler != null) {
            this._cachedHandler.drop(ddte);
        } else {
            ddte.reject();
        }
    }

    @Override
    public void dropActionChanged(DiagramDropTargetDragEvent ddte) {
        this.getPriorityDropHandler(ddte);
        if (this._cachedHandler != null) {
            this._cachedHandler.dropActionChanged(ddte);
        } else {
            ddte.reject();
        }
    }

    @Override
    public boolean registerDropHandler(DropHandler handler, float priority) {
        if (this._handlers.getHandlerForFlavor(handler.getDataFlavor()) != null) {
            return false;
        }
        this._handlers.addHandler(handler.getDataFlavor(), handler, priority);
        return true;
    }

    @Override
    public boolean replaceDropHandler(DropHandler handler, float priority) {
        this._handlers.removeHandler(handler.getDataFlavor());
        this._handlers.addHandler(handler.getDataFlavor(), handler, priority);
        return true;
    }

    @Override
    public DropHandler getDropHandler(DataFlavor flavor) {
        return this._handlers.getHandlerForFlavor(flavor);
    }

    private DropHandler getPriorityDropHandler(DiagramDropTargetCommonEvent ddtce) {
        return this.getPriorityDropHandler(ddtce.getCurrentDataFlavorsAsList());
    }

    private DropHandler getPriorityDropHandler(List<DataFlavor> flavors) {
        this._cachedHandler = this._handlers.getPriorityHandler(flavors);
        return this._cachedHandler;
    }
}

