/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.action.handler;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.action.handler.AbstractHandler;
import oracle.diagram.framework.graphic.features.AlignPlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class AlignHandler
extends AbstractHandler {
    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == Actions.CMD_ALIGN) {
            AlignPlugin plugin = this.getAlignPlugin(context);
            if (plugin != null && plugin.configureAlign() && ReadOnlyUtil.checkWritable(this.getDiagramContext(context))) {
                plugin.align();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == Actions.CMD_ALIGN) {
            AlignPlugin plugin = this.getAlignPlugin(context);
            if (plugin != null) {
                IlvManagerView mView = this.getManagerView(context);
                IlvManager manager = mView.getManager();
                IlvGraphicEnumeration selection = manager.getSelectedObjects(true);
                int nbNodeSelected = 0;
                while (nbNodeSelected < 2 && selection.hasMoreElements()) {
                    IlvGraphic element = selection.nextElement();
                    if (element instanceof IlvLinkImage) continue;
                    ++nbNodeSelected;
                }
                action.setEnabled(nbNodeSelected > 1);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    protected AlignPlugin getAlignPlugin(Context context) {
        return this.getPlugin(context, AlignPlugin.class);
    }
}

